/* $XConsortium: regionstr.h,v 1.5 89/07/09 15:34:24 rws Exp $ */
/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
#ifndef REGIONSTRUCT_H
#define REGIONSTRUCT_H

#include "region.h"
#include "miscstruct.h"
/* 
 *   clip region
 */

typedef struct _RegData {
    int		size;
    int 	numRects;
/*  BoxRec	rects[size];   in memory but not explicitly declared */
} RegDataRec;

#ifdef EMS
extern _segment _near ems_base;
typedef RegDataRec _based(void) *RegDataPtr;
typedef BoxRec _based(ems_base) *RegBoxPtr;
#else
typedef RegDataRec *RegDataPtr;
typedef BoxRec *RegBoxPtr;
#endif

typedef struct _Region {
    BoxRec 	extents;
#ifdef EMS
    u_char	page;
    u_char	flags;		/* we'll think of something to use this for */
    RegDataPtr	data;
#else
    RegDataPtr	data;
#endif
} RegionRec;

#ifdef EMS
extern u_short _near RegionHandle;
/* data is _based(void).  Seg is the segment on which it is based.
 * Convert this to a number based on ems_base.  */
#define to_ems_based(data, seg) ((RegDataRec _based(ems_base) *) \
    ((char _based(ems_base) *)(data) + ((u_short)((seg) - ems_base) << 4)))
#define to_void_based(data, seg) ((RegDataPtr) \
	    ((char _based(void) *)(data) - ((u_short)((seg) - ems_base) << 4)))
/* Warning: this macro only works if reg->data != NULL */
#define	REGION_DATAPTR(reg)	((RegDataRec _based(ems_base) *) \
	to_ems_based((reg)->data, ems_map(RegionHandle, (reg)->page)))

#define REGION_NIL(reg) ((reg)->data && !REGION_DATAPTR(reg)->numRects)
#define REGION_NUM_RECTS(reg) ((reg)->data ? REGION_DATAPTR(reg)->numRects : 1)
#define REGION_SIZE(reg) ((reg)->data ? REGION_DATAPTR(reg)->size : 0)
#define REGION_RECTS(reg) ((reg)->data ? (BoxPtr)(REGION_DATAPTR(reg) + 1) \
			               : &(reg)->extents)
#define REGION_BOXPTR(reg) ((RegBoxPtr)(REGION_DATAPTR(reg) + 1))
#define REGION_BOX(reg,i) (&REGION_BOXPTR(reg)[i])
/* The following two will call ems_map twice.  This should be optimized. */
#define REGION_TOP(reg) REGION_BOX(reg, REGION_DATAPTR(reg)->numRects)
#define REGION_END(reg) REGION_BOX(reg, REGION_DATAPTR(reg)->numRects - 1)

#else

#define REGION_DATAPTR(reg)	((reg)->data)
#define REGION_NIL(reg) ((reg)->data && !(reg)->data->numRects)
#define REGION_NUM_RECTS(reg) ((reg)->data ? (reg)->data->numRects : 1)
#define REGION_SIZE(reg) ((reg)->data ? (reg)->data->size : 0)
#define REGION_RECTS(reg) ((reg)->data ? (BoxPtr)((reg)->data + 1) \
			               : &(reg)->extents)
#define REGION_BOXPTR(reg) ((RegBoxPtr)((reg)->data + 1))
#define REGION_BOX(reg,i) (&REGION_BOXPTR(reg)[i])
#define REGION_TOP(reg) REGION_BOX(reg, (reg)->data->numRects)
#define REGION_END(reg) REGION_BOX(reg, (reg)->data->numRects - 1)
#endif

#define REGION_SZOF(n) (sizeof(RegDataRec) + ((n) * sizeof(BoxRec)))

#endif /* REGIONSTRUCT_H */
