/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* $XConsortium: os.h,v 1.39 89/12/06 16:41:26 rws Exp $ */

#ifndef OS_H
#define OS_H
#include "misc.h"
#include <memory.h>

#define bcopy(s,d,c)	memcpy(d,s,c)
#define ovbcopy(s,d,c)	memmove(d,s,c)
#define bzero(a,c)	memset(a, 0, c)
#define bcmp(a,b,c)	memcmp(a,b,c)

#define n_clicks()	(*(u_long far *)0x0040006cL)
#define b_clicks()	(*(u_char far *)0x0040006cL)
#define s_clicks()	(*(u_short far *)0x0040006cL)
/* This comes to 1001 hz.  Close enough... */
#define clock()		(n_clicks() * 55)

char * near X11env;

#include <malloc.h>

#ifdef INCLUDE_ALLOCA_H
#include <alloca.h>
#endif

#define NullFID ((FID) 0)

#define SCREEN_SAVER_ON   0
#define SCREEN_SAVER_OFF  1
#define SCREEN_SAVER_FORCER 2

#if defined(stellar)
#define MAX_REQUEST_SIZE 65535
#else
/* #define MAX_REQUEST_SIZE 16384 */
/* this number is shifted left by 2.  If we use the above number on a
 * 16 bit machine we get 0!  Actually, using 8191 is pretty silly because
 * if it's bigger than that shifted left by 2 it's probably negative. */
#define MAX_REQUEST_SIZE 8191
#endif

typedef pointer	FID;
typedef struct _FontPathRec *FontPathPtr;
typedef struct _NewClientRec *NewClientPtr;

#ifndef NO_ALLOCA
/*
 * os-dependent definition of local allocation and deallocation
 * If you want something other than Xalloc/Xfree for ALLOCATE/DEALLOCATE
 * LOCAL then you add that in here.
 */
#if defined(__HIGHC__)

extern char *alloca();

#if HCVERSION < 21003
#define ALLOCATE_LOCAL(size)	alloca((int)(size))
pragma on(alloca);
#else /* HCVERSION >= 21003 */
#define	ALLOCATE_LOCAL(size)	_Alloca((int)(size))
#endif /* HCVERSION < 21003 */

#define DEALLOCATE_LOCAL(ptr)  /* as nothing */

#endif /* defined(__HIGHC__) */


#ifdef __GNUC__
#define alloca __builtin_alloca
#define ALLOCATE_LOCAL(size) alloca((int)(size))
#define DEALLOCATE_LOCAL(ptr)  /* as nothing */
#else /* ! __GNUC__ */
/*
 * warning: mips alloca is unsuitable in the server, do not use.
 */
#if defined(vax) || defined(sun) || defined(apollo) || defined(stellar)
/*
 * Some System V boxes extract alloca.o from /lib/libPW.a; if you
 * decide that you don't want to use alloca, you might want to fix 
 * ../os/4.2bsd/Imakefile
 */
char *alloca();
#define ALLOCATE_LOCAL(size) alloca((int)(size))
#define DEALLOCATE_LOCAL(ptr)  /* as nothing */
#endif /* who does alloca */
#endif /* __GNUC__ */

/* msdos */
#define ALLOCATE_LOCAL(size) alloca(size)
#define DEALLOCATE_LOCAL(ptr)  /* as nothing */

#endif /* NO_ALLOCA */

#ifndef ALLOCATE_LOCAL
#define ALLOCATE_LOCAL(size) Xalloc(size)
#define DEALLOCATE_LOCAL(ptr) Xfree((pointer)(ptr))
#endif /* ALLOCATE_LOCAL */

#define xalloc(size) Xalloc(size)
#define xrealloc(ptr, size) Xrealloc(ptr, size)
#define xfree(ptr) Xfree(ptr)

#ifdef EMS
/* structure for each of the 4 "physical" pages */
struct ems_phys {
	u_short handle;		/* who has it */
	u_short	page;		/* which logical page */
	u_short	gen;		/* time stamp for LRU code */
	u_short	flags;
#define EMS_MAPPED	0x0001
#define EMS_LOCKED	0x0002
};
#define NPHYS 4
#endif

int		ReadRequestFromClient(struct _Client _near *);
Bool		CloseDownConnection(struct _Client near *);
char  *ClientAuthorized(struct  _Client _near *client,unsigned short  proto_n,char  *auth_proto,unsigned short  string_n,char  *auth_string);
void  OnlyListenToOneClient(struct  _Client _near *client);
void	ListenToAllClients(void);
int  InsertFakeRequest(struct  _Client _near *client,char  *data,int  count);
int  ResetCurrentRequest(struct  _Client _near *client);
int  WriteToClient(struct  _Client _near *who,int  count,char  *buf);
int  OsLookupColor(int, char *, unsigned short,
			unsigned short *, unsigned short *, unsigned short *);
int ChangeAccessControl(struct _Client _near *client, int fEnabled);
int  AddHost(struct  _Client _near *client,unsigned char  family,unsigned short  length,void *pAddr);
int  RemoveHost(struct  _Client _near *client,unsigned char  family,unsigned short  length,void *pAddr);
int GetHosts (void **, int *, int *, unsigned char *);
FontPathPtr	GetFontPath();
FontPathPtr	ExpandFontNamePattern(unsigned, char *, unsigned);
FID		FiOpenForRead();
int		FontFileRead(char *, unsigned short, unsigned short, FID);
int		FontFileSkip(unsigned, FID);
void		CreateWellKnownSockets(void);
void		ResetWellKnownSockets(void);
void		OsInit(void);
int		SetDefaultFontPath(char *);
void		FreeFontRecord();
int		SetFontPath(struct _Client _near *client, unsigned npaths, char *countedStrings);
void		ErrorF(char *,...);
void		Error();
void		FatalError(char *,...);
void		ProcessCommandLine(int, char **);
void		Xfree(void *);
void		FlushAllOutput(void);
void		FlushIfCriticalOutputPending(void);
void		*Xalloc(unsigned int);
void		*Xrealloc(void *, unsigned int);
unsigned long	GetTimeInMillis(void);
int WaitForSomething(int *);

#endif /* OS_H */
