	name	vesa

	.286p

NUMPAGES	equ	1
HEADLAND	equ	0
VESA		equ	1

setpage	MACRO	page		; page to be set is in ah
	push	bx
	push	dx
	push	cx
	IFDIFI	<page>,<dl>	; dst != dl
	mov	dl,page
	ENDIF
	sub	dh,dh		; upper part of page
	mov	cl,cs:page_shift
	shl	dx,cl

	mov	ax,4f05h
	sub	bx,bx
	int	10h

	pop	cx
	pop	dx
	pop	bx
		ENDM

include	vga.inc

_text	segment	word public 'CODE'

	ASSUME	cs:_text,ds:nothing,es:nothing

	ORG	0

include common.asm

do_local	PROC NEAR
	ASSUME	ds:_text
	push	cx
	push	es
	push	bp
	mov	bp,sp
	sub	sp,256		; size of VESA mode information buffer
				; mode in reg ax
	cmp	ax,0100h
	jl	set_normal
	push	ax		; save mode
	mov	bx,ax		; mode
	mov	ax,4f02h
	int	10h
	cmp	ax,004fh
	jne	local_bad

	; figure out the page shift from the window granularity
	pop	cx		; get mode
	mov	ax,ss
	mov	es,ax
	mov	di,sp
	mov	ax,4f01h
	int	10h
	cmp	ax,004fh
	jne	shift_skip
	mov	ax,es:4[di]
	or	ax,ax
	je	shift_skip
	mov	bl,6		; start with 6
shift_1:
	test	al,1
	jnz	shift_2		; found 1 bit
	dec	bl
	shr	ax,1
	jmp	short shift_1
shift_2:
	mov	page_shift,bl
shift_skip:
	xor	ax,ax		; return OK
local_out:
	mov	sp,bp
	pop	bp
	pop	es
	pop	cx
	ret
set_normal:
	int	10h
	jmp	short shift_skip
local_bad:
	mov	ax,08002h	; non-supported mode
	jmp	short local_out
	ASSUME	ds:nothing
do_local	ENDP

page_shift	db	0
old_mode	db	?

mono_modes:
	dw	0011h		; 640x480 mono
	dw	0102h		; 800x600 16 colors
	dw	0104h		; 1024x768 16 colors
	dw	0106h		; 1280x1024 16 colors
color_modes:
	dw	0101h		; 640x480 256 colors
	dw	0103h		; 800x600 256 colors
	dw	0105h		; 1024x768 256 colors
	dw	0107h		; 1280x1024 256 colors

include	copy.asm
include	stipple.asm

Init	PROC NEAR
	mov	word ptr es:[di+14],offset Init	; free memory
	mov	word ptr es:[di+16],cs		; segment of free memory
	mov	ret_data.close_seg,cs
	mov	ret_data.page_seg,cs
	mov	ret_data.copy_seg,cs
	mov	ret_data.move_seg,cs
	mov	ret_data.c_stipple_seg,cs
	mov	cx,dx
	mov	dx,offset copyright
	mov	ah,9
	int	21h
	mov	dx,cx
	xor	ax,ax			; success
	ret
Init	ENDP

copyright db	10, 13, 'VESA driver '
include version.asm
include date.asm
	db	'installed.', 10, 13
	db	'Copyright (c) 1991 Starnet Communications '
	db	'Corporation. All rights reserved.',10,13,'$'

_text	ENDS
	END
