	name	ati4

	.286p

NUMPAGES	equ	1
HEADLAND	equ	0
VESA		equ	0

setpage	MACRO	page		; page to be set is in ah
	IFDIFI	<page>,<ah>	; dst != ah
	mov	ah,page
	ENDIF
	shl	ah,1

	mov	al,0b2h		; register 0b2h
	push	dx
	mov	dx,cs:[ioaddr]
	out	dx,al		; set the page
	inc	dx
	in	al,dx
	dec	dx
	and	al,0e1h		; mask out old page
	or	ah,al		; mask in new page
	mov	al,0b2h
	out	dx,ax
	pop	dx
		ENDM

include	vga.inc

_text	segment	word public 'CODE'

	ASSUME	cs:_text,ds:nothing,es:nothing

	ORG	0

include common.asm

do_local	PROC NEAR
				; mode in reg al
	xor	ah,ah		; function 0 = set mode
;	mov	bl,al		; save mode
	int	10h
	; read the mode back from BIOS to make sure we actually changed
	; it
;	mov	ah,0fh
;	int	10h		; get current mode
;	cmp	al,bl
;	jnz	local_bad
	mov	ax,0c000h	; point to the VGA ROM
	mov	es,ax
	mov	bx,10h		; get the extended i/o address
	mov	dx,es:[bx]
	mov	cs:[ioaddr],dx
	mov	al,0beh		; point to misc register
	cli
	out	dx,al
	inc	dx
	in	al,dx
	and	al,0f7h		; disable two page pointers
	out	dx,al
	sti
	mov	dl,0
	setpage	dl
	xor	ax,ax		; return OK
	ret
;local_bad:
;	mov	ax,08002h	; non-supported mode
;	ret
do_local	ENDP

old_mode	db	?
mono_modes:
	dw	0011h		; 640x480 mono
	dw	006ah		; 800x600 16 colors
	dw	0055h		; 1024x768 mono
	dw	0000h		; 1280x1024 mono
color_modes:
	dw	0062h		; 640x480 256 colors
	dw	0063h		; 800x600 256 colors
	dw	0064h		; 1024x768 256 colors
	dw	0000h		; 1280x1024 256 mono
ioaddr		dw	?

include	copy.asm
include	stipple.asm

Init	PROC NEAR
	mov	word ptr es:[di+14],offset Init	; free memory
	mov	word ptr es:[di+16],cs		; segment of free memory
	mov	ret_data.close_seg,cs
	mov	ret_data.page_seg,cs
	mov	ret_data.copy_seg,cs
	mov	ret_data.move_seg,cs
	mov	ret_data.c_stipple_seg,cs
	mov	cx,dx
	mov	dx,offset copyright
	mov	ah,9
	int	21h
	mov	dx,cx
	xor	ax,ax			; success
	ret
Init	ENDP

copyright db	10, 13, 'ATI Version 3 driver '
include version.asm
include date.asm
	db	'installed.', 10, 13
	db	'Copyright (c) 1991 Starnet Communications '
	db	'Corporation. All rights reserved.',10,13,'$'

_text	ENDS
	END
