	name	ahead

	.286p

NUMPAGES	equ	2
HEADLAND	equ	0
VESA		equ	0

setpage	MACRO	srcpage,dstpage	; page to be set is in ah
	IFIDNI	<dstpage>,<ah>	; dst == ah
	IFIDNI	<srcpage>,<ah>	; dst == ah && src == ah
	mov	al,ah
	shl	ah,4
	or	ah,al
	ELSE			; dst == ah && src != ah
	shl	ah,4
	or	ah,srcpage
	ENDIF
	ELSE			; dst != ah
	IFIDNI	<srcpage>,<ah>	; dst != ah && src == ah
	IFDIFI	<dstpage>,<al>	; dst != ah && src == ah && dst != al
	mov	al,dstpage
	ENDIF
	shl	al,4
	or	ah,al
	ELSE			; dst != ah && src != ah
	mov	ah,dstpage
	shl	ah,4
	or	ah,srcpage
	ENDIF
	ENDIF

	mov	al,0dh		; register 0dh
	push	dx
	mov	dx,03ceh
	out	dx,ax		; set the page
	pop	dx
		ENDM

include	vga.inc

_text	segment	word public 'CODE'

	ASSUME	cs:_text,ds:nothing,es:nothing

	ORG	0

include common.asm

do_local	PROC NEAR
				; mode in reg al
	xor	ah,ah		; function 0 = set mode
	push	ax		; save mode
	int	10h
	; read the mode back from BIOS to make sure we actually changed
	; it
	mov	ah,0fh
	int	10h		; get current mode
	pop	dx
	cmp	al,dl
	jnz	local_bad
	mov	dl,0
	setpage	dl,dl
	xor	ax,ax		; return OK
	ret
local_bad:
	mov	ax,08002h	; non-supported mode
	ret
do_local	ENDP

old_mode	db	?
mono_modes:
	dw	0011h		; 640x480 mono
	dw	006ah		; 800x600 16 colors
	dw	0076h		; 1024x768 mono
	dw	0000h		; 1280x1024 mono
color_modes:
	dw	0061h		; 640x480 256 colors
	dw	0062h		; 800x600 256 colors
	dw	0063h		; 1024x768 256 colors
	dw	0000h		; 1280x1024 256 colors

include	copy.asm
include	stipple.asm

Init	PROC NEAR
	mov	word ptr es:[di+14],offset Init	; free memory
	mov	word ptr es:[di+16],cs		; segment of free memory
	mov	ret_data.close_seg,cs
	mov	ret_data.page_seg,cs
	mov	ret_data.copy_seg,cs
	mov	ret_data.move_seg,cs
	mov	ret_data.c_stipple_seg,cs
	mov	cx,dx
	mov	dx,offset copyright
	mov	ah,9
	int	21h
	mov	dx,cx
	xor	ax,ax			; success
	ret
Init	ENDP

copyright db	10, 13, 'Ahead V5000 Rev B driver '
include version.asm
include date.asm
	db	'installed.', 10, 13
	db	'Copyright (c) 1991 Starnet Communications '
	db	'Corporation. All rights reserved.',10,13,'$'

_text	ENDS
	END
