/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* $XConsortium: miglblt.c,v 1.18 88/09/06 14:49:13 jim Exp $ */

#include	"X.h"
#include	"Xmd.h"
#include	"Xproto.h"
#include	"fontstruct.h"
#include	"dixfontstr.h"
#include	"gcstruct.h"
#include	"windowstr.h"
#include	"scrnintstr.h"
#include	"pixmap.h"
#include	"servermd.h"
#include	"vga.h"

void
vgaPolyGlyphBlt(pDrawable, pGC, x, y, nglyph, ppci, pglyphBase)
    DrawablePtr pDrawable;
    GC 		*pGC;
    int 	x, y;
    unsigned int nglyph;
    CharInfoPtr *ppci;		/* array of character info */
    unsigned char *pglyphBase;	/* start of array of glyphs */
{
    int height;
    FontRec *pfont;
    int i, j;
    CharInfoPtr pci;			/* currect char info */
    unsigned char *pglyph;		/* pointer bits in glyph */
    int gWidth, gHeight;		/* width and height of glyph */
    register int nbyGlyphWidth;		/* bytes per scanline of glyph */
    int totwidth;
    unsigned char *line;
    int xoffset, xshift;
    int maxAscent;
    PixmapPtr pPixmap;
    int nbyPixmap;
    unsigned char *pdst;

    if (pGC->miTranslate) {
	x += pDrawable->x;
	y += pDrawable->y;
    }
    pfont = pGC->font;
    maxAscent = pfont->pFI->maxbounds.metrics.ascent;
    height = maxAscent + pfont->pFI->maxbounds.metrics.descent;

    /* Make enough space to hold all possible characters */
    totwidth = pfont->pFI->maxbounds.metrics.characterWidth * nglyph;
    pPixmap = vgaCreatePixmap(pDrawable->pScreen, totwidth, height, 1);
    if (!pPixmap) {
printf("PolyGlyphBlt: can't allocate Pixmap\n");
	return;
    }
    nbyPixmap = pPixmap->devKind;
    pdst = pPixmap->devPrivate.ptr;
    bzero(pdst, nbyPixmap * height);
    xoffset = -(*ppci)->metrics.leftSideBearing;	/* first char */
    xshift = xoffset;

    while(nglyph--)
    {
	u_char rshift, lshift;

	pci = *ppci++;
	gHeight = GLYPHHEIGHTPIXELS(pci);
	gWidth = GLYPHWIDTHPIXELS(pci);
	nbyGlyphWidth = GLYPHWIDTHBYTESPADDED(pci);

	xshift += pci->metrics.leftSideBearing;
	rshift = (u_char)(xshift & 7);
	lshift = (u_char)8 - rshift;

	line = pdst + xshift / 8 +
	    nbyPixmap * (maxAscent - pci->metrics.ascent);
	pglyph = pglyphBase + pci->byteOffset;

	/* Change gWidth into number of bytes - 1 */
	gWidth = gWidth - 1 >> 3;

	for (i = 0; i < gHeight; i++) {
	    register unsigned char *lp = line;

	    if (!gWidth) {
		    *lp++ |= *pglyph >> rshift;
		    *lp   |= *pglyph << lshift;
	    } else
		for (j = 0; j <= gWidth; j++) {
		    *lp++ |= pglyph[j] >> rshift;
		    *lp   |= pglyph[j] << lshift;
	    }
	    line += nbyPixmap;
	    pglyph += nbyGlyphWidth;
	}

	xshift -= pci->metrics.leftSideBearing;
	xshift += pci->metrics.characterWidth;
    }
    vgaPushPixels(pGC, pPixmap, pDrawable,
	xshift + xoffset, height, x - xoffset, y - maxAscent);
    vgaDestroyPixmap(pPixmap);
}

vgaImageGlyphBlt(pDrawable, pGC, x, y, nglyph, ppci, pglyphBase)
    DrawablePtr pDrawable;
    GC 		*pGC;
    int 	x, y;
    unsigned int nglyph;
    CharInfoPtr *ppci;		/* array of character info */
    unsigned char *pglyphBase;	/* start of array of glyphs */
{
    FontRec *pfont;
    int i, j;
    CharInfoPtr pci;			/* currect char info */
    unsigned char *pglyph;		/* pointer bits in glyph */
    int gWidth, gHeight;		/* width and height of glyph */
    register int nbyGlyphWidth;		/* bytes per scanline of glyph */
    int totwidth, totheight;		/* width and height of area */
    unsigned char *pdst, *line;
    int xoffset, xshift;
    int maxAscent;
    int nbytes;
    ExtentInfoRec info;		/* used by QueryGlyphExtents() */

    pfont = pGC->font;
    QueryGlyphExtents(pfont, ppci, nglyph, &info);

    totwidth = info.overallWidth;
    maxAscent = info.overallAscent;
    totheight = maxAscent + info.overallDescent;

    /* Make enough space to hold all possible characters */
    nbytes = PixmapBytePad(totwidth, 1);
    pdst = ALLOCATE_LOCAL(nbytes * totheight);
    if (!pdst)
	return BadAlloc;
    bzero(pdst, nbytes * totheight);

    xoffset = -(*ppci)->metrics.leftSideBearing;	/* first char */
    xshift = xoffset;

    while(nglyph--)
    {
	u_char rshift, lshift;

	pci = *ppci++;
	gHeight = GLYPHHEIGHTPIXELS(pci);
	gWidth = GLYPHWIDTHPIXELS(pci);
	nbyGlyphWidth = GLYPHWIDTHBYTESPADDED(pci);

	xshift += pci->metrics.leftSideBearing;
	rshift = (u_char)(xshift & 7);
	lshift = (u_char)8 - rshift;

	line = pdst + xshift / 8 +
	    nbytes * (maxAscent - pci->metrics.ascent);
	pglyph = pglyphBase + pci->byteOffset;

	/* Change gWidth into number of bytes - 1.  This lets us optimize
	 * the loop below so we can avoid the index and the inner for
	 * loop.
	 */
	gWidth = gWidth - 1 >> 3;

	for (i = 0; i < gHeight; i++) {
	    unsigned char *lp;

	    lp = line;
	    if (!gWidth) {
		    *lp++ |= *pglyph >> rshift;
		    *lp   |= *pglyph << lshift;
	    } else
		for (j = 0; j <= gWidth; j++) {
		    *lp++ |= pglyph[j] >> rshift;
		    *lp   |= pglyph[j] << lshift;
	    }
	    line += nbytes;
	    pglyph += nbyGlyphWidth;
	}

	xshift -= pci->metrics.leftSideBearing;
	xshift += pci->metrics.characterWidth;
    }
    (*pGC->ops->PutImage)(pDrawable, pGC, 1, x - xoffset, y - maxAscent,
	totwidth, totheight, 0, XYBitmap, pdst);
    DEALLOCATE_LOCAL(pdst);
    return 0;
}
