/* routines to draw the cursor on the screen */

#include "X.h"
#include "xproto.h"
#include "vga.h"
#include "cursorst.h"
#include "servermd.h"
#include "../common/mouse.h"
#include "../common/ibmmouse.h"
#include <dos.h>

/* TODO: use "software" cursor */
Bool near direct_mouse = TRUE;
Bool near mouse_moved = FALSE;
extern int _near mouse_flags;

void
mouseBlockHandler()
{
}

/* Set the cursor position */
void _fastcall _near
mouseSetCursor(x, y)
int x, y;
{

}

void _near
HideCursor()
{
	msHideCursor();
}

void
vgaRecolorCursor(pScr, pCurs, displayed)
ScreenPtr pScr;
CursorPtr pCurs;
Bool displayed;
{
}

Bool
mouseRealizeCursor(pScr, pCur)
ScreenPtr pScr;
CursorPtr pCur;
{
	GraphicCursor *pPriv;
	int i;
	int blen, h;
	u_short mask;
	CursorBitsPtr pbits = pCur->bits;

	h = min(pbits->height, 16);
	blen = PixmapBytePad(pbits->width, 1);
	pPriv = (GraphicCursor *)xalloc(sizeof (GraphicCursor));
	if (!pPriv)
		return FALSE;
	pbits->devPriv[pScr->myNum] = (pointer)pPriv;
	if (pbits->width >= 16)
		mask = 0;
	else
		mask = (u_short)(-1) >> pbits->width;
	/* set the screen mask to a 0 where the cursor should be shown.
	 * set it to a 1 outside of the cursor area.
	 * Don't set both cursorMask and screenMask to a 1 because this
	 * means "invert" to the Microsoft mouse but X doesn't use this
	 * feature.
	 */
	for (i = 0; i < h; i++) {
		pPriv->screenMask[i] = mask |
				      ~(((u_short)pbits->mask[i*blen] << 8) +
				      pbits->mask[i*blen + 1]);
		pPriv->cursorMask[i] = ~(((u_short)pbits->source[i*blen] << 8) +
				      pbits->source[i*blen + 1]) &
				      ~pPriv->screenMask[i] & ~mask;
	}
	for (; i < 16; i++) {
		pPriv->cursorMask[i] = 0;
		pPriv->screenMask[i] = -1;
	}
	pPriv->hotX = pbits->xhot;
	pPriv->hotY = pbits->yhot;
	return TRUE;
}

Bool
mouseUnrealizeCursor(pScr, pCur)
ScreenPtr pScr;
CursorPtr pCur;
{
	CursorBitsPtr pbits = pCur->bits;

	if (pbits->refcnt <= 1) {
		xfree(pCur->bits->devPriv[pScr->myNum]);
		pCur->bits->devPriv[pScr->myNum] = 0;
	}
	return TRUE;
}

Bool
mouseDisplayCursor(pScr, pCur)
ScreenPtr pScr;
CursorPtr pCur;
{
	GraphicCursor *graph =
	    (GraphicCursor *)pCur->bits->devPriv[pScr->myNum];

	if (!(mouse_flags & MOUSE_ON))
		return FALSE;
	{
		_asm	les	di,[graph]
		_asm	mov	dx,di
		_asm	mov	bx,es:64[di]	/* hotX */
		_asm	mov	cx,es:66[di]	/* hotY */
		_asm	mov	ax, 9
		_asm	int	0x33
	}
	return TRUE;
}
