/***********************************************************
Copyright 1987 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/
/* $XConsortium: scrinit.c,v 1.57 88/10/02 15:08:27 rws Exp $ */

#include <fcntl.h>
#include "X.h"
#include "Xproto.h"	/* for xColorItem */
#include "Xmd.h"
#include "scrnintstr.h"
#include "pixmapstr.h"
#include "resource.h"
#include "colormap.h"
#include "svga.h"
#include "cursor.h"
#include "..\common\ibmmouse.h"
#include "../../mi/mistruct.h"
#include "dix.h"
#include <dos.h>
#include "../../mi/mipointer.h"

#include "servermd.h"
#include <string.h>

extern int _near monitorResolution;

static VisualRec far visual = {
/* vid  class       bpRGB cmpE nplan rMask gMask bMask oRed oGreen oBlue */
   0,   PseudoColor, 6,   256,   8,    0,    0,    0,    0,   0,     0
};

static VisualID VID;

static DepthRec depth = {
/* depth	numVid		vids */
    8,		1,		&VID,
#ifdef notdef
    1,		0,		0
#endif
};

svgaPrivScr _near svgapriv;
struct vga_conf _near vga_conf;

struct resolution {
	int width, height;
};

static struct resolution vga_res[] = {
    { 0,	0},
    { 640,	480},
    { 800,	600},
    { 1024,	768},
    { 1280,	1024}
};

Bool
svgainit(iScreen, pScreen, argc, argv)
int iScreen;
ScreenPtr pScreen;
int argc;
char **argv;
{
    ColormapPtr pColormap;
    union REGS regs;
    _segment	fb = 0xa000;
    int		mode = 1;
    int		i;
    int		fd;
    CARD16	zero = 0, ones = ~0;

    while (argc > 0) {
	if (strcmp(*argv, "-mode") == 0) {
		argv++; argc--;
		if (!argc) {
			printf("bad -mode argument\n");
			break;
		}
		mode = atoi(*argv);
	}
	argv++; argc--;
    }

    if (svgaGeneration != serverGeneration)
    {
	svgaGCPrivateIndex = AllocateGCPrivateIndex();
/*	svgaScrPrivateIndex = AllocateScreenPrivateIndex(); */
	visual.vid = FakeClientID(0);
	VID = visual.vid;
	svgaGeneration = serverGeneration;
    }
    if (!AllocateGCPrivate(pScreen, svgaGCPrivateIndex, sizeof(svgaPrivGC)))
	return FALSE;

    if (i = _dos_open("XWVGA", O_RDONLY, &fd)) {
	fprintf(stderr, "VGA device driver not loaded.\n");
	return FALSE;
    }

    mode |= 0x100;	/* set color bit */

    regs.h.ah = 0x44;
    regs.h.al = 3;
    regs.x.bx = fd;
    regs.x.cx = sizeof mode;
    regs.x.dx = (short)&mode;
    intdos(&regs, &regs);
    if (regs.x.cflag) {
	mode &= ~0x100;
	fprintf(stderr, "Color mode %d is not supported by your VGA card.\n",
		mode);
	(void)_dos_close(fd);
	return FALSE;
    }

    regs.h.ah = 0x44;
    regs.h.al = 2;
    regs.x.bx = fd;
    regs.x.cx = sizeof vga_conf;
    regs.x.dx = (short)&vga_conf;
    intdos(&regs, &regs);
    if (regs.x.cflag) {
	fprintf(stderr, "XWVGA: read failed error code %d\n", regs.x.ax);
	(void)_dos_close(fd);
	return FALSE;
    }
    (void)_dos_close(fd);

    pScreen->devPrivate = (pointer)&svgapriv;

    mode &= 0xff;

    svgapriv.fb = fb;
    svgapriv.devKind = vga_res[mode].width;
    pScreen->width = vga_res[mode].width;
    pScreen->height = vga_res[mode].height;
/*
printf("svga: mode=%d, columns=%d, height=%d\n", regs.h.al, regs.h.ah, pScreen->height);
*/

    if (monitorResolution) {
	pScreen->mmWidth = pScreen->width * 25 / monitorResolution;
	pScreen->mmHeight = pScreen->height * 25 / monitorResolution;
    } else {
	pScreen->mmWidth = 250;
	pScreen->mmHeight = 180;
    }

    pScreen->numDepths = 1;
    pScreen->allowedDepths = &depth;

    pScreen->rootDepth = 8;
    pScreen->rootVisual = VID;
    pScreen->backingStoreSupport = NotUseful;
    pScreen->saveUnderSupport = NotUseful;

    pScreen->numVisuals = 1;
    pScreen->visuals = &visual;

    pScreen->CreateWindow = svgaCreateWindow;
    pScreen->DestroyWindow = svgaDestroyWindow;
    pScreen->PositionWindow = svgaPositionWindow;
    pScreen->RealizeWindow = svgaMapWindow;
    pScreen->UnrealizeWindow = svgaUnmapWindow;
    pScreen->ChangeWindowAttributes = svgaChangeWindowAttributes;
    pScreen->ValidateTree = miValidateTree;
    pScreen->WindowExposures = miWindowExposures;

    pScreen->ClearToBackground = miClearToBackground;
    pScreen->PaintWindowBackground = svgaPaintWindow;
    pScreen->PaintWindowBorder = svgaPaintWindow;
    pScreen->CopyWindow = svgaCopyWindow;

    pScreen->RealizeFont = svgaRealizeFont;
    pScreen->UnrealizeFont = svgaUnrealizeFont;
    pScreen->GetImage = svgaGetImage;
    pScreen->GetSpans = svgaGetSpans;
    pScreen->CreatePixmap = svgaCreatePixmap;
    pScreen->DestroyPixmap = svgaDestroyPixmap;

    pScreen->CreateColormap = svgaCreateColormap;
    pScreen->DestroyColormap = svgaDestroyColormap;
    pScreen->InstallColormap = svgaInstallColormap;
    pScreen->UninstallColormap = svgaUninstallColormap;
    pScreen->ListInstalledColormaps = svgaListInstalledColormaps;
    pScreen->StoreColors = svgaStoreColors;
    pScreen->ResolveColor = svgaResolveColor;

    pScreen->CreateGC = svgaCreateGC;

    pScreen->RegionCreate = miRegionCreate;
    pScreen->RegionInit = miRegionInit;
    pScreen->RegionCopy = miRegionCopy;
    pScreen->RegionDestroy = miRegionDestroy;
    pScreen->RegionUninit = miRegionUninit;
    pScreen->Intersect = miIntersect;
    pScreen->Inverse = miInverse;
    pScreen->Union = miUnion;
    pScreen->Subtract = miSubtract;
    pScreen->RegionReset = miRegionReset;
    pScreen->TranslateRegion = miTranslateRegion;
    pScreen->RectIn = miRectIn;
    pScreen->PointInRegion = miPointInRegion;
    pScreen->RegionNotEmpty = miRegionNotEmpty;
    pScreen->RegionEmpty = miRegionEmpty;
    pScreen->RegionExtents = miRegionExtents;
    pScreen->RegionAppend = miRegionAppend;
    pScreen->RegionValidate = miRegionValidate;
#ifdef SHAPE
    pScreen->BitmapToRegion = mfbPixmapToRegion;
    pScreen->RectsToRegion = miRectsToRegion;
#endif
    pScreen->SendGraphicsExpose = miSendGraphicsExpose;

    pScreen->CloseScreen = svgaClose;
    pScreen->SaveScreen = svgaSaveScreen;

    /*
     * Cursor functions
     */
    pScreen->PointerNonInterestBox = mousePointerNonInterestBox;
    pScreen->RealizeCursor = mouseRealizeCursor;
    pScreen->UnrealizeCursor = mouseUnrealizeCursor;
    pScreen->DisplayCursor = mouseDisplayCursor;
    pScreen->SetCursorPosition = mouseSetCursorPosition;
    pScreen->CursorLimits = mouseCursorLimits;
    pScreen->ConstrainCursor = mouseConstrainCursor;
    pScreen->RecolorCursor = svgaRecolorCursor;

    pScreen->QueryBestSize = svgaQueryBestSize;

    /* os layer stuff */
#ifdef notused
    pScreen->BlockHandler = svgaBlockHandler;
    pScreen->WakeupHandler = svgaWakeupHandler;
    pScreen->wakeupData = (pointer)0;
    pScreen->blockData = (pointer)0;
#endif

    pScreen->defColormap = (Colormap) FakeClientID(0);
    pScreen->minInstalledCmaps = 1;
    pScreen->maxInstalledCmaps = 1;
    pScreen->whitePixel = 0xff;
    pScreen->blackPixel = 0;
    if ((i = CreateColormap(pScreen->defColormap, pScreen, &visual,
	&pColormap, AllocNone, 0)) != Success || pColormap == NULL) {
		ErrorF("svgainit: CreateColormap returned %d\n", i);
		ErrorF("memavl=%u\n", _memavl());
		return FALSE;
    }
    if (AllocColor(pColormap, &zero, &zero, &zero, (&pScreen->blackPixel), 0) ||
	AllocColor(pColormap, &ones, &ones, &ones, (&pScreen->whitePixel), 0))
		FatalError("svgaInit: Can't alloc black & white pixels\n");
    svgaInstallColormap(pColormap);

    /* Initialize the mouse to black on white */
    svgaCursor.fore_color = pScreen->blackPixel;
    svgaCursor.back_color = pScreen->whitePixel;
    svgaCursor.depth = depth.depth;

    return TRUE;
}

/* Should this be a 8-bit array? */
int near endtab[16] = 
	{
	0x0000,
	0x8000,
	0xC000,
	0xE000,
	0xF000,
	0xF800,
	0xFC00,
	0xFE00,
	0xFF00,
	0xFF80,
	0xFFC0,
	0xFFE0,
	0xFFF0,
	0xFFF8,
	0xFFFC,
	0xFFFE
	};

u_char near masktab[8] = {
	0x80,
	0x40,
	0x20,
	0x10,
	0x08,
	0x04,
	0x02,
	0x01
};

void _near
screen_abort()
{
	if (svgapriv.fb)
		svgaClose(0, (ScreenPtr)0);
}
