COPY_STIPPLE	PROC FAR
;	copy stipple, no tiling
;	copy_stipple(short dstx, short dsty, short dstwidth, short dstheight,
;		char far * psrc, short srcwidth, short xoff, short yoff,
;		char fgpixel, char bgpixel);
s_next_src_line =	-4	; number of bytes to next src line
s_next_scan_line =	-2	; number of bytes to next scan line
s_dstx =	6
s_dsty =	8
s_dstwidth =	10
s_dstheight =	12
s_psrc =	14
s_srcwidth =	18
s_xoff =	20
s_yoff =	22
s_fgpixel =	24
s_bgpixel =	26

c_stipple640:
	push	bp
	mov	bp,sp		; setup frame pointer
	sub	sp,4		; setup two temp word variables
	push	ds
	push	es
	push	si		; psrc
	push	di		; pdst
	mov	ax,0a000h
	mov	es,ax		; point to video area

	mov	bx,640
	mov	ax,s_dsty[bp]	; multiply it by 640
	mul	bx
	add	ax,s_dstx[bp]
	adc	dl,0
	mov	di,ax
	xchg	bx,dx		; bl = page number of dst

	jmp	short c_stipple
c_stipple800:
	push	bp
	mov	bp,sp		; setup frame pointer
	sub	sp,4		; setup two temp word variables
	push	ds
	push	es
	push	si		; psrc
	push	di		; pdst
	mov	ax,0a000h
	mov	es,ax		; point to video area

	mov	bx,800
	mov	ax,s_dsty[bp]	; multiply it by 800
	mul	bx
	add	ax,s_dstx[bp]
	adc	dl,0
	mov	di,ax
	xchg	bx,dx		; bl = page number of src

	jmp	short c_stipple
c_stipple1024:
	push	bp
	mov	bp,sp		; setup frame pointer
	sub	sp,4		; setup two temp word variables
	push	ds
	push	es
	push	si		; psrc
	push	di		; pdst
	mov	ax,0a000h
	mov	es,ax		; point to video area

	mov	bx,1024
	mov	ax,s_dsty[bp]
	mul	bx
	add	ax,s_dstx[bp]
	adc	dl,0
	mov	di,ax
	xchg	bx,dx		; bl = page number of src

c_stipple:
;	dx = number of bytes in one scan line
;	bl = current page number
	mov	cx,s_dstwidth[bp]	; get number of bytes in one line
	sub	dx,cx		; get number of bytes to next scan line
	mov	s_next_scan_line[bp],dx		; save it
	setpage	bl,bl		; set the VGA page register
;	setup_page	bl, bl
	write_page
	lds	si,s_psrc[bp]	; get src buffer
	mov	ax,s_srcwidth[bp]
	add	ax,7		; round up to byte value
	and	al,0f8h		; number of "bytes" of src
	mov	dx,ax		; put srcwidth in dx
	sub	dx,cx		; dx has the "bytes" to next src line
	mov	cx,s_xoff[bp]	; xoff
	and	cx,7		; xoff & 7
	sub	dx,cx		; srcwidth - (xoff & 7)
	shr	dx,3		; convert to actual src bytes
	mov	s_next_src_line[bp],dx
	shr	ax,3		; convert srcwidth to bytes
	mul	word ptr s_yoff[bp]	; srcwidth * yoff
	add	si,ax		; psrc += srcwidth * yoff
	mov	ax,s_xoff[bp]	; get xoff
	shr	ax,3		; convert xoff to bytes
	add	si,ax		; psrc += xoff
	mov	dh,s_fgpixel[bp]	; dh = foreground color
	mov	dl,s_bgpixel[bp]	; dl = background color
	and	byte ptr s_xoff[bp],7	; just need low 3 bits of xoff
$CS0:
	mov	cl,s_xoff[bp]	; get xoff
	lodsb			; get source byte
	shl	al,cl		; get rid of any offsets
	mov	bh,8
	sub	bh,cl		; ah has number of bits left
	mov	cx,s_dstwidth[bp]	; get number of bytes in one line
same_src:
	shl	al,1		; check bit
	jnc	write_bg
	mov	es:[di],dh	; write out foreground color
	jmp	short $CS1
write_bg:
	mov	es:[di],dl	; write out background color
$CS1:
	inc	di
	jz	page_it
cont_after_page:
	dec	cx
	jcxz	next_line
	dec	bh
	jnz	same_src
	lodsb
	mov	bh,8
	jmp	short same_src
page_it:
	push	ax
	push	dx
	inc	bl
	setpage	bl,bl
	pop	dx
	pop	ax
	jmp	short cont_after_page
next_line:
	dec	word ptr s_dstheight[bp]	; any more
	jz	no_more
	add	si,s_next_src_line[bp]
	add	di,s_next_scan_line[bp]
	jnc	$CS0
	push	dx
	inc	bl
	setpage	bl,bl
	pop	dx
	jmp	short $CS0
no_more:
	pop	di
	pop	si
	pop	es
	pop	ds
	leave
	ret
COPY_STIPPLE	ENDP
