	name	ahead

	.286p

setpage	MACRO	write, read
	mov	ah,write	; get dest
	shl	ah,4
	or	ah,read		; port = (dest << 4) | src
	mov	al,0dh		; register 0dh
	mov	dx,03ceh
	out	dx,ax		; set the page
ENDM

write_page	MACRO		; page to be set is in ah
	mov	al,0dh		; register 0dh
	mov	dx,03ceh
	out	dx,ax		; set the page
		ENDM

page_setup	MACRO	src, dst	; setup page info into reg ah
	mov	ah,dst
	shl	ah,4
	or	ah,src
		ENDM

load_page	MACRO
	mov	ah,c_page[bp]
		ENDM

save_page	MACRO
	mov	c_page[bp],ah
		ENDM

inc_src_page	MACRO		; increment the src page number
	inc	ah		; cannot overflow to the dst page
		ENDM

dec_src_page	MACRO		; decrement the src page number
	dec	ah		; cannot overflow to the dst page
		ENDM

inc_dst_page	MACRO		; increment the dst page number
	add	ah,10h
		ENDM

dec_dst_page	MACRO		; decrement the dst page number
	sub	ah,10h
		ENDM

inc_dst_page_in_mem	MACRO	; increment the dst page number in memory
	add	byte ptr c_page[bp],10h
		ENDM
dec_dst_page_in_mem	MACRO	; decrement the dst page number in memory
	sub	byte ptr c_page[bp],10h
		ENDM

inc_both_pages	MACRO	
	add	ah,11h
		ENDM

include	vga.inc

_text	segment	word public 'CODE'

	ASSUME	cs:_text,ds:nothing,es:nothing

	ORG	0

include common.asm

old_mode	db	?
mono_modes:
	db	11h		; 640x480 mono
	db	71h		; 800x600 16 colors
	db	76h		; 1024x768 mono
color_modes:
	db	61h		; 640x480 256 colors
	db	62h		; 800x600 256 colors
	db	63h		; 1024x768 256 colors

include	acopy.asm
include	stipple.asm

Init	PROC NEAR
	mov	word ptr es:[di+14],offset Init	; free memory
	mov	word ptr es:[di+16],cs		; segment of free memory
	mov	ret_data.close_seg,cs
	mov	ret_data.page_seg,cs
	mov	ret_data.copy_seg,cs
	mov	ret_data.move_seg,cs
	mov	ret_data.c_stipple_seg,cs
	mov	cx,dx
	mov	dx,offset copyright
	mov	ah,9
	int	21h
	mov	dx,cx
	xor	ax,ax			; success
	ret
Init	ENDP

copyright db	10, 13, 'Ahead VGA driver '
include version.asm
include date.asm
	db	'installed.', 10, 13
	db	'Copyright (c) 1991 Starnet Communications '
	db	'Corporation, Inc. All rights reserved.',10,13,'$'

_text	ENDS
	END
