#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <dos.h>

char device[13];

typedef unsigned char u_char;
typedef unsigned long u_long;

struct vga_conf {
	u_char	version;
	u_char	spare;
	void (_far *close)(void);
	void (_far *page)(int);
	void (_far *copy)(int, int, int, int, int, int);
	void (_far *move)(int, int, int, int, int, int, int);
	void (_far *copy_stipple)(int, int, int, int, char far *, int,
	    int, int, u_char, u_char);
};

main(int argc, char **argv)
{
	int fd, i;
	struct vga_conf vga;
	union REGS regs;
	int mode = 0x101;
	char stipple[] = { 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55, 0x55,
			0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa,
			0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11, 0x11,
			0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22, 0x22,
			0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33, 0x33,
			0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44, 0x44,
			0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66, 0x66,
			0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77, 0x77 };

	if (argc > 1)
		strcpy(device, argv[1]);
	else
		strcpy(device, "XWVGA");
	i = _dos_open(device, O_RDONLY|O_BINARY, &fd);
	if (i) {
		fprintf(stderr, "open failed: name %s, code %d\n", device, i);
		exit(1);
	}
	printf("handle is %d\n", fd);
	regs.h.ah = 0x44;            	// write to device
	regs.h.al = 3;
	regs.x.bx = fd;
	regs.x.cx = sizeof mode;
	regs.x.dx = (short)&mode;
	intdos(&regs, &regs);
	if (regs.x.cflag) {
		printf("write failed: error code %d\n", regs.x.ax);
		_dos_close(fd);
		return 1;
	} else {
		printf("wrote %d bytes:\n", regs.x.ax);
	}
	memset(&vga, 0, sizeof vga);
	regs.h.ah = 0x44;
	regs.h.al = 2;
	regs.x.bx = fd;
	regs.x.cx = sizeof vga;
	regs.x.dx = (short)&vga;
	intdos(&regs, &regs);
	if (regs.x.cflag) {
		printf("read failed: error code %d\n", regs.x.ax);
	} else {
		printf("read %d bytes:\n", regs.x.ax);
		printf("    vers=%d\n", vga.version);
		printf("    spare=%d\n", vga.spare);
		printf("    close=%#lx\n", vga.close);
		printf("    page=%#lx\n", vga.page);
		printf("    copy=%#lx\n", vga.copy);
		printf("    move=%#lx\n", vga.move);
		printf("    copy_stipple=%#lx\n", vga.copy_stipple);
		(*vga.copy_stipple)(0, 0, 64, 8, (char _far *)stipple,
		64, 0, 0, 1, 2);
		(*vga.close)();
	}
	_dos_close(fd);
}
