#include <stdio.h>
#include "X.h"
#define NEED_EVENTS
#include "Xproto.h"
#include "misc.h"
#include "window.h"
#include "dix.h"
#include "input.h"
#include "inputstr.h"
#include "ibmmouse.h"
#include "ibmfuncs.h"

u_short near input_ready, near input_ref;
extern int kbdproc(), mouseproc();
extern void near mouseProcessInput(void);
extern void near kbdProcessInput(void);

static void kbdBell(), kbdControlProc();

u_long near TimeLastInput;

void
ProcessInputEvents()
{
	if (input_ready & INPUT_KBD)
		kbdProcessInput();
	if (input_ready & INPUT_MOUSE)
		mouseProcessInput();
}

void
InitInput(argc, argv)
int argc;
char **argv;
{
	DevicePtr dptr;

	dptr = AddInputDevice(kbdproc, TRUE);
	if (dptr)
		RegisterKeyboardDevice(dptr);

	dptr = AddInputDevice(mouseproc, TRUE);
	if (dptr)
		RegisterPointerDevice(dptr);
	input_ready = input_ref = 0;
	SetInputCheck(&input_ready, &input_ref);
	TimeLastInput = GetTimeInMillis();
}

u_long
TimeSinceLastInputEvent()
{

	return GetTimeInMillis() - TimeLastInput;
}
