#include "scrnints.h"
#include "cursorst.h"

struct _IBM_Cur {
	unsigned int	screenMask[16],
			cursorMask[16];
	int		hotX, hotY;
};

struct _IBM_Mouse {
	struct _IBM_Mouse near *next;	/* next element in queue */
	unsigned int	buttonState;
	int		x, y;
	unsigned long	time;
};

#define	MOUSE_CURPOS	0x0001
#define MOUSE_LEFTDOWN	0x0002
#define MOUSE_LEFTUP	0x0004
#define MOUSE_RIGHTDOWN	0x0008
#define MOUSE_RIGHTUP	0x0010
#define MOUSE_MIDDLEDOWN	0x0020
#define MOUSE_MIDDLEUP	0x0040
#define MOUSE_BUTTONPRESS (MOUSE_LEFTDOWN|MOUSE_RIGHTDOWN|MOUSE_MIDDLEDOWN)
#define MOUSE_BUTTONRELSE (MOUSE_LEFTUP|MOUSE_RIGHTUP|MOUSE_MIDDLEUP)

typedef struct _IBM_Cur GraphicCursor;

Bool mouseRealizeCursor(ScreenPtr, CursorPtr);
Bool mouseUnrealizeCursor(ScreenPtr, CursorPtr);
Bool mouseDisplayCursor(ScreenPtr, CursorPtr);
Bool mouseSetCursorPosition(ScreenPtr, int, int, Bool);
void mouseCursorLimits(ScreenPtr, CursorPtr, BoxPtr, BoxPtr);
void mouseConstrainCursor(ScreenPtr, BoxPtr);
void mousePointerNonInterestBox(ScreenPtr, BoxPtr);

#define INPUT_MOUSE	0x0002
#define INPUT_KBD	0x0001

#define MOUSE_ON	0x0001
#define MOUSE_SIM3	0x0004		/* simulate button 3 */
#define MOUSE_PEND	0x0008		/* button 3 simulation pending */
#define MOUSE_DOWN	0x0010		/* fake button 3 is down */
#define MOUSE_OFLO	0x0020

#define NMQUEUE		50
