#include "X.h"
#include "scrnintstr.h"
#include "windowstr.h"
#include "i8.h"
#include "../../mi/mistruct.h"
#include "regionstr.h"
#include "gcstruct.h"
#include "../common/mouse.h"
#include "../../../os/msdos/msdos.h"
#include <string.h>

Bool
i8CreateWindow(pWin)
WindowPtr pWin;
{
	return TRUE;
}

Bool
i8DestroyWindow(pWin)
WindowPtr pWin;
{
#ifdef BACKING_STORE
	if (pWin->backingStore != NotUseful) {
		miFreeBackingStore(pWin);
	}
#endif
	return TRUE;
}

Bool
i8PositionWindow(pWin, x, y)
WindowPtr pWin;
int x, y;
{
	return TRUE;
}

Bool
i8MapWindow(pWin)
WindowPtr pWin;
{
	return TRUE;
}

Bool
i8UnmapWindow(pWin)
WindowPtr pWin;
{
	return TRUE;
}

void 
i8CopyWindow(pWin, ptOldOrg, prgnSrc)
    WindowPtr pWin;
    DDXPointRec ptOldOrg;
    RegionPtr prgnSrc;
{
    RegionPtr prgnDst;
    int dx, dy, width;
    int i;
    RegBoxPtr pbox;
    int y, xMax, yMax;
    int xMin;
    unsigned int	*ordering;
    int		num_rects;

    y = pWin->drawable.y;
    prgnDst = (* pWin->drawable.pScreen->RegionCreate)(NullBox, 
					       REGION_NUM_RECTS(&pWin->borderClip));

    /* turn cursor off while we do the copy */
    HideCursor();
    dx = pWin->drawable.x - ptOldOrg.x;
    dy = y - ptOldOrg.y;
    (* pWin->drawable.pScreen->TranslateRegion)(prgnSrc, dx, dy);
    (* pWin->drawable.pScreen->Intersect)(prgnDst, &pWin->borderClip, prgnSrc);

    num_rects = REGION_NUM_RECTS(prgnDst);
    ordering = (unsigned int *)
        ALLOCATE_LOCAL(num_rects * sizeof(unsigned int));
    if (!ordering)
	return;

    width = pWin->borderWidth;
    ptOldOrg.x -= width;
    ptOldOrg.y -= width;
    width *= 2;
    /* find out which direction to scroll */
    /* if no overlap, it doesn't matter which direction, so stop now */
    if ((unsigned)abs(dy) >= pWin->drawable.height + width ||
      (unsigned)abs(dx) >= pWin->drawable.width + width)
	for (i=0; i < num_rects; i++)
	    ordering[i] = i;
    else {
      if (dy <= 0) { /* Scroll up or stationary vertical.
                                  Vertical order OK */
        if (dx <= 0) { /* Scroll left or stationary horizontal.
                                  Horizontal order OK as well */
          for (i=0; i < num_rects; i++)
            ordering[i] = i;
        } else { /* scroll right. must reverse horizontal banding of rects. */
          for (i=0, xMin=1, xMax=0;
               i < num_rects;
               xMin=i+1, xMax=i) {
            /* find extent of current horizontal band */
            y=REGION_RECTS(prgnDst)[i].y1; /* band has this y coordinate */
            while ((xMin < num_rects) &&
                   (REGION_RECTS(prgnDst)[xMin].y1 == y))
              xMin++;
            /* reverse the horizontal band in the output ordering */
            for (xMin-- ; xMin >= xMax; xMin--, i++)
              ordering[i] = xMin;
          }
        }
      }
      else { /* Scroll down. Must reverse vertical banding. */
        if (dx < 0) { /* Scroll left. Horizontal order OK. */
          for (i=num_rects-1, xMin=i-1, xMax=i, yMax=0;
              i >= 0;
              xMin=i-1, xMax=i) {
            /* find extent of current horizontal band */
            y=REGION_RECTS(prgnDst)[i].y1; /* band has this y coordinate */
            while ((xMin >= 0) &&
                   (REGION_RECTS(prgnDst)[xMin].y1 == y))
              xMin--;
            /* reverse the horizontal band in the output ordering */
            for (xMin++ ; xMin <= xMax; xMin++, i--, yMax++)
              ordering[yMax] = xMin;
          }
        }
        else /* Scroll right or horizontal stationary.
                Reverse horizontal order as well (if stationary, horizontal
                order can be swapped without penalty and this is faster
                to compute). */
          for (i=0, xMin=num_rects-1;
               i < num_rects;
               i++, xMin--)
              ordering[i] = xMin;
      }
    }

    width = ((i8PrivScr *)(pWin->drawable.pScreen->devPrivate))->devKind;

    for (i = 0; i < num_rects; i++) {
	pbox = &REGION_RECTS(prgnDst)[ordering[i]];
	xMin = pbox->x1;
	xMax = pbox->x2;
	y = pbox->y1;
	yMax = pbox->y2;
	if (xMax <= xMin || yMax <= y)
	    continue;

	xMax -= xMin;
	yMax -= y;

	/*
	(*vga_conf.copy)(xMin - dx, y - dy, xMin, y, xMax, yMax);
	*/
    }
    DEALLOCATE_LOCAL(ordering);
#ifdef DIRECT_MOUSE
    /* turn cursor back on */
    ShowCursor();
#endif
    (* pWin->drawable.pScreen->RegionDestroy)(prgnDst);
}

Bool
i8ChangeWindowAttributes(pWin, mask)
WindowPtr pWin;
unsigned long mask;
{

    return(TRUE);
}
