
struct ai_funcs {
	void (_pascal _far *hline)(struct aifpb _far *);
	void (_pascal _far *hcline)(struct aifpb _far *);
	void (_pascal _far *hrline)(struct aifpb _far *);
	void (_pascal _far *hcrline)(struct aifpb _far *);
	void (_pascal _far *hscp)(struct aifpb _far *);		/* 4 */
	void (_pascal _far *hbar)(struct aifpb _far *);
	void (_pascal _far *hear)(struct aifpb _far *);
	void (_pascal _far *hscol)(struct aifpb _far *);
	void (_pascal _far *hopen)(struct aifpb _far *);
	void (_pascal _far *hsmx)(struct aifpb _far *);
	void (_pascal _far *hsbcol)(struct aifpb _far *);		/* 10 */
	void (_pascal _far *hslt)(struct aifpb _far *);
	void (_pascal _far *hslw)(struct aifpb _far *);
	void (_pascal _far *hegs)(struct aifpb _far *);
	void (_pascal _far *hsgq)(struct aifpb _far *);
	void (_pascal _far *hscmp)(struct aifpb _far *);
	void (_pascal _far *hint)(struct aifpb _far *);
	void (_pascal _far *hspatto)(struct aifpb _far *);
	void (_pascal _far *hspatt)(struct aifpb _far *);
	void (_pascal _far *hldpal)(struct aifpb _far *);
	void (_pascal _far *hshs)(struct aifpb _far *);		/* 20 */
	void (_pascal _far *hbbw)(struct aifpb _far *);
	void (_pascal _far *hcbbw)(struct aifpb _far *);
	void (_pascal _far *hbbr)(struct aifpb _far *);
	void (_pascal _far *hbbchn)(struct aifpb _far *);
	void (_pascal _far *hbbc)(struct aifpb _far *);
	void (_pascal _far *hscoord)(struct aifpb _far *);
	void (_pascal _far *hqcoord)(struct aifpb _far *);
	void (_pascal _far *hsmode)(struct aifpb _far *);
	void (_pascal _far *hqmode)(struct hqmode_data _far *);
	void (_pascal _far *hqmodes)(struct aifpb _far *);	/* 30 */
	void (_pascal _far *hqdps)(struct hqdps_data _far *);
	void (_pascal _far *hrect)(struct aifpb _far *);
	void (_pascal _far *hsbp)(struct aifpb _far *);
	void (_pascal _far *hclose)(struct aifpb _far *);
	void (_pascal _far *hesc)(struct aifpb _far *);
	void (_pascal _far *hxlate)(struct aifpb _far *);
	void (_pascal _far *hscs)(struct aifpb _far *);
	void (_pascal _far *hchst)(struct aifpb _far *);
	void (_pascal _far *hcchstg)(struct aifpb _far *);
	void (_pascal _far *ablkmfi)(struct aifpb _far *);		/* 40 */
	void (_pascal _far *ablkcga)(struct aifpb _far *);
	void (_pascal _far *aerase)(struct aifpb _far *);
	void (_pascal _far *ascroll)(struct aifpb _far *);
	void (_pascal _far *acursor)(struct aifpb _far *);
	void (_pascal _far *ascur)(struct aifpb _far *);
	void (_pascal _far *asfont)(struct aifpb _far *);
	void (_pascal _far *axlate)(struct aifpb _far *);
	void (_pascal _far *hinit)(struct aifpb _far *);
	void (_pascal _far *hsync)(struct aifpb _far *);
	void (_pascal _far *hmrk)(struct aifpb _far *);		/* 50 */
	void (_pascal _far *hcmrk)(struct aifpb _far *);
	void (_pascal _far *hsmark)(struct aifpb _far *);
	void (_pascal _far *hslpc)(struct aifpb _far *);
	void (_pascal _far *hrlpc)(struct aifpb _far *);
	void (_pascal _far *hqcp)(struct aifpb _far *);
	void (_pascal _far *hqdfpal)(struct aifpb _far *);
	void (_pascal _far *hspal)(struct aifpb _far *);
	void (_pascal _far *hrpal)(struct aifpb _far *);
	void (_pascal _far *H59)(struct aifpb _far *);
	void (_pascal _far *ascell)(struct aifpb _far *);		/* 60 */
};

/* AI function parameter block */
struct aifpb {
	u_short	length;		/* length of remaining structure */
	u_char	params[8];	/* long enough for simple requests */
};

#pragma pack(1)
struct hqmode_data {
	u_short length;
	u_char	mode;
	u_short	code;
	u_char	adapt_type;
	u_char	disp_type;
	u_char	cell_width;
	u_char	cell_height;
	u_char	planes;
	u_short	width;
	u_short	height;
	u_short	horiz_res;	/* Pixels/inch - horizontal */
	u_short	vert_res;	/* Pixels/inch - vertical */
	u_char	color_flag;
	u_char	bpc;		/* intensity bits per color */
};

struct hldpal_data {
	u_short	length;
	u_char	type;
	u_char	res;
	u_short	first;
	u_short	num;
	struct cm_entry _far *entries;
};

struct cm_entry {
	u_char	red, green, blue, res;
};

struct hqdps_data {
	u_short length;
	u_short	buffer_size;
	u_short	stack_size;
	u_short	palette_size;
};

struct hspatt_data {
	u_short length;
	u_char	width;
	u_char	height;
	u_char	flags;
	u_char	res;
	u_short	patt_size;
	u_char	_far *patt_def;
	u_char	_far *patt_color;
};

struct afipoint {
	u_short	x, y;
};

struct hline_data {
	u_short	length;
	struct afipoint points[5];
};

struct hinit_data {
	u_short	length;
	u_short	task_seg;
};

struct hrect_data {
	u_short	length;
	u_short	x, y;
	u_short	width, height;
};

struct hsbp_data {
	u_short	length;
	u_long	graph_plane;
	u_long	alpha_plane;
	u_long	disp_plane;
};
#pragma pack()

void _fastcall _near callafi(int, char _far *);

#define HLINE(x)	callafi(0, (char _far *)x)
#define HBAR(x)		callafi(5, (char _far *)x)
#define HEAR(x)		callafi(6, (char _far *)x)
#define HOPEN(x)	callafi(8, (char _far *)x)
#define HEGS(x)		callafi(13, (char _far *)x)
#define HSPATT(x)	callafi(18, (char _far *)x)
#define HLDPAL(x)	callafi(19, (char _far *)x)
#define HSHS(x)		callafi(20, (char _far *)x)
#define HQMODE(x)	callafi(29, (char _far *)x)
#define	HQDPS(x)	callafi(31, (char _far *)x)
#define	HRECT(x)	callafi(32, (char _far *)x)
#define HSBP(x)		callafi(33, (char _far *)x)
#define HCLOSE(x)	callafi(34, (char _far *)x)
#define HINIT(x)	callafi(48, (char _far *)x)
#define HSYNC(x)	callafi(49, (char _far *)x)
#define HSPAL(x)	callafi(57, (char _far *)x)
#define HRPAL(x)	callafi(58, (char _far *)x)
