#include "pcdefs.h"
#include "mbuf.h"
#include "protocol.h"
#include "data.h"
#include "config.h"
#include "funcdef.h"

/***************************************************************************
*  netdlayer
*       get data layer address for insertion into outgoing packets.
*   searches based on ip number.  If it finds the address, ok, else . . .
*
*   Checks to see if the address is on the same network.  If it is,
*   then ARPs the machine to get address.  Forces pause between sending
*   arps to guarantee not saturating network.
*
*   If not on the same network, it needs the ether address of a 
*   gateway.  Searches the list of machines for a gateway flag.
*   Returns the first gateway found with an Ethernet address. 
*
*   Returns NULL if not here, or pointer to ether address if here.
*   If we don't have it, this also sends an ARP request so that the
*   next time we are called, the ARP reply may be here by then.
*
*/
u_char _near * _fastcall _near
netdlayer(tipnum)
u_long	tipnum;
{
	u_char _near *cp;
	u_long	time;

	if (slip_mode)
		return(NNULL);

	tipnum = find_route(tipnum);
	time = n_clicks() + ARPWAIT;	/* one second time out */
	do {
		cp = cachelook(tipnum);
		if (cp)
			break;
	} while (n_clicks() < time);
	return(cp);
}

#ifdef notdef
/***************************************************************************
*  getdlayer
*   check for the hardware address one time
*/
u_char _near * _fastcall _near
getdlayer(tipnum)
u_long	tipnum;
{

/*
*  Check to see if we need to go through a gateway.
*  If the machine is on our network, then assume that we can send an ARP
*  to that machine, otherwise, send the ARP to the gateway.
*
*  Uses internet standard subnet mask method, RFC950
*  if subnets are not in use, netmask has been pre-set to the appropriate 
*  network addressing mask.
*/ 
	if (slip_mode)
		return(NNULL);

	return(cachelook(find_route(tipnum)));
}
#endif
