/*
*    data.h
*   Declarations of global variables for TCP/IP libraries
*
****************************************************************************
*                                                                          *
*                                                                          *
*      NCSA Telnet                                                         *
*      by Tim Krauskopf; VT100 by Gaige Paulsen, Tek by Aaron Contorer     *
*                                                                          *
*      National Center for Supercomputing Applications                     *
*      152 Computing Applications Building                                 *
*      605 E. Springfield Ave.                                             *
*      Champaign; IL  61820                                                *
*                                                                          *
****************************************************************************
*         
*/

#define DLAYTIMEOUT	10
/*
*  how often to poke a TCP connection to keep it alive and make
*  sure other side hasn't crashed. (poke) in 1/18ths sec
*  And, timeout interval
*/
#define POKEINTERVAL 3000
#define ARPTO   2
#define ARPWAIT 18
#define CACHETO 7000
#define WAITTIME 35
#define LASTTIME 4000
#define MAXSEG 1024
#define MSS_SMALL	(512-40)

#ifdef MASTERDEF
struct	conf _near	Scon = { 0 };
u_char _near	myether[DADDLEN] = {	/* my ethernet hardware address */
	0x0, 0x0, 0x0, 0x0, 0x0, 0x0
};
u_char _near	etherall[DADDLEN] = {	/* the broadcast address */	
	0xff, 0xff, 0xff, 0xff, 0xff, 0xff
};
u_long _near	ipall = 0L;
u_long _near	nameserver = 0L;
u_long _near	nmask = 0L;
u_int _near	nnipident = 1;		/* ident field of outgoing ip packets */
int _near	slip_mode = 0;
u_short _near	tcpmss = 0;

struct pseudotcp _near otcps = { 0 };
struct pseudotcp _near itcps = { 0 };
struct port far * _near portlist[NPORTS] = { 0 }; /* allocate like in UNIX */
struct acache _near arpc[NPORTS] = { 0 }; /* cache for hardware addresses */
struct route_st _near route[NPORTS] = { 0 };	/* out routing table */
struct mbuf near * _near mbfree = 0;
struct mbuf near * _near mbprocess = 0;
struct mbuf near * _near mbnext = 0;
unsigned char _near mb[NMBUFS * sizeof(struct mbuf)] = { 0 };
unsigned char _near eb[NEBUFS * sizeof(struct ebuf)] = { 0 };

struct arp _near arp = { 0 };
union arpbuff {
	struct	arp	arp;
	u_char	data[AMAXLEN];
};
union arpbuff _near arpbuffer = { 0 };
#define	arpbuf	arpbuffer.arp

unsigned char _near etherbuff[RAWETHER] = { 0 };
union rawether {
	struct ip	ip;
	struct udp	udp;
	struct tcp	tcp;
	struct icmp	icmp;
	u_char data[MTU + sizeof(struct ether)];
};
#define rawip(x) ((x)->ip)
#define rawudp(x) ((x)->udp)
#define rawtcp(x) ((x)->tcp)
#define rawicmp(x) ((x)->icmp)
#define rawdata(x) ((x)->data)

union rawether _near outbuffer = { 0 };
#define ipout outbuffer.ip
#define udpout outbuffer.udp
#define tcpout outbuffer.tcp
#define icmpout outbuffer.icmp
#define rawout outbuffer.data

struct ether _near blankd = { 0 };
struct ip _near blankip = { 0 };
struct bpport _near bpstat = { 0 };		/* buffer for UDP */
int arp_queued = 0;

#else

extern struct conf _near	Scon;
extern u_char _near myether[DADDLEN];	/* my ethernet hardware address */
extern u_char _near etherall[DADDLEN];	/* the broadcast address */
extern u_long _near ipall;
extern u_long _near nameserver;
extern u_long _near nmask;
extern u_int _near nnipident;		/* ident field of ip */
extern int _near slip_mode;
extern u_short _near tcpmss;

extern struct pseudotcp _near otcps;
extern struct pseudotcp _near itcps;
extern struct port far * _near portlist[NPORTS]; /* allocate like in UNIX */
extern struct acache _near arpc[NPORTS]; /* cache for hardware addresses */
extern struct route_st _near route[NPORTS];	/* our routing table */
extern struct mbuf _near * _near mbfree;
extern struct mbuf _near * _near mbprocess;
extern struct mbuf _near * _near mbnext;
extern unsigned char _near mb[NMBUFS * sizeof(struct mbuf)];
extern unsigned char _near eb[NEBUFS * sizeof(struct ebuf)];

extern struct arp _near arp;
union arpbuff {
	struct	arp	arp;
	u_char	data[AMAXLEN];
};
extern union arpbuff _near arpbuffer;
#define	arpbuf	arpbuffer.arp

extern unsigned char _near etherbuff[RAWETHER];
union rawether {
	struct ip	ip;
	struct udp	udp;
	struct tcp	tcp;
	struct icmp	icmp;
	u_char data[MTU + sizeof(struct ether)];
};
#define rawip(x) ((x)->ip)
#define rawudp(x) ((x)->udp)
#define rawtcp(x) ((x)->tcp)
#define rawicmp(x) ((x)->icmp)
#define rawdata(x) ((x)->data)

extern union rawether _near outbuffer;
#define ipout outbuffer.ip
#define udpout outbuffer.udp
#define tcpout outbuffer.tcp
#define icmpout outbuffer.icmp
#define rawout outbuffer.data

extern struct ether _near blankd;
extern struct ip _near blankip;
extern struct bpport _near bpstat;

extern int arp_queued;
#endif
