/*
   -------------------------------------------------------------------
        LANERA TCPOpen source.
 
        Copyright 1991, 1992 LANERA Corporation.
 
        All Rights Reserved.
 
        The copyright above and this notice must be preserved in all
        copies of this source code.  The copyright above does not
        evidence any actual or intended publication of this source
        code.
 
        This is unpublished proprietary trade secret source code of
        LANERA Corporation.  This source code may not be copied,
        disclosed, distributed, demonstrated or licensed except as
        expressly authorized by LANERA Corporation.
 
   -------------------------------------------------------------------
*/
/*   Revision:  1.1   sysent.h   10/12/92   */

/*
 * network system call
 */
#ifndef DLL
#ifdef KERNEL
extern int	socket();
extern int	bind();
extern int	listen();
extern int	accept();
extern int	connect();
extern int	send();
extern int	sendto();
extern int	sendmsg();
extern int	recv();
extern int	recvfrom();
extern int	recvmsg();
extern int	sread();
extern int	swrite();
extern int	sclose();
extern int	sreset();
extern int	sselect();
extern int	sgsignal();
extern int	salarm();
extern int	sioctl();
extern int	sstat();
extern int	setsockopt();
extern int	getsockopt();
extern int	getsockname();
extern int	getpeername();
extern int	shutdown();
extern int	reset();
extern int	config();
extern int	astatus();
extern int	getstats();
extern int	sgsignal();
extern int	salarm();
extern int	disconnect();
#else
extern int	net_init(int);
extern int	socket(int, int, int);
extern int	bind(int, fptr, int);
extern int	listen(int, int);
extern int	accept(int, fptr, int far *);
extern int	connect(int, fptr, int);
extern int	sendto(int, fptr, int, int, fptr, int);
extern int	send(int, fptr, int, int);
extern int	sendmsg(int, struct msghdr far *, int);
extern int	recvfrom(int, fptr, int, int, fptr, int far *);
extern int	recv(int, fptr, int, int);
extern int	recvmsg(int, struct msghdr far *, int);
extern int	sread(int, fptr, unsigned);
extern int	swrite(int, fptr, unsigned);
extern int	sclose(int);
extern int	sreset(fptr);
extern int	sexit(int);
extern int	select(int, fd_set far *, fd_set far *, fd_set far *, struct timeval far *);
extern int	sgsignal(int, fptr);
extern int	salarm(int, int);
extern int	ioctl(int, int, fptr);
extern int	sstat(int, fptr, int, int);
extern int	setsoopt(int, int, int, fptr, int);
extern int	getsoopt(int, int, int, fptr, int far *);
extern int	gethostname(char *, int);
extern int	getsockname(int, fptr, int far *);
extern int	getpeername(int, fptr, int far *);
extern int	shutdown(int, int);
extern int	reset();
extern int	config();
extern int	astatus();
extern int	getstats(int, fptr, int);
extern int	sgsignal(int, fptr);
extern int	salarm(int, int);
extern int	sleep(int);
#endif	/* KERNEL */
#endif	/* !DLL */

struct syscall {
	int     (*proc)();
	int     argcnt;	
	int	socketreq;		/* required socket id ?		*/
};

struct debug_argv{
	int	flags;			/* tell which deug type to set	     */
	int	layer;			/* debugging protocol layer	     */
	int	outp;			/* output medium, video, printer,... */
};

struct socket_argv {
	int	domain;
	int	type;
	int	protocol;
};
struct bind_argv {
	int	s;
	fptr	name;
	int	namelen;
};
struct listen_argv {
	int	s;
	int	backlog;
};
struct accept_argv {
	int	s;
	fptr	name;
	int far	*anamelen;
};
struct connect_argv {
	int	s;
	fptr	name;
	int	namelen;
};
struct sendto_argv {
	int	s;
	fptr	buf;
	int	len;
	int	flags;
	fptr	to;
	int	tolen;
};
struct send_argv {
	int	s;
	fptr    buf;
	int	len;
	int	flags;
};
struct sendmsg_argv {
	int	s;
	struct	msghdr far *msg;
	int	flags;
};
struct recvfrom_argv {
	int	s;
	fptr	buf;
	int	len;
	int	flags;
	fptr	from;
	int far	*fromlenaddr;
};
struct recv_argv {
	int	s;
	fptr	buf;
	int	len;
	int	flags;
};
struct recvmsg_argv {
	int	s;
	struct	msghdr far *msg;
	int	flags;
};
struct shutdown_argv {
	int	s;
	int	how;
};
struct setsockopt_argv {
	int	s;
	int	level;
	int	name;
	fptr	val;
	int	valsize;
};
struct getsockopt_argv {
	int	s;
	int	level;
	int	name;
	fptr	val;
	int far *avalsize;
};
struct getsockname_argv {
	int	s;
	fptr	asa;
	int far	*alen;
};
struct getpeername_argv {
	int	s;
	fptr	asa;
	int far	*alen;
};

struct read_argv {
	int	s;
	fptr	cbuf;
	unsigned count;
};
struct write_argv {
	int	s;
	fptr	cbuf;
	unsigned count;
};
struct salarm_argv {
	int	s;
	int timeo;
};
struct ioctl_argv {
	int	s;
	int	cmd;
	fptr	cmarg;
};
struct stat_argv {
	int  	s;
	fptr 	sb;
	int     sb_len;
	int	sb_flag;	/* what stat, see definition stat.h */
};
struct close_argv {
	int	s;
};
struct select_argv  {
	int	nd;
	fd_set	far *in; 
	fd_set  far *ou; 
	fd_set  far *ex;
	struct  timeval far *timeo; 
};
struct signal_argv {
	int	s;
	fptr	signalp;	/* pointer to a u_long in appl space */
};
struct stats_argv  {
	int	st_id;
	fptr    st_buf;
	int	st_blen;
};
struct deinstall_argv {
	int	flags;
#define DEINS_IF_SAFE	0
#define	DEINS_BY_FORCE	1
};
struct disconnect_argv {
	int	s;
};

#define PANIC_BUFSIZ	200
struct read_panic_argv {
	int	 len;
	fptr	 buf;
};

struct reset_argv {
	fptr	d_name;
};

