#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include "defs.h"

int neterrno;

char *neterr_list[] = {
	"No error",					/*  0 */
	"System error",					/*  1 */
	"Address in use",				/*  2 */
	"Out of resources (memory/connections)",	/*  3 */
	"Not a network descriptor",			/*  4 */
	"Network unreachable",				/*  5 */
	"Host unreachable",				/*  6 */
	"Connection not established",			/*  7 */
	"Can't broadcast",				/*  8 */
	"Operation would block",			/*  9 */
	"Timeout",					/* 10 */
	"Unknown host",					/* 11 */
	"Bad system call",				/* 12 */
	"Bad argument",					/* 13 */
	"System error",					/* 14 */
	"Operation not supported",			/* 15 */
	"Connection refused",				/* 16 */
	"Network transport not loaded",			/* 17 */
	0
};

void
net_perror(str)
const char *str;
{
	if (neterrno == NETERR_ERRNO) {
		perror(str);
		return;
	}
	if (str)
		fprintf(stderr, "%s: ", str);
	if (neterrno < 0 || neterrno > MAX_NET_ERR || !neterr_list[neterrno])
		fprintf(stderr, "Error %d\n", neterrno);
	else
		fprintf(stderr, "%s\n", neterr_list[neterrno]);
}

/*
 * Map from Microsoft C errno to Watcom errno.
 */
static int map[] = {
	0, EACCES, ENOENT, 0, EINTR, 0, 0, E2BIG,
	ENOEXEC, EBADF, ECHILD, 0, ENOMEM, EACCES, 0, 0,
	0, EEXIST, EXDEV, 0, 0, 0, EINVAL, ENFILE,
	EMFILE, 0, 0, 0, ENOSPC, 0, 0, 0,
	0, EDOM, ERANGE, 0, EDEADLOCK
};

#define nerrors	(sizeof map / sizeof map[0])

void
map_errno(err)
int err;
{
    if (err < 0 || err >= nerrors || map[err] == 0)
	errno = err;
    else
	errno = map[err];
}
