#include "../defs.h"
#include <xti.h>

static int map[] = {
	0,			/*  0: TSUCCESS */
	NETERR_BADARGS,		/*  1: TBADADDR */
	NETERR_BADARGS,		/*  2: TBADOPT */
	NETERR_OTHER+1,		/*  3: TACCES */
	NETERR_BADFD,		/*  4: TBADF */
	NETERR_ADDRINUSE,	/*  5: TNOADDR */
	NETERR_NOTESTAB,	/*  6: TOUTSTATE */
	NETERR_BADARGS,		/*  7: TBADSEQ */
	NETERR_ERRNO,		/*  8: TSYSERR */
	NETERR_OTHER+3,		/*  9: TLOOK */
	NETERR_BADARGS,		/* 10: TBADDATA */
	NETERR_NOMEM,		/* 11: TBUFOFLW */
	NETERR_WOULD_BLOCK,	/* 12: TFLOW */
	NETERR_WOULD_BLOCK,	/* 13: TNODATA */
	NETERR_OTHER+5,		/* 14: TNODIS */
	NETERR_OTHER+6,		/* 15: TNOUDERR */
	NETERR_BADARGS,		/* 16: TBADFLAG */
	NETERR_OTHER+7,		/* 17: TNOREL */
	NETERR_NOSUPPORT,	/* 18: TNOTSUPPORT */
	NETERR_OTHER+8,		/* 19: TSTATECHNG */
	NETERR_BADARGS,		/* 20: TNOSTRUCTYPE */
	NETERR_NOSUPPORT,	/* 21: TBADNAME */
	NETERR_BADARGS,		/* 22: TBADQLEN */
	NETERR_ADDRINUSE,	/* 23: TADDRBUSY */
	NETERR_OTHER+9,		/* 24: TINDOUT */
	NETERR_NOSUPPORT,	/* 25: TPROVMISMATCH */
	NETERR_BADARGS,		/* 26: TRESQLEN */
	NETERR_OTHER+10,	/* 27: TRESADDR */
	NETERR_OTHER+11,	/* 28: TQFULL */
	NETERR_SYSTEM,		/* 29: TPROTO */
	0
};
#define nerrors (sizeof map / sizeof map[0])

int _fastcall
convert_error(err)
int err;
{
	if (err < 0 || err >= nerrors)
		return err;
	return map[err];
}
