#define SOCK_STREAM     1               /* stream */
#define SOCK_DGRAM      2               /* datagram */
#define SO_ACCEPTCONN   2               /* Allow incoming connections */
#define AF_INET         2               /* internet */

#define SIOCDONE        0x7300
#define FIONREAD        0x667f
#define FIONBIO         0x667e

#define BRDINIT 0
#define BRDADDR 10

#define EBADF           9
#define EWOULDBLOCK     35              /* function would block */
#define EMSGSIZE        40              /* message to big for buffers */
#define EAFNOSUPPORT    47              /* Address family not supported */
#define ECONNABORTED    53              /* User requested hangup */
#define ENOBUFS         55              /* No buffers available */
#define EISCONN         56              /* Socket has closed */
#define ENOTCONN        57              /* Socket is not connected */
#define ESHUTDOWN       58              /* Socket is closed */
#define ETOOMANYREFS    59              /* Too many sockets open */
#define ETIMEDOUT       60              /* Connection timed out */
#define ECONNREFUSED    61              /* Connection refused */


struct sockaddr {
        short sa_family;
        char sa_data[14];
        };

struct sockproto {
        short sp_family;
        short sp_protocol;
        };

struct  hostent {
        char    *h_name;        /* official name of host */
        char    **h_aliases;    /* alias list */
        int     h_addrtype;     /* host address type */
        int     h_length;       /* length of address */
        char    **h_addr_list;  /* list of addresses from name server */
#define h_addr  h_addr_list[0]  /* address, for backward compatiblity */
};

unsigned long htonl(unsigned long);
unsigned long ntohl(unsigned long);
unsigned short htons(unsigned short);
unsigned short ntohs(unsigned short);
int loaded(void);
int socket(int,struct sockproto *,struct sockaddr *,int);
int soioctl(int,int,char *);
int soclose(int);
int sowrite(int, char *, int);
int soread(int, char *, int);
int accept(int , struct sockaddr *);
int connect(int, struct sockaddr *);
int socketaddr(int, struct sockaddr *);
int sosend(int, struct sockaddr *, char *, int);
int soreceive(int, struct sockaddr *, char *, int);
int soselect(int , long *, long *, long );
unsigned long inet_addr(char *);
char *raddr(unsigned long);
unsigned long rhost(char **);
int brdopen(int ,int );
int brdioctl(int ,int ,unsigned long *);
int brdread(int ,unsigned char *,int);
int brdwrite(int ,char *,int );
int brdclose(int );
