typedef unsigned long u_long;
typedef unsigned short u_short;
typedef unsigned char u_char;

#pragma pack(1)
struct eth {
	int	io;
	char	dma;
	char	vector;
	char	irq;
	int	buffer_size;
	int	maximum_window;
	int	time_zone;
	char	my_type;
	long	internet_address;
	int	value;
	char	subnet_mask;
	int	ether_pointer;
	int	log_server_pointer;
	int	name_server_pointer;
	int	print_server_pointer;
	int	time_server_pointer;
	int	gateway_pointer;
	int	driver_segment;
	char	transfer_size;
	char	card_name[9];
};

struct iph {
	u_char	versionandhdrlen;	/* I prefer to OR them myself */
					/* each half is four bits */
	u_char	service;		/* type of service for IP */
	u_short	tlen;			/* total length of IP packet */
	u_short	ident;			/* these are all BYTE-SWAPPED! */
	u_short	frags;			/* combination of flags and value */
	u_char	ttl;    		/* time to live */
	u_char	protocol;		/* higher level protocol type */
	u_short	check;			/* header checksum, byte-swapped */
	u_long	ipsource;		/* IP addresses */
	u_long	ipdest;
};

struct udph {
	u_short	source;		/* port numbers, all byte-swapped */
	u_short	dest;
	u_short	length;		/* length of packet, including hdr */
	u_short	check;		/* TCP checksum of whole packet */
};

struct udp_input {
         int udp_lp;
         int udp_dp;
         int udp_odlen;
	 int udp_ptr;		/* 6 */
	 u_char pad[6];		/* 8 */
	 struct iph ip;		/* 14 */
	 struct udph udp;	/* 34 */
};

struct udp_output {
         int udp_lp;		/* 0:  local port */
         int udp_dp;		/* 2:  destination port */
         int udp_odlen;		/* 4:  output data length */
	 u_long udp_dest;	/* 6:  IP destination address */
         unsigned char udp_otb[14];	/* 10 */
	 struct iph udp_otb_ip;		/* 24 */
	 struct udph udp_otb_udp;	/* 44 */
					/* 52 */
};

#pragma pack()

extern struct eth _eth;
extern int _near errno;

#define htons(x) ((u_short)((u_char)(x) << 8) | (u_char)((u_short)(x) >> 8))
#define ntohs(x) ((u_short)((u_char)(x) << 8) | (u_char)((u_short)(x) >> 8))

#define EBADF           9
#define EWOULDBLOCK     35              /* function would block */
#define EMSGSIZE        40              /* message to big for buffers */
#define EAFNOSUPPORT    47              /* Address family not supported */

#define	TCP_ERR_USR_HANGUP	50
#define	TCP_ERR_HANGUP		51
#define	TCP_ERR_NET_ERR		52
#define	TCP_ERR_IS_CLOSED	53
#define	TCP_ERR_TIME_OUT	54
#define	TCP_ERR_RESET		55
#define	TCP_ERR_FULL		56
#define	TCP_ERR_BLOCK		57
#define	TCP_ERR_SHUTDOWN	58
