/***********************************************************
Copyright 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* $XConsortium: snf_util.c,v 1.7 88/10/10 19:34:56 rws Exp $ */

#include <stdio.h>
#include "Xos.h"
#include <sys/stat.h>

#include "X.h"
#include "Xproto.h"
#include "Xmd.h"

#include "fontstruct.h"
#include "../../server/ddx/snf/snfstruct.h"
#include "../bdftosnf/bdftosnf.h"

#include "fontdir.h"

#ifdef DEBUG
#define	DUMPSTR(str)						\
	do {							\
  	    if (!str || !*str)  				\
		fprintf(stderr, "%s: (%s)\n",#str, "NULL");   	\
	    else                                       		\
		fprintf(stderr, "%s: (%s)\n",#str, str);   	\
	} while (0)

#define EXIT(n)		fprintf(stderr,"exit: %d\n", (n))
#else
#define	DUMPSTR(str)
#define EXIT(n)
#endif

void GetSNFFontName( fp, font_name)
    FILE *fp;
    char *font_name;
{
    FontInfoRec	fi;
    FontPropPtr	pffp;
    char	*propspace;
    size_t	bytestoread;
    int		i;
    long	offset;
    char	*strings;
    struct stat	stats;
    int		c;

    bytestoread = sizeof(FontInfoRec);
    if ( fread((char *)&fi, 1, bytestoread, fp) != bytestoread) {
	DUMPSTR(font_name);	
	font_name[0] = NUL;
	EXIT(1);
        return;
    }

    if (fi.version1 != FONT_FILE_VERSION || fi.version2 != FONT_FILE_VERSION) {
	DUMPSTR(font_name);	
	font_name[0] = NUL;
	EXIT(2);
	return;
    }

    /* skip what we find unintersting */
    offset = BYTESOFCHARINFO(&fi) + BYTESOFGLYPHINFO(&fi);
    fstat(fileno(fp), &stats);
    if ((stats.st_mode & S_IFMT) == S_IFREG) {
	if (fseek(fp, offset, SEEK_CUR)) {
	    perror("fseek");
	    return;
	}
    } else {
	while (offset-- && ((c = getc(fp)) != EOF))
	    ;
	if (c == EOF) {
	    fprintf(stderr, "%s: file too small\n", font_name);
	    return;
	}
    }

    /* now read properties */
    bytestoread = BYTESOFPROPINFO(&fi) + BYTESOFSTRINGINFO(&fi);
    propspace = (char *) malloc(bytestoread);
    if (propspace == 0) {
	font_name[0] = NUL;
	perror("malloc");
	return;
    }

    if (fread(propspace, 1, bytestoread, fp) != bytestoread) {
	free(propspace);
	DUMPSTR(font_name);	
	font_name[0] = NUL;
	EXIT(3);
        return;
    }

    pffp = (FontPropPtr)propspace;
    strings = propspace + BYTESOFPROPINFO(&fi);
    for (i = 0; i < fi.nProps; i++, pffp++) {
	if (strcmp(&strings[pffp->name], "FONT") == 0) {
	    if (pffp->indirect)	/* right type for name */
		strcpy(font_name, &strings[pffp->value]);
	    break;
	}
    }
    free(propspace);
}
