/***********************************************************
Copyright 1988 by Digital Equipment Corporation, Maynard, Massachusetts,
and the Massachusetts Institute of Technology, Cambridge, Massachusetts.

                        All Rights Reserved

Permission to use, copy, modify, and distribute this software and its 
documentation for any purpose and without fee is hereby granted, 
provided that the above copyright notice appear in all copies and that
both that copyright notice and this permission notice appear in 
supporting documentation, and that the names of Digital or MIT not be
used in advertising or publicity pertaining to distribution of the
software without specific, written prior permission.  

DIGITAL DISCLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING
ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS, IN NO EVENT SHALL
DIGITAL BE LIABLE FOR ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR
ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
SOFTWARE.

******************************************************************/

/* $XConsortium: mkfontdir.c,v 1.10 88/10/11 08:07:40 rws Exp $ */

#include <stdio.h>
#include <dos.h>
#include <errno.h>
#include "xos.h"
/* #include <X11/Xmu.h>  don't include this */
void CopyISOLatin1Lowered();

#include "fontdir.h"

#define  XK_LATIN1
#include "keysymdef.h"

typedef void (*GetNameProc)(FILE *, char *);
typedef struct _FileType {
    char 		*extension;
    GetNameProc		proc;
    char		**filter;
} FileTypeRec, *FileType;

extern void GetSNFFontName(FILE *, char *);

/*
 * The table of font file formats that are understood.  Order is important.
 */
static FileTypeRec fileTypes[] = {
    {".snf", GetSNFFontName, NULL},
    {0, 0, 0}
};

/*
 * Only works when table is freshly built. I.e. it cannot contain any aliases.
 */
static void WriteFontDir(table)
    FontTable table;
{
    char name[256];
    FILE *file;
    int i;
    int width = 0;

    /* XXX unix dependent file-name mangling */
    strcpy(name, table->directory);
    strcat(name, FontDirFile);
    file = fopen(name, "w");
    if (file == NULL)
	return;
    for (i = 0; i < table->name.used; i++) {
	int idx = table->name.fn[i].u.index;
	int len = strlen(table->file.ff[idx].name);
	if (len > width)
	    width = len;
    }
    width += 4;
    fprintf(file, "%d\n", table->name.used);
    for (i = 0; i < table->name.used; i++) {
	int idx = table->name.fn[i].u.index;
	fprintf(file, "%-*s %s\n",
		width, table->file.ff[idx].name, table->name.fn[i].name);
    }
    fclose(file);
}

#if defined(macII) || (defined(SYSV) && !defined(hpux))
#define vfork() fork()
#endif

static int
FontFilter(fp, filter)
    FILE *fp;
    char **filter;
{
    int pfd[2];
    int pid;

    if (pipe(pfd) < 0) {
	fclose(fp);
	return (-1);
    }
    switch(pid = vfork()) {
    case 0:
	dup2(fileno(fp), 0);
	close(fileno(fp));
	dup2(pfd[1], 1);
	close(pfd[0]);
	close(pfd[1]);
	execvp(filter[0], filter);
	_exit(127);
    case -1:
	close(pfd[0]);
	close(pfd[1]);
	fclose(fp);
	return(-1);
    default:
	dup2(pfd[0], fileno(fp));
	close(pfd[0]);
	close(pfd[1]);
	return(pid);
    }    
}

static Boolean ProcessFile (dir, path, table, fileType)
    struct find_t *dir;
    char *path;
    FontTable table;
    FileType fileType;
{
    int i, j;
    Boolean found;
    FILE *file;
    char font_name[256];
    int pid, child;
    char extension[16];

    file = fopen(path, "rb");
    if (file == NULL) {
	perror(path);
	return False;
    }
    i = strlen(dir->name) - strlen(fileType->extension);
    strncpy(font_name, dir->name, i + 1);
    font_name[i] = NUL;

    if (fileType->filter) {
#ifdef notdef
	pid = FontFilter(file, fileType->filter);
	if (pid < 0) {
	    fprintf (stderr, "failed to process file %s\n", path);
	    return False;
	}
#endif
	return False;
    }
    (*fileType->proc)(file, font_name);
    fclose(file);
#ifdef notdef
    if (pid >= 0)
       do { child = wait(0); } while (child != pid && child != -1);
#endif
    if (strlen(font_name) == 0) {
	fprintf(stderr, "%s: invalid font, skipping\n", path);
	return False;
    }
    CopyISOLatin1Lowered (font_name, font_name);
    i = AddFileEntry(table, dir->name, False);
    j = FindNameInFontTable (table, font_name, &found);
    if (found) {
	fprintf (stderr, "duplicate FONT property %s in file %s and %s\n",
	    font_name, path, table->file.ff[table->name.fn[j].u.index].name);
	return False;
    }
    (void) AddNameEntry(table, font_name, i);
    return True;
}

static int
EnumFiles(directory, fileType, data)
    char *directory;
    FileType fileType;
    FontTable data;		/* should be an opaque type */
{
    struct	find_t file;
    char	*cp;
    int     count = 0;
    char    filepath[256];

    strcpy(filepath, directory);
    cp = filepath + strlen(filepath);
    if (cp[-1] != '\\')
	*cp++ = '\\';
    *cp = '*';
    strcpy(cp+1, fileType->extension);
    if (_dos_findfirst(filepath, _A_NORMAL, &file))
	return 0;

    do {
	strcpy(cp, file.name);
	if (ProcessFile(&file, filepath, data, fileType))
	    count++;
    } while (_dos_findnext(&file) == 0);
    return count;
}

static void DoDirectory(dir)
    char *dir;
{
    char *cp;
    FontTable table;
    char dirName[256];
    FileType fileType;

    /* XXX unix dependent file-name mangling */
    strcpy(dirName, dir);
    cp = dirName + strlen(dirName) - 1;
    if (*cp == '/')
	*cp = '\\';
    else if (*cp != '\\') {
	*++cp = '\\';
	*++cp = 0;
    }
    table = MakeFontTable(dirName, 5);
    for (fileType = fileTypes; fileType->extension; fileType++)
	(void)EnumFiles(dir, fileType, table);
    if (table->file.used > 0)
	WriteFontDir(table);
    FreeFontTable(table);
}

main (argc, argv)
    int argc;
    char **argv;
{
    int i;

    if (argc == 1)
	DoDirectory(".");
    else
	for (i = 1; i < argc; i++) {
	    DoDirectory(argv[i]);
 	}
    exit(0);	
}

Xfree (l)
unsigned long	*l;
{
	free ((char *) l);
}

unsigned long *
Xalloc (n)
unsigned long	n;
{
	extern char	*malloc ();

	return (unsigned long *) malloc ((unsigned) n);
}

unsigned long *
Xrealloc (l, n)
unsigned long	*l;
unsigned long	n;
{
	extern char	*realloc ();

	return (unsigned long *) realloc ((char *) l, (unsigned) n);
}

/*
 * ISO Latin-1 case conversion routine
 *
 * this routine always null-terminates the result, so
 * beware of too-small buffers
 */

void
CopyISOLatin1Lowered(dest, source)
    unsigned char *dest, *source;
{

    for (; *source; source++, dest++) {
	if ((*source >= XK_A) && (*source <= XK_Z))
	    *dest = *source + (XK_a - XK_A);
	else if ((*source >= XK_Agrave) && (*source <= XK_Odiaeresis))
	    *dest = *source + (XK_agrave - XK_Agrave);
	else if ((*source >= XK_Ooblique) && (*source <= XK_Thorn))
	    *dest = *source + (XK_oslash - XK_Ooblique);
	else
	    *dest = *source;
    }
    *dest = '\0';
}
