
/************************************************************************/
/*                                                                      */
/*                   ****   *****  *   *  ****   ****                   */
/*                   *   *    *     * *   *   *  *                      */
/*                   ****     *      *    ****   ***                    */
/*                   *   *    *      *    *      *                      */
/*                   ****     *      *    *      ****                   */
/*                                                                      */
/*                    The GEM Programmer's Workbench                    */
/*                            Workbench types                           */
/*                                                                      */
/*                     +--------------------------+			*/
/*		       |       Dylan Harris       |			*/
/*		       | Cyberspace Services Ltd. |			*/
/*		       |                          |			*/
/*		       |   www.cyberspace.co.uk   |			*/
/*		       |  dylan@cyberspace.co.uk  |			*/
/*		       |                          |			*/
/*		       |      070 50 164 263      |			*/
/*		       |    0870 052 4051 (Fax)   |			*/
/*		       |                          |			*/
/*		       |   Originally written by  |			*/
/*		       |     Dylan Harris for     |			*/
/*		       |   Software Experts Ltd.  |			*/
/*		       +--------------------------+			*/
/*                                                                      */
/************************************************************************/

#include "portab.h"     /* portable C types and some useful macros        */
#include "machine.h"    /* machine independent addressing macros          */
#include "obdefs.h"     /* GEM AES structures and associated constants    */
#include "treeaddr.h"   /* to access OBJECT fields                        */
#include "vdibind.h"    /* VDI library bindings functions                 */
#include "gembind.h"    /* AES library bindings functions                 */
#include "dosbind.h"    /* GEM operating system semi-independant bindings */

typedef struct /* LONG_GRECT */ {

  LONG l_x, l_y, l_w, l_h;

} LONG_GRECT;

typedef struct /* window_struct */ {

  WORD  _handler,               /* AES window handler                   */
        _components,            /* window's components                  */
        (*_drawer) (),          /* draw function                        */
        _control,               /* window control bits                  */
        _which_rectangle [2],   /* which rectangle being awaited        */
        _intersect [2],         /* is rectangle to intersect work area? */
        _mouseform [2],         /* mouse form when inside rectangle     */
        _full_size,             /* TRUE if currently full size          */
        _up_move, _across_move; /* distances moved with arrows          */
  GRECT _old,                   /* old or hidden window size            */
        _rectangle [2];         /* awaited rectangle                    */
  LONG  _contents;              /* window's display tree                */
  LONG_GRECT _theoretical_area; /* 'area' of contents of window         */

} window_struct;

/* general definitions */

#define GFILL(a,h,i,j,k) ((a.g_x=(h)), (a.g_y=(i)), (a.g_w=(j)), (a.g_h=(k)))
#define ABS(x) ((x) < 0 ? -1*(x) : (x))
#define GEM_NULL 0x0L
#define QUANTITY_WINDOWS 5
     /* includes room for background window (AES window zero) */

/* for details of constants, see the relevent function declarations */

/* flags */

#define WB_SUPRESS_REDRAW 1

/* wb_start */

#define WB_RESOURCE_ERROR -1
#define WB_APPL_ERROR -2

/* wb_dialogue */

#define WB_START 1
#define WB_REDRAW 2
#define WB_FINISH 4
#define WB_ALL 7
#define WB_CONTINUE 8

/* wb_state */

#define WB_SET 1
#define WB_RESET 0
#define WB_TOGGLE -1

/* wb_dstate */

#define WB_DISPLAY 1
#define WB_NEXT 2
#define WB_INCLUDE 3
/* WB_FINISH 4  - defined above! */

/* wb_open */

#define WB_HIDDEN 0x0001
#define WB_LOWSUPPORT 0x0002 
#define WB_LOWMOUSE 0x0004
/* WB_ACTIVATE (0x0010), WB_SELECT (0x1000) defined below */
#define WB_DRAGSELF 0x0008
#define WB_DRAGANY 0x0020

/* wb_rectangle */

#define WB_WORK 0
#define WB_CURRENT 1
#define WB_OBJECT 2
#define WB_WINDOW 3
#define WB_ROOT 4
#define WB_ABSOLUTE 5
#define WB_NONE -1

/* wb_await */

#define WB_0ENTER 0x0001
#define WB_0LEAVE 0x0002
#define WB_1ENTER 0x0004
#define WB_1LEAVE 0x0008
#define WB_ACTIVATE 0x0010
#define WB_DRAG 0x0020
#define WB_CLOSE 0x0040
#define WB_MENU 0x0080
#define WB_MESSAGE 0x0100
#define WB_DELAY 0x0200
#define WB_KEYBOARD 0x0400
#define WB_MOUSE 0x0800
#define WB_SELECT 0x1000
#define WB_DESELECT 0x2000
#define WB_SUPPORT 0x4000

