(* Programm: gembind.pas
   Funktion: Programmierschnittstelle zu
             GEM fr Pascal
   Sprache:  Turbo-Pascal ab 5.0
   Autor:    Jan Willamowius
   (C) 1991 DMV Widuch GmbH & Co KG      *)

unit Gembind;

interface

uses Dos;

const
  No_Window = -1;  {kein Fenster verfgbar}
  Root = 0;        { Wurzel des Objektbaum}
  Null_Index = -1; { kein Objekt gefunden }
  Max_Depth = 8;   { Maximale Schachte-
                     lungstiefe }
  Max_Tree = 100;  { Maximale Baumgre }
  
  Max_C_String = 255; {Maximale Lnge eines 
                       C_String in Pascal }
  
  Max_Fn = 12;     { Lnge des Dateinamen }
  Max_Path = 80;   { Lnge des Pfadnamen }
  Max_WTitle = 80; { Lnge des 
                     Fenstertitels }
  
  R_Tree = 0;      { Resourcestrukturen }
  R_String = 5;
  
  E_Keyboard =  1;
  E_Button   =  2;
  E_Mouse1   =  4;
  E_Mouse2   =  8;
  E_Message  = 16;
  E_Timer    = 32;

  Replace_Mode   = 1;
  Trans_Mode     = 2;
  XOR_Mode       = 3;
  Rev_Trans_Mode = 4;

  Solid      = 1;
  LongDash   = 2;
  Dotted     = 3;
  DashDot    = 4;
  Dashed     = 5;
  DashDotDot = 6;

  Normal      =   0;
  Thickened   =   1;
  Lightened   =   2;
  Slanted     =   4;
  Underlined  =   8;
  Outlined    =  16;
  Shadowed    =  32;
  Draw3D      =  64;
  WhiteBak    = 128;

  System_Font = 3;
  Small_Font  = 5;
  
  G_Box       = 20;
  G_Text      = 21;
  G_BoxText   = 22;
  G_Image     = 23;
  G_ProgDef   = 24;   
  { 2 Namen fr die gleiche Sache }
  G_UserDef   = 24;
  G_IBox      = 25;
  G_Button    = 26;
  G_Boxchar   = 27;
  G_String    = 28;
  G_FText     = 29;
  G_FBoxText  = 30;
  G_Icon      = 31;
  G_Title     = 32;
  
  None        = $000;
  Selectable  = $001;
  Default     = $002;
  Exit_Btn    = $004;
  Editable    = $008;
  Radio_Btn   = $010;
  Last_Ob     = $020;
  Touch_Exit  = $040;
  Hide_Tree   = $080;
  Indirect    = $100;
  
  Selected    = 1;
  Crossed     = 2;
  Checked     = 4;
  Disabled    = 8;
  
  G_Name      = $001;
  G_Close     = $002;
  G_Full      = $004;
  G_Move      = $008;
  G_Info      = $010;
  G_Size      = $020;
  G_UpArrow   = $040;
  G_DnArrow   = $080;
  G_VSlide    = $100;
  G_LArrow    = $200;
  G_RArrow    = $400;
  G_HSlide    = $800;
  G_All       = $FEF;
  
  White   =  0;
  Black   =  1;
  Red     =  2;
  Green   =  3;
  Blue    =  4;
  Cyan    =  5;
  Yellow  =  6;
  Magenta =  7;
  L_White =  8;
  L_Black =  9;
  L_Red   = 10;
  L_Green = 11;
  L_Blue  = 12;
  L_Cyan  = 13;
  L_Yellow = 14;
  L_Magenta = 15;

  MN_Selected = 10;
  WM_Redraw   = 20;
  WM_Topped   = 21;
  WM_Closed   = 22;
  WM_Fulled   = 23;
  WM_Arrowed  = 24;
  WM_HSlid    = 25;
  WM_VSlid    = 26;
  WM_Sized    = 27;
  WM_Moved    = 28;
  WM_Newtop   = 29;
  WM_Untopped = 30;
  AC_Open     = 40;
  AC_Close    = 41;
  
  WF_Kind     =  1;
  WF_Name     =  2;
  WF_Info     =  3;
  WF_WorkXYWH =  4;
  WF_CurrXYWH =  5;
  WF_PrevXYWH =  6;
  WF_FullXYWH =  7;
  WF_HSlide   =  8;
  WF_VSlide   =  9;
  WF_Top      = 10;
  WF_FirstXYWH = 11;
  WF_NextXYWH = 12;
  WF_Newdesk  = 14;
  WF_HSlSize  = 15;
  WF_VSlSize  = 16;
  WF_Screen   = 17;
  WF_TAttrb   = 18;
  WF_SizTop   = 19;
  
  Crystal: array [10..125,1..3] of
    Integer = (
  (0,1,0), (2,1,1), (2,1,1), (0,1,1),
  (2,1,1), (1,1,1), (0,0,0), (0,0,0),
  (0,0,0), (0,1,0), (0,1,0), (3,5,0),
  (5,5,0), (0,1,1), (2,1,0), (16,7,1),
  (2,1,0), (0,0,0), (0,0,0), (0,0,0),
  (1,1,1), (2,1,1), (2,1,1), (2,1,1),
  (1,1,2), (1,1,1), (0,0,0), (0,0,0),
  (0,0,0), (0,0,0), (2,1,1), (1,1,1),
  (6,1,1), (4,1,1), (1,3,1), (2,1,1),
  (4,2,1), (8,1,1), (0,0,0), (0,0,0),
  (1,1,1), (9,1,0), (1,1,1), (1,1,0),
  (0,5,1), (3,3,1), (2,2,1), (0,0,0),
  (0,0,0), (0,0,0), (0,0,0), (0,0,0),
  (0,0,0), (0,0,0), (0,0,0), (0,0,0),
  (0,0,0), (0,0,0), (0,0,0), (0,0,0),
  (4,3,0), (8,3,0), (6,1,0), (8,1,0),
  (8,1,0), (4,1,1), (3,1,1), (0,5,0),
  (1,1,1), (0,5,0), (0,1,1), (0,1,1),
  (0,0,0), (0,0,0), (0,0,0), (0,0,0),
  (0,0,0), (0,0,0), (0,0,0), (0,0,0),
  (0,2,2), (0,0,0), (0,0,0), (0,0,0),
  (0,0,0), (0,0,0), (0,0,0), (0,0,0),
  (0,0,0), (0,0,0), (5,1,0), (5,1,0),
  (1,1,0), (1,1,0), (2,5,0), (6,1,0),
  (2,1,0), (1,1,0), (6,5,0), (0,0,0),
  (0,1,1), (0,1,0), (2,1,0), (2,1,1),
  (1,1,1), (0,0,0), (0,0,0), (0,0,0),
  (0,0,0), (0,0,0), (0,1,2), (3,1,2),
  (1,1,1), (1,1,1), (0,1,1), (0,1,2));

type Color_Reg = White..L_Magenta;
     Draw_Modes =
       Replace_Mode..Rev_Trans_Mode;
     Line_Types = Solid..DashDotDot;
     Paint_Types = Integer;
     
     Mouse_Type = (M_Arrow,M_Text_Curs,
                   M_Bee,M_Point_Hand,
                   M_Flat_Hand,
                   M_Thin_Cross,
                   M_Thick_Cross,
                   M_Outln_Cross);

     Pointer     = ^Char;
     Text_Ptr    = ^Char;
     
     Mouse_Form  =
     record
       hot_x: Integer;
       hot_y: Integer;
       res: Integer;
       mask_color: Integer;
       data_color: Integer;
       mask: array [0..15] of Integer;
       data: array [0..15] of Integer;
     end;
     
     File_Name       = string [Max_Fn];
     Path_Name       = string [Max_Path];
     Window_Title    = string [Max_WTitle];
     
     Message_Buffer  = array [0..15]
                       of Integer;

     Ctrl_Parms      = array [0.. 11]
                       of Integer;
     Global_parms    = array [0.. 15]
                       of Integer;
     Int_In_Parms    = array [0..128]
                       of Integer;
     Int_Out_Parms   = array [0..128]
                       of Integer;
     Pts_In_Parms    = array [0..256]
                       of Integer;
     Pts_Out_Parms   = array [0.. 11]
                       of Integer;
     Addr_In_Parms   = array [0..  2]
                       of Pointer;
     Addr_Out_Parms  = array [0..  2]
                       of Pointer;

     Point = record
              x,y: Integer
             end;

     Rectangle = record
                   x,y,w,h: Integer;
                 end;

     Str255          = string [255];
     TE_Just         = (TE_Left,TE_Right,
                        TE_Center);
     Tree_Range = Root..Max_Tree;
     Tree_Index = Null_Index..Max_Tree;
     
     Ob_Type         = G_Box..G_Title;
     
     C_String = Packed array
                [0..Max_C_String] of Char;
     String_Ptr      = ^C_String;
     
     Text_Ed_Info =
     record
       te_ptext: String_Ptr;
       te_ptmplt: String_Ptr;
       te_pvalid: String_Ptr;
       te_font: Integer;
       te_junk1: Integer;
       TE_Just: Integer;
       te_color: Integer;
       te_junk2: Integer;
       te_thickness: Integer;
       te_txtlen: Integer;
       te_tmplen: Integer;
     end;
     Ted_Ptr = ^Text_Ed_Info;
     
     Spec_Info =
     record
       case Ob_Type of
         G_Box,
         G_IBox,
         G_Boxchar: (thick: Integer;
         color: Integer);
         G_Text,
         G_BoxText,
         G_FText,
         G_FBoxText: (info: Ted_Ptr);
         G_Image,
         G_ProgDef,
         G_Button,
         G_Icon: (Ptr: Pointer);
         G_String,
         G_Title: (Str: String_Ptr);
       end;
       
     Objekt =
     record
       ob_next: Integer;
       ob_head: Integer;
       ob_tail: Integer;
       ob_Type: Integer;
       ob_flags: Integer;
       ob_state: Integer;
       ob_spec: Spec_Info;
       ob_x: Integer;
       ob_y: Integer;
       ob_w: Integer;
       ob_h: Integer;
     end;

     Tree            = array [Tree_Range]
                       of Objekt;
     Tree_Ptr        = ^Tree;
     Menu_Ptr        = Tree_Ptr;
     Dialog_Ptr      = Tree_Ptr;

     Icon_Block =
     record
       ib_pmask: Pointer;
       ib_pdata: Pointer;
       ib_ptext: Pointer;
       ib_char: Integer;
       ib_xchar: Integer;
       ib_ychar: Integer;
       ib_xicon: Integer;
       ib_yicon: Integer;
       ib_wicon: Integer;
       ib_hicon: Integer;
       ib_xtext: Integer;
       ib_ytext: Integer;
       ib_wtext: Integer;
       ib_htext: Integer;
     end;

     Bit_Block =
     record
       bi_pdata: Pointer;
       bi_wb: Integer;
       bi_hl: Integer;
       bi_x: Integer;
       bi_y: Integer;
       bi_color: Integer;
     end;

     Parm_Blk =
     record
       pb_tree: Pointer;
       pb_obj: Integer;
       pb_prevstate: Integer;
       pb_currstate: Integer;
       pb_x: Integer;
       pb_y: Integer;
       pb_w: Integer;
       pb_h: Integer;
       pb_xc: Integer;
       pb_yc: Integer;
       pb_wc: Integer;
       pb_hc: Integer;
       pb_parm: Pointer;
     end;

var Control: Ctrl_Parms;
    Global: Global_parms;
    Int_In: Int_In_Parms;
    Int_Out: Int_Out_Parms;
    Addr_In: Addr_In_Parms;
    Addr_Out: Addr_Out_Parms;
    Pts_In: Pts_In_Parms;
    Pts_Out: Pts_Out_Parms;
    VDI_Handle,
    GEMResX,
    GEMResY: Integer;
    
    
procedure AES_Call (op: Integer; 
             var Int_In: Int_In_Parms;
             var Int_Out: Int_Out_Parms;
             var Addr_In: Addr_In_Parms;
             var Addr_Out: Addr_Out_Parms);

procedure VDI_call (cmd,sub_cmd: Integer;
             nints,npts: Integer;
             var Control: Ctrl_Parms;
             var Int_In: Int_In_Parms;
             var Int_Out: Int_Out_Parms;
             var Pts_In: Pts_In_Parms;
             var Pts_Out: Pts_Out_Parms;
             translate: Boolean);

function  Init_GEM: Integer;
procedure Exit_GEM;
procedure Hide_Mouse;
procedure Show_Mouse;
procedure Set_Mouse (M_Type: Mouse_Type);
procedure Init_Mouse;
function  Do_Alert (maske: Str255;
          btn: Integer): Integer;
function  Load_Resource(name:
          string): Boolean;
procedure Free_Resource;
procedure Find_Menu (Index: Integer;
          var Menu: Menu_Ptr);
procedure Find_Dialog(Index: Integer; 
          var Dial: Dialog_Ptr);
procedure Objc_Draw (dialog: Dialog_Ptr;
          start,tiefe,x,y,w,h: Integer);
function  Do_dialog (dialog: Dialog_Ptr;
          ed_start: Integer): Integer;
procedure Show_Dialog (dialog: Dialog_Ptr);
procedure Center_Dialog (Dial: Dialog_Ptr);
procedure End_dialog (dialog: Dialog_Ptr);
procedure Set_DText (Dial: Dialog_Ptr; 
          item: Tree_Index; s: Str255;
          font: Integer; just: TE_Just);
procedure Obj_SetState (Dial: Dialog_Ptr; 
          Index: Tree_Index;
          state: Integer;
          redraw: Boolean);
function  Obj_State (Dial: Dialog_Ptr; 
          Index: Integer): Integer;
procedure Get_DEdit (Dial: Dialog_Ptr;
          item: Tree_Index; var s: Str255);
procedure Draw_Menu (Menu: Menu_Ptr);
procedure Erase_Menu (Menu: Menu_Ptr);
procedure Menu_Enable (Menu: Menu_Ptr;
          item: Tree_Index);
procedure Menu_Disable (Menu: Menu_Ptr; 
          item: Tree_Index);
procedure Menu_Normal (Menu: Menu_Ptr; 
          Title: Tree_Index);
procedure Menu_Hilight (Menu: Menu_Ptr; 
          Title: Tree_Index);
function  New_Window (w_type: Integer; 
          var Title: Window_Title;
          x_max,y_max,w_max,
          h_max:Integer): Integer;
procedure Open_window (Handle: Integer;
          x,y,w,h: Integer);
procedure Set_WName (Handle: Integer; 
          var name: Window_Title);
procedure Set_Winfo (Handle: Integer; 
          var info: Window_Title);
procedure Close_Window (Handle: Integer);
procedure Delete_Window (Handle: Integer);
procedure Work_Rect (Handle: Integer;
          var x,y,w,h: Integer);
function  Front_Window: Integer;
procedure Set_Window (Handle: Integer);
procedure Wind_Get (Handle,request:Integer;
          var v1,v2,v3,v4: Integer);
procedure Wind_Set (Handle,request:Integer;
          v1,v2,v3,v4: Integer);
function  Get_in_file (var Path,
          name: Path_Name): Boolean;
procedure Dragbox (x1,y1,w1,h1,x2,y2,w2,
          h2: Integer; var Endx,
          Endy: Integer);
procedure Growbox (stx,sty,stw,sth,fix,
          fiy,fiw,fih: Integer);
procedure Shrinkbox (stx,sty,stw,sth,fix,
          fiy,fiw,fih: Integer);
function  Get_Event (emask,bmask,bstate,
          n_clicks: Integer;
          ticks: Longint;
          m1_flag: Boolean; 
          m1x,m1y,m1w,m1h: Integer;
          m2_flag: Boolean; 
          m2x,m2y,m2w,m2h: Integer;
          var message: Message_Buffer;
          var key,brtn,bclick,mx,my,
          kstate: Integer): Integer;
procedure Set_Clip (x,y,w,h: Integer);
procedure Draw_String(x,y: Integer; 
          s: Str255);
procedure Line_Color (color_index:Integer);
procedure Draw_Mode (mode: Integer);
procedure Paint_Color 
          (color_index: Integer);
procedure Paint_Style 
          (style_index: Integer);
procedure Paint_Rect (x,y,w,h: Integer);
procedure Line_Endstyle (beg_style,
          End_style: Integer);
procedure Line_Style (style: Line_Types);
procedure Pline (x1,y1,x2,y2: Integer);
procedure Frame_Rect (x,y,w,h: Integer);
procedure First_Rect(hand: integer; var x,
          y, w, h: Integer);
procedure Next_Rect(hand: Integer; var x,
          y, w, h: Integer);
function Rect_Intersect(x1, y1, w1,
          h1: Integer; var x2, y2, w2,
          h2: Integer): Boolean;
procedure Set_WSize(hand, x, y, w,
          h: Integer);
procedure Begin_Update;
procedure End_Update;
procedure Border_Rect(Handle: Integer;
          Var x, y, w, h: Integer);
procedure Text_Heigth (Heigth: Integer);
procedure Text_Style (style: Integer);
procedure Text_Rotation (angle: Integer);


Implementation

procedure Pas_To_C (s: Str255;
          var C_str: C_String);
var i: Integer;
begin
  for i := 1 to Length(s) do
  C_str[i-1] := s[i];
  C_str[Length(s)] := Chr(0);
end;

procedure C_to_pas (C_str: C_String;
          var s: Str255);
var i: Integer;
begin
  i := 0;
  s := '';
  while C_str[i] <> Chr(0) do
  begin
    s := Concat(s,C_str[i]);
    i := i + 1;
  end;
end;

function dptr_to_point 
         (dptr: Dialog_Ptr): Pointer;
var Trick:
record
  case Integer of
    0: (d: Dialog_Ptr);
    1: (p: Pointer);
  end;
  begin
    Trick.d := dptr;
    dptr_to_point := Trick.p;
  end;
  
function Mptr_to_point 
         (Mptr: Menu_Ptr): Pointer;
var Trick:
record
  case Integer of
    0: (M: Menu_Ptr);
    1: (p: Pointer);
  end;
  begin
    Trick.M := Mptr;
    Mptr_to_point := Trick.p;
  end;
  
procedure split_addr (Addr: Pointer;
          var p1,p2: Integer);
var Trick:
record
  case Integer of
    0: (p: Pointer);
    1: (a1: Integer;
    a2: Integer);
  end;
  begin
    Trick.p := Addr;
    p1 := Trick.a1;
    p2 := Trick.a2;
  end;
  
procedure AES_Call (op: Integer; 
          var Int_In: Int_In_Parms;
          var Int_Out: Int_Out_Parms;
          var Addr_In: Addr_In_Parms;
          var Addr_Out: Addr_Out_Parms);
var 
  Regs: Registers;
  Addr_Block:
    record
      Control_point: Pointer;
      global_point: Pointer;
      Int_In_point: Pointer;
      Int_Out_point: Pointer;
      Addr_In_point: Pointer;
      Addr_Out_point: Pointer;
    end;
begin
  Control[0] := op;
  Control[1] := Crystal[op,1];
  Control[2] := Crystal[op,2];
  Control[3] := Crystal[op,3];
  Addr_Block.Control_point := 
    Addr(Control);
  Addr_Block.global_point := Addr(Global);
  Addr_Block.Int_In_point := Addr(Int_In);
  Addr_Block.Int_Out_point := 
    Addr(Int_Out);
  Addr_Block.Addr_In_point := 
    Addr(Addr_In);
  Addr_Block.Addr_Out_point := 
    Addr(Addr_Out);
  Regs.ES := Seg (Addr_Block);
  Regs.BX := Ofs (Addr_Block);
  Regs.CX := 200;  { AES - Kennziffer }
  Intr ($EF,Regs);
end;

procedure VDI_call (cmd,sub_cmd: Integer;
          nints,npts: Integer;
          var Control: Ctrl_Parms;
          var Int_In: Int_In_Parms;
          var Int_Out: Int_Out_Parms;
          var Pts_In: Pts_In_Parms;
          var Pts_Out: Pts_Out_Parms;
          translate: Boolean);
var 
  Regs: Registers;
  Addr_Block:
  record
    Control_point: Pointer;
    Int_In_point: Pointer;
    Pts_In_Point: Pointer;
    Int_Out_point: Pointer;
    Pts_Out_point: Pointer;
  end;

begin
  Control[0] := cmd;
  Control[1] := npts;
  Control[3] := nints;
  Control[5] := sub_cmd;
  Control[6] := VDI_Handle;
  Addr_Block.Control_point :=
    Addr(Control);
  Addr_Block.Int_In_point  := Addr(Int_In);
  Addr_Block.Pts_In_Point  := Addr(Pts_In);
  Addr_Block.Int_Out_point :=
    Addr(Int_Out);
  Addr_Block.Pts_Out_point :=
    Addr(Pts_Out);
  Regs.DS := Seg(Addr_Block);
  Regs.DX := Ofs(Addr_Block);
  Regs.CX := 1139; { VDI - Kennziffer }
  Intr($EF,Regs);
end;

function Init_GEM: Integer;
var i: Integer;
begin
  { appl_init }
  AES_Call(10,Int_In,Int_Out,Addr_In,
    Addr_Out);
  Init_GEM := Int_Out[0];
  { graf_handle }
  AES_Call(77,Int_In,Int_Out,Addr_In,
    Addr_Out);
  VDI_Handle := Int_Out[0];
  { virtuelle workstation auf }
  for i := 1 to 9 do
  Int_In[i] := 1;
  Int_In[10] := 2;
  VDI_call(100,0,11,0,Control,Int_In,
          Int_Out,Pts_In,Pts_Out,False);
  VDI_Handle := Control[6];
  GEMResX := Int_Out[0];
  GEMResY := Int_Out[1];
end;

procedure Exit_GEM;
begin
  { appl_exit }
  AES_Call(19,Int_In,Int_Out,Addr_In,
    Addr_Out);
  { close virtual workstation }
  VDI_call(101,0,0,0,Control,Int_In,
          Int_Out,Pts_In,Pts_Out,False);
end;

procedure Hide_Mouse;
begin
  VDI_call(123,0,0,0,Control,Int_In,
          Int_Out,Pts_In,Pts_Out,False);
end;

procedure Show_Mouse;
begin
  Int_In[0] := 1;
  VDI_call(122,0,1,0,Control,Int_In,
          Int_Out,Pts_In,Pts_Out,False);
end;

procedure Set_Mouse (M_Type: Mouse_Type);
begin
  Int_In[0] := Ord(M_Type);
  AES_Call(78,Int_In,Int_Out,Addr_In,
          Addr_Out);
end;

procedure Init_Mouse;
begin
  Int_In[0] := 0;
  VDI_call(122,0,0,0,Control,Int_In,
          Int_Out,Pts_In,Pts_Out,False);
  Set_Mouse(M_Arrow);
end;

function Do_Alert (maske: Str255;
         btn: Integer): Integer;
begin
  Int_In[0] := btn;
  maske[Length(maske)+1] := Chr(0);
  { C-Konvention }
  Addr_In[0] := Addr(maske[1]);
  { 0. Byte berspringen ! }
  AES_Call(52,Int_In,Int_Out,Addr_In,
          Addr_Out);
  Do_Alert := Int_Out[0];
end;

function Load_Resource
    (name: string): Boolean;
begin
  name[Length(name)+1] := Chr(0);
  Addr_In[0] := Addr(name[1]);
  AES_Call(110,Int_In,Int_Out,Addr_In,
          Addr_Out);
  Load_Resource := (Int_Out[0] <> 0);
end;

procedure Free_Resource;
begin
  AES_Call(111,Int_In,Int_Out,Addr_In,
          Addr_Out);
end;

procedure Find_Menu (Index: Integer;
          var Menu: Menu_Ptr);
var Trick:
record
  case Integer of
    0: (M: Menu_Ptr);
    1: (p: Pointer);
  end;
  begin
    Int_In[0] := R_Tree;
    Int_In[1] := Index;
    AES_Call(112,Int_In,Int_Out,Addr_In,
            Addr_Out);
    Trick.p := Addr_Out[0];
    Menu := Trick.M;
  end;
  
procedure Find_Dialog(Index: Integer;
          var Dial: Dialog_Ptr);
var Trick:
record
  case Integer of
    0: (d: Dialog_Ptr);
    1: (p: Pointer);
  end;
  begin
    Int_In[0] := R_Tree;
    Int_In[1] := Index;
    AES_Call(112,Int_In,Int_Out,Addr_In,
      Addr_Out);
    Trick.p := Addr_Out[0];
    Dial := Trick.d;
  end;
  
procedure form_dial (flag,litx,lity,litw,
          lith,bigx,bigy,bigw,
          bigh: Integer);
begin
  Int_In[0] := flag;
  Int_In[1] := litx;
  Int_In[2] := lity;
  Int_In[3] := litw;
  Int_In[4] := lith;
  Int_In[5] := bigx;
  Int_In[6] := bigy;
  Int_In[7] := bigw;
  Int_In[8] := bigh;
  AES_Call (51,Int_In,Int_Out,Addr_In,
           Addr_Out);
end;

function form_Do (dialog: Dialog_Ptr;
         ed_start: Integer): Integer;
begin
  Int_In[0] := ed_start;
  Addr_In[0] := dptr_to_point(dialog);
  AES_Call (50,Int_In,Int_Out,Addr_In,
           Addr_Out);
  form_Do := Int_Out[0];
end;

procedure Objc_Draw (dialog: Dialog_Ptr;
          start,tiefe,x,y,w,h: Integer);
begin
  Int_In[0] := start;
  Int_In[1] := tiefe;
  Int_In[2] := x;
  Int_In[3] := y;
  Int_In[4] := w;
  Int_In[5] := h;
  Addr_In[0] := dptr_to_point(dialog);
  AES_Call (42,Int_In,Int_Out,Addr_In,
           Addr_Out);
end;

function Do_dialog (dialog: Dialog_Ptr;
         ed_start: Integer): Integer;
var xdial,ydial,wdial,hdial: Integer;
    oldx,oldy,oldw,oldh: Integer;
begin
  xdial := dialog^[Root].ob_x;
  ydial := dialog^[Root].ob_y;
  wdial := dialog^[Root].ob_w;
  hdial := dialog^[Root].ob_h;
  if dialog^[Root].ob_state AND
     Outlined <> 0 then
  begin
    xdial := xdial - 3;
    if xdial < 0 then xdial := 0;
    ydial := ydial - 3;
    if ydial < 0 then ydial := 0;
    wdial := wdial + 6;
    hdial := hdial + 6;
  end;
  Hide_Mouse;
  form_dial (0,0,0,0,0,xdial,ydial,wdial,
            hdial);
  Objc_Draw (dialog,Root,Max_Depth,xdial,
            ydial,wdial,hdial);
  Show_Mouse;
  Do_dialog := form_Do (dialog,ed_start);
  form_dial (3,0,0,0,0,xdial,ydial,wdial,
            hdial);
end;

procedure Show_Dialog (dialog: Dialog_Ptr);
begin
  Int_In[0] := Root;
  Int_In[1] := Max_Depth;
  Int_In[2] := 0;
  Int_In[3] := 0;
  Int_In[4] := GEMResX;
  Int_In[5] := GEMResY;
  Addr_In[0] := dptr_to_point(dialog);
  AES_Call (42,Int_In,Int_Out,Addr_In,
    Addr_Out);
end;

procedure Center_Dialog (Dial: Dialog_Ptr);
begin
  Addr_In[0] := dptr_to_point(Dial);
  AES_Call(54,Int_In,Int_Out,Addr_In,
          Addr_Out);
end;

procedure End_dialog (dialog: Dialog_Ptr);
var xdial,ydial,wdial,hdial: Integer;
begin
  xdial := dialog^[Root].ob_x;
  ydial := dialog^[Root].ob_y;
  wdial := dialog^[Root].ob_w;
  hdial := dialog^[Root].ob_h;
  if dialog^[Root].ob_state AND
     Outlined <> 0 then
  begin
    xdial := xdial - 3;
    if xdial < 0 then xdial := 0;
    ydial := ydial - 3;
    if ydial < 0 then ydial := 0;
    wdial := wdial + 6;
    hdial := hdial + 6;
  end;
  Hide_Mouse;
  form_dial (3,0,0,0,0,xdial,ydial,wdial,
            hdial);
  Show_Mouse;
end;

procedure Set_DText (Dial: Dialog_Ptr;
          item: Tree_Index; s: Str255;
font: Integer; just: TE_Just);
var C_str: C_String;
    i: Integer;
begin
  Pas_To_C (s,C_str);
  i := 0;
  if (Dial^[item].Ob_Type = G_String) OR
     (Dial^[item].Ob_Type = G_Title) then
  begin
    while C_str[i] <> Chr(0) do
    begin
      Dial^[item].ob_spec.Str^[i] := 
        C_str[i];
      i := i + 1;
    end;
    if s = '' then
      Dial^[item].ob_spec.Str^[i] := 
        Chr(0);
  end;
  if (Dial^[item].Ob_Type = G_Text) OR
     (Dial^[item].Ob_Type = G_BoxText) OR
     (Dial^[item].Ob_Type = G_FText) OR
     (Dial^[item].Ob_Type = G_FBoxText)
     then
  begin
    while C_str[i] <> Chr(0) do
    begin
      Dial^[item].ob_spec.info^.
        te_ptext^[i] := C_str[i];
      i := i + 1;
    end;
    if s = '' then 
      Dial^[item].ob_spec.info^.
        te_ptext^[i] := Chr(0);
    Dial^[item].ob_spec.info^.te_font :=
      font;
    Dial^[item].ob_spec.info^.TE_Just :=
      Ord(just);
  end;
end;

procedure Obj_SetState (Dial: Dialog_Ptr;
          Index: Tree_Index;
          state: Integer; redraw: Boolean);
begin
  Dial^[Index].ob_state := state;
  if redraw then Show_Dialog (Dial);
end;

function Obj_State (Dial: Dialog_Ptr;
         Index: Integer): Integer;
begin
  Obj_State := Dial^[Index].ob_state;
end;

procedure Get_DEdit (Dial: Dialog_Ptr;
          item: Tree_Index; var s: Str255);
var C_str: C_String;
begin
  C_str :=
    Dial^[item].ob_spec.info^.te_ptext^;
  C_to_pas (C_str,s);
end;

procedure Draw_Menu (Menu: Menu_Ptr);
begin
  Addr_In[0] := Mptr_to_point(Menu);
  Int_In[0] := 1;
  AES_Call(30,Int_In,Int_Out,Addr_In,
    Addr_Out);
end;

procedure Erase_Menu (Menu: Menu_Ptr);
begin
  Addr_In[0] := Mptr_to_point(Menu);
  Int_In[0] := 0;
  AES_Call(30,Int_In,Int_Out,Addr_In,
    Addr_Out);
end;

procedure Menu_Enable (Menu: Menu_Ptr;
          item: Tree_Index);
begin
  Addr_In[0] := Mptr_to_point(Menu);
  Int_In[0] := item;
  Int_In[1] := 1;
  AES_Call(32,Int_In,Int_Out,Addr_In,
          Addr_Out);
end;

procedure Menu_Disable (Menu: Menu_Ptr;
          item: Tree_Index);
begin
  Addr_In[0] := Mptr_to_point(Menu);
  Int_In[0] := item;
  Int_In[1] := 0;
  AES_Call(32,Int_In,Int_Out,Addr_In,
    Addr_Out);
end;

procedure Menu_Normal (Menu: Menu_Ptr;
          Title: Tree_Index);
begin
  Addr_In[0] := Mptr_to_point(Menu);
  Int_In[0] := Title;
  Int_In[1] := 1;
  AES_Call(33,Int_In,Int_Out,Addr_In,
    Addr_Out);
end;

procedure Menu_Hilight (Menu: Menu_Ptr;
          Title: Tree_Index);
begin
  Addr_In[0] := Mptr_to_point(Menu);
  Int_In[0] := Title;
  Int_In[1] := 0;
  AES_Call(33,Int_In,Int_Out,Addr_In,
    Addr_Out);
end;

function New_Window (w_type: Integer;
         var Title: Window_Title;
         x_max,y_max,w_max,
         h_max: Integer): Integer;
begin
  Int_In[0] := w_type;
  Int_In[1] := x_max;
  Int_In[2] := y_max;
  Int_In[3] := w_max;
  Int_In[4] := h_max;
  AES_Call(100,Int_In,Int_Out,Addr_In,
    Addr_Out);
  New_Window := Int_Out[0];
  Int_In[0] := Int_Out[0];
  Int_In[1] := WF_Name;
  Title[Length(Title)+1] := Chr(0);
  split_addr (Addr(Title[1]),Int_In[2],
             Int_In[3]);
  AES_Call(105,Int_In,Int_Out,Addr_In,
          Addr_Out);
end;

procedure Open_window (Handle: Integer;
          x,y,w,h: Integer);
begin
  Int_In[0] := Handle;
  Int_In[1] := x;
  Int_In[2] := y;
  Int_In[3] := w;
  Int_In[4] := h;
  AES_Call(101,Int_In,Int_Out,Addr_In,
          Addr_Out);
end;

procedure Set_WName (Handle: Integer;
          var name: Window_Title);
begin
  Int_In[0] := Handle;
  Int_In[1] := WF_Name;
  name[Length(name)+1] := Chr(0);
  split_addr (Addr(name[1]),Int_In[2],
             Int_In[3]);
  AES_Call(105,Int_In,Int_Out,Addr_In,
          Addr_Out);
end;

procedure Set_Winfo (Handle: Integer;
          var info: Window_Title);
begin
  Int_In[0] := Handle;
  Int_In[1] := WF_Info;
  info[Length(info)+1] := Chr(0);
  split_addr (Addr(info[1]),Int_In[2],
             Int_In[3]);
  AES_Call(105,Int_In,Int_Out,Addr_In,
          Addr_Out);
end;

procedure Close_Window (Handle: Integer);
begin
  Int_In[0] := Handle;
  AES_Call(102,Int_In,Int_Out,Addr_In,
          Addr_Out);
end;

procedure Delete_Window (Handle: Integer);
begin
  Int_In[0] := Handle;
  AES_Call(103,Int_In,Int_Out,Addr_In,
          Addr_Out);
end;

procedure Work_Rect (Handle: Integer;
          var x,y,w,h: Integer);
begin
  Int_In[0] := Handle;
  Int_In[1] := WF_WorkXYWH;
  AES_Call(104,Int_In,Int_Out,Addr_In,
          Addr_Out);
  x := Int_Out[1];
  y := Int_Out[2];
  w := Int_Out[3];
  h := Int_Out[4];
end;

procedure Wind_Get (Handle,
          request: Integer;
          var v1,v2,v3,v4: Integer);
begin
  Int_In[0] := Handle;
  Int_In[1] := request;
  AES_Call(104,Int_In,Int_Out,Addr_In,
          Addr_Out);
  v1 := Int_Out[1];
  v2 := Int_Out[2];
  v3 := Int_Out[3];
  v4 := Int_Out[4];
end;

procedure Wind_Set (Handle,
          request: Integer;
          v1,v2,v3,v4: Integer);
begin
  Int_In[0] := Handle;
  Int_In[1] := request;
  Int_In[2] := v1;
  Int_In[3] := v2;
  Int_In[4] := v3;
  Int_In[5] := v4;
  AES_Call(105,Int_In,Int_Out,Addr_In,
          Addr_Out);
end;

function Front_Window: Integer;
begin
  Int_In[0] := 0;
  Int_In[1] := WF_Top;
  AES_Call(104,Int_In,Int_Out,Addr_In,
          Addr_Out);
  Front_Window := Int_Out[1];
end;

procedure Set_Window (Handle: Integer);
begin
  Int_In[0] := Handle;
  Int_In[1] := WF_Top;
  AES_Call(105,Int_In,Int_Out,Addr_In,
          Addr_Out);
end;

function Get_in_file (var Path,
         name: Path_Name): Boolean;
var i: Integer;
    connect: Path_Name;
begin
  Path[Length(Path)+1] := Chr(0);
  Addr_In[0] := Addr(Path[1]);
  name[Length(name)+1] := Chr(0);
  Addr_In[1] := Addr(name[1]);
  AES_Call(90,Int_In,Int_Out,Addr_In,
          Addr_Out);
  Get_in_file := (Int_Out[1] <> 0);
  if Int_Out[1] <> 0 then
  begin
    i := 1;
    while Path[i] <> Chr(0) do
    i := i + 1;
    Path[0] := Chr(i-1);
    i := 1;
    while name[i] <> Chr(0) do
    i := i + 1;
    name[0] := Chr(i-1);
    connect := Path;
    repeat
      Delete(connect,Length(connect),1);
    until connect[Length(connect)] = '\';
    connect := Concat(connect,name);
    name := connect;
  end;
end;

procedure Dragbox (x1,y1,w1,h1,x2,y2,w2,
          h2: Integer; var Endx,
          Endy: Integer);
begin
  Int_In[0] := w2;
  Int_In[1] := h2;
  Int_In[2] := x2;
  Int_In[3] := y2;
  Int_In[4] := x1;
  Int_In[5] := y1;
  Int_In[6] := w1;
  Int_In[7] := h1;
  AES_Call(71,Int_In,Int_Out,Addr_In,
          Addr_Out);
  Endx := Int_Out[1];
  Endy := Int_Out[2];
end;

procedure Growbox (stx,sty,stw,sth,fix,
          fiy,fiw,fih: Integer);
begin
  Int_In[0] := stx;
  Int_In[1] := sty;
  Int_In[2] := stw;
  Int_In[3] := sth;
  Int_In[4] := fix;
  Int_In[5] := fiy;
  Int_In[6] := fiw;
  Int_In[7] := fih;
  AES_Call (73,Int_In,Int_Out,Addr_In,
           Addr_Out);
end;

procedure Shrinkbox (stx,sty,stw,sth,fix,
          fiy,fiw,fih: Integer);
begin
  Int_In[0] := stx;
  Int_In[1] := sty;
  Int_In[2] := stw;
  Int_In[3] := sth;
  Int_In[4] := fix;
  Int_In[5] := fiy;
  Int_In[6] := fiw;
  Int_In[7] := fih;
  AES_Call (74,Int_In,Int_Out,Addr_In,
           Addr_Out);
end;

function Get_Event (emask,bmask,bstate,
         n_clicks: Integer;
         ticks: Longint;
         m1_flag: Boolean;
         m1x,m1y,m1w,m1h: Integer;
         m2_flag: Boolean;
         m2x,m2y,m2w,m2h: Integer;
         var message: Message_Buffer;
         var key,brtn,bclick,mx,my,
         kstate: Integer): Integer;
begin
  Int_In[0] := emask;
  Int_In[1] := n_clicks;
  Int_In[2] := bmask;
  Int_In[3] := bstate;
  Int_In[4] := Ord(m1_flag);
  Int_In[5] := m1x;
  Int_In[6] := m1y;
  Int_In[7] := m1w;
  Int_In[8] := m1h;
  Int_In[9] := Ord(m2_flag);
  Int_In[10] := m2x;
  Int_In[11] := m2y;
  Int_In[12] := m2w;
  Int_In[13] := m2h;
  Addr_In[0] := Addr(message);
  Int_In[14] := ticks MOD $10000;
  Int_In[15] := ticks DIV $10000;
  AES_Call(25,Int_In,Int_Out,Addr_In,
          Addr_Out);
  mx := Int_Out[1];
  my := Int_Out[2];
  key := Int_Out[5];
  brtn := Int_Out[6];
  bclick := Int_Out[3];
  kstate := Int_Out[4];
  Get_Event := Int_Out[0];
end;

procedure Set_Clip (x,y,w,h: Integer);
begin
  Int_In [0] := 1; { True }
  Pts_In [0] := x;
  Pts_In [1] := y;
  Pts_In [2] := x + w - 1;
  Pts_In [3] := y + h - 1;
  VDI_call(129,0,1,4,Control,Int_In,
          Int_Out,Pts_In,Pts_Out,False);
end;

procedure Draw_String(x,y: Integer;
          s: Str255);
var i: Integer;
begin
  Pts_In[0] := x;
  Pts_In[1] := y;
  i := 1;
  while (i <= Length(s)) do
  begin
    Int_In[i-1] := Ord(s[i]);
    i := i + 1;
  end;
  Int_In[i] := 0;
  VDI_call(8,0,Length(s),1,Control,Int_In,
          Int_Out,Pts_In,Pts_Out,False);
end;

procedure Line_Color
          (color_index: Integer);
begin
  Int_In [0] := color_index;
  VDI_call(17,0,1,0,Control,Int_In,Int_Out,
          Pts_In,Pts_Out,False);
end;

procedure Draw_Mode (mode: Integer);
begin
  Int_In [0] := mode;
  VDI_call(32,0,1,0,Control,Int_In,Int_Out,
          Pts_In,Pts_Out,False);
end;

procedure Paint_Color
          (color_index: Integer);
begin
  Int_In [0] := color_index;
  VDI_call(25,0,1,0,Control,Int_In,Int_Out,
          Pts_In,Pts_Out,False);
end;

procedure Paint_Style
          (style_index: Integer);
begin
  Int_In [0] := 2;
  VDI_call(23,0,1,0,Control,Int_In,Int_Out,
          Pts_In,Pts_Out,False);
  Int_In [0] := style_index;
  VDI_call(24,0,1,0,Control,Int_In,Int_Out,
          Pts_In,Pts_Out,False);
end;

procedure Paint_Rect (x,y,w,h: Integer);
begin
  Pts_In[0] := x;
  Pts_In[1] := y;
  Pts_In[2] := x + w - 1;
  Pts_In[3] := y + h - 1;
  VDI_call(11,1,0,4,Control,Int_In,Int_Out,
          Pts_In,Pts_Out,False);
end;

procedure Line_Endstyle (beg_style,
          End_style: Integer);
begin
  Int_In [0] := beg_style;
  Int_In [1] := End_style;
  VDI_call(108,0,2,0,Control,Int_In,
          Int_Out,Pts_In,Pts_Out,False);
end;

procedure Line_Style (style: Line_Types);
begin
  Int_In [0] := style;
  VDI_call(15,0,1,0,Control,Int_In,Int_Out,
          Pts_In,Pts_Out,False);
end;

procedure Pline (x1,y1,x2,y2: Integer);
begin
  Pts_In[0] := x1;
  Pts_In[1] := y1;
  Pts_In[2] := x2;
  Pts_In[3] := y2;
  VDI_call(6,0,0,2,Control,Int_In,Int_Out,
          Pts_In,Pts_Out,False);
end;

procedure Frame_Rect (x,y,w,h: Integer);
begin
  Pline (x,y,x+w-1,y);
  Pline (x+w-1,y,x+w-1,y+h-1);
  Pline (x+w-1,y+h-1,x,y+h-1);
  Pline (x,y+h-1,x,y);
end;

procedure First_Rect(hand: Integer;
          var x, y, w, h: Integer);
begin
  Wind_Get(hand, WF_FIRSTXYWH, x, y, w, h);
end;

procedure Next_Rect(hand: Integer; var x,
          y, w, h: Integer);
begin
  Wind_Get(hand, WF_NEXTXYWH, x, y, w, h);
end;

function Min(a, b: Integer): Integer;
begin
  if a < b Then Min := a Else Min := b
end;

function Max(a, b: Integer): Integer;
begin
  if a > b Then Max := a Else Max := b
end;

function Rect_Intersect
         (x1, y1, w1, h1: Integer; var x2,
          y2, w2, h2: Integer): Boolean;
var
  tx, ty, tw, th : Integer;
begin
  tw := min(x2 + w2, x1 + w1);
  th := min(y2 + h2, y1 + h1);
  tx := max(x2, x1); ty := max(y2, y1);
  x2 := tx;          y2 := ty;
  w2 := tw - tx;     h2 := th - ty;
  Rect_Intersect := (tw > tx) AND
    (th > ty);
end;

procedure Set_WSize(hand, x, y, w,
                    h: Integer);
begin
  Wind_Set(hand, WF_CurrXYWH, x, y, w, h);
end;

procedure Begin_Update;
begin
  int_in[0] := 1; (* BEG_UPDATE *)
  AES_Call(107,Int_In,Int_Out,Addr_In,
          Addr_Out);
end;

procedure End_Update;
begin
  int_in[0] := 0; (* End_UPDATE *)
  AES_Call(107,Int_In,Int_Out,Addr_In,
          Addr_Out);
end;

procedure Border_Rect(Handle: Integer;
          var x, y, w, h: Integer);
begin
  Int_in[0] := handle;
  Int_In[1] := WF_CurrXYWH;
  AES_Call(104,Int_In,Int_Out,Addr_In,
          Addr_Out);
  x := Int_Out[1]; y := Int_Out[2];
  w := Int_Out[3]; h := Int_Out[4];
end;

procedure Text_Heigth (Heigth: Integer);
begin
  Pts_In[0] := 0;
  Pts_In[1] := Heigth;
  VDI_call(12,0,0,1,Control,Int_In,Int_Out,
          Pts_In,Pts_Out,False);
end;

procedure Text_Style (style: Integer);
begin
  Int_In[0] := style;
  VDI_call(106,0,1,0,Control,Int_In,
          Int_Out,Pts_In,Pts_Out,False);
end;

procedure Text_Rotation (angle: Integer);
begin
  Int_In [0] := angle;
  VDI_call(13,0,1,0,Control,Int_In,Int_Out,
          Pts_In,Pts_Out,False);
end;

begin
end.