/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include "fdisk.h"
#include "common.h"
#include "global.h"

/*=================== H  l  W        ===================*/
static sword ForStartCyl (const void *elem1, const void *elem2)
{
    const PARTN *e1 = (const PARTN *)elem1;
    const PARTN *e2 = (const PARTN *)elem2;
 
    return( (e1->stCyl < e2->stCyl) ? -1 :
            (e1->stCyl > e2->stCyl) ?  1 : 0 );
} /* end fcmp */


/*=================== H   s         ===================*/
static sword ForNO (const void *elem1, const void *elem2)
{
    const PARTN *e1 = (const PARTN *)elem1;
    const PARTN *e2 = (const PARTN *)elem2;
 
    return( (e1->id == 0) ? 1 :
            (e2->id == 0) ? 0 : e1->no - e2->no );
} /* end ForNO */


/*============================== ΰ}CƧ ===============================*/
void Sort_Partn (PARTN *partnArr, sword kind)
{
    sword (*fcmp)(const void *elem1, const void *elem2);
 
    fcmp = ( kind == FOR_STCYL ) ? ForStartCyl : ForNO;
 
    /*---------- sort primary partition ----------*/
    Select_Sort(partnArr, g_Info.fd.pri_use, sizeof(PARTN), fcmp);
 
    /*---------- sort logic partition ----------*/
    Select_Sort(partnArr + g_Info.fd.pri_use, 
                g_Info.fd.used - g_Info.fd.pri_use, sizeof(PARTN), fcmp);
} /* end Sort_Partn */
