/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include "selemenu.h"
#include "fdisk.h"
#include "common.h"
#include "global.h"
#include "keymap.h"

static void Adjust_capacity (PARTN *partnArr, sword ndx);
static void Move_location (PARTN *partnArr, sword ndx);

void Adjust_partn (PARTN *partnArr, sword ndx)
{
    extern SeleMenu g_Menu;                                /** ο檫 **/
    static sbyte *Text[] =
    {
        #if ( DISPLAY == CHINESE )
            "1.      e  q",  "2.        m",  "3.     l "
        #else 
            "1. Adjust capacity",  "2. Move location",  "3. Adjust begin side"
        #endif
    };
    sword  sele, flag, i;
    PARTN  *ptr;
 
    ptr  = partnArr + ndx;
    flag = ITEM2 | ( (Is_Extended(ptr->id)) ? ITEM1 : ITEM3 );
    
    if ( ptr->stCyl != ptr->endCyl )
        flag |= ITEM1;
 
    g_Menu.menuColor( PAR_MENU_COLOR, LIGHT_BAR_COLOR );   /** ]wC **/
 
    /*
     * ]wο椺e
     */
    #if ( DISPLAY == CHINESE )
        for ( i = 0 ; i < sizeof(Text) / sizeof(sbyte *) ; i++, flag >>= 1 )
            g_Menu.prompt(43, i + 13, Text[i], flag & 1);
        MenuBox(41, 12, 62, 16, NULL);                   /** øsΤ **/
    #else
        for ( i = 0 ; i < sizeof(Text) / sizeof(sbyte *) ; i++, flag >>= 1 )
            g_Menu.prompt(39, i + 13, Text[i], flag & 1);
        MenuBox(37, 12, 61, 16, NULL);                   /** øsΤ **/
    #endif
 
    sele = g_Menu.select(1);
    if ( sele == 1 )
        Adjust_capacity(partnArr, ndx);
    else if ( sele == 2 )
        Move_location(partnArr, ndx);
    else if ( sele == 3 )
        Adjust_head(partnArr, ndx);
} /* end Adjust_partn */


/*===========================      l  ==========================*/
void Adjust_head (PARTN *partnArr, sword ndx)
{
    PARTN  *ptr = partnArr + ndx;
    dword  side = ptr->side;
    sword  key = ESC_KEY;
 
    #if ( DISPLAY == CHINESE )
        Warning_Msg_Box(" T w    n  A   I", NULL);
    #endif
 
    while ( 1 )
    {
        #if ( DISPLAY == CHINESE )
            ShowMSG(" [Esc]:/[+]:դj/[-]:դj/[Enter]:T{G %ld ", side);
        #else
            ShowMSG("Press [Esc]:Cancel/[+]:Add/[-]:Sub/[Enter]:OK --> %ld ", side);
        #endif
 
        key = WaitKey();
        if ( key == '+' )
        {
            if ( ++side > CUR_DK->lgeo.maxHead )
                side = 0;
        }
        else if ( key == '-' )
        {
            if ( --side < 0 )
                side = CUR_DK->lgeo.maxHead;
        }
        else if ( key == ENTER_KEY )
        {
            if ( ptr->side != side )
            {
                ptr->side = side;
                g_Info.fd.modified = 1;
            } /* end if */

            break;
        }
        else if ( key == ESC_KEY )
        {
            break;
        } /* end if */
    } /* end while */
 
    if ( key == ESC_KEY )
        Cancel_Box();
} /* end Adjust_head */


/*============================     e q ============================*/
void Adjust_capacity (PARTN *partnArr, sword ndx)
{                
    #if ( DISPLAY == CHINESE )
         #define TO_AVOID_DATA_BE_CUT    " F        Q  "
         #define PLEASE_EXECUTE_DEFRAG   "             { "
         #define PRESS_ANY_KEY_TO_CONT   "  N  ~ DDDDD"
         #define PROMPT_FUNC_KEY         "[][]:վ  [Home]:ϬWY  [End]:ϬW  [Enter]:T{"
         #define START_CYL_MSG           "ҩlϬWG %lu"
         #define END_CYL_MSG             "ϬWG %lu"
         #define PROMPT_EXPERT_MODE      "   [Esc] վAMaҦUi [TAB] վҩlϬW  "
         #define THE_PARTN_SIZE          "ΤjpG "
         #define COL                     27
    #else     
         #define TO_AVOID_DATA_BE_CUT    "In order to avoid to cut the data of partition"
         #define PLEASE_EXECUTE_DEFRAG   "Please execute complete disk reorganizetions program"
         #define PRESS_ANY_KEY_TO_CONT   "Press any key to continue....."
         #define PROMPT_FUNC_KEY         "[<-][][->][]:adjust  [Home]:Cyl_head  [End]:Cyl_end  [Enter]:OK"
         #define START_CYL_MSG           "Start cylinder: %lu"
         #define END_CYL_MSG             " End  cylinder: %lu"
         #define PROMPT_EXPERT_MODE      " Press [Esc]: Cancel / [TAB] switch adjust(Expert Mode) "
         #define THE_PARTN_SIZE          "The partition: "
         #define COL                     32
    #endif

    dword  endBound, stBound, startCyl, endCyl, *valPtr;
    sword  isExt, key, y;
    PARTN  chg, *ptr;
    sbyte  *unit;
    double size;
 
    ptr      = partnArr + ndx;
    chg      = *ptr;                                               /** ƥ **/
    endCyl   = ptr->endCyl;
    startCyl = ptr->stCyl;
 
    Redraw_Fdisk_Picture(TRUE);
    isExt = Is_Extended(ptr->old_id);
 
    if ( isExt )
    {
        if ( ndx < (g_Info.fd.pri_use - 1) )
            if ( (ptr + 1)->no == 0 )            /** O_ϥΪŶ **/
                endCyl = (ptr + 1)->endCyl;
        if ( ndx > 0 )
            if ( (ptr - 1)->no == 0 )            /** eO_ϥΪŶ **/
                startCyl = (ptr - 1)->stCyl;
    }
    else
    {
        ShowCenter(11, TO_AVOID_DATA_BE_CUT);
        ShowCenter(13, PLEASE_EXECUTE_DEFRAG);
        ShowMSG(PRESS_ANY_KEY_TO_CONT);

        if ( ptr->no == 5 &&
             g_Info.fd.ext_head != 1 &&
             ptr->stCyl > g_Info.fd.ext_head )
        {
            startCyl = g_Info.fd.ext_head;
        } /* end if */
  
        WaitKey();
    } /* end if */
 
    Clr_Block(2, 3, 77, 20);


    ShowMSG(PROMPT_FUNC_KEY);
    c_printXY(16, 10, START_CYL_MSG, ptr->stCyl);
    c_printXY(16, 14, END_CYL_MSG, ptr->endCyl);
    c_textattr(ADJUST_COLOR);
    ShowCenter(20, PROMPT_EXPERT_MODE);

    c_textattr(DEFAULT_COLOR);
    valPtr   = &chg.endCyl;
    stBound  = chg.stCyl;
    endBound = endCyl;
    y        = 14;
 
    do
    {
        if ( valPtr == &chg.stCyl && !g_Info.expertMode )
            c_textattr(READ_ONLY_COLOR);
        else
            c_textattr(KEY_IN_COLOR);
  
        c_printXY(COL, y, "%lu", *valPtr);
  
        c_textattr(DEFAULT_COLOR);
        c_printf("    ");

        c_printXY(41, 14, THE_PARTN_SIZE);
  
        size = (double)Get_nSector(&chg) / 2.0;         /** pΤjp KB **/
        size = TranSizeUnit(size, &unit, KB_UNIT);        /** transfer unit **/
  
        c_textattr(KEY_IN_COLOR);
        c_printf("%.2f %s", size, unit);
  
        c_textattr(DEFAULT_COLOR);
        c_printf("    ");
  
        c_gotoxy(78, 23);
        key = WaitKey();
  
        if ( key == TAB_KEY )                            /** վ㪺ﹳ **/
        {
            c_printXY(COL, y, "%lu", *valPtr);                 /** Mϥ **/
            y ^= 0x04;                                         /** 10  14 **/
            if ( valPtr == &chg.endCyl )
            {
                valPtr   = &chg.stCyl;
                stBound  = startCyl;
                endBound = chg.endCyl;
            }
            else
            {           
                valPtr   = &chg.endCyl;
                stBound  = chg.stCyl;
                endBound = endCyl;
            } /* end if */
        }
        else if ( IsFuncKey(key) )                           /** Bz\ **/
        {
            /*--------------------------------*/
            /*  DMaҦ\վҩlϬW  */
            /*--------------------------------*/
            if ( (valPtr == &chg.stCyl) && !g_Info.expertMode )
                continue;
   
            switch( key )
            {      
                case DOWN_KEY:                       /** chg.stCyl iର 0 **/
                    if ( (*valPtr + 10) <= endBound )
                        *valPtr += 10;
                    else
                        *valPtr = endBound;
                    break;
    
                case UP_KEY:
                    if ( *valPtr >= (stBound + 10) )
                    {
                        (*valPtr) -= 10;
                        if ( *valPtr == 0 )
                            *valPtr = 1;
                    }
                    else
                        *valPtr = stBound + (stBound == 0);
                    break;
    
                case RIGHT_KEY:
                    if ( *valPtr < endBound )
                        (*valPtr)++;
                    break;
    
                case LEFT_KEY:                       /** chg.stCyl iର 0 **/
                    if ( (*valPtr > stBound) && (*valPtr > 1) )
                        (*valPtr)--;
                    break;
    
                case HOME_KEY:
                    *valPtr = stBound + (stBound == 0);
                    break;
    
                case END_KEY:
                    *valPtr = endBound;
                    break;
            } /* end switch */
        } /* end if */
    } while ( (key != '\r') && (key != ESC_KEY) );
 
 
    if ( (key != ESC_KEY) &&
         ((chg.endCyl != ptr->endCyl) || (chg.stCyl != ptr->stCyl)) )
    {  
        ptr->stCyl  = chg.stCyl;
        ptr->endCyl = chg.endCyl;
        ptr->adjust = TRUE;
  
        if ( isExt )
        {
            g_Info.fd.ext_head = ptr->stCyl;
            g_Info.fd.ext_end  = ptr->endCyl;
        } /* end if */
  
        Remove_unused_partn(partnArr);
        Find_Problem(partnArr);
        Find_space(partnArr);                          /** Mtm϶ **/
        g_Info.fd.modified = 1;
    } /* end if */
} /* end Adjust_capacity */


/*====================          e q =====================*/
sword Reference_from_boot (PARTN *partnArr, sword ndx)
{       
    #if ( DISPLAY == CHINESE )   
        #define ARE_YOU_SURE_RECORVERY      "ѦұҰʺϰϪe٭ΤjpH\npGO DOS ҰʺϰϦʧ@NLġI"
        #define ADJ_OK_BUT_NO_SAVE          "νվ㧹A|xsI"
        #define ADJ_OK_BUT_PARTN_OVERLAP    "νվ㧹Ao{έ|I"
        #define PARTN_SIZE_IS_CORRECT       "ήeqwOTAݽվI"
    #else
        #define ARE_YOU_SURE_RECORVERY      "Are you sure to recovery from boot\nsector ?"
        #define ADJ_OK_BUT_NO_SAVE          "Partition adjust done, but no save !"
        #define ADJ_OK_BUT_PARTN_OVERLAP    "Partition adjust done, but exist overlay !"
        #define PARTN_SIZE_IS_CORRECT       "The partition not be adjusted !"
    #endif  /* DISPLAY == CHINESE */

    dword  maxLbaSect, sector, nSect;
    dword  newEndCyl, oldEndCyl;
    sword  update, fatType;
    byte   buff[512];
    PARTN  *ptr/*, *next*/;

    if ( !YN_box(TALK_BOX, ARE_YOU_SURE_RECORVERY) )
        return(0);
      
    update = FALSE;
 
    ptr = partnArr + ndx;
    if ( chs_ReadWDK(ptr->side, ptr->stCyl, ptr->sector, 1, buff) == 0 )
    {
        fatType = IsFAT(buff);
  
        if ( fatType == 0 )
            ShowError( 21 );                    /** ȯϥΩ FAT ɮרt **/
        else
        {
            nSect = (dword)( *(word *)&buff[0x13] );
            if ( nSect == 0 )
                nSect = *(dword *)&buff[0x20];
   
            maxLbaSect = CHS_to_Sect(CUR_DK->lgeo.maxCyl,
                                     CUR_DK->lgeo.maxHead,
                                     CUR_DK->lgeo.maxSect, CUR_DK);
            sector = GetStart(ptr);
            if ( (sector + nSect) > maxLbaSect )
                nSect = maxLbaSect - sector + 1;
   
            sector = sector + nSect - 1;
            Sect_to_CHS(sector, &newEndCyl, NULL, NULL, CUR_DK);
   
            oldEndCyl   = ptr->endCyl;
            ptr->endCyl = newEndCyl;
    
            Remove_unused_partn(partnArr);
            Find_Problem(partnArr);
            Find_space(partnArr);                      /** Mtm϶ **/
    
            if ( oldEndCyl != ptr->endCyl )
                update = TRUE;
    
            fatType = ( fatType == 12 ) ? 1 :
                      ( fatType == 32 ) ? 0x0b :
                      ( (nSect / 2048) < 32 ) ? 4 : 6;
    
            if ( ptr->id != fatType )
            {
                ptr->id = fatType;
                update = TRUE;
            } /* end if */
    
            /*=========== DζWL 1024 Cyl ===========*/
            if ( (ndx < g_Info.fd.pri_use) && (ptr->endCyl > 1023) )
                ptr->id = ( ptr->id == 0x0b ) ? 0x0c : 0x0e;

            if ( update )
            {   
                if ( g_Info.fd.canSaveFlag )
                    Prompt_Msg_Box(ADJ_OK_BUT_NO_SAVE, NULL);
                else
                    Warning_Msg_Box(ADJ_OK_BUT_PARTN_OVERLAP, NULL);
            }
            else
                Prompt_Msg_Box(PARTN_SIZE_IS_CORRECT, NULL);
        } /* end if */
    } /* end if */
 
    return( update );
} /* end Reference_from_boot */


/*============================    m ] w ============================*/
void Move_location (PARTN *partnArr, sword ndx)
{   
    #if ( DISPLAY == CHINESE )
        #define PROMPT_DATA_FOLLOW_MOVE  "ΤƤ]n۲ʶܡH " 
        #define MOVE_TO_FRONT_MSG        "1.  V e     K "
        #define MOVE_TO_REAR_MSG         "2.  V      K "
        #define ARE_YOU_SURE_MOVE_MSG    "z T w n i    h H"
    #else      
        #define PROMPT_DATA_FOLLOW_MOVE  "To move data of the partiton\ntogether ?"
        #define MOVE_TO_FRONT_MSG        "1. Move to front of the area"
        #define MOVE_TO_REAR_MSG         "2. Move to rear of the area"
        #define ARE_YOU_SURE_MOVE_MSG    "Are you sure to move the partition ?"
    #endif
    
    extern SeleMenu g_Menu;                                /** ο檫 **/
    dword  source, offset, front, rear;
    sword  isExt, sele, i;
    byte   spaceFlag;
    PARTN  *ptr;
 
    ptr = partnArr + ndx;
    i   = ( ptr->no < 5 ) ? 0 : -1;                /** ϤDΩ޿ **/
 
    spaceFlag = 0;
    if ( (ndx > 0) && ((ptr-1)->no == i) )                   /** e観Ŷ **/
        spaceFlag |= ITEM1;
    if ( (ndx < g_Info.fd.used) && ((ptr+1)->no == i) )      /** 観Ŷ **/
        spaceFlag |= ITEM2;

    /*
     * ]w椺e
     */
    g_Menu.prompt(9, 15, MOVE_TO_FRONT_MSG, spaceFlag & ITEM1);
    g_Menu.prompt(9, 16, MOVE_TO_REAR_MSG,  spaceFlag & ITEM2);
    
    MenuBox(7, 14, 38, 17, NULL);                        /** øsΤ **/
    g_Menu.menuColor(PAR_MENU_COLOR, LIGHT_BAR_COLOR);
    sele = g_Menu.select( 1 );
 
    if ( sele < 1 )                                            /** վ **/
        return;
 
    source = -1;
    offset = ptr->stCyl;
 
    if ( YN_box(TALK_BOX, PROMPT_DATA_FOLLOW_MOVE) )
    {
        if ( !YN_box(IMMEDIATE_BOX, ARE_YOU_SURE_MOVE_MSG) )
        {
            Cancel_Box();                                  /** ܨ **/
            return;
        } /* end if */
  
        source = ptr->stCyl;                           /** OheϬW **/
    } /* end if */
 
    Disable_Ctrl_Break();                             /** \ Ctrl_Break **/
 
    /*------------------------+
    |         m    |
    +------------------------*/
    if ( sele == 1 )                                   /** ܸӰ϶̫e **/
    {
        front          = (ptr-1)->stCyl;
        rear           = front + (ptr->endCyl - ptr->stCyl);
        *(ptr-1)       = *ptr;                                 /** c **/
        (ptr-1)->stCyl = front;
        (ptr-1)->endCyl= rear;
        ptr->stCyl     = rear + 1;
    }
    else                                               /** ܸӰ϶̫ **/
    {
        rear           = (ptr+1)->endCyl;
        front          = rear - (ptr->endCyl - ptr->stCyl);
        *(ptr+1)       = *ptr;
        (ptr+1)->stCyl = front;
        (ptr+1)->endCyl= rear;
        ptr->endCyl    = front - 1;
    } /* end if */
 
    isExt = Is_Extended(ptr->old_id);                          /** XR **/
 
    if ( isExt )
    {
        if ( sele == 1 )
        {
            g_Info.fd.ext_head = (ptr - 1)->stCyl;
            g_Info.fd.ext_end  = (ptr - 1)->endCyl;
        }
        else
        {
            g_Info.fd.ext_head = (ptr + 1)->stCyl;
            g_Info.fd.ext_end  = (ptr + 1)->endCyl;
        } /* end if */
    } /* end if */              
 
    ptr->id = ptr->old_id = 0;                             /** ]ťդ **/
    Del_Partn(partnArr, ndx);                        /** RΤΪŶX **/
 
    if ( sele == 1 )
    {
        ptr--;
        ndx--;
    }
    else if ( spaceFlag != 3 )                         /** YDeҦŶ **/
    {
        ptr++;
        ndx++;
    } /* end if */
 
 
    /*-------------------------------------------------+
    |     DΪ΢޿ΪΪQ\     |
    +-------------------------------------------------*/
    if ( (ptr->no > 4) && (ptr->stCyl == g_Info.fd.ext_head) ||
         (source > 0) && (ptr->stCyl == 0) && \
         (Is_Extended(ptr->id) || ptr->side == 0) )
    {
        ptr->stCyl++;                                          /** ϶ᮿ **/
        ptr->endCyl++;
        (ptr + 1)->stCyl++;
    } /* end if */
    
    /*-------------------------------------------------+
    |    YOXRΫhU޿Τ]۽վ    |
    +-------------------------------------------------*/
    if ( isExt )
    {
        offset -= ptr->stCyl;                    /** pվ᪺ϬW **/
        ptr = partnArr + g_Info.fd.pri_use;
        for ( i = g_Info.fd.pri_use ; i < g_Info.fd.used ; i++,  ptr++ )
        {
            ptr->stCyl  -= offset;
            ptr->endCyl -= offset;
            ptr->adjust  = TRUE; /** ]wغXAxsɤ~վҰʺϰϤe **/
        } /* end for */
    } /* end if */
 
    if ( g_Info.fd.modified != 1 )
        g_Info.fd.modified = -1;                  
                
    Find_Problem(partnArr);
 
    if ( source > -1 )                                 /** ߧYiηh **/
    {
        if ( !IsAllowSavePartn() )                   /** ΦDʧ@ **/
            return;
  
        /*--------------------------------------------+
        |    iηhAxsΪA         |
        |    _hio͸ƳQs޿Ϊл\p   |
        +--------------------------------------------*/
        MovePartnData(source, partnArr, ndx);              /** hθ **/
        if ( Write_Partn(partnArr, 0, 1) )
        {
            ShowError( 6 );                                    /** gJ **/
            g_Info.fd.modified = 1;
        }
        else             
            g_Info.fd.modified = 0;
    } /* end if */

    Enable_Ctrl_Break();                                /** \ Ctrl_Break **/
} /* end Move_location */


/*========================= h       ============================*/
sword MovePartnData (dword sourCyl, PARTN *partnArr, sword ndx)
{
    dword  source, target;
    sbyte  *pmt_str;
    PARTN  *ptr;
 /* sword  i;         */
 /* dword  ExtStart;  */
 
    ptr = partnArr + ndx;
 
#if 0
    ExtStart = 0;
    if ( ptr->no > 4 )
    {
        i = Find_EXT(partnArr);                            /** MXR **/
        ExtStart = GetStart(partnArr + i);
    } /* end if */
#endif
 
    source = CHS_to_Sect(sourCyl, ptr->side, ptr->sector, CUR_DK);
    target = GetStart(ptr);
 
    if ( source == target )
       return(0);
 
    Redraw_Fdisk_Picture(TRUE);
 
    #if ( DISPLAY == CHINESE )
        ShowCenter(9, "DDD{ b  i      h  DDD");

        c_textattr(PAR_MENU_COLOR);
        ShowCenter(12, "ĵ iI     n  s }     q ");

        pmt_str = "  W  %05lu    W  %05luA p   %05lu    W ";
 
    #else
        ShowCenter(9, "It's moving data of the partition");
       
        c_textattr(PAR_MENU_COLOR);
        ShowCenter(12, "Warning !  Please don't to reboot or to turn off");
       
        pmt_str = "< From cyl %05lu move to cyl %05luA Total of cylinder %05lu >";
    #endif   /** end CHINESE */
 
    c_textattr(DEFAULT_COLOR);
    c_printXY(10, 18, pmt_str, sourCyl, ptr->stCyl, ptr->endCyl - ptr->stCyl + 1);
 
    CopySector(CUR_DK, source, target, Get_nSector(ptr));      /** ϰϫ **/
    Adjust_DOS_BootSector(ptr /*, ExtStart*/ );   /** ץ DOS Ұʺϰ **/
 
    ShowMSG(NULL);
    return(0);
} /* end MovePartnData */


/*===========================       =============================*/
/*              DOS          e  q      m              */
/*     u  D         e  n    m  (0x1c)     */
/*===========================================================================*/
sword Adjust_DOS_BootSector (PARTN *ptr  /**, dword ExtStart */)
{
    byte   bootSect[512], buff[512];
    dword  begin;
    sword  type;
    DOSBPB *bpb;

    begin = GetStart(ptr);
    linear_ReadWDK(begin, 1, bootSect);                    /** ŪҰʺϰ **/
  
    type = IsFAT(bootSect);

    /*if ( ChkSysID(ptr->old_id, FAT12_16_32) ) */
    if ( type != 0 )                                           /** Is DOS ? **/
    {
        bpb = (DOSBPB *)bootSect;
        if ( bpb->comm.magicNum == 0xaa55 )
        {
            bpb->fat1x.tSector2 = 0;
            bpb->comm.nHiddSect = begin;                   /** ץΦm **/
            bpb->comm.tSector4  = Get_nSector(ptr);        /** ץΤjp **/
   
            #if 0
                if ( ptr->no < 5 )
                    bpb->comm.nHiddSect = begin - ExtStart;/** ץΦm **/
            #endif
   
            linear_WriteWDK(begin, 1, bootSect);
            if ( IsFAT(bootSect) == 32 )    /** pGO FAT32 Ұʺϰ **/
            {
                linear_WriteWDK(begin + bpb->fat32.bakBootSect, 1, bootSect);
    
                CreateFsSector(ptr, bpb, buff, FALSE);
                linear_WriteWDK(begin + 1, 1, buff);   
                linear_WriteWDK(begin + 1 + bpb->fat32.bakBootSect, 1, buff);
            } /* end if */
        } /* end if */
    } /* end if */
 
    return(0);
} /* end Adjust_DOS_BootSector */

