/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/

#ifndef  __FONT_H
#define  __FONT_H
                      
#include <stdarg.h>

#ifndef __COMMON_H_
   #include "common.h"
#endif

typedef struct _font
{
   byte  key[3],
         font[30];
} FONT;

typedef struct _Screen
{
   sword  graphicMode;
   sword  x;
   sword  y;
   byte   color;
   byte   cursorColor;
   /*------------------*/
   word   cursorShow : 1;
   word   cursorStat : 1;
} Screen;

typedef struct _CharData
{
   sword   valid;
   sword   x;
   sword   y;
   byte    color;
   sbyte   chr;
} CharData;

#define FONT_CACHE_SIZE        32

#define TEXT_MAX_X             80                   /* modified form 80 for debug by SPF */
#define TEXT_MAX_Y             25                   /* modified form 25 for debug by SPF */

#define MAX_X                 640
#define MAX_Y                 480
#define ROW_SIZE           (MAX_X / 8)
#define FRAME_SIZE         (ROW_SIZE * MAX_Y)
#define VRAM_SEG           0xa000
#define VRAM_OFF                0

#define V_GAP                   4                                /** CZ **/
#define H_GAP                   0                              /** rZ **/
#define E_WIDTH                 8                        /** Cӭ^re **/
#define E_HIGH                 15                        /** Cӭ^r **/
#define C_WIDTH                16                        /** CӤr **/
#define C_HIGH                 15                        /** CӤr **/

#define TAB_LEN                 8

#define IS_HIGH_BYTE(h)        ((byte)(h) > 0xa0 && (byte)(h) < 0xff)
#define IS_LOW_BYTE(l)         ((byte)(l) > 0x3f && (byte)(l) < 0x7f ||\
                                (byte)(l) > 0xa0 && (byte)(l) < 0xff) 
#define IS_CHINESE(h,l)        (IS_HIGH_BYTE(h) && IS_LOW_BYTE(l))
#define TEXTFORM(color,chr)    (((word)(color) << 8) | (word)((byte)(chr)))

#define GET_TEXT(y,x)          (g_TextArea[y][x])
#define SET_TEXT(y,x,val)      (g_TextArea[y][x] = (val))
#define GET_COLOR(y,x)         ((g_TextArea[y][x] >>  8) & 0xff)
#define FOREGROUND_COLOR(y,x)  ((g_TextArea[y][x] >> 12) & 0x0f)

sword Flush (void);
sword get_Index_Font (sword index, long item, void *buffer);
sword show_word (byte *aWord, sword x, sword y, byte color);
sword IsCursorShow (void);
sword c_UseChiSys (void);
sword GetColor (void);

void  Init_Screen (void);
void  End_Screen (void);
void  IntoGraphicMode (void);
void  IntoTextMode (void);
void  SortFont (FONT *pFont, sword n);
void  Adjust_XY (sword *x, sword *y);
void  scroll_up (sword x1, sword y1, sword x2, sword y2, sword line);
void  scroll_down (sword x1, sword y1, sword x2, sword y2, sword line);
void  CursorShow (void);
void  CursorHidden (void);

void  SetColor (sword color);
void  ColorStr (const sbyte *str);
void  ColorChar (sbyte chr);

void  GetXY (sword *x, sword *y);
void  SetXY (sword x, sword y);
void  Clr_Block (sword x1, sword y1, sword x2, sword y2);
void  c_gotoxy (sword x, sword y);
void  c_clrscr (void);
void  c_clreol (void);
void  c_textattr (sword color);
void  c_printf (const sbyte *form, ...);
void  c_vprintf (const sbyte *form, va_list list);
void  c_printXY (sword x, sword y, const sbyte *form, ...);
void  c_putch (sbyte ch);
void  c_gettext (sword x1, sword y1, sword x2, sword y2, void *buff);
void  c_puttext (sword x1, sword y1, sword x2, sword y2, void *buff);
void  c_movetext (sword x1, sword y1, sword x2, sword y2, sword tX, sword tY);
void  c_setUseChiSys (sword flag);

word  c_getattr (void);


/*---------------------------------------------------------------------------*/
/* Output File */
FILE  *new_fopen (const sbyte *filename, const sbyte *mode);
sword  new_fclose (FILE *fp);
sword  new_fgetc (FILE *fp);
sword  new_fputc (sword c, FILE *fp);
sword  new_access (const sbyte *filename, sword amode);
sword  new_fseek (FILE *fp, sdword offset, sword whence);
sword  new_unlink (const sbyte *filename);
sword  new_feof (FILE *stream);
sword  new_fprintf (FILE *fp, const sbyte *format, ...);
sword  new_fflush (FILE *fp);
sdword new_flength (FILE *fp);
size_t new_fread (void *ptr, size_t size, size_t n, FILE *fp);
size_t new_fwrite (const void *ptr, size_t size, size_t n, FILE *fp);

#endif

