/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/

#ifndef __GLOBAL_H_
#define __GLOBAL_H_

#ifndef __COMMON_H_
   #include "common.h"
#endif

#ifndef __BOOTMGR_H_
   #include "bootmgr.h"
#endif

#ifndef __FDISK_H_
   #include "fdisk.h"
#endif

extern sword     g_WriteSW;                                    /** gJ} **/
extern DiskDT    *g_DTable;            /** VɰtmϺаѼƪ(}C) **/
extern INFO      g_Info;                                   /** XTc **/
extern word      g_TextArea[TEXT_MAX_Y][TEXT_MAX_X];

extern Screen    g_CurPos;

/*---------------------------------------------------------------------------*/
extern void      LOADER (void);
extern void      LDR_END (void);
extern void      MY_INT_24 (void);
extern void      MY_INT_13 (void);
extern void      END_INT13 (void);
extern void      BOOT_HEAD (void);
extern void      BOOT_END (void);
extern void      BOOT_DATA (void);
extern void      g_OldInt13 (void);
extern void      g_TDISK (void);


/*----------------------------------------------------------------------------+
|                      SPF Boot Manager use global variable                   |
+----------------------------------------------------------------------------*/
extern sbyte     g_Magic_Str[9];
extern BOOTPARA  g_BootPara;
extern BMGR      g_Boot[REC_NUMBER];
extern byte      g_EndLoad[];

extern volatile word  bm_Timer;
extern volatile word  bm_Counter;

extern sbyte     *g_SysName[];

extern sbyte     bm_SecStr[],
                 bm_BootTitle[],
                 bm_FsTitle[], 
                 bm_Introduce[],
                 bm_UpSym[],
                 bm_DownSym[],
                 bm_PmtStr[],
                 bm_ErrorMsg[],
                 bm_PwPmtStr[],
                 bm_PwErrStr[];

extern FONT      g_Font[],
                 bm_Font[],
                 *bm_PreUseFont,
                 *bm_Pre2UseFont;
                 
extern sword     g_nFont;
extern sword     bm_nFont;
                 
extern sword     bm_BootTime;
extern byte      g_DataEnd[];

#endif  /* __GLOBAL_H_ */
