/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#ifndef __FDISK_H__
#define __FDISK_H__

/*#include <dos.h> */
#include <stdio.h>

#ifndef __COMMON_H_
   #include "common.h"
#endif

typedef struct partition
{
   byte  active,                                                /* ʤ  */
         problem;
   sword no,                                                    /* νs  */
         id,                                                    /* t ID   */
         old_id,                                                /* ëe ID */
     /*  sector,   */                                           /* ҩl    */
     /*  side,     */                                           /* ҩlϰ  */
         remake,                                                /* غX  */
         adjust;
   dword stCyl,                                                 /* ҩlϬW  */
         endCyl,                                                /* ϬW  */
         side,                                                  /* ҩl    */
         sector;                                                /* ҩlϰ  */
} PARTN;


typedef union boot_sector
{
    struct common
    {
        byte   jumpCode;
        byte   jumpOffset;
        byte   nop;
        byte   oem[8];
        word   bytePerSect;
        byte   sectPerClust;
        word   nBootSect;
        byte   nFAT;
        word   nonComm[2];                                  /** FAT32 unuse **/
        byte   m_descriptor;
        word   nFatSect;                                    /** FAT32 unuse **/
        word   sectPerTrack;
        word   nHead;
        dword  nHiddSect;
        dword  tSector4;
        byte   other[474];
        word   magicNum;
    } comm;
 
    struct fat1x_fd
    {
        byte   comm17[17];
        word   nFdbRoot;                                    /** FAT32 unuse **/
        word   tSector2;                                    /** FAT32 unuse **/
        byte   comm1;
        word   nFatSect;                                  /** FAT32 unuse **/
        byte   comm12[12];
        byte   firstHD;
        byte   hold;
        byte   signature;
        word   serNoLow;
        word   serNoHigh;
        sbyte  label[11];
        sbyte  fsType[8];
        byte   bootStrap[448];
    } fat1x;
 
    struct fat32_fd
    {
        byte   comm[36];
        dword  nFatSect;
        word   extFlag;
        word   fsVersion;
        dword  rootClust;
        word   fsInfoSect;
        word   bakBootSect;
        byte   hold12[12];
        byte   firstHD;
        byte   hold1;
        byte   signature;
        word   serNoLow;
        word   serNoHigh;
        sbyte  label[11];
        sbyte  fsType[8];
        byte   bootStrap[420];
    } fat32;
} DOSBPB;


typedef struct fsSectInfo_fd
{
    dword title;
    byte  hole[480];
    dword signature;
    dword free_clust_cnt;
    dword next_free_clus;
    dword resvd[3];
    word  hole2;
    word  magicNum;
} FS_SECT;


typedef struct fsSectInfo_fd2
{
    byte  resvd[510];
    word  magicNum;
} FS_SECT2;


/*----------------------------------+
|   DOS    FDB  M   c   |
+----------------------------------*/
typedef struct DOS_FDB_DATE                                    /** Y **/
{
    word day:5,
         mon:4,
         year:7;
} FDB_DATE;
 

typedef struct DOS_FDB_TIME                                    /** Yɶ **/
{
    word sec:5,
         min:6,
         hour:5;
} FDB_TIME;


typedef union DOS_FDB
{
    struct DOS_SFN
    {
        byte     name[8],
                 ext[3],
                 attr,
                 hold[6];
        FDB_DATE useDate;
        word     clustHigh;
        FDB_TIME time;
        FDB_DATE date;
        word     clustLow;
        dword    size;
    } SFN;
 
    struct DOS_LFN
    {
        byte  serNO,
              name10[10],
              attr,
              type,
              chkSum,
              name12[12],
              hold[2],
              name4[4];
    } LFN;

} FDB;


/********************************    i ********************************/
void  Reset_Fdisk (void);
void  Init_Fdisk (void);
void  Fdisk_Menu (PARTN *partnArr, sword ndx);
void  Fdisk_Tab_Menu (PARTN *partnArr);
void  Adjust_partn (PARTN *partnArr, sword ndx);
void  Adjust_capacity (PARTN *partnArr, sword ndx);
void  Adjust_head (PARTN *partnArr, sword ndx);
void  Move_location (PARTN *partnArr, sword ndx);
void  Fdisk_Picture (sword flag);
void  CreateFsSector (PARTN *ptr, void *bootSect, void *target, sword bNew);
void  CreateFsSector2 (PARTN *ptr, void *bootSect, void *target);
void  Redraw_Fdisk_Picture (sword sw);
void  Chk_Surface (dword start_cyl, dword end_cyl, sword way);
void  Exchange_partn (PARTN *partnArr, sword ndx);
void  Find_space (PARTN *partnArr);
void  Ins_elem (PARTN *partnArr, sword ndx, dword begin, dword end);
void  Remove_unused_partn (PARTN *partnArr);
void  Del_Partn (PARTN *partnArr, sword ndx);
void  Sort_Partn (PARTN *partnArr, sword kind);
void  Display_Sector (void);
void  Init_Partn_Elem (PARTN *ptr);
void  Reset_Partn (PARTN *partnArr);
void  Process_Partn_Object (PARTN *partnArr);
void  Set_ID (PARTN *partnArr, sword ndx);
void  Hidden_partn (PARTN *ptr);
void  Dos_Tools (PARTN *partnArr, sword ndx);
void  Set_Active_Partn (PARTN *partnArr, PARTN *ptr, sword bToggle);
void  ShowSector (dword cyl, dword head, dword sector, sword mode);
void  ShowBootRecord (byte *buff);
void  ShowDIR (byte *buff);
void  ReloadLogicPartn (PARTN *partnArr);
void  Create_Partn (PARTN *partnArr, sword ndx,
                    dword begin, dword end, sword kind, sword find_sw);

sword CreateBPB (PARTN *partnArr, sword ndx, void *buffer);
sword Fdisk (PARTN *partnArr);
sword Find_EXT (PARTN *partnArr);
sword Adjust_DOS_BootSector (PARTN *ptr  /**, dword ExtStart */);
sword CreateNewPartn (PARTN *partnArr, sword ndx);
sword Chg_Work_Disk (PARTN *partnArr);
sword DestroyBootSect (PARTN *ptr);
sword Set_Fat32_Support (void);
sword ShowCluster (PARTN *ptr);
sword Save_Partn (PARTN *partnArr);
sword SaveDosBootSector (PARTN *ptr, void *bootSect, sword isFAT32);
sword Write_Partn (PARTN *partnArr, sword doom, sword adjust);
sword Reference_from_boot (PARTN *partnArr, sword ndx);
sword Save_Extended (PARTN *partnArr, dword ExtStart, sword doom, sword adjust);
sword MovePartnData (dword SourCyl, PARTN *partnArr, sword ndx);
sword Quick_Format (PARTN *partnArr, sword ndx);
sword Update_MBR (DiskDT *dk);
sword Get_Pre_Loader (byte *buff);
sword Get_Disk_Info (DiskDT *dk, PARTN *partnArr, sword find_flag);
sword Get_Logic_Partn (PARTN *partnArr, PARTN *extPartn);
sword Prompt_Save_Partn (PARTN *partnArr);
sword Sele_HD (sword use_floppy, sword startItem);
sword Sele_Partn (PARTN *partnArr, sword startItem, sword flags,
                  sword (*condition)(PARTN *partnArr, sword ndx));
sword DestructBootSect (PARTN *ptr);
sword Find_Problem (PARTN *partnArr);
sword Find_Partn_No (PARTN *partnArr, sword no);
sword Out_of_ext (PARTN *ptr);
      
dword GetStart (PARTN *ptr);
dword GetEnd (PARTN *ptr);   
dword GetNumCyl (PARTN *ptr);
dword Get_nSector (PARTN *ptr);

sword ChkValidLogicPartn (PARTN *ptr);
sword IsLegalBootSect (PARTN *ptr);
sword IsHiddenPartn (PARTN *ptr);
sword IsLikeExtPartn (void *buff);


/*=====================*/
/*  In the PartnMnu.C  */
/*=====================*/
sword General_sele (PARTN *partnArr, sword ndx);
sword Just_primary (PARTN *partnArr, sword ndx);
sword Just_logic (PARTN *partnArr, sword ndx);
sword ID20h_or_unused (PARTN *partnArr, sword ndx);
sword Just_id20h (PARTN *partnArr, sword ndx);
sword All_used (PARTN *partnArr, sword ndx);
sword User_hidden_set (PARTN *partnArr, sword ndx);
sword Search_no (DiskDT *dk, sword Par, void *HiddArr);


/*--------------------------------------+
|      PRE_LOAD.asm   LABEL     |
+--------------------------------------*/
extern void MBR_HEAD (void);
extern void MBR_END (void);


/*================================   w q ==============================*/
#define  SECTOR_PER_CYL(n)  (((n)->MaxHead + 1) * (n)->MaxSector)

#define  BOOT                0
#define  FAT_1               1
#define  FAT_2               2
#define  ROOT                3
#define  HEX_DUMP            4

#define  _ID_                0              /** get_sys_name() ϥΤwqr **/
#define  _INDEX_             1
#define  _GET_ID_            2

#define  _MBR_              0xff
#define  _FLOPPY_           0
#define  MAX_PARTN_ELEM     99                       /** i`ƶq **/
#define  PARTN_MENU_ITEMS   13                         /** ο@ **/
#define  BUFF_nSECT         10                           /** wİϤjp(KB) **/

#define  MOVE_LIGHT_BAR     0x01
#define  NO_REDRAW_MENU     0x02

/*-----------------------------------+
|    0x26  SPFDisk ۩w ID   |
+-----------------------------------*/
#define  HIDDEN_ID          0x26 
                            
/*--------------------------+
|      HUOU ID      |
+--------------------------*/
#define  UNKNOW_ID          0x100
#define  FLOPPY_ID          0x101
#define  BAD_HIDD_ID        0x102
#define  NOT_EXIST_ID       0x103
#define  MAX_ID_NUM         0x103      /** ID }C̤j ID ȡAܤ 0xff **/

#define  HIDD_BAK           0x1a0      /** H 0x26 îɦsƥ ID m **/

/*-------------------+
|      wq      |
+-------------------*/
#define PRIMARY_PARTN       1
#define EXTENDED_PARTN      2
#define LOGIC_PARTN         3
         
/*-----------------------+
|   ΪƧǤ覡wq   |
+-----------------------*/
#define  FOR_STCYL          0
#define  FOR_NUMBER         1

#endif  /* __FDISK_H__ */
