/*----------------------------------------------------------------------------+
|   Copyright (C) 2003  Hsu-Ping Feng                                         |
|                                                                             |
|   This program is free software; you can redistribute it and/or modify      |
|   it under the terms of the GNU General Public License as published by      |
|   the Free Software Foundation; either version 2 of the License, or         |
|   (at your option) any later version.                                       |
|                                                                             |
|   This program is distributed in the hope that it will be useful,           |
|   but WITHOUT ANY WARRANTY; without even the implied warranty of            |
|   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             |
|   GNU General Public License for more details.                              |
|                                                                             |
|   You should have received a copy of the GNU General Public License         |
|   along with this program; if not, write to the Free Software               |
|                                                                             |
|   Foundation, Inc., 59 Temple Place, Suite 330,                             |
|   Boston, MA  02111-1307 USA                                                |
|                                                                             |
|                                                                             |
|   Author e-mail: spferng@ksts.seed.net.tw                                   |
+----------------------------------------------------------------------------*/
#include <stdio.h>
#include <conio.h>
#include "fdisk.h"
#include "common.h"
#include "global.h"
#include "keymap.h"

/*=====================   e        =======================*/
void Chk_Surface (dword start_cyl, dword end_cyl, sword way)
{
   #if ( DISPLAY == CHINESE )
      static sbyte *Symbol[] = { "", "", "" };
   #else
      static sbyte *Symbol[] = { "", "BB", "CC" };
   #endif
   dword  track, box_size, bad;
   dword  sector, side, cyl;
   sword  lastkey, count, unit, err, x, y, k;
   sword  box_num = 38 * 14;

   #if ( DISPLAY == CHINESE )
      if ( YN_box(TALK_BOX, "T w n i    H") == 0 )
         return;
   #else
      if ( YN_box(TALK_BOX, "Do you want to check surface ?") == 0 )
         return;
   #endif

/* g_Info.fd.clr_screen = TRUE;  */
   Redraw_Fdisk_Picture(TRUE);
   Clr_Block (2, 1, 54, 1);

   #if ( DISPLAY == CHINESE )
      c_printXY(3, 2, "ˬddG   %lu ϬW   %lu ϬW", start_cyl, end_cyl);
   #else 
      c_printXY(3, 2, "Checking area:  Cylinder  %lu - %lu", start_cyl, end_cyl);
   #endif

   track = (dword)(end_cyl - start_cyl + 1) * (CUR_DK->lgeo.maxHead + 1);
   if ( track > box_num )
   {
      box_size = track / box_num;
      box_num = (sword)(track / (box_size + 1));
      unit = 1;
   }
   else
   {
      box_size = 0;
      unit     = (sword)(box_num / track);
      box_num  = (sword)(unit * track);
   }

   c_textattr(NO_CHECK_COLOR);
   for ( x = 0,  y = 4 ; x < box_num ; y++ )                   /** øX **/
   {
      c_gotoxy(3, y);
      Repeat_Str(Symbol[0], (((box_num - x) >= 38) ?  38 : box_num - x) );
      x += 38;
   }

#if ( DISPLAY == CHINESE )
   c_printXY(4, 20, Symbol[0]);
   c_printXY(8, 20, "հ϶");

   c_textattr(CHECKING_COLOR);
   c_printXY(4, 21, Symbol[1]);
   c_textattr(DEFAULT_COLOR);
   c_printXY(8, 21, "la϶");

   c_printXY(30, 20, Symbol[0]);
   c_printf("  wհ϶");

   c_printXY(30, 21, Symbol[2]);
   c_printf("  դ϶");

   c_printXY(55, 20, "laϰϼơG 0");

   c_textattr(MESSAGE_COLOR);
   c_gotoxy(3, 19);
   Repeat_Char('-', 51);

   c_printf(" ϶ = %lu ϰ",
            ((box_size < 1) ? (sword)CUR_DK->lgeo.maxSect / unit :
                              box_size * (sword)CUR_DK->lgeo.maxSect) );
   c_textattr(DEFAULT_COLOR);
   ShowMSG(" [Esc]    ");

#else
   c_printXY(4, 20, Symbol[0]);
   c_printXY(8, 20, "Not Test");

   c_textattr(CHECKING_COLOR);
   c_printXY(4, 21, Symbol[1]);
   c_textattr(DEFAULT_COLOR);
   c_printXY(8, 21, "Bad block");

   c_printXY(30, 20, Symbol[0]);
   c_printf("  Block Tested");

   c_printXY(30, 21, Symbol[2]);
   c_printf("  It's Checking");

   c_printXY(55, 20, "Bad Sector:  0");
   
   c_textattr(MESSAGE_COLOR);
   c_gotoxy(3, 19);
   Repeat_Char('-', 51);
   c_printf(" Block = %lu Sector",
            ((box_size < 1) ? CUR_DK->lgeo.maxSect / unit :
                              box_size * CUR_DK->lgeo.maxSect) );
   c_textattr(DEFAULT_COLOR);
   ShowMSG("Press [Esc] to stop");

#endif     /* end CHINESE */


   ResetWorkDisk();

   lastkey = count = err = 0;
   bad     = 0;
   x       = 3;
   y       = 4;

   for ( cyl = start_cyl ; cyl <= end_cyl ; cyl++ )
   {
      for ( side = 0 ; side <= CUR_DK->lgeo.maxHead ; side++ )
      {
         if ( count == 0 )
            c_printXY(x, y, Symbol[2]);
      
         c_printXY(55, 21, "Cyl: %lu, Side: %04lu", cyl, side);
      
         if ( ((err == 0) || (way == 0)) &&
              chs_CheckWDK(side, cyl, 1, CUR_DK->lgeo.maxSect, NULL) )
         {
            err = 1;
            ResetWorkDisk();                                       /** m **/
      
            /**********************************/
            /*      令HϰϬˬd      */
            /**********************************/
            for ( sector = 1 ; sector <= CUR_DK->lgeo.maxSect ; sector++ )
              if ( chs_CheckWDK(side, cyl, sector, 1, NULL) )
              {
                 ResetWorkDisk();                                  /** m **/
                 c_printXY(68, 20, " %lu", ++bad);
                 if ( c_kbhit() )                              /** Bz **/
                    if ( (lastkey = WaitKey()) == ' ' )
                       way = !way;
                    else if ( lastkey == ESC_KEY )
                       goto QUIT_Label;                 /** VUXhj **/
      
                 c_gotoxy(15, 23);

                 #if ( DISPLAY == CHINESE )
                    ShowMSG("laϰϵo{");
                    c_printf("---> ϬW %lu,  %lu, ϰ %lu  ", cyl, side, sector);
                 #else
                    ShowMSG("Bad sector found");
                    c_printf("---> Cyl %lu, Side %lu, Sector %lu  ", cyl, side, sector);
                 #endif

                 if ( way != 0 )                           /** Xϰˬd **/
                    break;
              } /* end if */
         } /* end if */
      
         if ( count < box_size )
            count++;
         else
         {
            for ( k = 1 ; k <= unit ; k++ )
            {
               c_gotoxy(x, y);
               if ( err )
               {
                  c_textattr(CHK_ERR_COLOR);
                  c_printf(Symbol[1]);
                  c_textattr(DEFAULT_COLOR);
               }
               else
                  c_printf(Symbol[0]);
      
               x += 2;
               if ( x > 78 )
               {
                  y++;
                  x = 3;
               }
            } /* end for */
      
            err   = 0;
            count = 0;
         } /* end if */
      
         if ( c_kbhit() )                                      /** Bz **/
            if ( (lastkey = WaitKey()) == ' ' )
               way = !way;
            else if ( lastkey == ESC_KEY )
               goto QUIT_Label;                        /** VUXhj **/
      } /* end for side */
   } /* end for */

   QUIT_Label:                                               /** Jump label **/

   if ( lastkey == ESC_KEY )
      User_Interrupt_Box ();                             /** ܨϥΪ̤_ **/
   else if ( bad == 0 )
      #if ( DISPLAY == CHINESE )
         Prompt_Msg_Box("S  o { l a   I", NULL);   /** ϰϥ` **/
      #else
         Prompt_Msg_Box("Not found any bad sector !", NULL);
      #endif
} /* end start_check */

