#include <graphics.h>
#include "color.h"
#include <stddef.h>
#include <dos.h>
#include "maus.h"
#include "defines.h"

void Fensterschatten( int Xlo, int Ylo, int Xru, int Yru)
{
   setcolor( 0x08);
   setwritemode( XOR_PUT);
   setlinestyle( SOLID_LINE, 0, THICK_WIDTH);
   line( Xru+ 2, Ylo+ 3, Xru+ 2, Yru+ 3);
   line( Xlo+ 3, Yru+ 2, Xru   , Yru+ 2);
   setlinestyle( SOLID_LINE, 0, NORM_WIDTH);
   setwritemode( COPY_PUT);
}

void Balken( int x, int y, int laenge, int hoehe, long wert, long grundwert, int *xsp)
{
   int xend, max;

   setcolor( EGA_LIGHTCYAN);
   setfillstyle( SOLID_FILL, EGA_CYAN);
   max= x+ laenge+ 3;
   if(( grundwert== 0)|| (( xend= x+ (( double)wert* ( double)laenge/ ( double)grundwert))> max))
      xend= max;
   if( x!= xend)
   {
      bar( x+ *xsp, y+ 1, xend, y+ hoehe);
      if( *xsp== 0)
	 line( x+ *xsp, y, x+ *xsp, y+ hoehe);
      line( x+ *xsp, y, xend, y);
   }
   *xsp= xend- x;
}

void Draw_Tal_Berg( int x1, int y1, int x2, int y2, char t_b)
{
   if( t_b== TAL)
      setcolor( EGA_WHITE);
   else
      setcolor( EGA_DARKGRAY);
   line( x1, y2, x2, y2);
   line( x2, y2, x2, y1);
   if( t_b== TAL)
      setcolor( EGA_DARKGRAY);
   else
      setcolor( EGA_WHITE);
   line( x1, y1, x2, y1);
   line( x1, y1, x1, y2);
}

void DrawTal( int x1, int y1, int x2, int y2)
{
   Draw_Tal_Berg( x1, y1, x2, y2, TAL);
}

void OkSound( void){}

void ErrorSound( void)
{
   int i;

   for( i= 0; i< 6; i++)
   {
      sound( 200);
      delay( 6);
      sound( 600);
      delay( 3);
      sound( 300);
      delay( 6);
   }
   nosound();
}

void HinweisSound( void)
{
   int i;

   for( i= 0; i< 6; i++)
   {
      sound( 200);
      delay( 6);
      sound( 600);
      delay( 3);
      sound( 300);
      delay( 6);
   }
   nosound();
}

void PutPaper( int pap1x, int pap1y, int pap2x, int pap2y, int fillcolor, int balken, int icon, char *text)
{
   int color, textx, lxend;

   color= getcolor();
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   bar( pap1x+ 1, pap1y+ 1, pap2x- 1, pap1y+ 3);
   bar( pap1x+ 1, pap1y+ 1, pap1x+ 3, pap2y- 1);
   bar( pap1x+ 1, pap2y- 3, pap2x- 1, pap2y- 1);
   bar( pap2x- 3, pap1y+ 1, pap2x- 1, pap2y- 1);
   setfillstyle( SOLID_FILL, fillcolor);
   bar( pap1x+ 5, pap1y+ 5, pap2x- 5, pap2y- 5);
   setcolor( EGA_DARKGRAY);
   line( pap2x, pap1y, pap2x, pap2y);
   line( pap2x, pap2y, pap1x, pap2y);
   line( pap1x+ 4, pap1y+ 4, pap2x- 4, pap1y+ 4);
   line( pap1x+ 4, pap1y+ 4, pap1x+ 4, pap2y- 4);
   setcolor( EGA_WHITE);
   line( pap1x, pap1y, pap2x, pap1y);
   line( pap1x, pap1y, pap1x, pap2y);
   line( pap2x- 4, pap1y+ 4, pap2x- 4, pap2y- 4);
   line( pap2x- 4, pap2y- 4, pap1x+ 4, pap2y- 4);
   setcolor( EGA_DARKGRAY);
   if( balken== AN)
   {
      setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
      bar( pap1x+ 4, pap1y+ 4, pap2x- 4, pap1y+ 21);
      line( pap1x+ 5, pap1y+ 22, pap2x- 5, pap1y+ 22);
      if( text[ 0]!= '#')
      {
	 textx= ( pap1x+(( pap2x- pap1x)>> 1)- ( strlen( text)<< 2));
	 lxend= textx+( strlen( text)<< 3);
	 setcolor( EGA_DARKGRAY);
	 line( textx- 5, pap1y+ 5, lxend+ 3, pap1y+ 5);
	 line( textx- 5, pap1y+ 5, textx- 5, pap1y+ 18);
	 setcolor( EGA_WHITE);
	 line( textx- 5, pap1y+ 18, lxend+ 3, pap1y+ 18);
	 line( lxend+ 3, pap1y+ 18, lxend+ 3, pap1y+ 5);
	 setcolor( EGA_BLACK);
	 outtextxy( textx, pap1y+ 8, text);
      }
      setcolor( EGA_DARKGRAY);
      if( icon== AN)
      {
	 Button( pap1x+ 4, pap1y+ 4, pap1x+ 24, pap1y+ 19, "", 0);
	 setcolor( EGA_BLACK);
	 putpixel( pap1x+ 12, pap1y+ 9, EGA_BLACK);
	 line( pap1x+ 11, pap1y+ 10, pap1x+ 16, pap1y+ 10);
	 line( pap1x+ 10, pap1y+ 11, pap1x+ 16, pap1y+ 11);
	 line( pap1x+ 11, pap1y+ 12, pap1x+ 16, pap1y+ 12);
	 putpixel( pap1x+ 12, pap1y+ 13, EGA_BLACK);
      }
   }
   Fensterschatten( pap1x, pap1y, pap2x, pap2y);
   setcolor( color);
   return;
}
