/*  SYSSETUP.C  System setup
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <graphics.h>
#include <dos.h>
#include <io.h>
#include <dir.h>
#include <string.h>
#include <conio.h>
#include <fcntl.h>
#include "pal_op.h"
#include "filemgr.h"
#include "mouse_op.h"

#define SEKUNDE    0
#define MINUTE     2
#define STUNDE     4
#define TAG        7
#define MONAT      8
#define JAHR       9
#define ST_B       11
#define AL_STUNDE  5
#define AL_MINUTE  3
#define AL_SEKUNDE 1

void SetMouseSpeed( void)
{
   int status, ret= 0, mausspeedsp= mausspeed, klickwaitsp= klickwait, linkshaendermaussp= linkshaendermaus;
   void *arg_ptr[ 5];
   char *msg[]= { "Mauszeigergeschwindigkeit anpassen",
		  "Doppelklickgeschwindigkeit anpassen",
		  "Testfeld fr die momentan eingestellte Doppelklickgeschwindigkeit",
		  "rechte und linke Maustaste werden vertauscht" };
   WORD mauspos[]= { BUTTON|           FRAME| KEY,                   5,  27,   5,  21, ESC,
		     LAUFLEISTE|       FRAME| KEY|            MSG,  13,  31, 263,   1,  30,   1, CURSOR_LEFT, CURSOR_RIGHT,
		     LAUFLEISTE|       FRAME| KEY|            MSG,  13,  59, 263,  50, 300,  25,         'y',          'x',
		     DOUBLE_KLICKAREA|                        MSG, 282, 346,  31,  79,
		     CHECKBOX|         FRAME| KEY|            MSG,  13,  86, 'l',
		     BUTTON|           FRAME| KEY| DEFBUTTON,       13, 176, 109, 134, RETURN,
		     BUTTON|           FRAME| KEY,                 184, 346, 109, 134, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 360, 150, 8, INIT, NULL, AN};

   ( char *)arg_ptr[ 0]= "%d Mickeys/8 Pixel";
   arg_ptr[ 1]= &mausspeedsp;
   ( char *)arg_ptr[ 2]= "%d ms Doppelklick";
   arg_ptr[ 3]= &klickwaitsp;
   arg_ptr[ 4]= &linkshaendermaussp;
   MS.x= &speedx;
   MS.y= &speedy;
   MS.msg= msg;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   if( globalmaus== AN)
   {
      PCX_Window( MS.x, MS.y, PCX_MAUSEINSTELLUNGEN, &MS.sa, SHADOW);
      do
      {
	 status= __CheckMousepos( &MS);
	 switch( status)
	 {
	    case 1:                               /* Mickeys/Pixel gendert */
	       MSpeed( mausspeedsp);
	       break;
	    case 3:                                  /* Doppelklicktestfeld */
	       sound( 100);
	       delay( 100);
	       nosound();
	       break;
	    case 5:                                               /* RETURN */
	       mausspeed=        mausspeedsp;
	       klickwait=        klickwaitsp;
	       linkshaendermaus= linkshaendermaussp;
	       veraendert= AN;
	       ret= 1;
	       break;
	    case 6:                                              /* ABBRUCH */
	    case 0:                                                  /* ESC */
	       MSpeed( mausspeed);
	       ret= 1;
	       break;
	 }
      }while( !ret);
      ShowMouse( AUS);
      BigScreenRestore( &MS.sa, speedx, speedy);
      ShowMouse( AN);
   }
   else
      ErrorMsg( "Einstellungen knnen nur mit einer Maus angepat werden");
}

void Alarm( int Alarm_nummer)
{
   struct textsettingstype text;
   struct{ int X, Y;}Win_Koord[ MAX_ANZ_ALARME]= { { 160,  70},
						   { 160, 200},
						   { 160, 330} };
   int handle, color, fehler= 0;
   char tmp_array[ MAXPATH];
   WORD mauspos[]= { BUTTON| FRAME| KEY| DEFBUTTON,  80, 219,  85,  110, RETURN,
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 300, 120, 2, INIT, NULL, AUS};

   MS.x= &Win_Koord[ Alarm_nummer].X;
   MS.y= &Win_Koord[ Alarm_nummer].Y;
   MS.mauspos= mauspos;
   color= getcolor();
   PCX_Window( MS.x, MS.y, PCX_ALARM, &MS.sa, SHADOW);
   gettextsettings( &text);
   setcolor( EGA_BLACK);
   settextjustify( CENTER_TEXT, text.vert);
   sprintf( tmp_array, "%d.%02d", Alarmdaten[ Alarm_nummer].stunde, Alarmdaten[ Alarm_nummer].minute);
   ShowMouse( AN);
   outtextxy( *MS.x+ 150, *MS.y+ 33, tmp_array);
   outtextxy( *MS.x+ 150, *MS.y+ 58, Alarmdaten[ Alarm_nummer].msg);
   ShowMouse( AN);
   settextjustify( text.horiz, text.vert);
   strcpy( tmp_array, prgexe_ptr);
   if( ExistDatei( "ALARMMSG.DB2"))
   {
      if(( handle= _open( prgexe_path, O_RDWR))!= -1)
      {
	 lseek( handle, Alarm_nummer* sizeof( Alarm_struct), SEEK_SET);
	 Alarmdaten[ Alarm_nummer].alarm= AUS;
	 if( _write( handle, &Alarmdaten[ Alarm_nummer].alarm, sizeof( BOOL))== -1)
	 {
	    ErrorMsg( WRITE_ERROR"ALARMMSG.DB2");
	    fehler= -1;
	 }
	 _close( handle);
	 if( fehler== -1)                                /* Schreibfehler ? */
	    unlink( prgexe_path);
      }
      else
	 ErrorMsg( OPEN_ERROR"ALARMMSG.DB2");
   }
   strcpy( prgexe_ptr, tmp_array);
   AlarmSound();
   while( __CheckMousepos( &MS)== -1)
      ;
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   setcolor( color);
}

int SetAlarm( void)
{
   int handle, ret_val= 0;

   if( ExistDatei( "ALARMMSG.DB2"))
   {
      if(( handle= _open( prgexe_path, O_RDONLY))!= -1)
      {
	 if( _read( handle, Alarmdaten, MAX_ANZ_ALARME* sizeof( Alarm_struct))== -1)
	 {
	    ErrorMsg( READ_ERROR"ALARMMSG.DB2");
	    ret_val= -1;
	 }
	 _close( handle);
	 if( ret_val== -1)                                  /* Lesefehler ? */
	    unlink( prgexe_path);
      }
      else
      {
	 ErrorMsg( OPEN_ERROR"ALARMMSG.DB2");
	 ret_val= -1;
      }
   }
   return( ret_val);
}

int SetClock( void)
{
   struct dostime_t t;
   struct dosdate_t d;
   Alarm_struct _Alarm_sp[ MAX_ANZ_ALARME];
   int status, ret= 0, ret_val= 0, handle, stunde, minute, sekunde, tag, monat, jahr;
   char	Days_of_Month[]= { 31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31}, alwahl= 0;
   void *arg_ptr[ 25];
   char *msg[]= { "Werte fr den ersten Alarm setzen",
		  "Werte fr den zweiten Alarm setzen",
		  "Werte fr den dritten Alarm setzen",
		  "dieser Text wird bei einem Alarm mitausgegeben",
		  "aktiviert oder sperrt einen Alarm" };
   WORD mauspos[]= { BUTTON|      FRAME| KEY,              5,  27,   5,   21,  ESC,
		     LAUFLEISTE|  FRAME| KEY,             20,  37, 202,    0,   23,   1, CURSOR_LEFT, CURSOR_RIGHT,
		     LAUFLEISTE|  FRAME| KEY,             20,  65, 202,    0,   59,   1,         'e',          'r',
		     LAUFLEISTE|  FRAME| KEY,             20,  93, 202,    0,   59,   1,         'd',          'f',
		     LAUFLEISTE|  FRAME| KEY,            232,  37, 202,    1,   31,   1,         't',          'z',
		     LAUFLEISTE|  FRAME| KEY,            232,  65, 202,    1,   12,   1,         'g',          'h',
		     LAUFLEISTE|  FRAME| KEY,            232,  93, 202, 1980, 1999,   1,         'b',          'n',
		     LAUFLEISTE|  FRAME| KEY,             20, 133, 202,    0,   23,   1,         'y',          'x',
		     LAUFLEISTE|  FRAME| KEY,             20, 161, 202,    0,   59,   1,         'u',          'i',
		     LAUFLEISTE|  FRAME| KEY,            232, 133, 202,    1,   31,   1,         'j',          'k',
		     LAUFLEISTE|  FRAME| KEY,            232, 161, 202,    1,   12,   1,         'm',          ',',
		     RADIOBUTTON| FRAME| KEY|       MSG,  52, 194,   0,  '1',
		     RADIOBUTTON| FRAME| KEY|       MSG,  52, 213,   1,  '2',
		     RADIOBUTTON| FRAME| KEY|       MSG,  52, 232,   2,  '3',
		     INPUT|       FRAME| KEY|       MSG, 232, 202, 202, MAX_ALARMMSGLENGTH- 1,  'w',
		     CHECKBOX|    FRAME| KEY|       MSG, 232, 228, 'v',
		     BUTTON|      FRAME| KEY| DEFBUTTON,  65, 144, 247,  297,  's',
		     BUTTON|      FRAME| KEY,            151, 230, 247,  297,  'l',
		     BUTTON|      FRAME| KEY,            237, 316, 247,  297,  '+',
		     BUTTON|      FRAME| KEY,            323, 389, 247,  297,  'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 455, 309, 21, INIT, NULL, AN};

   ( char *)arg_ptr[  0]= "%d Stunden";
   arg_ptr[  1]= &stunde;
   ( char *)arg_ptr[  2]= "%d Minuten";
   arg_ptr[  3]= &minute;
   ( char *)arg_ptr[  4]= "%d Sekunden";
   arg_ptr[  5]= &sekunde;
   ( char *)arg_ptr[  6]= "%d Tage";
   arg_ptr[  7]= &tag;
   ( char *)arg_ptr[  8]= "%d Monate";
   arg_ptr[  9]= &monat;
   ( char *)arg_ptr[ 10]= "%d Jahre";
   arg_ptr[ 11]= &jahr;
   ( char *)arg_ptr[ 12]= "%d \15-Stunden";
   arg_ptr[ 13]= &_Alarm_sp[ alwahl].stunde;
   ( char *)arg_ptr[ 14]= "%d \15-Minuten";
   arg_ptr[ 15]= &_Alarm_sp[ alwahl].minute;
   ( char *)arg_ptr[ 16]= "%d \15-Tage";
   arg_ptr[ 17]= &_Alarm_sp[ alwahl].tag;
   ( char *)arg_ptr[ 18]= "%d \15-Monate";
   arg_ptr[ 19]= &_Alarm_sp[ alwahl].monat;
   arg_ptr[ 20]= arg_ptr[ 21]= arg_ptr[ 22]= &alwahl;
   arg_ptr[ 23]= _Alarm_sp[ alwahl].msg;
   arg_ptr[ 24]= &_Alarm_sp[ alwahl].alarm;
   MS.x= &setclockx;
   MS.y= &setclocky;
   MS.msg= msg;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_UHRSTELLEN, &MS.sa, SHADOW);
   _dos_gettime( &t);
   _dos_getdate( &d);
   stunde = t.hour;
   minute = t.minute;
   sekunde= t.second;
   tag    = d.day;
   monat  = d.month;
   jahr   = d.year;
   memcpy( _Alarm_sp, Alarmdaten, MAX_ANZ_ALARME* sizeof( Alarm_struct));
   do
   {
      switch( status= __CheckMousepos( &MS))
      {
	 case 5:                                          /* Monat gendert */
	    mauspos[ 38]= Days_of_Month[ monat- 1];  /* Maximalwert von LAUFLEISTE fr Tag */
	    if( tag> Days_of_Month[ monat- 1])
	       tag= Days_of_Month[ monat- 1];
	    MS.statsp= REINIT;
	    break;
	 case 7:
	 case 8:
	 case 9:
	 case 10:
	 case 14:
	    _Alarm_sp[ alwahl].alarm= AN;
	    MS.statsp= REINIT;
	    break;
	 case 11:                                   /* Alarmnummer gendert */
	 case 12:
	 case 13:
	    arg_ptr[ 13]= &_Alarm_sp[ alwahl].stunde;
	    arg_ptr[ 15]= &_Alarm_sp[ alwahl].minute;
	    arg_ptr[ 17]= &_Alarm_sp[ alwahl].tag;
	    arg_ptr[ 19]= &_Alarm_sp[ alwahl].monat;
	    arg_ptr[ 24]= &_Alarm_sp[ alwahl].alarm;
	    arg_ptr[ 23]=  _Alarm_sp[ alwahl].msg;
	    MS.statsp= REINIT;
	    break;
	 case 18:                                          /* Uhr und Alarm */
	 case 16:                                            /* Uhr stellen */
	    t.hour=    stunde;
	    t.minute=  minute;
	    t.second=  sekunde;
	    t.hsecond= 0;
	    d.day=     tag;
	    d.month=   monat;
	    d.year=    jahr;
	    _dos_settime( &t);
	    _dos_setdate( &d);
	    uhrsp= -1;
	    if( status== 16)
	    {
	       ret= 1;
	       break;
	    }
	 case 17:                                           /* Alarm setzen */
	    strcpy( prgexe_ptr, "ALARMMSG.DB2");
	    if(( handle= _creat( prgexe_path, 0))!= -1)
	    {
	       if( _write( handle, memcpy( Alarmdaten, _Alarm_sp, MAX_ANZ_ALARME* sizeof( Alarm_struct)), MAX_ANZ_ALARME* sizeof( Alarm_struct))== -1)
	       {
		  ErrorMsg( WRITE_ERROR"ALARMMSG.DB2");
		  ret_val= -1;
	       }
	       _close( handle);
	       if( ret_val== -1)                         /* Schreibfehler ? */
		  unlink( prgexe_path);
	    }
	    else
	    {
	       ErrorMsg( CREAT_ERROR"ALARMMSG.DB2");
	       ret_val= -1;
	    }
	 case 0:                                                     /* ESC */
	 case 19:                                                /* Abbruch */
	    ret= 1;
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   return( ret_val);
}

void ColorDemo( int x, int y, char dateicolorsp, char menuinksp, char menubackroundsp)
{
   ShowMouse( AUS);
   setcolor( menubackround);
   setfillstyle( SOLID_FILL, menubackroundsp);
   bar( x+ 310, y+ 62, x+ 365, y+ 134);
   _Icon( x+ 321, y+ 72, ICO_FR);
   setcolor( menuinksp);
   setlinestyle( DOTTED_LINE, 0, NORM_WIDTH);
   rectangle( x+ 316, y+ 109, x+ 357, y+ 121);
   outtextxy( x+ 321, y+ 112, "Test");
   setlinestyle( SOLID_LINE, 0, NORM_WIDTH);
   setcolor( dateicolorsp);
   outtextxy( x+ 390, y+  95, "DBD.BAT");
   setcolor( EGA_BLACK);
   outtextxy( x+ 390, y+  81, "Die Datei");
   outtextxy( x+ 390, y+ 109, "ansehen ?");
   ShowMouse( AN);
}

int SetTextColor( void)
{
   int ret= 0, ret_val= 1, dateicolorsp= datcolor,
       menubackroundsp= menubackround, menuinksp= menuink;
   void *arg_ptr[ 6];
   char *msg[]= { "Farbe von Dateinamen, Verzeichnissen ua.",
		  "Farbe des Programmnamens unter den Icons",
		  "Hintergrundfarbe der Gruppenfenster und der Hauptgruppe" };
   WORD mauspos[]= { BUTTON|      FRAME| KEY,                   5,  27,   5,  21, ESC,
		     LAUFLEISTE|  FRAME| KEY| DEFBUTTON| MSG,  23,  54, 263,   0,  15,   1, 'e', 'r',
		     LAUFLEISTE|  FRAME| KEY|            MSG,  23,  82, 263,   0,  15,   1, 'd', 'f',
		     LAUFLEISTE|  FRAME| KEY|            MSG,  23, 110, 263,   0,  15,   1, 'c', 'v',
		     BUTTON|      FRAME| KEY,                  15, 237, 152, 177, RETURN,
		     BUTTON|      FRAME| KEY,                 250, 471, 152, 177, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 488, 194, 7, INIT, NULL, AN};

   ( char *)arg_ptr[ 0]= "Dateimanagertexte (%d)";
   arg_ptr[ 1]= &dateicolorsp;
   ( char *)arg_ptr[ 2]= "Programmnamen (%d)";
   arg_ptr[ 3]= &menuinksp;
   ( char *)arg_ptr[ 4]= "Programmablage (%d)";
   arg_ptr[ 5]= &menubackroundsp;
   MS.x= &tcolorx;
   MS.y= &tcolory;
   MS.msg= msg;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_FARBENSETZEN, &MS.sa, SHADOW);
   ColorDemo( *MS.x, *MS.y, dateicolorsp, menuinksp, menubackroundsp);
   do
   {
      switch( __CheckMousepos( &MS))
      {
	 case 0:                                                     /* ESC */
	 case 5:                                                 /* Abbruch */
	    ret= 1;
	    break;
	 case 1:                                         /* Farbe verndert */
	 case 2:
	 case 3:
	    ColorDemo( *MS.x, *MS.y, dateicolorsp, menuinksp, menubackroundsp);
	    break;
	 case 4:                                                  /* Return */
	    if( menuinksp== menubackroundsp)
	       Hinweis( "Farbe des Programmnamens und des Hintergrundes sind gleich");
	    else
	    {
	       if( dateicolorsp== EGA_LIGHTGRAY)
		  Hinweis( "'Dateimanagertext' wre unsichtbar");
	       else
	       {
		  if(( menuinksp!= menuink)|| ( menubackroundsp!= menubackround))
		     ret_val= 0;                          /* Anzeige neu aufbauen */
		  datcolor=      dateicolorsp;
		  menuink=       menuinksp;
		  menubackround= menubackroundsp;
		  veraendert= AN;
		  ret= 1;
	       }
	    }
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   return( ret_val);                               /* 0 -> Anzeige erneuern */
}

void VerSet( void)
{
   int ret= 0, x_dateiauswahlbox= 120, y_dateiauswahlbox= 30, minuten= ssaver_time,
       x_verzeichnisbaum= 100;
   char menusp= beginwindow_menu, schonersp= bildschirmschoner,
	interner_Editor_sp= interner_Editor, Tree_Sort_sp= Tree_Sort, LW_TREEINFO_sp= LW_TREEINFO,
	Default_DiskDrive_sp= Default_DiskDrive, Default_Format_sp= Default_Format- 1,
	Default_Verify_sp= Default_Verify, drag_drop_work_sp= drag_drop_work,
	Sounddevice_sp= Sounddevice, wait_Sound_sp= wait_Sound, Save_DOS_sp= Save_DOS,
	inputOverwrite_sp= inputOverwrite, Edit_X_Term_sp= Edit_X_Term,
	editorsp[ MAXPATH], anwender_prg_sp[ MAXPATH], iconsuchweg[ MAXPATH],
	iconpathsp[ MAXDIR];
   BYTE Icon_daten[ GRP_MAXICONBYTES];
   char *def_Format[]= { "  360 KByte",
			 "  1.2 MByte",
			 "  720 KByte",
			 " 1.44 MByte",
			 " 2.88 MByte" };
   void *arg_ptr[ 33];
   WORD mauspos[]= { BUTTON|      FRAME| KEY,              5,  27,   5,  21, ESC,
		     RADIOBUTTON| FRAME| KEY,             24,  41, PROGRAMM_MANAGER, 'r',
		     RADIOBUTTON| FRAME| KEY,             24,  60, DATEI_MANAGER,    't',
		     RADIOBUTTON| FRAME| KEY,             24,  87, PUZZLE_SCHONER,   'u',
		     RADIOBUTTON| FRAME| KEY,             24, 106, LINIEN_SCHONER,   'l',
		     LAUFLEISTE|  FRAME| KEY,             17, 117, 263,   2,  30,   1, CURSOR_LEFT, CURSOR_RIGHT,
		     DIRINPUT| IGN_CASE|    FRAME| KEY,             18, 165, 210, MAXDIR- 1, 234, 156, LWAUSWAHL, 'z',
		     RADIOBUTTON| FRAME| KEY,             24, 215, SOUNDBLASTER, 'g',
		     RADIOBUTTON| FRAME| KEY,             24, 234, PC_SPEAKER, 'c',
		     CHECKBOX|    FRAME| KEY,             18, 247, 'h',
		     CHECKBOX|    FRAME| KEY,             18, 274, 's',
		     CHECKBOX| FRAME| KEY,                18, 301, INSERT,
		     CHECKBOX| FRAME| KEY,                18, 320, 'X',
		     RADIOBUTTON| FRAME| KEY,            302,  41, DRAG_DROP_KOPIEREN, 'k',
		     RADIOBUTTON| FRAME| KEY,            302,  60, DRAG_DROP_VERSCHIEBEN, 'v',
		     CHECKBOX|    FRAME| KEY,            296,  81, 'y',
		     CHECKBOX|    FRAME| KEY,            296, 108, SPACE,
		     CHECKBOX|    FRAME| KEY,            296, 127, 'f',
		     KLICK_TABLE| FRAME| KEY,            315, 167, 145, 5, NORM_TEXT, 'm',
		     RADIOBUTTON| FRAME| KEY,            302, 196, 0, 'w',
		     RADIOBUTTON| FRAME| KEY,            302, 215, 1, 'b',
		     FILEINPUT| IGN_CASE|   FRAME| KEY,            296, 249, 261, MAXPATH- 1, 511, 281, DEFAULT, 'e',
		     RADIOBUTTON| FRAME| KEY,            302, 278, 1, 'n',
		     RADIOBUTTON| FRAME| KEY,            302, 297, 0, 'x',
		     FILEINPUT| IGN_CASE|   FRAME| KEY,            296, 331, 261, MAXPATH- 1, 511, 281, DEFAULT, 'o',
		     BUTTON|      FRAME| KEY,            511, 557, 359, 393, 'i',
		     BUTTON|      FRAME| KEY| DEFBUTTON,  63, 132, 349, 401, RETURN,
		     BUTTON|      FRAME| KEY,            152, 221, 349, 401, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 576, 420, 29, INIT, NULL, AUS};

   Paste_Filter_to_Dir( strcpy( iconsuchweg, default_icon_path), "*.ICO");
   memcpy( Icon_daten, OwnerButtonICO_ptr, sizeof( Icon_daten));

   arg_ptr[  0]= arg_ptr[  1]= &menusp;
   arg_ptr[  2]= arg_ptr[  3]= &schonersp;
   ( char *)arg_ptr[  4]= "aktiv nach %d Minuten";
   arg_ptr[  5]= &minuten;
   arg_ptr[  6]= strcpy( iconpathsp, default_icon_path);
   arg_ptr[  7]= &x_verzeichnisbaum;
   arg_ptr[  8]= arg_ptr[  9]= &Sounddevice_sp;
   arg_ptr[ 10]= &wait_Sound_sp;
   arg_ptr[ 11]= &Save_DOS_sp;
   arg_ptr[ 12]= &inputOverwrite_sp;
   arg_ptr[ 13]= &Edit_X_Term_sp;
   arg_ptr[ 14]= arg_ptr[ 15]= &drag_drop_work_sp;
   arg_ptr[ 16]= &Default_Verify_sp;
   arg_ptr[ 17]= &Tree_Sort_sp;
   arg_ptr[ 18]= &LW_TREEINFO_sp;
   arg_ptr[ 19]= def_Format;
   arg_ptr[ 20]= &Default_Format_sp;
   arg_ptr[ 21]= arg_ptr[ 22]= &Default_DiskDrive_sp;
   arg_ptr[ 23]= strcpy( editorsp, editor_path);
   arg_ptr[ 24]= &x_dateiauswahlbox;
   arg_ptr[ 25]= &y_dateiauswahlbox;
   ( char *)arg_ptr[ 26]= "*.EXE;*.COM";
   arg_ptr[ 27]= arg_ptr[ 28]= &interner_Editor_sp;
   arg_ptr[ 29]= strcpy( anwender_prg_sp, anwender_prg);
   arg_ptr[ 30]= &x_dateiauswahlbox;
   arg_ptr[ 31]= &y_dateiauswahlbox;
   ( char *)arg_ptr[ 32]= "*.EXE;*.COM";
   MS.x= &versetx;
   MS.y= &versety;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_VERSCHIEDENES_SETZEN, &MS.sa, SHADOW);
   Show_ico( *MS.x+ 404, *MS.y+ 360, Icon_daten);
   do
   {
      switch( __CheckMousepos( &MS))
      {
	 case 26:                                                     /* OK */
	    beginwindow_menu= menusp;
	    bildschirmschoner= schonersp;
	    ssaver_time= minuten;
	    interner_Editor= interner_Editor_sp;
	    Tree_Sort= Tree_Sort_sp;
	    LW_TREEINFO= LW_TREEINFO_sp;
	    Default_DiskDrive= Default_DiskDrive_sp;
	    Default_Format= Default_Format_sp+ 1;
	    Default_Verify= Default_Verify_sp;
	    inputOverwrite= inputOverwrite_sp;
	    Edit_X_Term= Edit_X_Term_sp;
	    drag_drop_work= drag_drop_work_sp,
	    Sounddevice= Sounddevice_sp;
	    wait_Sound= wait_Sound_sp;
	    Save_DOS= Save_DOS_sp;
	    strcpy( editor_path, editorsp);
	    strcpy( default_icon_path, iconpathsp);
	    strcpy( anwender_prg, anwender_prg_sp);
	    memcpy( OwnerButtonICO_ptr, Icon_daten, sizeof( Icon_daten));
	    veraendert= AN;
	 case 0:                                                     /* ESC */
	 case 27:                                                /* Abbruch */
	    ret= 1;
	    break;
	 case 25:
	    if( IconAuswahl( iconsuchweg)== 0)
	    {
	       Cpy_ICO_mem( Icon_daten, iconsuchweg);
	       Show_ico( *MS.x+ 404, *MS.y+ 360, Icon_daten);
	    }
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
}

BYTE einmalig_GRP_PRG_reihenfolge;              /* Programminterne Variable */

BOOL _SortIni( GRP_struct *GRP)
{
   int ret= 0, status;
   BOOL autosort_sp= autosort, INIchanged= FALSE;
   BYTE GRP_PRG_reihenfolge_sp= GRP_PRG_reihenfolge;
   void *arg_ptr[ 4];
   char *msg[]= { "sortiert automatisch neu, wenn eine Gruppe verndert wird",
		  "alle Gruppen des Programmanagers werden sortiert",
		  "nur die momentan aktive Gruppe wird sortiert",
		  "nur die Einstellungen werden gespeichert" };
   WORD mauspos[]= { BUTTON|      FRAME| KEY,                   5,  27,   5,  21, ESC,
		     RADIOBUTTON| FRAME| KEY,                  24,  41, GRP_vor_PRG, 'g',
		     RADIOBUTTON| FRAME| KEY,                  24,  60, PRG_vor_GRP, 'p',
		     RADIOBUTTON| FRAME| KEY,                  24,  79, EGAL,        'n',
		     CHECKBOX|    FRAME| KEY|	         MSG,  18, 100, 'u',
		     BUTTON|      FRAME| KEY|            MSG,  13,  79, 129, 179, 'l',
		     BUTTON|      FRAME| KEY|            MSG,  86, 152, 129, 179, 'k',
		     BUTTON|      FRAME| KEY|            MSG, 159, 225, 129, 179, 'v',
		     BUTTON|      FRAME| KEY| DEFBUTTON,      232, 298, 129, 179, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 312, 194, 10, INIT, NULL, AN};

   arg_ptr[ 0]= arg_ptr[ 1]= arg_ptr[ 2]= &GRP_PRG_reihenfolge_sp;
   arg_ptr[ 3]= &autosort_sp;
   MS.x= &sortinix;
   MS.y= &sortiniy;
   MS.msg= msg;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_SORTIEREN, &MS.sa, SHADOW);
   do
   {
      switch( status= __CheckMousepos( &MS))
      {
	 case 7:                                 /* Einstellungen speichern */
	    autosort= autosort_sp;
	    GRP_PRG_reihenfolge= GRP_PRG_reihenfolge_sp;
	    veraendert= AN;
	    break;
	 case 0:                                                     /* ESC */
	 case 5:                                            /* alle Gruppen */
	 case 6:                                         /* aktuelle Gruppe */
	 case 8:                                                 /* Abbruch */
	    ret= 1;
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   switch( status)
   {
      case 5:                                               /* alle Gruppen */
      case 6:                                            /* aktuelle Gruppe */
	 einmalig_GRP_PRG_reihenfolge= GRP_PRG_reihenfolge_sp;
	 _MakeSort( GRP, status- 5);
	 INIchanged= TRUE;
	 break;
   }
   return( INIchanged);                 /* TRUE -> nderung */
}

extern BOOL MakeFlexLibrary( void);

void SysSetup( GRP_struct *GRP)
{
   int ret= 0;
   void *arg_ptr[ 2];
   char *msg[]= { "Mauseinstellungen festlegen",
		  "Farbeinstellungen festlegen",
		  "zustzliche Einstellungen festlegen (Editor,...)",
		  "bestimmten Dateiextensionen Programme zuweisen",
		  "Uhrzeit des Systems stellen und Alarm(e) setzen",
		  "Einstellungen sichern" };
   WORD mauspos[]= { BUTTON|      FRAME| KEY,                   5,  27,   5,  21, ESC,
		     BUTTON|      FRAME| KEY|            MSG,   9,  78,  27,  80, 'm',
		     BUTTON|      FRAME| KEY|            MSG,  81, 150,  27,  80, 'f',
		     BUTTON|      FRAME| KEY| DEFBUTTON| MSG,   9,  78,  83, 136, 'z',
		     BUTTON|      FRAME| KEY|            MSG,  81, 150,  83, 136, 'b',
		     BUTTON|      FRAME| KEY|            MSG,   9,  78, 139, 192, 'h',
		     BUTTON|      FRAME| KEY|            MSG,  81, 150, 139, 192, 'i',
		     RADIOBUTTON| FRAME| KEY,                  41, 212,  AN, 'a',
		     RADIOBUTTON| FRAME| KEY,                  41, 231, AUS, 'u',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 160, 251, 10, INIT, NULL, AN};

   arg_ptr[ 0]= arg_ptr[ 1]= &okton;
   MS.x= &setupx;
   MS.y= &setupy;
   MS.msg= msg;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_SYSTEMEINSTELLUNGEN, &MS.sa, SHADOW);
   do
   {
      switch( __CheckMousepos( &MS))
      {
	 case 0:                                                     /* ESC */
	    ret= 1;
	    break;
	 case 1:                                       /* Mauseinstellungen */
	    SetMouseSpeed();
	    break;
	 case 2:                                                  /* Farben */
	    if( !SetTextColor())                        /* Anzeige erneuern */
	    {
	       GRP->Neu= GRP_REDRAW;
	       ShowMouse( AUS);
	       BigScreenRestore( &MS.sa, *MS.x, *MS.y);
	       ProgAnz( GRP);
	       PCX_Window( MS.x, MS.y, PCX_SYSTEMEINSTELLUNGEN, &MS.sa, SHADOW);
	       MS.statsp= REINIT;
	       ShowMouse( AN);
	    }
	    break;
	 case 3:                                    /* Verschiedenes setzen */
	    VerSet();
	    break;
	 case 4:                                   /* Dateiviewer festlegen */
	    if( MakeFlexLibrary())
	    {
	       _Editor_Viewer( prgexe_path, EDIT, NULL);
	       FreeFlexLibrary();
	       LoadFlexLibrary();
	    }
	    break;
	 case 5:                                       /* Uhrzeit und Alarm */
	    SetClock();
	    break;
	 case 6:                                   /* Einstellungen sichern */
	    saveSystem( "EINSTELL.DB2");
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
}
