/*  SOUND_OP.C  Sound operations
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include <string.h>
#include <bios.h>
#include <fcntl.h>
#include <dir.h>
#include <alloc.h>
#include "filemgr.h"
#include "mouse_op.h"

extern long _resource_length( BYTE ID);

static BOOL vocdriver_installed= AUS;
static WORD voc_status_word;
static char *voc_ptr_to_driver, *voc_ptr_mem;
WORD SB_BasisAdr= 0x220;

BYTE GetSBVolume( void)
{
   outportb( SB_BasisAdr+ 4, 0x22);
   return( inportb( SB_BasisAdr+ 5)& 0x0F);
}

void SetSBVolume( WORD Vol)
{
   outportb( SB_BasisAdr+ 4, 0x22);
   outportb( SB_BasisAdr+ 5, ( BYTE)_rotl( Vol, 4)| ( BYTE)Vol);
}

void SB_Volume( void)
{
   int ret= 0, Vol, Vol_sp;
   void *arg_ptr[ 2];
   WORD mauspos[]= { BUTTON|      FRAME| KEY,              5,  27,   5,   21,  ESC,
		     LAUFLEISTE|  FRAME| KEY,             16,  33, 200,    0,   15,   1, CURSOR_LEFT, CURSOR_RIGHT,
		     BUTTON|      FRAME| KEY| DEFBUTTON,  25,  99,  63,  105,  RETURN,
		     BUTTON|      FRAME| KEY,            133, 207,  63,  105,  'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 233, 117, 5, INIT, NULL, AUS};

   if( !vocdriver_installed)
      Info_Frage( 250, 200, "Sie besitzen keinen\nSoundblaster, oder Sie\nhaben seine Benutzung\ndeaktiviert.\n(SystemSetup->Zustze)", INFO);
   else
   {
      ( char *)arg_ptr[ 0]= "%d Volume";
      arg_ptr[ 1]= &Vol;
      MS.x= &X_setvolume;
      MS.y= &Y_setvolume;
      MS.mauspos= mauspos;
      MS.arg_ptr= arg_ptr;
      PCX_Window( MS.x, MS.y, PCX_SB_VOLUME, &MS.sa, SHADOW);
      Vol_sp= Vol= GetSBVolume();
      do
      {
	 switch( __CheckMousepos( &MS))
	 {
	    case 1:
	       SetSBVolume( Vol);
	       break;
	    case 0:                                                     /* ESC */
	    case 3:                                                 /* Abbruch */
	       SetSBVolume( Vol_sp);
	    case 2:                                                      /* OK */
	       ret= 1;
	       break;
	 }
      }while( !ret);
      ShowMouse( AUS);
      BigScreenRestore( &MS.sa, *MS.x, *MS.y);
      ShowMouse( AN);
   }
}

int _voc_init_driver( void)
{
   int  handle;
   WORD vseg, vofs, vout= 1, DRV_length;
   unsigned long adresse;
   char drv_path[ MAXPATH], *tmp_ptr, *BLASTER_ptr;

   BLASTER_ptr= getenv( "BLASTER");
   if(( tmp_ptr= getenv( "SOUND"))!= NULL)
      strcat( strcpy( drv_path, tmp_ptr), "\\DRV\\");
   else
      *( strncpy( drv_path, prgexe_path, prgexe_ptr- prgexe_path)+ ( prgexe_ptr- prgexe_path))= '\0';
   strcat( drv_path, "CT-VOICE.DRV");
   if(( handle= _open( drv_path, O_RDONLY))!= -1)
   {
      if(( voc_ptr_mem= malloc(( DRV_length= filelength( handle))+ 16))!= NULL)
      {
	 vseg= FP_SEG( voc_ptr_mem);
	 vofs= FP_OFF( voc_ptr_mem);
	 adresse= ( ( ptrdiff_t)vseg<< 4)+ ( ptrdiff_t)vofs;
	 vseg= ( adresse>> 4)+ 1;
	 vofs= 0;
	 voc_ptr_to_driver= MK_FP( vseg, vofs);
	 if( _read( handle, voc_ptr_to_driver, DRV_length)!= -1)
	 {
	    if( !memcmp( voc_ptr_to_driver+ 3, "CT-VOICE", 8))
	    {
	       if( BLASTER_ptr!= NULL)
	       {
		  if(( tmp_ptr= strpbrk( BLASTER_ptr, "Aa"))!= NULL)
		  {
		     SB_BasisAdr= atoi( tmp_ptr+ 1);
		     _AX= SB_BasisAdr= ( SB_BasisAdr<< 4)/ 10+ 0xC0;
		     asm{
			   mov  bx, 1
			   call voc_ptr_to_driver
			}
		  }
		  if(( tmp_ptr= strpbrk( BLASTER_ptr, "Ii"))!= NULL)
		  {
		     _AX= atoi( tmp_ptr+ 1);
		     asm{
			   mov  bx, 2
			   call voc_ptr_to_driver
			}
		  }
	       }
	       vseg= FP_SEG( &voc_status_word);
	       vofs= FP_OFF( &voc_status_word);
	       asm{
		     mov  bx, 3
		     call voc_ptr_to_driver
		     mov  vout, ax
		     mov  bx, 5
		     mov  es, vseg
		     mov  di, vofs
		     call voc_ptr_to_driver
		  }
	    }
	 }
	 if( vout!= 0)                                            /* Fehler */
	    free( voc_ptr_mem);
      }
      _close( handle);
   }
   return( vocdriver_installed= ( vout== 0));                /* 1- o.k. 0- Fehler */
}

void _voc_deinstall_driver( void)
{
   if( vocdriver_installed== AN)
   {
      asm{
	    mov  bx, 9
	    call voc_ptr_to_driver
	 }
      free( voc_ptr_mem);
   }
}

int _voc_play( char *voicefile)
{
   int handle, ret_val= -1;

   if( vocdriver_installed== AN)
   {
      if(( handle= _open( voicefile, O_RDONLY))!= -1)
      {
	 ret_val= _voc_handleplay( handle, filelength( handle));
	 _close( handle);
      }
   }
   return( ret_val);
}

int _voc_handleplay( int handle, long f_length)
{
   int ret_val= -1;
   unsigned ret= 0;
   WORD vseg, vofs, _reads;
   BOOL is_VOC;
   long offset= 0L;
   BYTE *voc_ptr, voc_header[ 14];

   if( vocdriver_installed== AN)
   {
      if(( voc_ptr= farmalloc( f_length))!= NULL)
      {
	 do
	 {
	    offset+= ret;
	    (( f_length- offset)< 65534) ? ( _reads= f_length- offset) : ( _reads= 65534);
	 }while( ( long)( ret= _read( handle, ( BYTE huge *)voc_ptr+ offset, _reads))> 0);
	 if(( ( int)ret!= -1)&& ((( is_VOC= ( memcmp( voc_ptr, "Creative Voice File", 19)== 0))!= 0)|| !memcmp( voc_ptr+ 8, "WAVEfmt ", 8)))
	 {
	    if( voc_status_word!= 0)      /* noch ein Sample in der Ausgabe */
	    {
	       asm{
		     mov  bx, 8
		     call voc_ptr_to_driver
		  }
	    }
	    vseg= FP_SEG( voc_ptr);
	    if( is_VOC)
	       vofs= FP_OFF( voc_ptr)+ *( WORD *)( voc_ptr+ 20);
	    else
	    {
	       voc_header[  0]= 8;
	       voc_header[  1]= 4;
	       voc_header[  2]= 0;
	       voc_header[  3]= 0;
	       *( WORD *)( voc_header+ 4)= ( ( *( WORD *)( voc_ptr+ 0x16)== 1) ? ( 65532- ( 256000000/ *( DWORD *)( voc_ptr+ 0x18))) : ( 65536- ( 256000000/ ( 2* *( DWORD *)( voc_ptr+ 0x18)))));
	       voc_header[  6]= 0;
	       voc_header[  7]= *( WORD *)( voc_ptr+ 0x16)- 1;
	       voc_header[  8]= 1;
	       voc_header[  9]= *( voc_ptr+ 0x28);
	       voc_header[ 10]= *( voc_ptr+ 0x29);
	       voc_header[ 11]= *( voc_ptr+ 0x2A);
	       voc_header[ 12]= 256- ( 1000000/ *( DWORD *)( voc_ptr+ 0x18));
	       voc_header[ 13]= 0;
	       *( ( BYTE huge *)voc_ptr+ 0x2C+ *( DWORD *)( voc_ptr+ 0x28)- 1)= 0;  /* VOC_ENDE_CODE */
	       vofs= FP_OFF( memcpy( voc_ptr+ 0x1E, voc_header, 14));
	    }
	    asm{
		  mov  bx, 6
		  mov  es, vseg
		  mov  di, vofs
		  call voc_ptr_to_driver
	       }
	    ret_val= 0;
	 }
	 farfree( voc_ptr);
      }
   }
   return( ret_val);                                 /* -1- Fehler, 0- o.k. */
}

int _Voc( BYTE ID)
{
   int handle, ret_val= -1;

   if( vocdriver_installed== AN)
   {
      if(( handle= _resource_open( ID))!= -1)
      {
	 ret_val= _voc_handleplay( handle, _resource_length( ID));
	 _dos_close( handle);
	 if( wait_Sound&& ( ret_val== 0))
	 {
	    while( voc_status_word!= 0)  /* Warten bis die Ausgabe beendet ist */
	       ;
	 }
      }
   }
   return( ret_val);
}

void ReadySound( void)
{
   if( okton== AN)
   {
      if( _Voc( VOC_READY))
      {
	 sound( 100);
	 delay( 300);
	 sound( 80);
	 delay( 300);
	 sound( 60);
	 delay( 300);
	 nosound();
      }
   }
}

void AlarmSound( void)
{
   int i, ii;

   if( okton== AN)
   {
      if( _Voc( VOC_ALARM))
      {
	 for( ii= 0; ii< 10; ii++)
	 {
	    for( i= 1000; i< 5000; i+= 100)
	    {
	       sound( i);
	       delay( 10);
	    }
	 }
	 nosound();
      }
   }
}

void HinweisSound( void)
{
   int i;

   if( okton== AN)
   {
      if( _Voc( VOC_HINWEIS))
      {
	 for( i= 0; i< 6; i++)
	 {
	    sound( 200);
	    delay( 6);
	    sound( 600);
	    delay( 3);
	    sound( 300);
	    delay( 6);
	 }
	 nosound();
      }
   }
}

void ErrorSound( void)
{
   int i;

   if( okton== AN)
   {
      if( _Voc( VOC_ERROR))
      {
	 for( i= 0; i< 6; i++)
	 {
	    sound( 200);
	    delay( 6);
	    sound( 600);
	    delay( 3);
	    sound( 300);
	    delay( 6);
	 }
	 nosound();
      }
   }
}