/*  SAVESCR.C  Save and restore the areas under a window
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <graphics.h>
#include <dir.h>
#include <dos.h>
#include <string.h>
#include <alloc.h>
#include <fcntl.h>
#include "pal_op.h"
#include "filemgr.h"
#include "xms.h"

#define XMS_HANDLE      1
#define HEAP_HANDLE     2
#define FILE_HANDLE     3

int SaveAll( saveall *sa)
{
   return( BigScreenSave( sa, 0, 0, 639, 479));
}

int RestoreAll( saveall *sa)
{
   return( BigScreenRestore( sa, 0, 0));
}

int BigScreenSave( saveall *sa, int Xlo, int Ylo, int Xru, int Yru)
{
   int y, word, i, l;
   unsigned size, far_size;
   long offset;
   char *mem_ptr;

   size= imagesize( Xlo, 0, Xru, 9);
   sa->END_val= 0;
   sa->x= Xru- Xlo;
   sa->y= Yru- Ylo;
   if( XMSTreiber&& (( sa->XMS_handle= XMSGetMem(((( long)imagesize( Xlo, Ylo, Xru, Ylo)* ( long)( Yru- Ylo+ 1))+ 1023+ 500)>> 10))!= 0))
   {
      if(( mem_ptr= malloc( size))!= NULL)
      {
	 word= ( size+ 1)>> 1;
	 for( y= Ylo, i= 9, offset= 0L; y<= Yru; y+= 10, offset+= ( word<< 1))
	 {
	    if(( y+ i)> Yru)
	    {
	       i= Yru- y;
	       word= ( imagesize( Xlo, y, Xru, y+ i)+ 1)>> 1;
	    }
	    getimage( Xlo, y, Xru, y+ i, mem_ptr);
	    XMSCopy( 0, ( long)(( void *)mem_ptr), sa->XMS_handle, offset, word);
	 }
	 free( mem_ptr);
	 sa->Mode= XMS_HANDLE;
      }
      else
      {
	 XMSFreeMem( sa->XMS_handle);
	 ErrorMsg( KEIN_SPEICHER);
	 sa->END_val= -1;
      }
   }
   else
   {
      far_size= imagesize( Xlo, 0, Xru, i= ((( Yru- Ylo+ 3)/ 3)- 1));
      if(( ( long)far_size* 3L)< ( farcoreleft()- 65535L))
      {
	 for( l= 0, y= Ylo; l< 3; l++, y+= i+ 1)
	 {
	    if(( y+ i)> Yru)
	    {
	       i= Yru- y;
	       far_size= imagesize( Xlo, y, Xru, y+ i);
	    }
	    if(( sa->ptr[ l]= malloc( far_size))== NULL)
	    {
	       for( i= 0; i< l; i++)
		  free( sa->ptr[ i]);
	       goto PLATTE;
	    }
	    getimage( Xlo, y, Xru, y+ i, sa->ptr[ l]);
	 }
	 sa->Mode= HEAP_HANDLE;
      }
      else
      {
	 PLATTE:
	 ;
	 if(( sa->Tmp= tmpfile())!= 0)
	 {
	    if(( mem_ptr= malloc( size))!= NULL)
	    {
	       for( y= Ylo, i= 9; y<= Yru; y+= 10)
	       {
		  if(( y+ i)> Yru)
		  {
		     i= Yru- y;
		     size= imagesize( Xlo, y, Xru, y+ i);
		  }
		  getimage( Xlo, y, Xru, y+ i, mem_ptr);
		  if( fwrite( mem_ptr, 1, size, sa->Tmp)!= size)
		  {
		     fclose( sa->Tmp);
		     ErrorMsg( WRITE_ERROR"TMP");
		     sa->END_val= -2;
		     break;
		  }
	       }
	       free( mem_ptr);
	       sa->Mode= FILE_HANDLE;
	    }
	    else
	    {
	       fclose( sa->Tmp);
	       ErrorMsg( KEIN_SPEICHER);
	       sa->END_val= -1;
	    }
	 }
	 else
	 {
	    ErrorMsg( CREAT_ERROR"TMP");
	    sa->END_val= -2;
	 }
      }
   }
   return( sa->END_val); /* 0= O.K., -1= kein Speicher, -2= Fehler mit TMP-Datei */
}

int BigScreenRestore( saveall *sa, int Xlo, int Ylo)
{
   int y, word, i, l, Xru, Yru, ret_val= 0;
   unsigned size;
   long offset;
   char *mem_ptr;

   if( sa->END_val== 0)           /* kein Fehler beim Speichern aufgetreten */
   {
      Xru= Xlo+ sa->x;
      Yru= Ylo+ sa->y;
      size= imagesize( Xlo, 0, Xru, 9);
      switch( sa->Mode)
      {
	 case XMS_HANDLE:
	    if(( mem_ptr= malloc( size))!= NULL)
	    {
	       word= ( size+ 1)>> 1;
	       for( y= Ylo, i= 9, offset= 0L; y<= Yru; y+= 10, offset+= ( word<< 1))
	       {
		  if(( y+ i)> Yru)
		  {
		     i= Yru- y;
		     word= ( imagesize( Xlo, y, Xru, y+ i)+ 1)>> 1;
		  }
		  XMSCopy( sa->XMS_handle, offset, 0, ( long)(( void *)mem_ptr), word);
		  putimage( Xlo, y, mem_ptr, COPY_PUT);
	       }
	       free( mem_ptr);
	    }
	    else
	    {
	       ErrorMsg( KEIN_SPEICHER);
	       ret_val= -1;
	    }
	    XMSFreeMem( sa->XMS_handle);
	    break;
	 case HEAP_HANDLE:
	    i= (( Yru- Ylo+ 3)/ 3)- 1;
	    for( l= 0, y= Ylo; l< 3; l++, y+= i+ 1)
	    {
	       putimage( Xlo, y, sa->ptr[ l], COPY_PUT);
	       free( sa->ptr[ l]);
	    }
	    break;
	 case FILE_HANDLE:
	    if(( mem_ptr= malloc( size))!= NULL)
	    {
	       rewind( sa->Tmp);
	       for( y= Ylo, i= 9; y<= Yru; y+= 10)
	       {
		  if(( y+ i)> Yru)
		  {
		     i= Yru- y;
		     size= imagesize( Xlo, y, Xru, y+ i);
		  }
		  fread( mem_ptr, 1, size, sa->Tmp);
		  putimage( Xlo, y, mem_ptr, COPY_PUT);
	       }
	       free( mem_ptr);
	    }
	    else
	    {
	       ErrorMsg( KEIN_SPEICHER);
	       ret_val= -1;
	    }
	    fclose( sa->Tmp);
	    break;
      }
   }
   else
      ret_val= -2;
   return( ret_val);  /* 0= O.K., -1= kein Speicher, -2= ...Save war erfolglos */
}
