/*  PRG_SET.C  Program and Group setup
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <graphics.h>
#include <conio.h>
#include <io.h>
#include <stdlib.h>
#include <alloc.h>
#include <fcntl.h>
#include <string.h>
#include <dir.h>
#include <dos.h>
#include "pal_op.h"
#include "filemgr.h"
#include "mouse_op.h"

#define ERASE         0
#define RENAME        1
#define ERASE_ALL     2

extern BYTE einmalig_GRP_PRG_reihenfolge, GRP_PRG_reihenfolge; /* SYSSETUP.C */
extern WORD Is_Window_EXE( char *file);
extern BOOL FindProgs( GRP_struct *GRP);
extern BOOL _SortIni( GRP_struct *GRP);

int Sort_GRP( BYTE **elem1, BYTE **elem2)
{
   int ret;

   if(( einmalig_GRP_PRG_reihenfolge== EGAL)|| (( ret= *( *elem1+ 8)- *( *elem2+ 8))== 0))
      ret= stricmp( *elem1+ 10, *elem2+ 10);
   else
   {
      if( einmalig_GRP_PRG_reihenfolge== PRG_vor_GRP)
	 ret= 0- ret;
   }
   return( ret);
}

BYTE *Sort_GRPinhalt( BYTE *GRP_ptr, WORD blocklen)
{
   typedef int ( *fcmp) ( const void *, const void *);
   WORD i, l, new_len, dist;
   BYTE *Entry_ptr[ 1500], *GRP_new= NULL;

   for( i= 0; *( DWORD *)GRP_ptr!= GRP_LASTENTRY; i++)
   {
      if(( Entry_ptr[ i]= malloc( *( DWORD *)GRP_ptr))!= NULL)
      {
	 memcpy( Entry_ptr[ i], GRP_ptr, *( DWORD *)GRP_ptr);
	 blocklen-= *( DWORD *)GRP_ptr;
	 memmove( GRP_ptr, GRP_ptr+ *( DWORD *)GRP_ptr, blocklen);
	 GRP_ptr= realloc( GRP_ptr, blocklen);
      }
      else
      {
	 for( l= 0; l< i; l++)
	    free( Entry_ptr[ l]);
	 break;
      }
   }
   if( *( DWORD *)GRP_ptr== GRP_LASTENTRY)       /* kein Fehler aufgetreten */
   {
      qsort( Entry_ptr, i, sizeof( BYTE *), ( fcmp)Sort_GRP);
      if(( GRP_new= malloc( 1))!= NULL)
      {
	 for( l= 0, dist= new_len= 0; l< i; l++)
	 {
	    new_len+= *( DWORD *)Entry_ptr[ l];
	    if(( GRP_new= realloc( GRP_new, new_len))!= NULL)
	    {
	       memcpy( GRP_new+ dist, Entry_ptr[ l], *( DWORD *)Entry_ptr[ l]);
	       free( Entry_ptr[ l]);
	    }
	    else
	    {
	       for( ; l< i; l++)
		  free( Entry_ptr[ l]);
	    }
	    dist= new_len;
	 }
	 if( GRP_new!= NULL)                     /* kein Fehler aufgetreten */
	 {
	    if(( GRP_new= realloc( GRP_new, dist+ sizeof( DWORD)))!= NULL)
	       *( DWORD *)( GRP_new+ dist)= GRP_LASTENTRY;
	 }
      }
   }
   free( GRP_ptr);
   if( GRP_new== NULL)
      ErrorMsg( KEIN_SPEICHER);
   return( GRP_new);                                  /* ==NULL wenn Fehler */
}

BYTE *Sort_and_Write( BYTE *GRP_ptr, int handle, long seek_pos, long mem_len)
{
   if(( GRP_ptr= Sort_GRPinhalt( GRP_ptr, mem_len))!= NULL)
   {
      if(( lseek( handle, seek_pos, SEEK_SET)== -1)|| ( _write( handle, GRP_ptr, mem_len)== -1))
      {
	 ErrorMsg( WRITE_ERROR"Gruppendatei");
	 Info_Frage( 100, 200, "Gruppendatei konnte\nnicht vollstndig ge-\nschrieben werden !\nEventuell ist sie\nzerstrt !", INFO);
      }
   }
   return( GRP_ptr);
}

#define ALLE_SORTIEREN      0
#define AKTUELLE_SORTIEREN  1

void *ptr_to_GRP( GRP_struct *, int *, BOOL);

void _MakeSort( GRP_struct *GRP, BYTE akt_alle)
{
   struct ffblk ffblk;
   int ret= 0, handle, done;
   long seek_pos, mem_len;
   BYTE *GRP_ptr;
   BOOL akt_GRP;

   if( akt_alle== AKTUELLE_SORTIEREN)
   {
      GRP_ptr= ptr_to_GRP( GRP, &ret, CHECK);
      if( !ret)
      {
	 if(( GRP_ptr= Sort_and_Write( GRP_ptr, GRP->File_handle, GRP->seek_pos, GRP->mem_len))!= NULL)
	 {
	    if( GRP->XMS_handle> 0)
	       XMSCopy( 0, ( DWORD)(( void far *)GRP_ptr), GRP->XMS_handle, 0L, ( GRP->mem_len+ 1)>> 1);
	    free( GRP_ptr);
	 }
      }
   }
   else
   {
      strcpy( prgexe_ptr, "*.DG2");
      done= findfirst( prgexe_path, &ffblk, FA_NORMAL);
      while( !done)
      {
	 strcpy( prgexe_ptr, ffblk.ff_name);
	 if(( handle= _open( prgexe_path, O_RDWR))!= -1)
	 {
	    if(( GRP_ptr= malloc( 13+ GRP_MAXGRUPPENDIR+ GRP_MAXGRUPPENNAME))!= NULL)
	    {
	       if( _read( handle, GRP_ptr, 13+ GRP_MAXGRUPPENDIR+ GRP_MAXGRUPPENNAME)!= -1)
	       {
		  if( !strncmp( GRP_ptr, GRP_DATEIID, sizeof( GRP_DATEIID)- 1))
		  {
		     akt_GRP= 0;
		     if( !strcmp( GRP_ptr+ 13, GRP->gruppendir)&& !strcmp( GRP_ptr+ 13+ GRP_MAXGRUPPENDIR, GRP->gruppe))
			akt_GRP= 1;
		     mem_len= filelength( handle)- ( seek_pos= tell( handle));
		     if(( GRP_ptr= realloc( GRP_ptr, mem_len))!= NULL)
		     {
			if( _read( handle, GRP_ptr, mem_len)!= -1)
			{
			   if(( GRP_ptr= Sort_and_Write( GRP_ptr, handle, seek_pos, mem_len))!= NULL)
			   {
			      if( akt_GRP&& ( GRP->XMS_handle> 0))
				 XMSCopy( 0, ( DWORD)(( void far *)GRP_ptr), GRP->XMS_handle, 0L, ( GRP->mem_len+ 1)>> 1);
			   }
			   else
			   {
			      _close( handle);
			      break;
			   }
			}
			else
			   ErrorMsg( READ_ERROR"Gruppendatei");
		     }
		     else
		     {
			_close( handle);
			ErrorMsg( KEIN_SPEICHER);
			break;
		     }
		  }
	       }
	       else
		  ErrorMsg( READ_ERROR"Gruppendatei");
	       if( GRP_ptr!= NULL)
		  free( GRP_ptr);
	    }
	    else
	    {
	       _close( handle);
	       ErrorMsg( KEIN_SPEICHER);
	       break;
	    }
	    _close( handle);
	 }
	 else
	    ErrorMsg( OPEN_ERROR"Gruppendatei");
	 done= findnext( &ffblk);
      }
   }
}

int cmps( char **elem1, char **elem2)
{
   return( strcmp( *elem1, *elem2));
}

typedef struct
	{
	   int *X, *Y;
	   char *ico_name[ 1000], *verzeichnis;
	   RBalken *RB;
	}ICO_ANZ_Struct;

void ICO_Balken( int X, int Y, int Zeiger_pos, char an_aus)
{
   int y;

   y= Y+ 71+ ( Zeiger_pos* 37);
   setlinestyle( DOTTED_LINE, 0, NORM_WIDTH);
   if( an_aus== AN)
      setcolor( EGA_BLACK);
   else
      setcolor( EGA_LIGHTGRAY);
   ShowMouse( AUS);
   rectangle( X+ 24, y, X+ 166, y+ 37);
   ShowMouse( AN);
   setlinestyle( SOLID_LINE, 0, NORM_WIDTH);
}

void ICO_Up_Down( ICO_ANZ_Struct *IS, char Richtung)
{
   char tmp_array[ MAXPATH];

   if( Richtung== UP)
   {
      strcpy( strrchr( strcpy( tmp_array, IS->verzeichnis), '\\')+ 1, IS->ico_name[ IS->RB->proz+ 5L]);
      ShowMouse( AUS);
      ScrollUpWindow( *IS->X+ 24, *IS->Y+ 108, *IS->X+ 166, *IS->Y+ 293, 37);
      ShowPicture( *IS->X+ 27, *IS->Y+ 259, tmp_array);
      setcolor( datcolor);
      outtextxy( *IS->X+ 68, *IS->Y+ 271, IS->ico_name[ IS->RB->proz+ 5L]);
      ShowMouse( AN);
   }
   else
   {
      strcpy( strrchr( strcpy( tmp_array, IS->verzeichnis), '\\')+ 1, IS->ico_name[ IS->RB->proz]);
      ShowMouse( AUS);
      ScrollDownWindow( *IS->X+ 24, *IS->Y+ 71, *IS->X+ 166, *IS->Y+ 256, 37);
      ShowPicture( *IS->X+ 27, *IS->Y+ 74, tmp_array);
      setcolor( datcolor);
      outtextxy( *IS->X+ 68, *IS->Y+ 86, IS->ico_name[ IS->RB->proz]);
      ShowMouse( AN);
   }
}

void ICO_Entry( ICO_ANZ_Struct *IS)
{
   int ypos, i;
   char tmp_array[ MAXPATH], *ico_ptr;

   ico_ptr= strrchr( strcpy( tmp_array, IS->verzeichnis), '\\')+ 1;
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   ShowMouse( AUS);
   bar( *IS->X+ 24, *IS->Y+ 71, *IS->X+ 166, *IS->Y+ 293);
   for( i= IS->RB->proz, ypos= *IS->Y+ 37; ( i< ( IS->RB->proz+ 6L))&& ( i< IS->RB->max); i++)
   {
      strcpy( ico_ptr, IS->ico_name[ i]);
      ShowPicture( *IS->X+ 27, ypos+= 37, tmp_array);
      setcolor( datcolor);
      outtextxy( *IS->X+ 68, ypos+ 12, IS->ico_name[ i]);
   }
   if( IS->RB->Zeiger_pos>= IS->RB->max)
      IS->RB->Zeiger_pos= 0;
   ShowMouse( AN);
}

int IconAuswahl( char *iconsuchweg)
{
   struct ffblk ffblk;
   typedef int ( *fcmp) ( const void *, const void *);
   ICO_ANZ_Struct IS;
   RBalken RB= { 176, 67, 297, VERT_DIR, 1, 6, 0L};
   int X_Tree= 300, done, status, ret_val= 0, ret= 0;
   char iconsuchwegsp[ MAXPATH];
   void *arg_ptr[ 4];
   WORD mauspos[]= { BUTTON|      FRAME| KEY,              5,  27,   5,  21, ESC,
		     DIRINPUT| IGN_CASE|    FRAME| KEY,             17,  43, 256, MAXPATH- 1, 227,  67, LWAUSWAHL, 'i',
		     DOUBLE_KLICKAREA|   KEY,             20, 169,  72, 107, '1',
		     DOUBLE_KLICKAREA|   KEY,             20, 169, 109, 144, '2',
		     DOUBLE_KLICKAREA|   KEY,             20, 169, 146, 181, '3',
		     DOUBLE_KLICKAREA|   KEY,             20, 169, 183, 218, '4',
		     DOUBLE_KLICKAREA|   KEY,             20, 169, 220, 255, '5',
		     DOUBLE_KLICKAREA|   KEY,             20, 169, 257, 292, '6',
		     ROLLBALKEN|         KEY,            CURSOR_UP, CURSOR_DOWN, PAGE_UP, PAGE_DOWN, HOME, END, 1,
		     BUTTON|      FRAME| KEY,            207, 281, 205, 247, 'a',
		     BUTTON|      FRAME| KEY| DEFBUTTON, 207, 281, 253, 295, RETURN,
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 291, 315, 12, INIT, NULL, AUS};

   IS.RB= &RB;
   arg_ptr[ 0]= IS.verzeichnis= strcpy( iconsuchwegsp, iconsuchweg);
   arg_ptr[ 1]= &X_Tree;
   arg_ptr[ 2]= IS.RB;
   ( void (*)())arg_ptr[ 3]= ICO_Balken;
   IS.X= MS.x= &iconausw_x;
   IS.Y= MS.y= &iconausw_y;
   MS.arg_ptr= arg_ptr;
   MS.mauspos= mauspos;
   PCX_Window( MS.x, MS.y, PCX_ICONAUSWAHL, &MS.sa, SHADOW);
   do
   {
      ret= 0;
      done= findfirst( iconsuchwegsp, &ffblk, FA_RDONLY| FA_HIDDEN| FA_SYSTEM| FA_ARCH);
      for( RB.max= 0L; !done&& ( RB.max< 1000L); )
      {
	 if( ffblk.ff_fsize== 766L)      /* 16 Color-Icon ist 766 Byte gro */
	 {
	    if(( IS.ico_name[ RB.max]= malloc( strlen( ffblk.ff_name)+ 1))!= NULL)
	       strcpy( IS.ico_name[ RB.max++], ffblk.ff_name);
	    else
	    {
	       for( ret_val= 0; ret_val< RB.max; ret_val++)
		  free( IS.ico_name[ ret_val]);
	       RB.max= 0L;
	       ret= ABBRUCH;
	       ret_val= NOT_MEMORY;
	       break;
	    }
	 }
	 done= findnext( &ffblk);
      }
      if( !done)
	 Info_Frage( 250, 250, "Es sind mehr als 1000\nIcon's im Verzeichnis\n vorhanden.\nEs knnen nicht alle\nIcon's dargestellt\nwerden.", INFO);
      if( ret_val== 0)                           /* kein Fehler aufgetreten */
      {
	 qsort( ( void *)IS.ico_name, RB.max, sizeof( char *), ( fcmp)cmps);
	 ICO_Entry( &IS);
	 do
	 {
	    while(( status= __CheckMousepos( &MS))== -1)
	       ;
	    switch( status)
	    {
	       case 0:                                               /* ESC */
	       case 9:                                           /* Abbruch */
		  ret= ABBRUCH;
		  ret_val= 1;
		  break;
	       case 1:                                     /* neuer Suchweg */
		  if( !access( iconsuchwegsp, 0)&& ( _chmod( iconsuchwegsp, 0)& FA_DIREC))
		     Paste_Filter_to_Dir( iconsuchwegsp, "*.ICO");
		  RB.proz= 0L;
		  MS.statsp= REINIT;
		  ret= NOCHMAL;
		  break;
	       case 8:                                        /* Rollbalken */
		  switch( RB.ret_val)
		  {
		     case ONE_ELEMENT_UP:
			ICO_Up_Down( &IS, DOWN);
			break;
		     case ONE_ELEMENT_DOWN:
			ICO_Up_Down( &IS, UP);
			break;
		     case ELEMENT_RANDOM:
			ICO_Entry( &IS);
			break;
		  }
		  break;
	       case 10:                                           /* Return */
		  if( RB.max> 0)
		  {
		     strcpy( strrchr( strcpy( iconsuchweg, iconsuchwegsp), '\\')+ 1, IS.ico_name[ RB.proz+ RB.Zeiger_pos]);
		     ret= ABBRUCH;
		  }
		  break;
	       default:                                  /* direkt geklickt */
		  if(( RB.proz+ status- 2)< RB.max)
		  {
		     strcpy( strrchr( strcpy( iconsuchweg, iconsuchwegsp), '\\')+ 1, IS.ico_name[ RB.proz+ status- 2]);
		     ret= ABBRUCH;
		  }
		  break;
	    }
	 }while( !ret);
	 for( status= 0; status< RB.max; status++)
	    free( IS.ico_name[ status]);
      }
   }while( ret!= ABBRUCH);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   return( ret_val);                            /* 0- OK, -1- ERROR, 1- ESC */
}

static int Search_not_allow_char_in_GRPname( char *string)
{
   char tmp_array[ 60], *char_ptr;

   if(( char_ptr= strpbrk( string, "?*.~ "))!= NULL)
   {
      sprintf( tmp_array, "Zeichen '%c' darf nicht in Gruppennamen verwendet werden", *char_ptr);
      ErrorMsg( tmp_array);
      return( -1);
   }
   else
      return( 0);
}

int Cpy_ICO_mem( void *Ico_ptr, char *file)
{
   int handle, ret_val= -1;

   if(( handle= _open( file, O_RDONLY))!= -1)
   {
      if( lseek( handle, 0x7EL, SEEK_SET)!= -1L)
      {
	 if( _read( handle, Ico_ptr, GRP_MAXICONBYTES)!= -1)
	    ret_val= 0;
      }
      _close( handle);
   }
   if( ret_val== -1)
      ErrorMsg( "Fehler beim Laden des ausgewhlten Icons");
   return( ret_val);
}

void Show_ico( int x, int y, void *Ico_ptr)
{
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   ShowMouse( AUS);
   bar( x, y, x+ 31, y+ 31);
   DrawIcon( x, y, Ico_ptr);
   ShowMouse( AN);
}

BYTE *Exist_Entry( BYTE *tmp_ptr, char *Entry_name, BYTE prg_grp)
{
   while( *( DWORD *)tmp_ptr!= GRP_LASTENTRY)
   {
      if(( *( tmp_ptr+ 8)== prg_grp)&& !strcmp( tmp_ptr+ 10, Entry_name)) /* existiert der Eintrag schon ? */
	 break;
      tmp_ptr+= *( DWORD *)tmp_ptr;          /* folgenden Eintrag auswerten */
   }
   if( *( DWORD *)tmp_ptr!= GRP_LASTENTRY)            /* gltiger Eintrag ? */
      return( tmp_ptr);
   else
      return( NULL);
}

BYTE *Last_Entry( BYTE *tmp_ptr)
{
   while( *( DWORD *)tmp_ptr!= GRP_LASTENTRY)
      tmp_ptr+= *( DWORD *)tmp_ptr;          /* folgenden Eintrag auswerten */
   return( tmp_ptr);
}

int INPUTWindow( char *input, BYTE Window_ID, MAUSStruct *MS)
{
   int ret= 0;
   char input_sp[ 100];
   void *arg_ptr[ 1];

   arg_ptr[ 0]= strcpy( input_sp, input);
   MS->arg_ptr= arg_ptr;
   PCX_Window( MS->x, MS->y, Window_ID, &MS->sa, SHADOW);
   do
   {
      switch( __CheckMousepos( MS))
      {
	 case 2:                                                      /* OK */
	    strcpy( input, input_sp);
	    ret= 1;
	    break;
	 case 0:                                                     /* ESC */
	 case 3:                                                 /* Abbruch */
	    ret= 2;
	    break;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS->sa, *MS->x, *MS->y);
   ShowMouse( AN);
   return( --ret);                                   /* 0= O.K., 1= Abbruch */
}

static int RenameWindow( char *new_name, BYTE grp_prg)
{
   int X= 130, Y= 250;

   WORD mauspos[]= { BUTTON|      FRAME| KEY,              5,  27,   5,  21, ESC,
		     INPUT|       FRAME| KEY| DEFBUTTON,  18,  42, 165, GRP_MAXGRUPPENNAME, 'n',
		     BUTTON|      FRAME| KEY,             17,  97,  65,  90, RETURN,
		     BUTTON|      FRAME| KEY,            104, 184,  65,  90, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 202, 103, 5, INIT, NULL, AUS};

   MS.x= &X;
   MS.y= &Y;
   MS.mauspos= mauspos;
   return( INPUTWindow( new_name, ( grp_prg== GRP_GRUPPE) ? ( PCX_GRUPPE_UMNENNEN) : ( PCX_PROGRAMM_UMNENNEN), &MS));
}

void *ptr_to_GRP( GRP_struct *, int *, BOOL);
void *open_resource_ICO( BYTE);

void Write_DG2( GRP_struct *GRP, BYTE *GRP_ptr, BOOL *ini_aenderung)
{
   if( *ini_aenderung)
   {
      if( autosort== AN)
      {
	 einmalig_GRP_PRG_reihenfolge= GRP_PRG_reihenfolge;
	 GRP_ptr= Sort_GRPinhalt( GRP_ptr, GRP->mem_len);
      }
      if( GRP_ptr!= NULL)                     /* kein Fehler beim Sortieren */
      {
	 if(( lseek( GRP->File_handle, sizeof( GRP_DATEIID)- 1, SEEK_SET)!= -1L)&& ( _write( GRP->File_handle, &GRP->RB->max, sizeof( WORD))!= -1)&& ( lseek( GRP->File_handle, GRP->seek_pos, SEEK_SET)!= -1L)&& ( _write( GRP->File_handle, GRP_ptr, GRP->mem_len)!= -1)&& ( chsize( GRP->File_handle, GRP->mem_len+ GRP->seek_pos)!= -1)) /* Anzahl und Inhalt der Eintrge aktualisieren */
	 {
	    if( GRP->XMS_handle> 0)
	    {
	       XMSFreeMem( GRP->XMS_handle);
	       if(( GRP->XMS_handle= XMSGetMem( ( GRP->mem_len+ 1023L)>> 10))!= 0)
		  XMSCopy( 0, ( DWORD)(( void far *)GRP_ptr), GRP->XMS_handle, 0L, ( GRP->mem_len+ 1)>> 1);
	    }
	 }
	 else
	 {
	    *ini_aenderung= 0;
	    ErrorMsg( WRITE_ERROR"Gruppendatei");
	    Info_Frage( 100, 200, "Gruppendatei konnte\nnicht vollstndig ge-\nschrieben werden !\nEventuell ist sie\nzerstrt !", INFO);
	 }
      }
   }
   if( GRP_ptr!= NULL)
      free( GRP_ptr);
}

BYTE *_Add_PRG( GRP_struct *GRP, BYTE *GRP_ptr, char *programmname, char *programmsuchweg, char *dateienpfad, BYTE *Icon_daten, char *parameter, BOOL parameterfenster, BOOL *ini_aenderung, int *ret_val)
{
   long new_mem_len;
   WORD new_len;
   BOOL Aufnehmen= 0;
   BYTE *tmp_ptr, *ptr, prgnamelen, prgpathlen, workdirlen, paralen;

   if( access( programmsuchweg, 0))
   {
      ErrorMsg( "Der Suchweg der Programmdatei ist falsch");
   }
   else
   {
      if( access( dateienpfad, 0)&& strcmp( dateienpfad, GRP_DEFAULTDIR))  /* aktuelles Verzeichnis beim Start */
      {
	 ErrorMsg( "Das Arbeitsverzeichnis existiert nicht");
      }
      else
      {
	 prgnamelen= ( strlen( programmname)+ 1);
	 prgpathlen= ( strlen( programmsuchweg)+ 1);
	 workdirlen= ( strlen( dateienpfad)+ 1);
	 paralen=    ( strlen( parameter)+ 1);
	 new_len= 16+ prgnamelen+ GRP_MAXICONBYTES+ prgpathlen+ workdirlen+ paralen;
	 if(( tmp_ptr= Exist_Entry( GRP_ptr, programmname, GRP_PROGRAMM))!= NULL) /* existiert das Programm schon ? */
	 {
	    if( !Info_Frage( 110, 200, "Das Programm existiert\nbereits. Soll es die\nneuen Daten erhalten ?", FRAGE))
	    {
	       if((( new_mem_len= GRP->mem_len+ ( new_len- *( DWORD *)tmp_ptr))+ GRP->seek_pos)<= GRP_MAXFILELENGTH)
	       {
		  if(( GRP_ptr= realloc( GRP_ptr, new_mem_len))!= NULL)
		  {
		     tmp_ptr= Exist_Entry( GRP_ptr, programmname, GRP_PROGRAMM); /* nochmal aufrufen, da sich die Adresse von GRP_ptr gendert haben knnte */
		     memmove( tmp_ptr+ new_len, tmp_ptr+ *( DWORD *)tmp_ptr, GRP->mem_len- (( tmp_ptr+ *( DWORD *)tmp_ptr)- GRP_ptr));
		     GRP->mem_len= new_mem_len;
		     *( DWORD *)tmp_ptr+= ( tmp_ptr+ new_len)- ( tmp_ptr+ *( DWORD *)tmp_ptr);
		     Aufnehmen= 1;
		  }
		  else
		  {
		     ErrorMsg( KEIN_SPEICHER);
		     *ret_val= ABBRUCH;
		  }
	       }
	       else
		  ErrorMsg( "Gruppendatei hat ihre max. Lnge erreicht");
	    }
	 }
	 else
	 {
	    if((( new_mem_len= GRP->mem_len+ new_len)+ GRP->seek_pos)<= GRP_MAXFILELENGTH)
	    {
	       if(( GRP_ptr= realloc( GRP_ptr, new_mem_len))!= NULL)
	       {
		  GRP->mem_len= new_mem_len;
		  GRP->RB->max++;
		  tmp_ptr= Last_Entry( GRP_ptr); /* nochmal aufrufen, da sich die Adresse von GRP_ptr gendert haben knnte */
		  *( DWORD *)( tmp_ptr+ new_len)= GRP_LASTENTRY;
		  *( DWORD *)tmp_ptr= ( DWORD)new_len;
		  Aufnehmen= 1;
	       }
	       else
	       {
		  ErrorMsg( KEIN_SPEICHER);
		  *ret_val= ABBRUCH;
	       }
	    }
	    else
	       ErrorMsg( "Gruppendatei hat ihre max. Lnge erreicht");
	 }
	 if( Aufnehmen)
	 {
	    *( DWORD *)( tmp_ptr+ 4)= 0;
	    *( BYTE *)( tmp_ptr+ 8)= GRP_PROGRAMM;
	    *( BYTE *)( tmp_ptr+ 9)= prgnamelen;
	    memcpy( tmp_ptr+ 10, programmname, prgnamelen);
	    *( BOOL *)( ptr= ( tmp_ptr+ 10+ prgnamelen))= parameterfenster;
	    *( WORD *)( ++ptr)= GRP_MAXICONBYTES;
	    *( BYTE *)( ptr+= 2)= prgpathlen;
	    *( BYTE *)( ++ptr)= workdirlen;
	    *( BYTE *)( ++ptr)= paralen;
	    memcpy( ++ptr, Icon_daten, GRP_MAXICONBYTES);
	    memcpy( ptr+= GRP_MAXICONBYTES, programmsuchweg, prgpathlen);
	    memcpy( ptr+= prgpathlen, dateienpfad, workdirlen);
	    memcpy( ptr+= workdirlen, parameter, paralen);
	    *ini_aenderung= 1;
	 }
      }
   }
   return( GRP_ptr);
}

void Check_GRPanzeige( GRP_struct *GRP)
{
   if(( GRP->RB->proz+ GRP->RB->maxstep)> GRP->RB->max)
   {
      if(( GRP->RB->proz= GRP->RB->max- GRP->RB->maxstep)< 0)
      {
	 GRP->RB->proz= 0;
	 if((((( GRP->balkenx+ ICONABSTANDX- MARKX)/ ICONABSTANDX)+ ((( GRP->balkeny- GRP->ymerk)/ ICONABSTANDY)<< 2))- 1)>= GRP->RB->max)
	    Mark_of_pos( GRP, 0);
      }
      GRP->MS->statsp= REINIT;
   }
}

BOOL MakeIni( GRP_struct *GRP)
{
   int i, status, ret= 0, handle, filebox_x= 200, filebox_y= 80, dirtree_x= 250;
   long new_mem_len;
   WORD Anz_Icons;
   BYTE *GRP_ptr, *tmp_ptr, *ptr, Icon_daten[ GRP_MAXICONBYTES], prgnamelen,
	newprgnamelen;
   BOOL parameterfenster, ini_aenderung= 0;
   char programmname[ GRP_MAXGRUPPENNAME]= "", programmsuchweg[ MAXPATH],
	dateienpfad[ MAXDIR], parameter[ GRP_MAXPARAMETER], iconsuchweg[ MAXPATH],
	newprogrammname[ GRP_MAXGRUPPENNAME];
   void *arg_ptr[ 12];
   char *msg[]= { "Ein neues Icon auswhlen",
		  "Dateiauswahlbox steht zur Verfgung",
		  "Verzeichnisbaum (Pfad) steht zur Verfgung",
		  "Dateiauswahlbox steht zur Verfgung" };
   WORD mauspos[]= { BUTTON|    FRAME| KEY,                   5,  27,   5,  21, ESC,
		     INPUT|     FRAME| KEY| DEFBUTTON,       18,  42, 165, GRP_MAXGRUPPENNAME- 1, 'n',
		     BUTTON|    FRAME| KEY|            MSG, 266, 312,  30,  64, 'i',
		     FILEINPUT| IGN_CASE| FRAME| KEY|            MSG,  18,  77, 240, MAXPATH- 1, 266,  68, DEFAULT,   's',
		     DIRINPUT| IGN_CASE|  FRAME| KEY|            MSG,  18, 112, 240, MAXDIR-  1, 266, 106, LWAUSWAHL, 'b',
		     FILEINPUT| FRAME| KEY|            MSG,  18, 147, 289, GRP_MAXPARAMETER- 1, 266,  68, DEFAULT, 'f',
		     CHECKBOX|  FRAME| KEY,                  19, 175, 'r',
		     BUTTON|    FRAME| KEY,                  18,  84, 215, 265, 'h',
		     BUTTON|    FRAME| KEY,                  93, 159, 215, 265, 'e',
		     BUTTON|    FRAME| KEY,                 167, 233, 215, 265, 'u',
		     BUTTON|    FRAME| KEY,                 241, 307, 215, 265, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 326, 281, 12, INIT, NULL, AN};

   Paste_Filter_to_Dir( strcpy( iconsuchweg, default_icon_path), "*.ICO");
   arg_ptr[  0]= programmname;
   arg_ptr[  1]= programmsuchweg;
   arg_ptr[  2]= &filebox_x;
   arg_ptr[  3]= &filebox_y;
   arg_ptr[  4]= "*.EXE;*.COM;*.BAT";
   arg_ptr[  5]= dateienpfad;
   arg_ptr[  6]= &dirtree_x;
   arg_ptr[  7]= parameter;
   arg_ptr[  8]= &filebox_x;
   arg_ptr[  9]= &filebox_y;
   ( char *)arg_ptr[ 10]= "*.*";
   arg_ptr[  11]= &parameterfenster;
   MS.x= &makeinix;
   MS.y= &makeiniy;
   MS.msg= msg;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_PROGRAMMINSTALLATION, &MS.sa, SHADOW);
   tmp_ptr= GRP_ptr= ptr_to_GRP( GRP, &ret, NO_CHECK);
   if( !ret)
   {
      if( GRP->RB->max> 0L)
      {
	 for( i= 0; i< ( GRP->RB->proz+ Mark_of_Entry( GRP)); i++)
	    tmp_ptr+= *( DWORD *)tmp_ptr;           /* einen Eintrag weiter */
	 if( *( tmp_ptr+ 8)== GRP_PROGRAMM)
	    strcpy( programmname, tmp_ptr+ 10);
	 else
	    tmp_ptr= GRP_ptr;
      }
      do
      {
	 ret= 0;
	 if(( tmp_ptr= Exist_Entry( tmp_ptr, programmname, GRP_PROGRAMM))!= NULL)
	 {
	    memcpy( Icon_daten,      ptr= tmp_ptr+ 16+ *( tmp_ptr+ 9), GRP_MAXICONBYTES);
	    strcpy( programmsuchweg, ptr+= *( WORD *)( tmp_ptr+ 11+ *( tmp_ptr+ 9)));
	    strcpy( dateienpfad,     ptr+= *( tmp_ptr+ 13+ *( tmp_ptr+ 9)));
	    strcpy( parameter,       ptr+= *( tmp_ptr+ 14+ *( tmp_ptr+ 9)));
	    parameterfenster= *( tmp_ptr+ 10+ *( tmp_ptr+ 9));
	 }
	 else
	 {
	    tmp_ptr= GRP_ptr;
	    if(( ptr= open_resource_ICO( ICO_FR))!= NULL)
	    {
	       memcpy( Icon_daten, ptr, GRP_MAXICONBYTES);
	       close_resource_ICO( ptr);
	    }
	    else
	    {
	       memset( Icon_daten, 0, 512);      /* vollstndig transparentes Icon */
	       memset( Icon_daten+ 512, 0xFF, 128);
	    }
	    *programmsuchweg= '\0';
	    *dateienpfad=     '\0';
	    *parameter=       '\0';
	    parameterfenster= GRP_NOPARAWIN;
	 }
	 Show_ico( *MS.x+ 207, *MS.y+ 34, Icon_daten);
	 do
	 {
	    switch( __CheckMousepos( &MS))
	    {
	       case 0:                                               /* ESC */
	       case 10:                                          /* Abbruch */
		  ret= ABBRUCH;
		  break;
	       case 1:
		  MS.statsp= REINIT;                        /* Programmname */
		  ret= NOCHMAL;
		  break;
	       case 2:                                              /* Icon */
		  status= 0;
		  if( Is_Window_EXE( programmsuchweg)>= 0x0300)  /* min. WINDOWS 3.x Programm ? */
		  {
		     if( !( status= Info_Frage( 50, 150, "Die Icons der WINDOWS-\nProgrammdatei extra-\nhieren und nutzen ?", FRAGE)))
		     {
			Anz_Icons= 0;
			if( !WinEXEIcons( programmsuchweg, iconsuchweg, &Anz_Icons)&& ( Anz_Icons> 0))
			{
			   ptr= strrchr( iconsuchweg, '.'); /* iconsuchweg enthlt Dateinamen der Form: EXE???.ICO, !!! stark abhngig von WinEXEIcons() !!! */
			   memmove( ptr- 2, ptr, strlen( ptr)+ 1);
			   *( ptr- 3)= '*';
			}
			else
			   Hinweis( "kein 16-Farben-Icon gefunden");
		     }
		  }
		  if( status!= 2)                             /* Abbruch */
		  {
		     if( !IconAuswahl( iconsuchweg))
		     {
			Cpy_ICO_mem( Icon_daten, iconsuchweg);
			Show_ico( *MS.x+ 207, *MS.y+ 34, Icon_daten);
		     }
		  }
		  break;
	       case 3:                                   /* Programmsuchweg */
		  if( *dateienpfad== '\0')
		  {
		     *( strncpy( dateienpfad, programmsuchweg, MAXDIR- 1)+ MAXDIR- 1)= '\0';
		     *strrchr( dateienpfad, '\\')= '\0';
		     if( *( dateienpfad+ 2)== '\0')
			strcat( dateienpfad, "\\");
		     MS.statsp= REINIT;
		  }
		  break;
	       case 7:                                         /* Aufnehmen */
		  GRP_ptr= _Add_PRG( GRP, GRP_ptr, programmname, programmsuchweg, dateienpfad, Icon_daten, parameter, parameterfenster, &ini_aenderung, &ret);
		  break;
	       case 8:                                         /* Entfernen */
		  if(( tmp_ptr= Exist_Entry( GRP_ptr, programmname, GRP_PROGRAMM))== NULL) /* existiert das Programm berhaupt ? */
		  {
		     ErrorMsg( "Das Programm existiert in der momentan aktiven Gruppe nicht");
		  }
		  else
		  {
		     GRP->RB->max--;
		     new_mem_len= GRP->mem_len- *( DWORD *)tmp_ptr;
		     memmove( tmp_ptr, tmp_ptr+ *( DWORD *)tmp_ptr, GRP->mem_len- (( tmp_ptr+ *( DWORD *)tmp_ptr)- GRP_ptr));
		     GRP->mem_len= new_mem_len;
		     GRP_ptr= realloc( GRP_ptr, GRP->mem_len);  /* berflssigen Speicher freigeben */
		     ini_aenderung= 1;
		  }
		  break;
	       case 9:                                          /* Umnennen */
		  strcpy( newprogrammname, programmname);
		  if( !RenameWindow( newprogrammname, GRP_PROGRAMM))
		  {
		     if( *newprogrammname!= '\0')    /* Wurde etwas eingegeben ? */
		     {
			if( Exist_Entry( GRP_ptr, newprogrammname, GRP_PROGRAMM)== NULL) /* existiert der neue Programmname noch nicht ? */
			{
			   if(( tmp_ptr= Exist_Entry( GRP_ptr, programmname, GRP_PROGRAMM))!= NULL) /* existiert das umzunennende Programm berhaupt ? */
			   {
			      newprgnamelen= strlen( newprogrammname)+ 1;
			      prgnamelen= strlen( tmp_ptr+ 10)+ 1;
			      if((( new_mem_len= GRP->mem_len+ ( newprgnamelen- prgnamelen))+ GRP->seek_pos)<= GRP_MAXFILELENGTH)
			      {
				 if(( GRP_ptr= realloc( GRP_ptr, new_mem_len))!= NULL)
				 {
				    tmp_ptr= Exist_Entry( GRP_ptr, programmname, GRP_PROGRAMM); /* nochmal aufrufen, da sich die Adresse von GRP_ptr gendert haben knnte */
				    memmove( tmp_ptr+ 10+ *( BYTE *)( tmp_ptr+ 9)+ ( newprgnamelen- prgnamelen), tmp_ptr+ 10+ *( BYTE *)( tmp_ptr+ 9), GRP->mem_len- (( tmp_ptr+ 10+ *( BYTE *)( tmp_ptr+ 9))- GRP_ptr));
				    GRP->mem_len= new_mem_len;
				    *( DWORD *)tmp_ptr+= ( newprgnamelen- prgnamelen);
				    *( BYTE *)( tmp_ptr+ 9)= newprgnamelen;
				    memcpy( tmp_ptr+ 10, newprogrammname, newprgnamelen);
				    strcpy( programmname, newprogrammname);
				    ini_aenderung= 1;
				    MS.statsp= REINIT;
				    ret= NOCHMAL;
				 }
				 else
				 {
				    ErrorMsg( KEIN_SPEICHER);
				    ret= ABBRUCH;
				 }
			      }
			      else
				 ErrorMsg( "Gruppendatei hat ihre max. Lnge erreicht");
			   }
			   else
			      ErrorMsg( "Das Programm existiert in der momentan aktiven Gruppe nicht");
			}
			else
			   ErrorMsg( "Der Programmname existiert bereits in dieser Gruppe");
		     }
		     else
			ErrorMsg( "Es mu ein Name eingegeben werden");
		  }
		  break;
	    }
	 }while( !ret);
	 tmp_ptr= GRP_ptr;
      }while( ret!= ABBRUCH);
      Write_DG2( GRP, GRP_ptr, &ini_aenderung);
   }
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   return( ini_aenderung== 1);                          /* TRUE -> nderung */
}

int Info_Frage( int x, int y, char *Msg, char Mode)  /* 22 Zeichen/Zeile */
{
   int status, iy, anzzeilen= 0;
   char color, *Msg_dup, *Msg_ptr;
   void *old_maus_cursor= last_maus_cursor;
   WORD mauspos_frage[]= { BUTTON| FRAME| KEY,              5,  27,   5,  21, ESC,
			   BUTTON| FRAME| KEY,             16,  90, 115, 157, 'j',
			   BUTTON| FRAME| KEY| DEFBUTTON, 101, 175, 115, 157, 'a',
			   BUTTON| FRAME| KEY,            186, 260, 115, 157, 'n',
			   MOVEWINDOW };
   WORD mauspos_info[]= { BUTTON| FRAME| KEY,              5,  27,   5,  21, ESC,
			  BUTTON| FRAME| KEY| DEFBUTTON,  54, 222, 114, 139, RETURN,
			  MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 278, DEFAULT, DEFAULT, INIT, NULL, AUS};

   MS.x= &x;
   MS.y= &y;
   if( Mode== FRAGE)
   {
      MS.mauspos= mauspos_frage;
      MS.ylength= 172;
      MS.spotanz= 5;
   }
   else
   {
      MS.mauspos= mauspos_info;
      MS.ylength= 150;
      MS.spotanz= 3;
   }
   if(( Msg_ptr= Msg_dup= strdup( Msg))== NULL)
   {
      ErrorMsg( KEIN_SPEICHER);
      return( -1);
   }
   else
   {
      color= getcolor();
      ShowMouse( AUS);
      PCX_Window( MS.x, MS.y, ( Mode== FRAGE) ? PCX_FRAGE : PCX_INFO, &MS.sa, SHADOW);
      while(( Msg_ptr= strchr( Msg_ptr, '\n'))!= NULL)
      {
	 Msg_ptr++;
	 anzzeilen++;
      }
      anzzeilen++;
      Msg_ptr= strtok( Msg_dup, "\n");
      for( iy= *MS.y+ 30+ ((( double)( 6- anzzeilen)/ ( double)2.0)* 12); ( iy< ( *MS.y+ 95))&& Msg_ptr; iy+= 12)
      {
	 OutTextN( *MS.x+ 80, iy, Msg_ptr, 22);
	 Msg_ptr= strtok( NULL, "\n");
      }
      ShowMouse( AN);
      free( Msg_dup);
      MouseArt( maus_pfeil);
      while(( status= __CheckMousepos( &MS))== -1)
	 ;
      MouseArt( old_maus_cursor);
      ShowMouse( AUS);
      BigScreenRestore( &MS.sa, *MS.x, *MS.y);
      ShowMouse( AN);
      setcolor( color);
      switch( status)
      {
	 case 1:                                                  /* Ja, OK */
	    return( 0);
	 case 3:                                                    /* Nein */
	    return( 1);
	 default:                                           /* ESC, Abbruch */
	    return( 2);
      }
   }
}

void Erase_Rename_GRP( char *gruppendir, char *gruppenname, char *new_gruppenname, BYTE del_ren)
{
   struct ffblk ffblk;
   int done, handle, i;
   BOOL grp_work;
   char ges_gruppe[ GRP_MAXGRUPPENDIR], newfile[ MAXPATH];
   BYTE *mem_ptr, *tmp_ptr, *ptr, grpname_len, newgrpname_len;

   if( del_ren== ERASE)
      PrintStatus( "Die dazugehrigen Gruppen werden gelscht ...");
   else
      PrintStatus( "Die dazugehrigen Gruppen werden umbenannt ...");
   if( *gruppendir!= HGRP_ID)
      strcat( strcat( strcpy( ges_gruppe, gruppendir), "\\"), gruppenname);
   else
      strcpy( ges_gruppe, gruppenname);
   strcpy( prgexe_ptr, "*.DG2");
   done= findfirst( prgexe_path, &ffblk, FA_NORMAL);
   while( !done)
   {
      grp_work= 0;
      strcpy( prgexe_ptr, ffblk.ff_name);
      if(( handle= _open( prgexe_path, O_RDWR))!= -1)
      {
	 if(( mem_ptr= malloc( 13+ GRP_MAXGRUPPENDIR+ GRP_MAXGRUPPENNAME))!= NULL)
	 {
	    if( _read( handle, mem_ptr, 13+ GRP_MAXGRUPPENDIR+ GRP_MAXGRUPPENNAME)!= -1)
	    {
	       if( !strncmp( mem_ptr, GRP_DATEIID, sizeof( GRP_DATEIID)- 1))
	       {
		  if( del_ren== ERASE_ALL)
		     grp_work= 1;
		  else
		  {
		     if( strstr( mem_ptr+ 13, ges_gruppe)== mem_ptr+ 13)
		     {
			if( del_ren== RENAME)
			{
			   if( lseek( handle, sizeof( GRP_DATEIID)- 1+ sizeof( WORD), SEEK_SET)!= -1)
			   {
			      tmp_ptr= mem_ptr+ 13+ strlen( ges_gruppe);
			      memmove( tmp_ptr+ (( newgrpname_len= strlen( new_gruppenname))- ( grpname_len= strlen( gruppenname))), tmp_ptr, strlen( tmp_ptr));
			      memcpy( tmp_ptr- grpname_len, new_gruppenname, newgrpname_len);
			      if( _write( handle, mem_ptr+ 13, strlen( mem_ptr+ 13))== -1)
				 ErrorMsg( WRITE_ERROR"Gruppendatei");
			   }
			   else
			      ErrorMsg( READ_ERROR"Gruppendatei");
			}
			else
			   grp_work= 1;
		     }
		     else
		     {
			if( !strcmp( mem_ptr+ 13, gruppendir)&& !strcmp( mem_ptr+ 13+ GRP_MAXGRUPPENDIR, gruppenname))
			{
			   if( del_ren== RENAME)
			   {
			      if( lseek( handle, ( long)( sizeof( GRP_DATEIID)- 1+ sizeof( WORD)+ GRP_MAXGRUPPENDIR), SEEK_SET)!= -1)
			      {
				 if( _write( handle, new_gruppenname, strlen( new_gruppenname)+ 1)== -1)
				    ErrorMsg( WRITE_ERROR"Gruppendatei");
			      }
			   }
			   grp_work= 1;
			}
		     }
		  }
	       }
	    }
	    else
	       ErrorMsg( READ_ERROR"Gruppendatei");
	    free( mem_ptr);
	 }
	 else
	 {
	    _close( handle);
	    ErrorMsg( KEIN_SPEICHER);
	    break;
	 }
	 _close( handle);
	 if( grp_work)
	 {
	    if( del_ren== RENAME)
	    {
	       *( strncpy( tmp_ptr= ( strcpy( newfile, prgexe_path)+ ( prgexe_ptr- prgexe_path)), new_gruppenname, 6)+ 6)= '\0';
	       ptr= strchr( tmp_ptr, '\0');
	       for( i= 0; i<= 99; i++)
	       {
		  sprintf( ptr, "%.2d.DG2", i);
		  if( access( newfile, 0))
		     break;
	       }
	       if(( i> 99)|| rename( prgexe_path, newfile))
		  ErrorMsg( "Konnte die dazugehrige Gruppendatei nicht umbenennen");
	    }
	    else
	    {
	       if( unlink( prgexe_path))
		  ErrorMsg( "Konnte die dazugehrige Gruppendatei nicht lschen");
	    }
	 }
      }
      else
	 ErrorMsg( OPEN_ERROR"Gruppendatei");
      done= findnext( &ffblk);
   }
   ClearStatus();
}

void EraseAllGRP( void)
{
   Erase_Rename_GRP( "", "", NULL, ERASE_ALL);
}

BYTE *__CreatGRP( GRP_struct *GRP, BYTE *GRP_ptr, char *gruppenname, BYTE *Icondata, BOOL *ini_aenderung, int *ret_val)
{
   DWORD lastentry= GRP_LASTENTRY;
   long new_mem_len;
   WORD Anz_Entrys= 0, new_len;
   ptrdiff_t ptrDelta;
   int handle, i;
   BOOL newFullIcon, isIcon;
   BYTE *tmp_ptr, grpname_len;
   char *ptr;

   if((( strlen( GRP->gruppendir)+ 1)+ GRP_MAXGRUPPENNAME)> GRP_MAXGRUPPENDIR)
      ErrorMsg( "max. Lnge der Fensterhierarchie wrde berschritten werden");
   else
   {
      if( !Search_not_allow_char_in_GRPname( gruppenname)) /* unzulssiges Zeichen im Namen ? */
      {
	 newFullIcon= (( Icondata!= NULL)&& ( memcmp( Icondata, GRP_ICO_ptr, GRP_MAXICONBYTES)!= 0));
	 grpname_len= strlen( gruppenname)+ 1;
	 if(( tmp_ptr= Exist_Entry( GRP_ptr, gruppenname, GRP_GRUPPE))== NULL)
	 {
	    new_len= 10+ grpname_len+ ( newFullIcon ? GRP_MAXICONBYTES : 0);
	    if((( new_mem_len= GRP->mem_len+ new_len)+ GRP->seek_pos)<= GRP_MAXFILELENGTH)
	    {
	       *( strncpy( prgexe_ptr, gruppenname, 6)+ 6)= '\0';
	       ptr= strchr( prgexe_ptr, '\0');
	       for( i= 0; i<= 99; i++)
	       {
		  sprintf( ptr, "%.2d.DG2", i);
		  if( access( prgexe_path, 0))
		     break;
	       }
	       if( i<= 99)
	       {
		  if(( handle= _creat( prgexe_path, FA_NORMAL))!= -1)
		  {
		     if(( _write( handle, GRP_DATEIID, sizeof( GRP_DATEIID)- 1)!= -1)&& ( _write( handle, &Anz_Entrys, sizeof( WORD))!= -1)&& ( _write( handle, GRP->gruppendir, GRP_MAXGRUPPENDIR)!= -1)&& ( _write( handle, gruppenname, GRP_MAXGRUPPENNAME)!= -1)&& ( _write( handle, &lastentry, sizeof( DWORD))!= -1))
		     {
			if(( GRP_ptr= realloc( GRP_ptr, new_mem_len))!= NULL)
			{
			   GRP->mem_len= new_mem_len;
			   GRP->RB->max++;
			   tmp_ptr= Last_Entry( GRP_ptr); /* nochmal aufrufen, da sich die Adresse von GRP_ptr gendert haben knnte */
			   *( DWORD *)( tmp_ptr+ new_len)= GRP_LASTENTRY;
			   *( DWORD *)tmp_ptr= ( DWORD)new_len;
			   if( newFullIcon)
			   {
			      *( DWORD *)( tmp_ptr+ 4)= GRP_ICONMASK;
			      memcpy( tmp_ptr+ 10+ grpname_len, Icondata, GRP_MAXICONBYTES);
			   }
			   else
			      *( DWORD *)( tmp_ptr+ 4)= 0;
			   *( BYTE *)( tmp_ptr+ 8)= GRP_GRUPPE;
			   *( BYTE *)( tmp_ptr+ 9)= grpname_len;
			   memcpy( tmp_ptr+ 10, gruppenname, grpname_len);
			   *ini_aenderung= 1;
			}
			else
			{
			   ErrorMsg( KEIN_SPEICHER);
			   *ret_val= ABBRUCH;
			}
		     }
		     else
			ErrorMsg( WRITE_ERROR"Gruppendatei");
		     _close( handle);
		  }
		  else
		     ErrorMsg( CREAT_ERROR"Gruppendatei");
	       }
	       else
		  Info_Frage( 250, 250, "Es existieren zu viele\nGruppen deren ersten 6\nBuchstaben gleich sind\nWhlen Sie einen\nanderen Namen.", INFO);
	    }
	    else
	       ErrorMsg( "Gruppendatei hat ihre max. Lnge erreicht");
	 }
	 else
	 {
	    isIcon= (( *( DWORD *)( tmp_ptr+ 4)& GRP_ICONMASK)!= 0);

	    if(( !isIcon&& newFullIcon)&& (( GRP->mem_len+ GRP_MAXICONBYTES+ GRP->seek_pos)> GRP_MAXFILELENGTH))
	       ErrorMsg( "Gruppendatei hat ihre max. Lnge erreicht");
	    else
	    {
	       if( !Info_Frage( 110, 200, "Die Gruppe existiert\nbereits. Soll sie die\nneuen Daten erhalten ?", FRAGE))
	       {
		  if( isIcon&& newFullIcon)               /* nur Icon tauschen */
		  {
		     memcpy( tmp_ptr+ 10+ grpname_len, Icondata, GRP_MAXICONBYTES);
		     *ini_aenderung= 1;
		  }

		  if( isIcon&& !newFullIcon)   /* Icon gegen Standardicon tauschen */
		  {
		     memmove( tmp_ptr+ 10+ grpname_len, tmp_ptr+ *( DWORD *)tmp_ptr, GRP->mem_len- (( tmp_ptr+ *( DWORD *)tmp_ptr)- GRP_ptr));
		     *( DWORD *)tmp_ptr-= GRP_MAXICONBYTES;
		     *( DWORD *)( tmp_ptr+ 4)&= ~GRP_ICONMASK;
		     GRP->mem_len-= GRP_MAXICONBYTES;
		     GRP_ptr= realloc( GRP_ptr, GRP->mem_len);
		     *ini_aenderung= 1;
		  }

		  if( !isIcon&& newFullIcon)          /* Standardicon ersetzen */
		  {
		     ptrDelta= tmp_ptr- GRP_ptr;
		     if(( GRP_ptr= realloc( GRP_ptr, GRP->mem_len+ GRP_MAXICONBYTES))!= NULL)
		     {
			tmp_ptr= GRP_ptr+ ptrDelta;
			memmove( tmp_ptr+ *( DWORD *)tmp_ptr+ GRP_MAXICONBYTES, tmp_ptr+ *( DWORD *)tmp_ptr, GRP->mem_len- (( tmp_ptr+ *( DWORD *)tmp_ptr)- GRP_ptr));
			*( DWORD *)tmp_ptr+= GRP_MAXICONBYTES;
			*( DWORD *)( tmp_ptr+ 4)|= GRP_ICONMASK;
			memcpy( tmp_ptr+ 10+ grpname_len, Icondata, GRP_MAXICONBYTES);
			GRP->mem_len+= GRP_MAXICONBYTES;
			*ini_aenderung= 1;
		     }
		     else
		     {
			ErrorMsg( KEIN_SPEICHER);
			*ret_val= ABBRUCH;
		     }
		  }
	       }
	    }
	 }
      }
   }
   return( GRP_ptr);
}

BOOL Gruppe( GRP_struct *GRP)
{
   int ret= 0, i;
   BYTE *GRP_ptr, *tmp_ptr, grpname_len, newgrpname_len, Icon_daten[ GRP_MAXICONBYTES];
   BOOL ini_aenderung= 0, isIcon= FALSE;
   char gruppenname[ GRP_MAXGRUPPENNAME]= "", new_gruppenname[ GRP_MAXGRUPPENNAME],
	iconsuchweg[ MAXPATH];
   long new_mem_len;
   void *arg_ptr[ 1];
   char *msg[]= { "Ein neues Icon auswhlen",
		  "Standardicon bernehmen (spart 640 Byte)" };
   WORD mauspos[]= { BUTTON|    FRAME| KEY,                   5,  27,   5,  21, ESC,
		     INPUT|     FRAME| KEY| DEFBUTTON,       17,  42, 165, GRP_MAXGRUPPENNAME- 1, 'g',
		     BUTTON|    FRAME| KEY|            MSG, 245, 291,  34,  68, 'i',
		     BUTTON|    FRAME| KEY|            MSG, 299, 328,  34,  68, 's',
		     BUTTON|    FRAME| KEY,                  17,  85,  86, 136, 'f',
		     BUTTON|    FRAME| KEY,                  98, 166,  86, 136, 'e',
		     BUTTON|    FRAME| KEY,                 179, 247,  86, 136, 'u',
		     BUTTON|    FRAME| KEY,                 260, 328,  86, 136, 'a',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 346, 151, 9, INIT, NULL, AN};

   Paste_Filter_to_Dir( strcpy( iconsuchweg, default_icon_path), "*.ICO");
   arg_ptr[ 0]= gruppenname;
   MS.x= &grux;
   MS.y= &gruy;
   MS.msg= msg;
   MS.mauspos= mauspos;
   MS.arg_ptr= arg_ptr;
   PCX_Window( MS.x, MS.y, PCX_GRUPPENINSTALLATION, &MS.sa, SHADOW);
   tmp_ptr= GRP_ptr= ptr_to_GRP( GRP, &ret, NO_CHECK);
   if( !ret)
   {
      if( GRP->RB->max> 0L)
      {
	 for( i= 0; i< ( GRP->RB->proz+ Mark_of_Entry( GRP)); i++)
	    tmp_ptr+= *( DWORD *)tmp_ptr;           /* einen Eintrag weiter */
	 if( *( tmp_ptr+ 8)== GRP_GRUPPE)
	 {
	    strcpy( gruppenname, tmp_ptr+ 10);
	    isIcon= ( *( DWORD *)( tmp_ptr+ 4)& GRP_ICONMASK)!= 0;
	 }
	 else
	    tmp_ptr= GRP_ptr;
      }
      if( isIcon)
	 memcpy( Icon_daten, tmp_ptr+ 10+ *( tmp_ptr+ 9), GRP_MAXICONBYTES);
      else
	 memcpy( Icon_daten, GRP_ICO_ptr, GRP_MAXICONBYTES);
      Show_ico( *MS.x+ 199, *MS.y+ 35, Icon_daten);
      do
      {
	 switch( __CheckMousepos( &MS))
	 {
	    case 0:                                                  /* ESC */
	    case 7:                                              /* Abbruch */
	       ret= 1;
	       break;
	    case 2:                                        /* Icon wechseln */
	       if( !IconAuswahl( iconsuchweg))
	       {
		  Cpy_ICO_mem( Icon_daten, iconsuchweg);
		  Show_ico( *MS.x+ 199, *MS.y+ 35, Icon_daten);
	       }
	       break;
	    case 3:
	       memcpy( Icon_daten, GRP_ICO_ptr, GRP_MAXICONBYTES);
	       Show_ico( *MS.x+ 199, *MS.y+ 35, Icon_daten);
	       break;
	    case 4:                                     /* Gruppe aufnehmen */
	       GRP_ptr= __CreatGRP( GRP, GRP_ptr, gruppenname, Icon_daten, &ini_aenderung, &ret);
	       break;
	    case 5:                                     /* Gruppe entfernen */
	       if(( tmp_ptr= Exist_Entry( GRP_ptr, gruppenname, GRP_GRUPPE))== NULL) /* existiert die Gruppe berhaupt ? */
	       {
		  ErrorMsg( "Die Gruppe existiert in der momentan aktiven Gruppe nicht");
	       }
	       else
	       {
		  if( !Info_Frage( 110, 200, "Wollen Sie die Gruppe\nwirklich lschen ?", FRAGE))
		  {
		     GRP->RB->max--;
		     new_mem_len= GRP->mem_len- *( DWORD *)tmp_ptr;
		     memmove( tmp_ptr, tmp_ptr+ *( DWORD *)tmp_ptr, GRP->mem_len- (( tmp_ptr+ *( DWORD *)tmp_ptr)- GRP_ptr));
		     GRP->mem_len= new_mem_len;
		     GRP_ptr= realloc( GRP_ptr, GRP->mem_len);  /* berflssigen Speicher freigeben */
		     ini_aenderung= 1;
		     Erase_Rename_GRP( GRP->gruppendir, gruppenname, NULL, ERASE);
		  }
	       }
	       break;
	    case 6:                                    /* Gruppe umbenennen */
	       strcpy( new_gruppenname, gruppenname);
	       if( !RenameWindow( new_gruppenname, GRP_GRUPPE))
	       {
		  if( *new_gruppenname!= '\0')    /* Wurde etwas eingegeben ? */
		  {
		     if( !Search_not_allow_char_in_GRPname( new_gruppenname)) /* unzulssiges Zeichen im Namen ? */
		     {
			if( Exist_Entry( GRP_ptr, new_gruppenname, GRP_GRUPPE)== NULL) /* existiert der neue Gruppenname noch nicht ? */
			{
			   if(( tmp_ptr= Exist_Entry( GRP_ptr, gruppenname, GRP_GRUPPE))!= NULL) /* existiert die umzunennende Gruppe berhaupt ? */
			   {
			      newgrpname_len= strlen( new_gruppenname)+ 1;
			      grpname_len= strlen( tmp_ptr+ 10)+ 1;
			      if((( new_mem_len= GRP->mem_len+ ( newgrpname_len- grpname_len))+ GRP->seek_pos)<= GRP_MAXFILELENGTH)
			      {
				 if(( GRP_ptr= realloc( GRP_ptr, new_mem_len))!= NULL)
				 {
				    tmp_ptr= Exist_Entry( GRP_ptr, gruppenname, GRP_GRUPPE); /* nochmal aufrufen, da sich die Adresse von GRP_ptr gendert haben knnte */
				    memmove( tmp_ptr+ 10+ *( BYTE *)( tmp_ptr+ 9)+ ( newgrpname_len- grpname_len), tmp_ptr+ 10+ *( BYTE *)( tmp_ptr+ 9), GRP->mem_len- (( tmp_ptr+ 10+ *( BYTE *)( tmp_ptr+ 9))- GRP_ptr));
				    GRP->mem_len= new_mem_len;
				    *( DWORD *)tmp_ptr+= ( newgrpname_len- grpname_len);
				    *( BYTE *)( tmp_ptr+ 9)= newgrpname_len;
				    memcpy( tmp_ptr+ 10, new_gruppenname, newgrpname_len);
				    ini_aenderung= 1;
				    Erase_Rename_GRP( GRP->gruppendir, gruppenname, new_gruppenname, RENAME);
				    strcpy( gruppenname, new_gruppenname);
				    MS.statsp= REINIT;
				 }
				 else
				 {
				    ErrorMsg( KEIN_SPEICHER);
				    ret= ABBRUCH;
				 }
			      }
			      else
				 ErrorMsg( "Gruppendatei hat ihre max. Lnge erreicht");
			   }
			   else
			      ErrorMsg( "Die Gruppe existiert in der momentan aktiven Gruppe nicht");
			}
			else
			   ErrorMsg( "Der Gruppenname existiert bereits in dieser Gruppe");
		     }
		  }
		  else
		     ErrorMsg( "Es mu ein Name eingegeben werden");
	       }
	       break;
	 }
      }while( !ret);
      Write_DG2( GRP, GRP_ptr, &ini_aenderung);
   }
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
   return( ini_aenderung== 1);                          /* TRUE -> nderung */
}

void ProgAufnehmen( GRP_struct *GRP)
{
   int ret= 0;
   BOOL INIchanged= FALSE;
   char *msg[]= { "Programm aufnehmen, Einstellungen bearbeiten, ...",
		  "Programmgruppe anlegen, lschen, umbenennen",
		  "Datentrger automatisch nach Programmen durchsuchen",
		  "Alle vorhandenen Gruppen lschen",
		  "Sortieren der Anwenderprogramme und Gruppen",
		  "ohne Funktion" };
   WORD mauspos[]= { BUTTON| FRAME| KEY,                   5,  27,   5,  21, ESC,
		     BUTTON| FRAME| KEY| DEFBUTTON| MSG,  11,  80,  29,  82, 'p',
		     BUTTON| FRAME| KEY|            MSG,  85, 154,  29,  82, 'g',
		     BUTTON| FRAME| KEY|            MSG,  11,  80,  87, 140, 'u',
		     BUTTON| FRAME| KEY|            MSG,  85, 154,  87, 140, 'l',
		     BUTTON| FRAME| KEY|            MSG,  11,  80, 145, 198, 's',
		     BUTTON| FRAME| KEY|            MSG,  85, 154, 145, 198, 'o',
		     MOVEWINDOW };
   MAUSStruct MS= { DEFAULT, DEFAULT, 166, 210, 8, INIT, NULL, AN};

   MS.x= &aufx;
   MS.y= &aufy;
   MS.msg= msg;
   MS.mauspos= mauspos;
   PCX_Window( MS.x, MS.y, PCX_PROGRAMM_GRUPPE_AUSWAHL, &MS.sa, SHADOW);
   do
   {
      switch( __CheckMousepos( &MS))
      {
	 case 0:                                                     /* ESC */
	    ret= 1;
	    break;
	 case 1:
	    if( MakeIni( GRP))
	    {
	       INIchanged= TRUE;
	       Check_GRPanzeige( GRP);
	       GRP->Neu= GRP_ALT;
	    }
	    break;
	 case 2:
	    if( Gruppe( GRP))
	    {
	       INIchanged= TRUE;
	       Check_GRPanzeige( GRP);
	       GRP->Neu= GRP_ALT;
	    }
	    break;
	 case 3:
	    if( FindProgs( GRP))
	    {
	       INIchanged= TRUE;
	       RBalken_Begin( GRP->MS, GRP->RB);
	       Mark_of_pos( GRP, 0);
	       GRP->Neu= GRP_REDRAW;
	    }
	    break;
	 case 4:
	    if( !Info_Frage( 200, 200, "Wollen Sie wirklich\nalle Gruppen lschen ?", FRAGE))
	    {
	       INIchanged= TRUE;
	       GRP_freeResourcen( GRP);       /* jetzt aktive Gruppe schlieen */
	       EraseAllGRP();                          /* alte Gruppen lschen */
	       RBalken_Begin( GRP->MS, GRP->RB);
	       Mark_of_pos( GRP, 0);
	       GRP->Neu= GRP_NEU;
	    }
	    break;
	 case 5:                                     /* Programme sortieren */
	    if( _SortIni( GRP))                        /* es wurde sortiert */
	    {
	       INIchanged= TRUE;
	       GRP->Neu= GRP_ALT;
	    }
	    break;
      }
      if( INIchanged)
      {
	 ShowMouse( AUS);
	 BigScreenRestore( &MS.sa, *MS.x, *MS.y);
	 ProgAnz( GRP);
	 PCX_Window( MS.x, MS.y, PCX_PROGRAMM_GRUPPE_AUSWAHL, &MS.sa, SHADOW);
	 MS.statsp= REINIT;
	 ShowMouse( AN);
	 INIchanged= FALSE;
      }
   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &MS.sa, *MS.x, *MS.y);
   ShowMouse( AN);
}
