/*  MOUSE_OP.C  GUI control operations related to mouse and keyboard
 *  Copyright (C) 1991-1998  Felix Ritter
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#define NDEBUG        /* Prprozessor entfernt smtliche Aufrufe von assert */
#include <assert.h>

#include <dos.h>
#include <graphics.h>
#include <alloc.h>
#include <stdlib.h>
#include <conio.h>
#include <dir.h>
#include <string.h>
#include <bios.h>
#include "pal_op.h"
#include "filemgr.h"
#include "mouse_op.h"

#define CODE_FILTER_TO_BYTE             0x00FF
#define ELEMENTTYPBEZEICHNER_FILTER     0x8000
#define ONLY_FRAME                      1
#define WORK                            0
#define DUP_DIRINPUT                    0x0001
#define DUP_FILEINPUT                   0x0002
#define AFTER_INIT                      0x8000
#define AFTER_INIT_FILTER               0x7FFF

#define TASTATUR                        0
#define MAUS                            1

#define FORWARD                         1
#define BACKWARD                        2
#define ANZEIGE                         3

#define TASTENKOMBINATION               0
#define MAUSPOSINDEX                    1
#define ARGPOINTERINDEX                 2
#define POS_AT_ELEMENT                  3

#define INPUT_PULL_DOWN_MODE            0x8000
#define INPUT_VERAENDERT                0x0001
#define INPUT_PULLDOWN                  0x4000

#define FEHLER                          0x8000

#define RBALKEN_MINUS_MIN_TASTE         1
#define RBALKEN_PLUS_MIN_TASTE          2
#define RBALKEN_MINUS_MAX               3
#define RBALKEN_PLUS_MAX                4
#define RBALKEN_POS1                    5
#define RBALKEN_ENDE                    6
#define RBALKEN_RETURN                  7
#define RBALKEN_RANDOM                  8
#define RBALKEN_MINUS_MIN_MAUS          9
#define RBALKEN_PLUS_MIN_MAUS           10
#define ZEIGERPOS_AUS                   11
#define ZEIGERPOS_AN                    12
#define UP                              1
#define DOWN                            2

#define MIN_Y_TO_MOVE                   21
#define MAX_Y_TO_MOVE                   456
#define MIN_X_TO_MOVE                   0
#define MAX_X_TO_MOVE                   635
#define INPUTZEILENHOEHE                16
#define INPUTZEILENTASTENBREITE         14
#define INPUTTEXT_Xl_ABSTAND            4
#define INPUTTEXT_Yo_ABSTAND            5
#define DATEIAUSWAHLBOXBUTTON_X_LAENGE  46
#define DATEIAUSWAHLBOXBUTTON_Y_LAENGE  34
#define DATEIAUSWAHLBOX_TASTE           'd';
#define DATEIAUSWAHLBOX_RET             2
#define CHECKBOX_X_LAENGE               12
#define CHECKBOX_Y_LAENGE               12
#define RADIOBUTTON_X_RADIUS            8
#define RADIOBUTTON_Y_RADIUS            8
#define FENSTERKOPFHOEHE                24
#define LAUFLEISTENTASTENBREITE         32
#define LAUFLEISTENHOEHE                20
#define LAUFLEISTEN_TASTEN_TEXTABSTAND  3
#define LAUFLEISTENANZEIGE              3
#define VERZEICHNISBAUMBUTTON_X_LAENGE  46
#define VERZEICHNISBAUMBUTTON_Y_LAENGE  34
#define VERZEICHNISBAUM_TASTE           'p';
#define VERZEICHNISBAUM_RET             2
#define INPUTZEILE                      1
#define ROLLBALKEN_DICKE		17
#define ANFASSER_LAENGE                 20
#define BALKENFARBE                     EGA_DARKGRAY
#define INPUT_TABLE_PULL_DOWN           16
#define PULL_DOWN_TABLE                 2

void *last_maus_cursor;         /* Zeigt auf das momentane Mauscursor_Array */

struct MouseStat MStat;               /* Speicher des letzten Mausstatusses */

typedef struct
	{
	   WORD tasten, zeiger, anz_Einzelelemente, WORDS_pro_Element;
	}ElementInfo;

WORD maus_pfeil[]= { 0x0002,                               /* horiz. HotSpot */
		     0x0001,                                /* vert. HotSpot */

		     0xFFFF,
		     0xCFFF,
		     0xC7FF,
		     0xC3FF,
		     0xC1FF,
		     0xC0FF,
		     0xC07F,
		     0xC03F,
		     0xC01F,                           /* ScreenMask ( UND ) */
		     0xC00F,
		     0xC007,
		     0xC007,
		     0xE00F,
		     0xFF0F,
		     0xFFFF,
		     0xFFFF,

		     0x0000,
		     0x0000,
		     0x1000,
		     0x1800,
		     0x1C00,
		     0x1E00,
		     0x1F00,
		     0x1F80,                           /* CursorMask ( XOR ) */
		     0x1FC0,
		     0x1FE0,
		     0x1B80,
		     0x01C0,
		     0x0000,
		     0x0000,
		     0x0000,
		     0x0000 };

WORD maus_text[]= { 0x0003,                               /* horiz. HotSpot */
		    0x0006,                                /* vert. HotSpot */

		    0xFFFF,
		    0xFFFF,
		    0xFFFF,
		    0xFFFF,
		    0xFFFF,
		    0xFFFF,
		    0xFFFF,
		    0xFFFF,
		    0xFFFF,                           /* ScreenMask ( UND ) */
		    0xFFFF,
		    0xFFFF,
		    0xFFFF,
		    0xFFFF,
		    0xFFFF,
		    0xFFFF,
		    0xFFFF,

		    0xD800,
		    0x2000,
		    0x2000,
		    0x2000,
		    0x2000,
		    0x2000,
		    0x2000,
		    0x2000,                           /* CursorMask ( XOR ) */
		    0x2000,
		    0x2000,
		    0xD800,
		    0x0000,
		    0x0000,
		    0x0000,
		    0x0000,
		    0x0000 };

WORD maus_sanduhr[]= { 0x0007,                            /* horiz. HotSpot */
		       0x0007,                             /* vert. HotSpot */

		       0xFFFF,
		       0x0000,
		       0x0000,
		       0x8001,
		       0x8001,
		       0x9009,
		       0x9819,
		       0x9E79,
		       0x9819,                        /* ScreenMask ( UND ) */
		       0x9009,
		       0x8001,
		       0x8001,
		       0x0000,
		       0x0000,
		       0xFFFF,
		       0xFFFF,

		       0x0000,
		       0x0000,
		       0x07E0,
		       0x07E0,
		       0x0000,
		       0x0000,
		       0x0000,
		       0x0000,                        /* CursorMask ( XOR ) */
		       0x0180,
		       0x0340,
		       0x07E0,
		       0x0660,
		       0x0000,
		       0x0000,
		       0x0000,
		       0x0000 };

WORD maus_nach[]= { 0x0001,                               /* horiz. HotSpot */
		    0x0008,                                /* vert. HotSpot */

		    0xFEFF,
		    0xFC7F,
		    0xF87F,
		    0xF01F,
		    0xE00F,
		    0xC00D,
		    0x800A,
		    0x000E,
		    0x800D,                           /* ScreenMask ( UND ) */
		    0xC00F,
		    0xE00D,
		    0xF00F,
		    0xF80F,
		    0xFC7F,
		    0xFE7F,
		    0xFF7F,

		    0x0000,
		    0x0000,
		    0x0200,
		    0x0600,
		    0x0FC0,
		    0x1FC0,
		    0x3FC0,
		    0x7FC0,                           /* CursorMask ( XOR ) */
		    0x3FC0,
		    0x1FC0,
		    0x0FC0,
		    0x0600,
		    0x0200,
		    0x0000,
		    0x0000,
		    0x0000 };

WORD maus_links_rechts[]= { 0x0008,                       /* horiz. HotSpot */
			    0x0006,                        /* vert. HotSpot */

			    0xFBBF,
			    0xF19F,
			    0xE00F,
			    0xC007,
			    0x8003,
			    0x0001,
			    0x8000,
			    0xC001,
			    0xE003,                   /* ScreenMask ( UND ) */
			    0xF007,
			    0xF98F,
			    0xFDDF,
			    0xFFFF,
			    0xFFFF,
			    0xFFFF,
			    0xFFFF,

			    0x0000,
			    0x0000,
			    0x0820,
			    0x1FF0,
			    0x3FF8,
			    0x7FFC,
			    0x3FF8,
			    0x1FF0,                   /* CursorMask ( XOR ) */
			    0x0820,
			    0x0000,
			    0x0000,
			    0x0000,
			    0x0000,
			    0x0000,
			    0x0000,
			    0x0000 };

WORD File_DragDrop[]= { 0x0005,                           /* horiz. HotSpot */
			0x0003,                            /* vert. HotSpot */

			0xE07F,
			0xC07F,
			0x807F,
			0x007F,
			0x007F,
			0x007F,
			0x003F,
			0x001F,
			0x000F,                       /* ScreenMask ( UND ) */
			0x0007,
			0xF803,
			0xF801,
			0xF800,
			0xF800,
			0xFC01,
			0xFFE1,

			0x0000,
			0x0F00,
			0x2F00,
			0x0900,
			0x7A00,
			0x7B00,
			0x7B80,
			0x7BC0,                       /* CursorMask ( XOR ) */
			0x7BE0,
			0x03F0,
			0x03F8,
			0x03FC,
			0x0370,
			0x0038,
			0x0000,
			0x0000 };

void ShowMouse( char e_a)           /* Schaltet den Mauscursor ein- und aus */
{
   if( globalmaus== AN)
   {
      if( !e_a)                                                      /* aus */
	 RP.r_ax= 2;
      else
	 RP.r_ax= 1;                                                 /* ein */
      intr( MAUS_INT, &RP);
   }
}

int InitMouse( void)                                 /* Hardware vorhanden? */
{
   RP.r_ax= 0;
   intr( MAUS_INT, &RP);
   globalmaus= RP.r_ax& 0x0001;
   return( RP.r_ax);
}

void MouseArt( unsigned mausarray[])          /* neuen Mauscursor einbinden */
{
   last_maus_cursor= mausarray;
   if( globalmaus== AN)
   {
      RP.r_ax= 9;
      RP.r_bx= mausarray[ 0];
      RP.r_cx= mausarray[ 1];
      RP.r_es= FP_SEG( &mausarray[ 2]);
      RP.r_dx= FP_OFF( &mausarray[ 2]);
      intr( MAUS_INT, &RP);
   }
}

BOOL MouseMove( void)
{
   if( globalmaus== AN)
   {
      RP.r_ax= 0x0B;
      intr( MAUS_INT, &RP);
      return(( RP.r_cx!= 0)|| ( RP.r_dx!= 0));
   }
   return( 0);
}

WORD MouseStat( void)                    /* Status des Mauszeigers abfragen */
{
   if( globalmaus== AUS)
   {
      MStat.x=       RP.r_cx= 0;
      MStat.y=       RP.r_dx= 0;
      MStat.buttons= RP.r_bx= NOTHING;
   }
   else
   {
      RP.r_ax= 0x03;
      intr( MAUS_INT, &RP);
      MStat.x=       RP.r_cx;
      MStat.y=       RP.r_dx;
      if(( linkshaendermaus== AN)&& (( RP.r_bx== LEFT)|| ( RP.r_bx== RIGHT)))
	 RP.r_bx^=0x0003;                                   /* bin 00000011 */
      MStat.buttons= RP.r_bx;
   }
   return( RP.r_bx);
}

void SetXRange( int MinX, int MaxX)    /* X-Position des Mauszeigers setzen */
{
   if( globalmaus== AN)
   {
      RP.r_ax= 7;
      RP.r_cx= MinX;
      RP.r_dx= MaxX;
      intr( MAUS_INT, &RP);
   }
}

void SetYRange( int MinY, int MaxY)    /* Y-Position des Mauszeigers setzen */
{
   if( globalmaus== AN)
   {
      RP.r_ax= 8;
      RP.r_dx= MaxY;
      RP.r_cx= MinY;
      intr( MAUS_INT, &RP);
   }
}

void SetMouse( int x, int y)             /* Position des Mauszeigers setzen */
{
   if( globalmaus== AN)
   {
      RP.r_ax= 4;
      RP.r_cx= x;
      RP.r_dx= y;
      intr( MAUS_INT, &RP);
   }
}

void MouseHideBar( int x1, int y1, int x2, int y2)      /* Ausschlubereich */
{
   if( globalmaus== AN)
   {
      RP.r_ax= 0x10;
      RP.r_cx= x1;
      RP.r_dx= y1;
      RP.r_si= x2;
      RP.r_di= y2;
      intr( MAUS_INT, &RP);
   }
}

void MSpeed( int speed)                           /* Geschwindigkeit setzen */
{
   if( globalmaus== AN)
   {
      RP.r_ax= 15;
      RP.r_cx= speed;
      RP.r_dx= speed;
      intr( MAUS_INT, &RP);
   }
}

void ClearStatus( void)
{
   int color;
   struct fillsettingstype fi;

   if( !msg_to_Klick&& _ShowStatus)
   {
      color= getcolor();
      getfillsettings( &fi);
      setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
      ShowMouse( AUS);
      bar( 10, 460, 559, 474);
      ShowMouse( AN);
      setfillstyle( fi.pattern, fi.color);
      setcolor( color);
   }
}

void PrintStatus( char *string)
{
   int color;
   struct fillsettingstype fi;

   if( !msg_to_Klick&& _ShowStatus)
   {
      color= getcolor();
      getfillsettings( &fi);
      setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
      ShowMouse( AUS);
      bar( 10, 460, 559, 474);
      setcolor( EGA_BLACK);
      outtextxy( 15, 463, string);
      ShowMouse( AN);
      setfillstyle( fi.pattern, fi.color);
      setcolor( color);
   }
}

void PrintStatus_at( int pos, char *string)
{
   int color;
   struct fillsettingstype fi;

   if( _ShowStatus)
   {
      color= getcolor();
      getfillsettings( &fi);
      ShowMouse( AUS);
      ClearTextN( 15+ ( pos<< 3), 463, strlen( string));
      setcolor( EGA_BLACK);
      outtextxy( 15+ ( pos<< 3), 463, string);
      ShowMouse( AN);
      setfillstyle( fi.pattern, fi.color);
      setcolor( color);
   }
}

void PrintStatus_to_Klick( char *string)
{
   int color;
   struct fillsettingstype fi;

   if( _ShowStatus)
   {
      color= getcolor();
      getfillsettings( &fi);
      setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
      ShowMouse( AUS);
      bar( 10, 460, 559, 474);
      setcolor( EGA_BLACK);
      outtextxy( 15, 463, string);
      ShowMouse( AN);
      setfillstyle( fi.pattern, fi.color);
      setcolor( color);
      msg_to_Klick= TRUE;
   }
}

void ErrorMsg( char *msg)                                 /* max 60 Zeichen */
{
   char errormsg[ 69]= "FEHLER: ";    /* Statuszeile umfat max. 68 Zeichen */

   PrintStatus_to_Klick( strcat( errormsg, msg));
   ErrorSound();
}

void Hinweis( char *msg)                                  /* max 59 Zeichen */
{
   char Hinweis_msg[ 69]= "HINWEIS: ";  /* Statuszeile umfat max. 68 Zeichen */

   PrintStatus_to_Klick( strcat( Hinweis_msg, msg));
   HinweisSound();
}

void CheckBox( int Xlo, int Ylo, int zust)
{
   char color;

   color= getcolor();
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   bar( Xlo+ 1, Ylo+ 1, Xlo+ 11, Ylo+ 11);
   if( zust)
   {
      setcolor( EGA_BLACK);
      line( Xlo+ 2, Ylo+ 6, Xlo+ 2, Ylo+ 10);
      line( Xlo+ 3, Ylo+ 5, Xlo+ 3, Ylo+ 10);
      line( Xlo+ 4, Ylo+ 8, Xlo+ 9, Ylo+ 3);
      line( Xlo+ 4, Ylo+ 9, Xlo+ 10, Ylo+ 3);
   }
   setcolor( EGA_WHITE);
   line( Xlo, Ylo, Xlo+ 12, Ylo);
   line( Xlo, Ylo, Xlo, Ylo+ 12);
   setcolor( EGA_DARKGRAY);
   line( Xlo+ 12, Ylo, Xlo+ 12, Ylo+ 12);
   line( Xlo, Ylo+ 12, Xlo+ 12, Ylo+ 12);
   setcolor( color);
}

void RadioButton( int Xm, int Ym, int zust)
{
   int poly[ 8];
   char color;

   color= getcolor();
   poly[ 0]= Xm;
   poly[ 1]= Ym- 3;
   poly[ 2]= Xm+ 3;
   poly[ 3]= Ym;
   poly[ 4]= Xm;
   poly[ 5]= Ym+ 3;
   poly[ 6]= Xm- 3;
   poly[ 7]= Ym;
   if( zust)
   {
      setfillstyle( SOLID_FILL, EGA_BLACK);
      setcolor( EGA_WHITE);
   }
   else
   {
      setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
      setcolor( EGA_DARKGRAY);
   }
   line( Xm+ 1, Ym- 5, Xm+ 6, Ym);
   line( Xm+ 6, Ym, Xm, Ym+ 6);
   if( zust)
      setcolor( EGA_DARKGRAY);
   else
      setcolor( EGA_WHITE);
   line( Xm, Ym- 6, Xm- 6, Ym);
   line( Xm- 6, Ym, Xm- 1, Ym+ 5);
   setcolor( EGA_LIGHTGRAY);
   fillpoly( 4, poly);
   setcolor( color);
}

void Button( int Xl, int Yo, int Xr, int Yu, char *text, int ausw)
{
   int textx, texty, linex;
   char color;

   color= getcolor();
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   bar( Xl+ 2, Yo+ 2, Xr- 2, Yu- 2);
   setcolor( EGA_WHITE);
   line( Xl- 1, Yu+ 1, Xr+ 1, Yu+ 1);
   line( Xr+ 1, Yo- 1, Xr+ 1, Yu+ 1);
   line( Xr- 1, Yo+ 1, Xl+ 1, Yo+ 1);
   line( Xl+ 1, Yo+ 1, Xl+ 1, Yu- 1);
   setcolor( EGA_DARKGRAY);
   line( Xl- 1, Yo- 1, Xl- 1, Yu+ 1);
   line( Xl- 1, Yo- 1, Xr, Yo- 1);
   line( Xl+ 2, Yu- 2, Xr- 1, Yu- 2);
   line( Xl+ 1, Yu- 1, Xr- 1, Yu- 1);
   line( Xr- 2, Yu- 1, Xr- 2, Yo+ 2);
   line( Xr- 1, Yu- 1, Xr- 1, Yo+ 1);
   setcolor( EGA_BLACK);
   rectangle( Xl, Yo, Xr, Yu);
   OutLineTextxy(( Xl+ (( Xr- Xl)>> 1)- ( strlen( text)<< 2)), ( Yo+ (( Yu- Yo)>> 1)- 3), text, ausw);
   setcolor( color);
}

void POS_Zeiger( int Xm, int Yo)
{
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   bar( Xm- 1, Yo+ 2, Xm+ 1, Yo+ LAUFLEISTENHOEHE- 2);
   Draw_Tal_Berg( Xm- 2, Yo+ 1, Xm+ 2, Yo+ LAUFLEISTENHOEHE- 1, BERG);
}

void _LaufLeiste( int x, int y, int laenge, char *format, int wert, int min, int max, char Zeiger_an_aus)
{
   int xend, balkenend;
   char string[ 40];
   struct textsettingstype text;
   
   xend= x+ laenge;
   balkenend= x+ LAUFLEISTENTASTENBREITE+ LAUFLEISTEN_TASTEN_TEXTABSTAND+ ((( double)( wert- min)* ( double)( laenge- (( LAUFLEISTENTASTENBREITE+ LAUFLEISTEN_TASTEN_TEXTABSTAND)<< 1)))/ ( double)( max- min));
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   bar( x+ LAUFLEISTENTASTENBREITE+ LAUFLEISTEN_TASTEN_TEXTABSTAND, y+ 1, xend- LAUFLEISTENTASTENBREITE- LAUFLEISTEN_TASTEN_TEXTABSTAND, y+ LAUFLEISTENHOEHE- 1);
   setcolor( EGA_BLACK);
   sprintf( string, format, wert);
   gettextsettings( &text);
   settextjustify( CENTER_TEXT, CENTER_TEXT);
   outtextxy(( x+ ( laenge>> 1)), y+ ( LAUFLEISTENHOEHE>> 1), string);
   settextjustify( text.horiz, text.vert);
   if( balkenend< ( x+ LAUFLEISTENTASTENBREITE+ LAUFLEISTEN_TASTEN_TEXTABSTAND+ 2))
      balkenend= x+ LAUFLEISTENTASTENBREITE+ LAUFLEISTEN_TASTEN_TEXTABSTAND+ 2;
   else
      if( balkenend> ( xend- LAUFLEISTENTASTENBREITE- LAUFLEISTEN_TASTEN_TEXTABSTAND- 2))
	 balkenend= xend- LAUFLEISTENTASTENBREITE- LAUFLEISTEN_TASTEN_TEXTABSTAND- 2;
   if( Zeiger_an_aus== AN)
      POS_Zeiger( balkenend, y);
}

void While_Klick( void)
{
   while( MouseStat()!= NOTHING)
      ;
}

int WaitDelay( int wert)
{
   int i;

   for( i= 0; i< wert; i++)
   {
      LoschTbuf();
      if(( MouseStat()== NOTHING)&& TASTE_LOSGELASSEN)
	 return( 1);
      delay( 1);
   }
   return( 0);
}

void *ButtonDown( int x1, int y1, int x2, int y2)
{
   void *mem_ptr;

   if(( mem_ptr= malloc( imagesize( x1+ 2, y1+ 2, x2- 2, y2- 2)))!= NULL)
   {
      ShowMouse( AUS);
      getimage( x1+ 2, y1+ 2, x2- 2, y2- 2, mem_ptr);
      putimage( x1+ 3, y1+ 3, mem_ptr, COPY_PUT);
      setcolor( EGA_DARKGRAY);
      line( x2- 1, y1+ 1, x1+ 1, y1+ 1);
      line( x1+ 1, y1+ 1, x1+ 1, y2- 1);
      setcolor( EGA_LIGHTGRAY);
      line( x1+ 2, y1+ 2, x1+ 2, y2- 2);
      line( x1+ 3, y1+ 2, x2- 2, y1+ 2);
      line( x1+ 2, y2- 1, x2- 1, y2- 1);
      line( x2- 1, y2- 2, x2- 1, y1+ 2);
      ShowMouse( AN);
   }
   return( mem_ptr);
}

void ButtonUp( void *mem_ptr, int x1, int y1, int x2, int y2)
{
   if( mem_ptr!= NULL)
   {
      ShowMouse( AUS);
      putimage( x1+ 2, y1+ 2, mem_ptr, COPY_PUT);
      setcolor( EGA_DARKGRAY);
      line( x2- 1, y1+ 2, x2- 1, y2- 1);
      line( x1+ 2, y2- 1, x2- 2, y2- 1);
      setcolor( EGA_WHITE);
      line( x1+ 1, y1+ 1, x2- 2, y1+ 1);
      line( x1+ 1, y1+ 2, x1+ 1, y2- 2);
      ShowMouse( AN);
      free( mem_ptr);
   }
}

void GetObjectRect( MAUSStruct *MS, int index, int *x1, int *y1, int *x2, int *y2)
{
   switch( MS->mauspos[ index]& CODE_FILTER)
   {
      case BUTTON:
	 *x1= MS->mauspos[ index+ 1]+ *MS->x+ 1;
	 *y1= MS->mauspos[ index+ 3]+ *MS->y+ 1;
	 *x2= MS->mauspos[ index+ 2]+ *MS->x- 1;
	 *y2= MS->mauspos[ index+ 4]+ *MS->y- 1;
	 break;
      case BUTTON2:
	 *x1= MS->mauspos[ index+ 1]+ *MS->x;
	 *y1= MS->mauspos[ index+ 3]+ *MS->y;
	 *x2= MS->mauspos[ index+ 2]+ *MS->x;
	 *y2= MS->mauspos[ index+ 4]+ *MS->y;
	 break;
      case BUTTON3:
	 *x1= MS->mauspos[ index+ 1]+ *MS->x- 1;
	 *y1= MS->mauspos[ index+ 3]+ *MS->y- 1;
	 *x2= MS->mauspos[ index+ 2]+ *MS->x+ 1;
	 *y2= MS->mauspos[ index+ 4]+ *MS->y+ 1;
	 break;
   }
}

BOOL IsMouseInArea( int x1, int y1, int x2, int y2)
{
    MouseStat();
    return(( MStat.x>= x1)&& ( MStat.x<= x2)&& ( MStat.y>= y1)&& ( MStat.y<= y2));
}

BOOL KlickButton( int x1, int y1, int x2, int y2)
{
   char color;
   BOOL buttonDown= FALSE, mouseInArea= TRUE;
   void *mem_ptr;

   if( MStat.buttons!= NOTHING)
   {
      color= getcolor();
      do
      {
	 mouseInArea= IsMouseInArea( x1, y1, x2, y2);
	 if( !buttonDown&& mouseInArea)
	 {
	    mem_ptr= ButtonDown( x1, y1, x2, y2);
	    buttonDown= TRUE;
	 }
	 if( buttonDown&& ( !mouseInArea|| ( MStat.buttons== NOTHING)))
	 {
	    ButtonUp( mem_ptr, x1, y1, x2, y2);
	    buttonDown= FALSE;
	 }
      }while(( MStat.buttons!= NOTHING)|| buttonDown);
      setcolor( color);
   }
   return( mouseInArea);
}

void WhiteClearN( int x, int y, int laenge)
{
   setfillstyle( SOLID_FILL, EGA_WHITE);
   bar( x- 1, y- 3, x+ ( laenge<< 3)+ 1, y+ 10);
}

void OutTextN( int x, int y, char *text, int anz)
{
   char buffer[ 81];

   *( strncpy( buffer, text, anz)+ anz)= '\0';
   setcolor( EGA_BLACK);
   outtextxy( x, y, buffer);
}

void InitInputLine( int Xlo, int Ylo, int Xlength, char *string)
{
   int length;

   WhiteClearN( Xlo+ INPUTZEILENTASTENBREITE+ INPUTTEXT_Xl_ABSTAND, Ylo+ INPUTTEXT_Yo_ABSTAND, length= (( Xlength- (( INPUTZEILENTASTENBREITE+ INPUTTEXT_Xl_ABSTAND)<< 1))>> 3));
   OutTextN( Xlo+ INPUTZEILENTASTENBREITE+ INPUTTEXT_Xl_ABSTAND, Ylo+ INPUTTEXT_Yo_ABSTAND, string, length);
}

void InitKlick_Table( int Xlo, int Ylo, int Xlength, char *string)
{
   InitInputLine( Xlo- INPUTZEILENTASTENBREITE, Ylo, Xlength+ ( INPUTZEILENTASTENBREITE<< 1)- INPUT_TABLE_PULL_DOWN, string);
}

void InputReverse( int x, int y, int laenge)
{
   int t_laenge= laenge<< 3,
       i;

   setcolor( 0x0F);
   setwritemode( XOR_PUT);
   line( x- 1, y- 3, x+ t_laenge, y- 3);
   setlinestyle( SOLID_LINE, 0, THICK_WIDTH);
   for( i= -1; i< 9; i+= 3)
      line( x- 1, y+ i, x+ t_laenge, y+ i);
   setlinestyle( SOLID_LINE, 0, NORM_WIDTH);
   setwritemode( COPY_PUT);
}

void InputRahmen( int x, int y, int laenge, char *input, char an_aus)
{
   int maxanzeige, length, l;
   char color;

   color= getcolor();
   maxanzeige= (( laenge- ( INPUTZEILENTASTENBREITE<< 1))>> 3)- 1;
   WhiteClearN( x+ INPUTZEILENTASTENBREITE+ INPUTTEXT_Xl_ABSTAND, y+ INPUTTEXT_Yo_ABSTAND, maxanzeige);
   OutTextN( x+ INPUTZEILENTASTENBREITE+ INPUTTEXT_Xl_ABSTAND, y+ INPUTTEXT_Yo_ABSTAND, input, maxanzeige);
   if( an_aus== AN)
   {
      (( l= strlen( input))> maxanzeige) ? ( length= maxanzeige) : ( length= l);
      InputReverse( x+ INPUTZEILENTASTENBREITE+ INPUTTEXT_Xl_ABSTAND, y+ INPUTTEXT_Yo_ABSTAND, length);
   }
   setcolor( color);
}

int extended_ungetch( int Tastatur_Code)
{
   WORD *next_char= MK_FP( 0x0040, 0x001A),
	*last_char= MK_FP( 0x0040, 0x001C);

   if( *next_char== 0x001E)
   {
      if( *last_char== 0x003C)                     /* Tastaturpuffer voll ? */
	 return( -1);
      else
	 *next_char= 0x003C;
   }
   else
   {
      if(( *next_char- 2)== *last_char)            /* Tastaturpuffer voll ? */
	 return( -1);
      else
	 *next_char-= 2;
   }
   *( WORD *)MK_FP( 0x0040, *next_char)= Tastatur_Code<< 8;
   return( Tastatur_Code);
}

int ungetch( int Tastatur_Code)
{
   WORD *next_char= MK_FP( 0x0040, 0x001A),
	*last_char= MK_FP( 0x0040, 0x001C);

   if( *next_char== 0x001E)
   {
      if( *last_char== 0x003C)                     /* Tastaturpuffer voll ? */
	 return( -1);
      else
	 *next_char= 0x003C;
   }
   else
   {
      if(( *next_char- 2)== *last_char)            /* Tastaturpuffer voll ? */
	 return( -1);
      else
	 *next_char-= 2;
   }
   *( WORD *)MK_FP( 0x0040, *next_char)= Tastatur_Code;
   return( Tastatur_Code);
}

void strtokeys( char *str)
{
   char *tmp_ptr;

   tmp_ptr= strrev( str);
   while( *tmp_ptr!= '\0')
      ungetch( *( tmp_ptr++));
}

int Anzahl_Eintraege_pro_Typ( WORD typ, ElementInfo *EInfo)
{
   /* Bytes, Tasten, Pointer, anz. Einzelelem. */

   int groesse[][ 4]= { 5, 1, 0, 1,                            /* KLICKAREA */
			5, 1, 0, 1,   		                /* PUSHAREA */
			4, 1, 1, 1,			     /* RADIOBUTTON */
			3, 1, 1, 1,			        /* CHECKBOX */
			1, 1, 0, 1,			      /* MOVEWINDOW */
			5, 1, 0, 1,			          /* BUTTON */
			5, 1, 0, 1,			         /* BUTTON2 */
			5, 1, 0, 1,				 /* HOTAREA */
			7, 2, 2, 2,                           /* LAUFLEISTE */
			5, 1, 1, 1,                                /* INPUT */
			8, 1, 4, 2,                            /* FILEINPUT */
			8, 1, 2, 2,      		        /* DIRINPUT */
			5, 1, 0, 1,			         /* BUTTON3 */
			1, 7, 2, 2,                           /* ROLLBALKEN */
			1, 1, 0, 1,                                /* TASTE */
			6, 1, 1, 1,                          /* INPUT_TABLE */
			5, 1, 0, 1,	                /* DOUBLE_KLICKAREA */
			6, 1, 2, 1,                          /* KLICK_TABLE */
			1, 0, 1, 1,                          /* NOT_USE_KEY */
			5, 1, 1, 1,                       /* FILEINPUTNOBOX */
			5, 1, 1, 1,                        /* DIRINPUTNOBOX */
			6, 1, 1, 1,                     /* FILE_INPUT_TABLE */
			6, 1, 1, 1,                      /* DIR_INPUT_TABLE */
			};

   EInfo->tasten= groesse[ typ& CODE_FILTER_TO_BYTE][ 1];
   EInfo->zeiger= groesse[ typ& CODE_FILTER_TO_BYTE][ 2];
   if( typ& _IF)
      EInfo->zeiger++;
   EInfo->anz_Einzelelemente= groesse[ typ& CODE_FILTER_TO_BYTE][ 3];
   EInfo->WORDS_pro_Element= groesse[ typ& CODE_FILTER_TO_BYTE][ 0];
   if( typ& KEY)                /* Hat das Element eine Tastenkombination ? */
      EInfo->WORDS_pro_Element+= groesse[ typ& CODE_FILTER_TO_BYTE][ 1];
   return( EInfo->WORDS_pro_Element);
}

int Is_Mouse_at_Element( MAUSStruct *MS, int index, int ptr_index)
{
   if( !(( MS->mauspos[ index]& _IF)&& !*( BOOL *)MS->arg_ptr[ ptr_index]))
   {
      switch( MS->mauspos[ index]& CODE_FILTER)
      {
	 case DOUBLE_KLICKAREA:
	 case KLICKAREA:
	 case PUSHAREA:
	 case BUTTON:
	 case BUTTON2:
	 case BUTTON3:
	 case HOTAREA:
	    return(( MStat.x>= ( MS->mauspos[ index+ 1]+ *MS->x))&& ( MStat.x<= ( MS->mauspos[ index+ 2]+ *MS->x))&& ( MStat.y>= ( MS->mauspos[ index+ 3]+ *MS->y))&& ( MStat.y<= ( MS->mauspos[ index+ 4]+ *MS->y)));
	 case RADIOBUTTON:
	    return(( MStat.x>= ( MS->mauspos[ index+ 1]- RADIOBUTTON_X_RADIUS+ *MS->x))&& ( MStat.x<= ( MS->mauspos[ index+ 1]+ RADIOBUTTON_X_RADIUS+ *MS->x))&& ( MStat.y>= ( MS->mauspos[ index+ 2]- RADIOBUTTON_Y_RADIUS+ *MS->y))&& ( MStat.y<= ( MS->mauspos[ index+ 2]+ RADIOBUTTON_Y_RADIUS+ *MS->y)));
	 case CHECKBOX:
	    return(( MStat.x>= ( MS->mauspos[ index+ 1]+ *MS->x))&& ( MStat.x<= ( MS->mauspos[ index+ 1]+ CHECKBOX_X_LAENGE+ *MS->x))&& ( MStat.y>= ( MS->mauspos[ index+ 2]+ *MS->y))&& ( MStat.y<= ( MS->mauspos[ index+ 2]+ CHECKBOX_Y_LAENGE+ *MS->y)));
	 case MOVEWINDOW:
	    return(( MStat.x>= *MS->x)&& ( MStat.x<= ( *MS->x+ MS->xlength))&& ( MStat.y>= *MS->y)&& ( MStat.y<= ( *MS->y+ FENSTERKOPFHOEHE)));
	 case ROLLBALKEN:
	    if( ( *( RBalken *)MS->arg_ptr[ ptr_index]).lage== VERT_DIR)
	    {
	       if(( MStat.x>= ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).x+ *MS->x))&& ( MStat.x<= ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).x+ *MS->x+ ROLLBALKEN_DICKE))&& ( MStat.y>= ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).y+ *MS->y))&& ( MStat.y<= ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).x_y+ *MS->y)))
		  if(( ( *( RBalken *)MS->arg_ptr[ ptr_index]).button_flag== RBALKEN_RANDOM)|| (( MStat.y>= ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).greifx_y+ *MS->y))&& ( MStat.y<= ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).greifx_y+ *MS->y+ ANFASSER_LAENGE))))
		     return( RBALKEN_RANDOM);
		  else
		     if( MStat.y<= ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).y+ *MS->y+ ROLLBALKEN_DICKE))
			return( RBALKEN_MINUS_MIN_MAUS);
		     else
			if( MStat.y>= ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).x_y+ *MS->y- ROLLBALKEN_DICKE))
			   return( RBALKEN_PLUS_MIN_MAUS);
			else
			   if(( ( *( RBalken *)MS->arg_ptr[ ptr_index]).button_flag== RBALKEN_MINUS_MAX)|| ( MStat.y< ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).greifx_y+ *MS->y)))
			      return( RBALKEN_MINUS_MAX);
			   else
			      return( RBALKEN_PLUS_MAX);
	    }
	    else
	    {
	       if(( MStat.x>= ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).x+ *MS->x))&& ( MStat.x<= ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).x_y+ *MS->x))&& ( MStat.y>= ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).y+ *MS->y))&& ( MStat.y<= ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).y+ *MS->y+ ROLLBALKEN_DICKE)))
		  if(( ( *( RBalken *)MS->arg_ptr[ ptr_index]).button_flag== RBALKEN_RANDOM)|| (( MStat.x>= ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).greifx_y+ *MS->x))&& ( MStat.x<= ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).greifx_y+ *MS->x+ ANFASSER_LAENGE))))
		     return( RBALKEN_RANDOM);
		  else
		     if( MStat.x<= ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).x+ *MS->x+ ROLLBALKEN_DICKE))
			return( RBALKEN_MINUS_MIN_MAUS);
		     else
			if( MStat.x>= ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).x_y+ *MS->x- ROLLBALKEN_DICKE))
			   return( RBALKEN_PLUS_MIN_MAUS);
			else
			   if(( ( *( RBalken *)MS->arg_ptr[ ptr_index]).button_flag== RBALKEN_MINUS_MAX)|| ( MStat.x< ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).greifx_y+ *MS->x)))
			      return( RBALKEN_MINUS_MAX);
			   else
			      return( RBALKEN_PLUS_MAX);
	    }
	    break;
	 case LAUFLEISTE:
	    if(( MStat.y>= ( MS->mauspos[ index+ 2]+ *MS->y))&& ( MStat.y<= ( MS->mauspos[ index+ 2]+ LAUFLEISTENHOEHE+ *MS->y)))
	    {
	       if(( MStat.x>= ( MS->mauspos[ index+ 1]+ *MS->x))&& ( MStat.x<= ( MS->mauspos[ index+ 1]+ LAUFLEISTENTASTENBREITE+ *MS->x)))
		  return( LEFT);
	       if(( MStat.x>= ( MS->mauspos[ index+ 1]+ MS->mauspos[ index+ 3]- LAUFLEISTENTASTENBREITE+ *MS->x))&& ( MStat.x<= ( MS->mauspos[ index+ 1]+ MS->mauspos[ index+ 3]+ *MS->x)))
		  return( RIGHT);
	       if(( MStat.x>= ( MS->mauspos[ index+ 1]+ LAUFLEISTENTASTENBREITE+ LAUFLEISTEN_TASTEN_TEXTABSTAND+ *MS->x))&& ( MStat.x<= ( MS->mauspos[ index+ 1]+ MS->mauspos[ index+ 3]- ( LAUFLEISTENTASTENBREITE+ LAUFLEISTEN_TASTEN_TEXTABSTAND)+ *MS->x)))
		  return( LAUFLEISTENANZEIGE);
	    }
	    break;
	 case INPUT_TABLE:
	 case FILE_INPUT_TABLE:
	 case DIR_INPUT_TABLE:
	    if(( MStat.y>= ( MS->mauspos[ index+ 2]+ *MS->y))&& ( MStat.y<= ( MS->mauspos[ index+ 2]+ INPUTZEILENHOEHE+ *MS->y)))
	    {
	       if(( MStat.x>= ( MS->mauspos[ index+ 1]+ *MS->x))&& ( MStat.x<= ( MS->mauspos[ index+ 1]+ MS->mauspos[ index+ 3]- INPUT_TABLE_PULL_DOWN+ *MS->x)))
		  return( INPUTZEILE);
	       if(( MStat.x>= ( MS->mauspos[ index+ 1]+ MS->mauspos[ index+ 3]- INPUT_TABLE_PULL_DOWN+ *MS->x))&& ( MStat.x<= ( MS->mauspos[ index+ 1]+ MS->mauspos[ index+ 3]+ *MS->x)))
		  return( PULL_DOWN_TABLE);
	    }
	    break;
	 case FILEINPUT:
	    if(( MStat.x>= ( MS->mauspos[ index+ 5]+ *MS->x))&& ( MStat.x<= ( MS->mauspos[ index+ 5]+ DATEIAUSWAHLBOXBUTTON_X_LAENGE+ *MS->x))&& ( MStat.y>= ( MS->mauspos[ index+ 6]+ *MS->y))&& ( MStat.y<= ( MS->mauspos[ index+ 6]+ DATEIAUSWAHLBOXBUTTON_Y_LAENGE+ *MS->y)))
	       return( DATEIAUSWAHLBOX_RET);
	    goto L_INPUT;
	 case DIRINPUT:
	    if(( MStat.x>= ( MS->mauspos[ index+ 5]+ *MS->x))&& ( MStat.x<= ( MS->mauspos[ index+ 5]+ VERZEICHNISBAUMBUTTON_X_LAENGE+ *MS->x))&& ( MStat.y>= ( MS->mauspos[ index+ 6]+ *MS->y))&& ( MStat.y<= ( MS->mauspos[ index+ 6]+ VERZEICHNISBAUMBUTTON_Y_LAENGE+ *MS->y)))
	       return( VERZEICHNISBAUM_RET);
	 case KLICK_TABLE:
	 case INPUT:
	 case FILEINPUTNOBOX:
	 case DIRINPUTNOBOX:
	    L_INPUT:
	    ;
	    return(( MStat.x>= ( MS->mauspos[ index+ 1]+ *MS->x))&& ( MStat.x<= ( MS->mauspos[ index+ 1]+ MS->mauspos[ index+ 3]+ *MS->x))&& ( MStat.y>= ( MS->mauspos[ index+ 2]+ *MS->y))&& ( MStat.y<= ( MS->mauspos[ index+ 2]+ INPUTZEILENHOEHE+ *MS->y)));
      }
   }
   return( 0);
}

void KlickRadioButton( int Xm, int Ym)
{
   char color, i;

   color= getcolor();
   setcolor( EGA_BLACK);
   for( i= 0; i< 2; i++)
   {
      ShowMouse( AUS);
      line( Xm+ 1, Ym- 5, Xm+ 6, Ym);
      line( Xm+ 6, Ym, Xm, Ym+ 6);
      line( Xm, Ym- 6, Xm- 6, Ym);
      line( Xm- 6, Ym, Xm- 1, Ym+ 5);
      line( Xm+ 1, Ym- 4, Xm+ 5, Ym);
      line( Xm+ 5, Ym, Xm, Ym+ 5);
      line( Xm, Ym- 5, Xm- 5, Ym);
      line( Xm- 5, Ym, Xm- 1, Ym+ 4);
      ShowMouse( AN);
      setcolor( EGA_LIGHTGRAY);
      if( i< 1)
	 While_Klick();
   }
   setcolor( color);
}

void KlickCheckBox( int Xlo, int Ylo)
{
   char color;

   color= getcolor();
   setcolor( EGA_BLACK);
   ShowMouse( AUS);
   line( Xlo, Ylo, Xlo+ 12, Ylo);
   line( Xlo+ 12, Ylo, Xlo+ 12, Ylo+ 12);
   line( Xlo+ 12, Ylo+ 12, Xlo, Ylo+ 12);
   line( Xlo, Ylo+ 12, Xlo, Ylo);
   line( Xlo+ 1, Ylo+ 1, Xlo+ 11, Ylo+ 1);
   line( Xlo+ 11, Ylo+ 1, Xlo+ 11, Ylo+ 11);
   line( Xlo+ 11, Ylo+ 11, Xlo+ 1, Ylo+ 11);
   line( Xlo+ 1, Ylo+ 11, Xlo+ 1, Ylo+ 1);
   ShowMouse( AN);
   setcolor( color);
   While_Klick();
}

int KlickLaufLeiste( int x, int y, int laenge, int min, int max, int step, int *wert, char *format, int left_right)
{
   int xend, balken_pos, maus_x_diff, x_pos_old= -1, x_pos, wert_old,
       X, wert_cmp, zw_wert;
   double runden;
   BYTE _first= 1;
   void *scr_ptr;

   xend= x+ laenge;
   wert_cmp= *wert;
   if( left_right== LEFT)
      X= x;
   else
      X= xend- LAUFLEISTENTASTENBREITE;
   switch( left_right)
   {
      case LEFT:
      case RIGHT:
	 wert_old= *wert<< 1;
	 scr_ptr= ButtonDown( X+ 1, y+ 1, X+ LAUFLEISTENTASTENBREITE- 1, y+ LAUFLEISTENHOEHE- 1);
	 do
	 {
	    LoschTbuf();
	    MouseStat();
	    if( left_right== LEFT)
	    {
	       if(( *wert- step)< min)
		  continue;
	       ( *wert)-= step;
	    }
	    else
	    {
	       if(( *wert+ step)> max)
		  continue;
	       ( *wert)+= step;
	    }
	    ShowMouse( AUS);
	    _LaufLeiste( x, y, laenge, format, *wert, min, max, AN);
	    ShowMouse( AN);
	    if( _first)
	       if( WaitDelay( 600))
		  break;
	    _first= 0;
	 }while(( MStat.buttons!= NOTHING)|| TASTE_GEDRUECKT);
	 ButtonUp( scr_ptr, X+ 1, y+ 1, X+ LAUFLEISTENTASTENBREITE- 1, y+ LAUFLEISTENHOEHE- 1);
	 break;
      case LAUFLEISTENANZEIGE:
	 wert_old= *wert;
	 balken_pos= x+ LAUFLEISTENTASTENBREITE+ LAUFLEISTEN_TASTEN_TEXTABSTAND+ ((( double)( *wert- min)* ( double)( laenge- (( LAUFLEISTENTASTENBREITE+ LAUFLEISTEN_TASTEN_TEXTABSTAND)<< 1)))/ ( double)( max- min));
	 if( balken_pos< ( x+ LAUFLEISTENTASTENBREITE+ LAUFLEISTEN_TASTEN_TEXTABSTAND+ 2))
	    balken_pos= x+ LAUFLEISTENTASTENBREITE+ LAUFLEISTEN_TASTEN_TEXTABSTAND+ 2;
	 else
	 {
	    if( balken_pos> ( xend- LAUFLEISTENTASTENBREITE- LAUFLEISTEN_TASTEN_TEXTABSTAND- 2))
	       balken_pos= xend- LAUFLEISTENTASTENBREITE- LAUFLEISTEN_TASTEN_TEXTABSTAND- 2;
	 }
	 if((( MStat.x>= balken_pos- 2)&& ( MStat.x<= balken_pos+ 2))&& (( scr_ptr= malloc( imagesize( 0, 0, 4, LAUFLEISTENHOEHE- 2)))!= NULL))
	 {
	    ShowMouse( AUS);
	    _LaufLeiste( x, y, laenge, format, *wert, min, max, AUS);
	    ShowMouse( AN);
	    MouseArt( maus_links_rechts);
	    maus_x_diff= MStat.x- ( balken_pos- 2);
	    while( MouseStat()!= NOTHING)
	    {
	       if(( MStat.x>= x+ maus_x_diff+ LAUFLEISTENTASTENBREITE+ LAUFLEISTEN_TASTEN_TEXTABSTAND)&& ( MStat.x<= xend- ( 4- maus_x_diff)- LAUFLEISTENTASTENBREITE- LAUFLEISTEN_TASTEN_TEXTABSTAND))
	       {
		  if( x_pos_old!= ( x_pos= MStat.x+ ( 2- maus_x_diff)))
		  {
		     zw_wert= runden= min+ ((( double)( MStat.x+ ( 2- maus_x_diff)- ( x+ LAUFLEISTENTASTENBREITE+ LAUFLEISTEN_TASTEN_TEXTABSTAND+ 2))* ( double)( max- min))/ ( double)(( xend- LAUFLEISTENTASTENBREITE- LAUFLEISTEN_TASTEN_TEXTABSTAND- 2)- ( x+ LAUFLEISTENTASTENBREITE+ LAUFLEISTEN_TASTEN_TEXTABSTAND+ 2)));
		     if(( runden- ( double)zw_wert)>= ( double)0.5)
			zw_wert++;
		     ShowMouse( AUS);
		     if( !_first)
			putimage( x_pos_old- 2, y+ 1, scr_ptr, COPY_PUT);
		     if( abs( wert_old- zw_wert)>= step)
		     {
			wert_old= *wert= ( zw_wert/ step)* step;
			_LaufLeiste( x, y, laenge, format, *wert, min, max, AUS);
		     }
		     getimage( x_pos- 2, y+ 1, x_pos+ 2, y+ LAUFLEISTENHOEHE- 1, scr_ptr);
		     _first= 0;
		     POS_Zeiger( x_pos, y);
		     ShowMouse( AN);
		     x_pos_old= x_pos;
		  }
		  delay( 10);
	       }
	    }
	    free( scr_ptr);
	    ShowMouse( AUS);
	    _LaufLeiste( x, y, laenge, format, *wert, min, max, AN);
	    ShowMouse( AN);
	    MouseArt( maus_pfeil);
	 }
	 break;
   }
   if( *wert!= wert_cmp)
      return( 1);
   return( 0);                            /* 1== verndert, 0== unverndert */
}

void vert_Anfasser( int x, int y)
{
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   setcolor( EGA_LIGHTGRAY);
   bar( x+ 5, y+ 2, x+ 10, y+ 18);
   putpixel( x+ 4 , y+ 5 , EGA_LIGHTGRAY);
   putpixel( x+ 4 , y+ 15, EGA_LIGHTGRAY);
   putpixel( x+ 11, y+ 5 , EGA_LIGHTGRAY);
   putpixel( x+ 11, y+ 15, EGA_LIGHTGRAY);
   line( x+ 3 , y+ 6 , x+ 4 , y+ 6 );
   line( x+ 3 , y+ 14, x+ 4 , y+ 14);
   line( x+ 11, y+ 6 , x+ 12, y+ 6 );
   line( x+ 11, y+ 14, x+ 12, y+ 14);
   setcolor( EGA_BLACK);
   line( x+ 7 , y    , x    , y+ 7 );
   line( x+ 8 , y    , x+ 15, y+ 7 );
   line( x    , y+ 8 , x+ 4 , y+ 8 );
   line( x+ 15, y+ 8 , x+ 11, y+ 8 );
   line( x+ 4 , y+ 9 , x+ 4 , y+ 11);
   line( x+ 11, y+ 9 , x+ 11, y+ 11);
   line( x    , y+ 12, x+ 4 , y+ 12);
   line( x+ 11, y+ 12, x+ 15, y+ 12);
   line( x,     y+ 13, x+ 7 , y+ 20);
   line( x+ 8 , y+ 20, x+ 15, y+ 13);
   setcolor( EGA_WHITE);
   line( x+ 1 , y+ 7 , x+ 7 , y+ 1 );
   line( x+ 5 , y+ 8 , x+ 5 , y+ 12);
   line( x+ 1 , y+ 13, x+ 5 , y+ 13);
   line( x+ 2 , y+ 14, x+ 7 , y+ 19);
   line( x+ 11, y+ 13, x+ 13, y+ 13);
   setcolor( EGA_DARKGRAY);
   line( x+ 8 , y+ 1 , x+ 13, y+ 6 );
   line( x+ 10, y+ 7 , x+ 14, y+ 7 );
   line( x+ 10, y+ 8 , x+ 10, y+ 13);
   line( x+ 8 , y+ 19, x+ 14, y+ 13);
}

void horiz_Anfasser( int x, int y)
{
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   setcolor( EGA_LIGHTGRAY);
   bar( x+ 2, y+ 5, x+ 18, y+ 10);
   putpixel( x+ 5 , y+ 4 , EGA_LIGHTGRAY);
   putpixel( x+ 15, y+ 4 , EGA_LIGHTGRAY);
   putpixel( x+ 5 , y+ 11, EGA_LIGHTGRAY);
   putpixel( x+ 15, y+ 11, EGA_LIGHTGRAY);
   line( x+ 6 , y+ 3 , x+ 6 , y+ 4 );
   line( x+ 14, y+ 3 , x+ 14, y+ 4 );
   line( x+ 6 , y+ 11, x+ 6 , y+ 12);
   line( x+ 14, y+ 11, x+ 14, y+ 12);
   setcolor( EGA_BLACK);
   line( x,     y+ 7 , x+ 7 , y    );
   line( x+ 8 , y,     x+ 8 , y+ 4 );
   line( x+ 9 , y+ 4 , x+ 11, y+ 4 );
   line( x+ 12, y+ 4 , x+ 12, y    );
   line( x+ 13, y,     x+ 20, y+ 7 );
   line( x+ 20, y+ 8 , x+ 13, y+ 15);
   line( x+ 12, y+ 15, x+ 12, y+ 11);
   line( x+ 11, y+ 11, x+ 9 , y+ 11);
   line( x+ 8 , y+ 11, x+ 8 , y+ 15);
   line( x+ 7 , y+ 15, x,     y+ 8 );
   setcolor( EGA_WHITE);
   line( x+ 7 , y+ 1 , x+ 1 , y+ 7 );
   line( x+ 8 , y+ 5 , x+ 12, y+ 5 );
   line( x+ 13, y+ 1 , x+ 13, y+ 5 );
   line( x+ 13, y+ 11, x+ 13, y+ 13);
   setcolor( EGA_DARKGRAY);
   line( x+ 7 , y+ 2 , x+ 7 , y+ 4 );
   line( x+ 7 , y+ 10, x+ 13, y+ 10);
   line( x+ 13, y+ 14, x+ 19, y+ 8 );
   line( x+ 14, y+ 2 , x+ 19, y+ 7 );
   line( x+ 1 , y+ 8 , x+ 7 , y+ 14);
   line( x+ 7 , y+ 11, x+ 7 , y+ 13);
}

void Proz_Anfasser( MAUSStruct *MS, int x_yproz, RBalken *RB)
{
   setfillstyle( SOLID_FILL, BALKENFARBE);
   if( x_yproz> RB->x_y- 38)
      x_yproz= RB->x_y- 38;
   if( RB->lage== VERT_DIR)
   {
      if( x_yproz< RB->y+ 18)
	 x_yproz= RB->y+ 18;
      if(( x_yproz!= RB->greifx_y)|| ( MS->statsp== INIT)|| ( MS->statsp== REINIT))
      {
	 ShowMouse( AUS);
	 if(( RB->greifx_y> ( RB->y+ 17))&& (( RB->greifx_y+ 20)< ( RB->x_y- 17)))
	    bar( *MS->x+ RB->x+ 1, RB->greifx_y+ *MS->y, *MS->x+ RB->x+ 16, RB->greifx_y+ *MS->y+ 20);
	 vert_Anfasser( *MS->x+ RB->x+ 1, x_yproz+ *MS->y);
	 ShowMouse( AN);
      }
   }
   else
   {
      if( x_yproz< RB->x+ 18)
	 x_yproz= RB->x+ 18;
      if(( x_yproz!= RB->greifx_y)|| ( MS->statsp== INIT)|| ( MS->statsp== REINIT))
      {
	 ShowMouse( AUS);
	 if(( RB->greifx_y> ( RB->x+ 17))&& (( RB->greifx_y+ 20)< ( RB->x_y- 17)))
	    bar( RB->greifx_y+ *MS->x, *MS->y+ RB->y+ 1, RB->greifx_y+ *MS->x+ 20, *MS->y+ RB->y+ 16);
	 horiz_Anfasser( x_yproz+ *MS->x, *MS->y+ RB->y+ 1);
	 ShowMouse( AN);
      }
   }
   RB->greifx_y= x_yproz;
}

void _ViewAnfasser( MAUSStruct *MS, RBalken *RB)
{
   int x_yproz;

   if( RB->lage== VERT_DIR)
   {
      if( RB->maxstep< ( RB->max- RB->min))
	 x_yproz= RB->y+ ( ROLLBALKEN_DICKE+ 1)+ (( double)( RB->proz- RB->min)* ( double)(( RB->x_y- ( ROLLBALKEN_DICKE+ 1+ ANFASSER_LAENGE))- ( RB->y+ ( ROLLBALKEN_DICKE+ 1)))/ ( double)(( RB->max- RB->maxstep)- RB->min));
      else
	 x_yproz= RB->y;
   }
   else
   {
      if( RB->maxstep< ( RB->max- RB->min))
	 x_yproz= RB->x+ ( ROLLBALKEN_DICKE+ 1)+ (( double)( RB->proz- RB->min)* ( double)(( RB->x_y- ( ROLLBALKEN_DICKE+ 1+ ANFASSER_LAENGE))- ( RB->x+ ( ROLLBALKEN_DICKE+ 1)))/ ( double)(( RB->max- RB->maxstep)- RB->min));
      else
	 x_yproz= RB->x;
   }
   Proz_Anfasser( MS, x_yproz, RB);
}

void ViewPG( int X, int Y, int X_Y, int greifx_y, char up_down, char Lage, char an_aus)
{
   int PG_fill[ 12], v_X, v_Y;
   BYTE pattern[]= { 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55};

   if( Lage== VERT_DIR)
   {
      v_X= X;
      v_Y= Y;
   }
   else
   {
      v_X= Y;
      v_Y= X;
   }
   PG_fill[  1- Lage]= v_X+ 1;
   PG_fill[  3- Lage]= v_X+ 16;
   PG_fill[  5- Lage]= v_X+ 16;
   PG_fill[  7- Lage]= v_X+ 9;
   PG_fill[  9- Lage]= v_X+ 8;
   PG_fill[ 11- Lage]= v_X+ 1;
   if( up_down== DOWN)
   {

      PG_fill[ Lage+  0]= X_Y- 18;
      PG_fill[ Lage+  2]= X_Y- 18;
      PG_fill[ Lage+  4]= greifx_y+ 14;
      PG_fill[ Lage+  6]= greifx_y+ 21;
      PG_fill[ Lage+  8]= greifx_y+ 21;
      PG_fill[ Lage+ 10]= greifx_y+ 14;
   }
   else
   {
      PG_fill[ Lage+  0]= v_Y+ 18;
      PG_fill[ Lage+  2]= v_Y+ 18;
      PG_fill[ Lage+  4]= greifx_y+ 6;
      PG_fill[ Lage+  6]= greifx_y- 1;
      PG_fill[ Lage+  8]= greifx_y- 1;
      PG_fill[ Lage+ 10]= greifx_y+ 6;
   }
   ShowMouse( AUS);
   if( an_aus== AN)
   {
      setcolor( EGA_BLACK);
      setfillpattern( pattern, BALKENFARBE);
   }
   else
   {
      setcolor( BALKENFARBE);
      setfillstyle( SOLID_FILL, BALKENFARBE);
      if( Lage== VERT_DIR)
      {
	 bar( X+  1, greifx_y+ 9, X+  4, greifx_y+ 11);
	 bar( X+ 13, greifx_y+ 9, X+ 16, greifx_y+ 11);
      }
      else
      {
	 bar( greifx_y+ 9, Y+  1, greifx_y+ 11, Y+ 4);
	 bar( greifx_y+ 9, Y+ 13, greifx_y+ 11, Y+ 16);
      }
   }
   fillpoly( 6, PG_fill);
   ShowMouse( AN);
}

int KlickRollBalken( MAUSStruct *MS, RBalken *RB, void ( *Zeiger_Funktion)(), int Element)
{
   RBalken _Anfasser;
   int X, Y, X_Y, differenz;
   BOOL Scrolling;
   double runden;

   RB->ret_val= 0;
   Scrolling= ( RB->maxstep< ( RB->max- RB->min));
   X= *MS->x+ RB->x;
   Y= *MS->y+ RB->y;
   _Anfasser.x=        RB->x;
   _Anfasser.y=        RB->y;
   _Anfasser.x_y=      RB->x_y;
   _Anfasser.max=      RB->x_y- 18;
   _Anfasser.lage=     RB->lage;
   _Anfasser.greifx_y= RB->greifx_y;
   if( RB->lage== VERT_DIR)
   {
      X_Y= *MS->y+ RB->x_y;
      _Anfasser.min= RB->y+ 18;
   }
   else
   {
      X_Y= *MS->x+ RB->x_y;
      _Anfasser.min= RB->x+ 18;
   }
   switch( Element)
   {
      case RBALKEN_MINUS_MIN_TASTE:
	 if(( RB->Zeiger_pos- 1)>= 0)
	 {
	    ( *Zeiger_Funktion)( *MS->x, *MS->y, RB->Zeiger_pos, AUS);
	    ( *Zeiger_Funktion)( *MS->x, *MS->y, --RB->Zeiger_pos, AN);
	    RB->ret_val= POINTER_ONE_UP;
	    break;
	 }
      case RBALKEN_MINUS_MIN_MAUS:
	 if( Scrolling)
	 {
	    if( RB->button_flag== 0)
	    {
	       ( *Zeiger_Funktion)( *MS->x, *MS->y, RB->Zeiger_pos, AUS);
	       if( Element== RBALKEN_MINUS_MIN_MAUS)
	       {
		  ShowMouse( AUS);
		  RB->button= ButtonDown( X, Y, X+ 17, Y+ 17);
		  ShowMouse( AN);
		  RB->button_flag= RBALKEN_MINUS_MIN_MAUS;
	       }
	       else
		  RB->button_flag= ZEIGERPOS_AUS;
	    }
	    if( RB->proz!= RB->min)
	    {
	       if(( RB->proz- RB->minstep)>= RB->min)
		  RB->proz-= RB->minstep;
	       else
		  RB->proz= RB->min;
	       _ViewAnfasser( MS, RB);
	       RB->ret_val= ONE_ELEMENT_UP;
	    }
	 }
	 break;
      case RBALKEN_PLUS_MIN_TASTE:
	 if((( RB->Zeiger_pos+ 1)< RB->maxstep)&& (( RB->Zeiger_pos+ 1)< RB->max))
	 {
	    ( *Zeiger_Funktion)( *MS->x, *MS->y, RB->Zeiger_pos, AUS);
	    ( *Zeiger_Funktion)( *MS->x, *MS->y, ++RB->Zeiger_pos, AN);
	    RB->ret_val= POINTER_ONE_DOWN;
	    break;
	 }
      case RBALKEN_PLUS_MIN_MAUS:
	 if( Scrolling)
	 {
	    if( RB->button_flag== 0)
	    {
	       ( *Zeiger_Funktion)( *MS->x, *MS->y, RB->Zeiger_pos, AUS);
	       if( Element== RBALKEN_PLUS_MIN_MAUS)
	       {
		  ShowMouse( AUS);
		  RB->button= ( ( RB->lage== VERT_DIR) ? ButtonDown( X, X_Y- 17, X+ 17, X_Y) : ButtonDown( X_Y- 17, Y, X_Y, Y+ 17));
		  ShowMouse( AN);
		  RB->button_flag= RBALKEN_PLUS_MIN_MAUS;
	       }
	       else
		  RB->button_flag= ZEIGERPOS_AUS;
	    }
	    if( RB->proz!= ( RB->max- RB->maxstep))
	    {
	       if(( RB->proz+ RB->minstep)<= ( RB->max- RB->maxstep))
		  RB->proz+= RB->minstep;
	       else
		  RB->proz= ( RB->max- RB->maxstep);
	       _ViewAnfasser( MS, RB);
	       RB->ret_val= ONE_ELEMENT_DOWN;
	    }
	 }
	 break;
      case RBALKEN_MINUS_MAX:
	 if( Scrolling&& ( RB->proz!= RB->min))
	 {
	    if(( RB->proz- RB->maxstep)>= RB->min)
	       RB->proz-= RB->maxstep;
	    else
	       RB->proz= RB->min;
	    _ViewAnfasser( MS, RB);
	    if( RB->button_flag== RBALKEN_MINUS_MAX)
	       ViewPG( X, Y, X_Y, RB->greifx_y+ ( ( RB->lage== VERT_DIR) ? ( *MS->y) : ( *MS->x)), DOWN, RB->lage, AUS);
	    if( RB->button_flag== 0)
	    {
	       ViewPG( X, Y, X_Y, RB->greifx_y+ ( ( RB->lage== VERT_DIR) ? ( *MS->y) : ( *MS->x)), UP, RB->lage, AN);
	       ( *Zeiger_Funktion)( *MS->x, *MS->y, RB->Zeiger_pos, AUS);
	       RB->button_flag= RBALKEN_MINUS_MAX;
	    }
	    if(( RB->greifx_y+ ( ( RB->lage== VERT_DIR) ? ( *MS->y) : ( *MS->x))+ 10)<= ( ( RB->lage== VERT_DIR) ? ( MStat.y) : ( MStat.x)))
	       while( MouseStat()!= NOTHING)
		  ;
	    RB->ret_val= ELEMENT_RANDOM;
	 }
	 break;
      case RBALKEN_PLUS_MAX:
	 if( Scrolling&& ( RB->proz!= ( RB->max- RB->maxstep)))
	 {
	    if(( RB->proz+ RB->maxstep)< ( RB->max- RB->maxstep))
	       RB->proz+= RB->maxstep;
	    else
	       RB->proz= ( RB->max- RB->maxstep);
	    _ViewAnfasser( MS, RB);
	    if( RB->button_flag== RBALKEN_PLUS_MAX)
	       ViewPG( X, Y, X_Y, RB->greifx_y+ ( ( RB->lage== VERT_DIR) ? ( *MS->y) : ( *MS->x)), UP, RB->lage, AUS);
	    if( RB->button_flag== 0)
	    {
	       ViewPG( X, Y, X_Y, RB->greifx_y+ ( ( RB->lage== VERT_DIR) ? ( *MS->y) : ( *MS->x)), DOWN, RB->lage, AN);
	       ( *Zeiger_Funktion)( *MS->x, *MS->y, RB->Zeiger_pos, AUS);
	       RB->button_flag= RBALKEN_PLUS_MAX;
	    }
	    if(( RB->greifx_y+ ( ( RB->lage== VERT_DIR) ? ( *MS->y) : ( *MS->x))+ 10)>= ( ( RB->lage== VERT_DIR) ? ( MStat.y) : ( MStat.x)))
	       while( MouseStat()!= NOTHING)
		  ;
	    RB->ret_val= ELEMENT_RANDOM;
	 }
	 break;
     case RBALKEN_POS1:
	if( Scrolling&& ( RB->proz!= RB->min))
	{
	   RB->proz= RB->min;
	   _ViewAnfasser( MS, RB);
	   if( RB->button_flag== 0)
	   {
	      ( *Zeiger_Funktion)( *MS->x, *MS->y, RB->Zeiger_pos, AUS);
	      RB->button_flag= ZEIGERPOS_AUS;
	   }
	   RB->ret_val= ELEMENT_RANDOM;
	}
	break;
     case RBALKEN_ENDE:
	if( Scrolling&& ( RB->proz!= ( RB->max- RB->maxstep)))
	{
	   RB->proz= RB->max- RB->maxstep;
	   _ViewAnfasser( MS, RB);
	   if( RB->button_flag== 0)
	   {
	      ( *Zeiger_Funktion)( *MS->x, *MS->y, RB->Zeiger_pos, AUS);
	      RB->button_flag= ZEIGERPOS_AUS;
	   }
	   RB->ret_val= ELEMENT_RANDOM;
	}
	break;
     case RBALKEN_RETURN:
	RB->ret_val= POINTER_RETURN;
	break;
     case RBALKEN_RANDOM:
	if( Scrolling)
	{
	   if( RB->button_flag== 0)
	   {
	      if( RB->lage== VERT_DIR)
		 RB->maus_to_Zeiger_ref= MStat.y- ( RB->greifx_y+ *MS->y);
	      else
		 RB->maus_to_Zeiger_ref= MStat.x- ( RB->greifx_y+ *MS->x);
	      ( *Zeiger_Funktion)( *MS->x, *MS->y, RB->Zeiger_pos, AUS);
	      RB->button_flag= ZEIGERPOS_AUS;
	   }
	   do
	   {
	      if((( MStat.x>= X)&& ( MStat.x<= X+ 20)&& ( RB->lage== VERT_DIR))|| (( MStat.y>= Y)&& ( MStat.y<= Y+ 20)&& ( RB->lage== HORIZ_DIR)))
	      {
		 Proz_Anfasser( MS, ( ( RB->lage== VERT_DIR) ? ( MStat.y) : ( MStat.x))- RB->maus_to_Zeiger_ref- ( ( RB->lage== VERT_DIR) ? ( *MS->y) : ( *MS->x)), &_Anfasser);
		 if( ( RB->max- RB->maxstep)> RB->min)
		 {
		    RB->proz= runden= ( ( RB->lage== VERT_DIR) ? ( RB->min+ ((( double)( _Anfasser.greifx_y- ( _Anfasser.y+ 18))* ( double)( ( RB->max- RB->maxstep)- RB->min))/ ( double)(( _Anfasser.x_y- 38)- ( _Anfasser.y+ 18)))) : ( RB->min+ ((( double)( _Anfasser.greifx_y- ( _Anfasser.x+ 18))* ( double)( ( RB->max- RB->maxstep)- RB->min))/ ( double)(( _Anfasser.x_y- 38)- ( _Anfasser.x+ 18)))));
		    if(( runden- ( double)RB->proz)>= ( double)0.5)
		       RB->proz++;
		 }
		 else
		    RB->proz= RB->min;
		 if(( RB->proz!= RB->proz_sp)&& (( RB->proz>= RB->proz_sp+ RB->minstep)|| ( RB->proz<= RB->proz_sp- RB->minstep)|| ( RB->proz== RB->max- RB->maxstep)|| ( RB->proz== RB->min)))
		 {
		    differenz= ( int)( RB->proz_sp- RB->proz);
		    if( differenz== - RB->minstep)
		    {
		       RB->ret_val= ONE_ELEMENT_DOWN;
		    }
		    else
		    {
		       if( differenz== RB->minstep)
			  RB->ret_val= ONE_ELEMENT_UP;
		       else
			  RB->ret_val= ELEMENT_RANDOM;
		    }
		    RB->button_flag= RBALKEN_RANDOM;
		    break;
		 }
		 delay( 10);
	      }
	   }while( MouseStat()!= NOTHING);
	   RB->greifx_y= _Anfasser.greifx_y;
	}
	break;
   }
   RB->proz_sp= RB->proz;
   return( RB->ret_val);
}

void RBalken_Begin( MAUSStruct *MS, RBalken *RB)
{
   RB->proz=        0L;
   RB->proz_sp=     0L;
   RB->button_flag= 0;
   RB->Zeiger_pos=  0;
   MS->statsp= REINIT;
}

char *MakeShowPath( char *path, char *showpath, int maxlaenge) /* funktioniert bei Dateien und Gruppen */
{
   int laenge, len;
   char *ptr;

   if(( laenge= strlen( path))> maxlaenge)
   {
      strncpy( showpath, path, len= strchr( path, '\\')- path+ 1);
      strcpy( showpath+ len, "...");
      if(( ptr= strchr( path+ ( laenge- ( maxlaenge- ( len+ 4))), '\\'))!= NULL)
	 strcpy( showpath+ len+ 3, ptr);
      else
	 *( strncpy( showpath+ len+ 3, strrchr( path, '\\'), maxlaenge- ( len+ 3))+ maxlaenge- ( len+ 3))= '\0';
   }
   else
      strcpy( showpath, path);
   return( showpath);
}

int _EntryInPullTable( char *tab_ptr[], int maxentrys, char *entry, BOOL ignoreCase)
{
   int i, l;
   char *ptr;

   for( i= --maxentrys; i>= 0; i--)
   {
      if( ignoreCase)
      {
	 if( stricmp( tab_ptr[ i], entry)== 0)
	    break;
      }
      else
      {
	 if( strcmp( tab_ptr[ i], entry)== 0)
	    break;
      }
   }
   if( i< 0)
      i= maxentrys;
   ptr= tab_ptr[ i];
   for( l= i; l> 0; l--)
      tab_ptr[ l]= tab_ptr[ l- 1];
   strcpy( tab_ptr[ 0]= ptr, entry);
   return( i>= 0);                      /* 1 -> Eintrag war schon vorhanden */
}

void PullDown_Balken( int X, int Y, int X_length, int Balken_pos)
{
   int y;

   y= Y+ 4+ Balken_pos* 14;
   setcolor( 0x08);
   setlinestyle( SOLID_LINE, 0, THICK_WIDTH);
   setwritemode( XOR_PUT);
   ShowMouse( AUS);
   line( X+ 3, y,    X+ X_length- 3, y   );
   line( X+ 3, y+ 3, X+ X_length- 3, y+ 3);
   line( X+ 3, y+ 6, X+ X_length- 3, y+ 6);
   ShowMouse( AN);
   setlinestyle( SOLID_LINE, 0, NORM_WIDTH);
   setwritemode( COPY_PUT);
}

int PullDown( int x, int y, int laenge, char *menutext[], int menuanz, WORD Mode)
{
   saveall sa;
   int yend, xend, i, taste, status= -1, ret= 0, Balken_pos= 0, Balken_posSP= 1;
   char tmp_array[ 81];

   yend= y+ ( menuanz* 14);
   xend= x+ laenge;
   ShowMouse( AUS);
   BigScreenSave( &sa, x, y, xend+ 1, yend+ 1);
   setfillstyle( SOLID_FILL, EGA_LIGHTGRAY);
   bar( x, y, xend, yend);
   setcolor( 0x08);
   setwritemode( XOR_PUT);
   line( xend+ 1, y+ 1, xend+ 1, yend+ 1);
   line( x+ 1, yend+ 1, xend, yend+ 1);
   setwritemode( COPY_PUT);
   setcolor( EGA_DARKGRAY);
   line( xend, y, xend, yend);
   line( x, yend, xend, yend);
   setcolor( EGA_WHITE);
   line( x, y, x, yend);
   line( x, y, xend, y);

   setcolor( EGA_BLACK);

   for( i= 0; ( i< menuanz)&& ( menutext[ i]!= NULL); i++)
   {
      if( Mode& VERZEICHNIS)
	 outtextxy( x+ 7, y+ 4+ i* 14, MakeShowPath( menutext[ i], tmp_array, ( laenge- 14)>> 3));
      else
	 OutTextN( x+ 7, y+ 4+ i* 14, menutext[ i], ( laenge- 14)>> 3);
   }
   ShowMouse( AN);

   MouseMove();

   do
   {
      if( Balken_posSP!= Balken_pos)
      {
	 if(( *menutext[ Balken_pos]!= '\0')&& ( menutext[ Balken_pos]!= NULL))
	    PullDown_Balken( x, y, laenge, Balken_pos);
	 Balken_posSP= Balken_pos;
      }
      while(( MouseStat()== NOTHING)&& !MouseMove()&& ( !kbhit()))
	 ;

      if( kbhit())
      {
	 switch( taste= getch())
	 {
	    case 0:
	       switch( taste= getch())
	       {
		  case CURSOR_UP& EXTENDED_FILTER:
		     if( Balken_pos> 0)
			Balken_pos--;
		     break;
		  case CURSOR_DOWN& EXTENDED_FILTER:
		     if(( *menutext[ Balken_pos+ 1]!= '\0')&& ( menutext[ Balken_pos+ 1]!= NULL)&& (( Balken_pos+ 1)< menuanz))
			Balken_pos++;
		     break;
		  case HOME& EXTENDED_FILTER:
		     Balken_pos= 0;
		     break;
		  case END& EXTENDED_FILTER:
		     for( i= 0; i< menuanz; i++)
			if(( *menutext[ i]== '\0')|| ( menutext[ i]== NULL))
			   break;
		     Balken_pos= i- 1;
		     break;
		  default:
		     extended_ungetch( taste);
		     ret= 1;
		     break;
	       }
	       break;
	    case RETURN:
	       status= Balken_pos;
	       ret= 1;
	       break;
	    default:
	       ungetch( taste);
	    case ESC:
	       ret= 1;
	       break;
	 }
      }
      else
      {
	 if(( MStat.x> x)&& ( MStat.x< xend)&& ( MStat.y>= ( y+ 3))&& ( MStat.y< ( yend- 1)))
	 {
	    status= ( MStat.y- ( y+ 3))/ 14;

	    if( ( status>= 0) &&( status< menuanz))
	       Balken_pos= status;
	 }
	 if( MouseStat()!= NOTHING)
	 {
	    while( MouseStat()!= NOTHING)
	       ;

	    ret= 1;
	    break;
	 }
      }

      if( Balken_posSP!= Balken_pos)
	 if(( *menutext[ Balken_posSP]!= '\0')&& ( menutext[ Balken_posSP]!= NULL))
	    PullDown_Balken( x, y, laenge, Balken_posSP);

   }while( !ret);
   ShowMouse( AUS);
   BigScreenRestore( &sa, x, y);
   ShowMouse( AN);
   if(( *menutext[ status]== '\0')|| ( menutext[ status]== NULL))
      status= -1;
   return( status);
}

int Klick_Input_Table( MAUSStruct *MS, int index, int ptr_index, int status)
{
   int ret_val= 1, ret;
   WORD input_ret= 0, Mode= 0;
   char tmp_array[ 200];

   if( status== INPUTZEILE)
   {
      assert( sizeof( tmp_array)> MS->mauspos[ index+ 4]);
      strcpy( tmp_array, (( char **)MS->arg_ptr[ ptr_index])[ 0]);
      if(( input_ret= _Input( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, MS->mauspos[ index+ 3]- INPUT_TABLE_PULL_DOWN, tmp_array, MS->mauspos[ index+ 4], MS->mauspos[ index]& CODE_FILTER, ( MS->mauspos[ index]& IGN_CASE)!= 0 ))& INPUT_VERAENDERT)
      {
	 _EntryInPullTable( MS->arg_ptr[ ptr_index], MS->mauspos[ index+ 5], tmp_array, ( MS->mauspos[ index]& IGN_CASE)!= 0 );
	 ret_val= 0;
      }
   }
   if(( status== PULL_DOWN_TABLE)|| ( input_ret& INPUT_PULLDOWN))
   {
      if( KlickButton( MS->mauspos[ index+ 1]+ MS->mauspos[ index+ 3]- INPUT_TABLE_PULL_DOWN+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, MS->mauspos[ index+ 1]+ MS->mauspos[ index+ 3]+ *MS->x, MS->mauspos[ index+ 2]+ INPUTZEILENHOEHE+ *MS->y))
      {
	 switch( MS->mauspos[ index]& CODE_FILTER)
	 {
	    case FILE_INPUT_TABLE:
	    case DIR_INPUT_TABLE:
	       Mode|= VERZEICHNIS| ( ( MS->mauspos[ index]& IGN_CASE) ? IGNORE_CASE : 0);
	 }
	 if(( ret= PullDown( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ INPUTZEILENHOEHE+ *MS->y+ 1, MS->mauspos[ index+ 3], MS->arg_ptr[ ptr_index], MS->mauspos[ index+ 5], Mode))> 0)  /* Abbruch oder Element gewhlt, welches schon in der Inputzeile steht */
	 {
	    ShowMouse( AUS);
	    InitInputLine( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, MS->mauspos[ index+ 3]- INPUT_TABLE_PULL_DOWN, (( char **)MS->arg_ptr[ ptr_index])[ ret]);
	    ShowMouse( AN);
	    _EntryInPullTable( MS->arg_ptr[ ptr_index], MS->mauspos[ index+ 5], (( char **)MS->arg_ptr[ ptr_index])[ ret], ( MS->mauspos[ index]& IGN_CASE)!= 0 );
	    ret_val= 0;
	 }
      }
   }
   return( ret_val);
}

int Klick_Table( MAUSStruct *MS, int index, int ptr_index)
{
   int ret_val= 1, ret;

   if( KlickButton( MS->mauspos[ index+ 1]+ MS->mauspos[ index+ 3]- INPUT_TABLE_PULL_DOWN+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, MS->mauspos[ index+ 1]+ MS->mauspos[ index+ 3]+ *MS->x, MS->mauspos[ index+ 2]+ INPUTZEILENHOEHE+ *MS->y))
      if((( ret= PullDown( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ INPUTZEILENHOEHE+ *MS->y+ 1, MS->mauspos[ index+ 3], MS->arg_ptr[ ptr_index], MS->mauspos[ index+ 4], MS->mauspos[ index+ 5]))>= 0)&& ( *( BYTE *)MS->arg_ptr[ ptr_index+ 1]!= ret))
      {
	 ShowMouse( AUS);
	 InitKlick_Table( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, MS->mauspos[ index+ 3], *( ( char **)MS->arg_ptr[ ptr_index]+ ( *( BYTE *)MS->arg_ptr[ ptr_index+ 1]= ret)));
	 ShowMouse( AN);
	 ret_val= 0;
      }
   return( ret_val);
}

void InitElemente( MAUSStruct *MS, int index, int ptr_index)
{
   if( !(( MS->mauspos[ index]& _IF)&& !*( BOOL *)MS->arg_ptr[ ptr_index]))
   {
      if( MS->mauspos[ index]& _IF)
	 ptr_index++;
      switch( MS->mauspos[ index]& CODE_FILTER)
      {
	 case ROLLBALKEN:
	    if( MS->statsp== INIT)
	    {
	       ( *( RBalken *)MS->arg_ptr[ ptr_index]).proz=        0L;
	       ( *( RBalken *)MS->arg_ptr[ ptr_index]).proz_sp=     0L;
	       ( *( RBalken *)MS->arg_ptr[ ptr_index]).button_flag= 0;
	       ( *( RBalken *)MS->arg_ptr[ ptr_index]).Zeiger_pos=  0;
	       ( *( RBalken *)MS->arg_ptr[ ptr_index]).greifx_y=    -1;  /* Balkenpfeilkoordinaten auerhalb des Bildschirms setzen */
	    }
	    _ViewAnfasser( MS, MS->arg_ptr[ ptr_index]);
	    ( ( void (*)())MS->arg_ptr[ ptr_index+ 1])( *MS->x, *MS->y, ( *( RBalken *)MS->arg_ptr[ ptr_index]).Zeiger_pos, AN);
	    break;
	 case RADIOBUTTON:
	    if( ( char)MS->mauspos[ index+ 3]== *( char *)MS->arg_ptr[ ptr_index])
	    {
	       ShowMouse( AUS);
	       RadioButton( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, AN);
	       ShowMouse( AN);
	    }
	    break;
	 case CHECKBOX:
	    ShowMouse( AUS);
	    CheckBox( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, *( char *)MS->arg_ptr[ ptr_index]);
	    ShowMouse( AN);
	    break;
	 case LAUFLEISTE:
	    ShowMouse( AUS);
	    _LaufLeiste( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, MS->mauspos[ index+ 3], ( char *)MS->arg_ptr[ ptr_index], *( int *)MS->arg_ptr[ ptr_index+ 1], MS->mauspos[ index+ 4], MS->mauspos[ index+ 5], AN);
	    ShowMouse( AN);
	    break;
	 case FILEINPUT:
	    if( MS->statsp== INIT)
	    {
	       if( MS->dup_flag& DUP_FILEINPUT)
		  MS->duplicate|= DUP_FILEINPUT;
	       MS->dup_flag|= DUP_FILEINPUT;
	       MS->intern_Tasten[ MS->anz_intern_Tasten  ][ TASTENKOMBINATION]= DATEIAUSWAHLBOX_TASTE;
	       MS->intern_Tasten[ MS->anz_intern_Tasten  ][ MAUSPOSINDEX     ]= index;
	       MS->intern_Tasten[ MS->anz_intern_Tasten  ][ ARGPOINTERINDEX  ]= ptr_index;
	       MS->intern_Tasten[ MS->anz_intern_Tasten++][ POS_AT_ELEMENT   ]= DATEIAUSWAHLBOX_RET;
	       assert( MS->anz_intern_Tasten< MAX_INTERN_TASTEN);
	    }
	    goto L_INPUT;
	 case DIRINPUT:
	    if( MS->statsp== INIT)
	    {
	       if( MS->dup_flag& DUP_DIRINPUT)
		  MS->duplicate|= DUP_DIRINPUT;
	       MS->dup_flag|= DUP_DIRINPUT;
	       MS->intern_Tasten[ MS->anz_intern_Tasten  ][ TASTENKOMBINATION]= VERZEICHNISBAUM_TASTE;
	       MS->intern_Tasten[ MS->anz_intern_Tasten  ][ MAUSPOSINDEX     ]= index;
	       MS->intern_Tasten[ MS->anz_intern_Tasten  ][ ARGPOINTERINDEX  ]= ptr_index;
	       MS->intern_Tasten[ MS->anz_intern_Tasten++][ POS_AT_ELEMENT   ]= VERZEICHNISBAUM_RET;
	       assert( MS->anz_intern_Tasten< MAX_INTERN_TASTEN);
	    }
	 case INPUT:
	 case FILEINPUTNOBOX:
	 case DIRINPUTNOBOX:
	    L_INPUT:
	    ;
	    ShowMouse( AUS);
	    InitInputLine( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, MS->mauspos[ index+ 3], ( char *)MS->arg_ptr[ ptr_index]);
	    ShowMouse( AN);
	    break;
	 case INPUT_TABLE:
	 case FILE_INPUT_TABLE:
	 case DIR_INPUT_TABLE:
	    ShowMouse( AUS);
	    InitInputLine( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, MS->mauspos[ index+ 3]- INPUT_TABLE_PULL_DOWN, *( char **)MS->arg_ptr[ ptr_index]);
	    ShowMouse( AN);
	    break;
	 case KLICK_TABLE:
	    ShowMouse( AUS);
	    InitKlick_Table( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, MS->mauspos[ index+ 3], *( ( char **)MS->arg_ptr[ ptr_index]+ *( BYTE *)MS->arg_ptr[ ptr_index+ 1]));
	    ShowMouse( AN);
	    break;
      }
   }
}

unsigned Taste_Umformen( unsigned Taste, WORD Sondertaste)
{
   Taste&= EXTENDED_FILTER;
   if( Sondertaste& ALT_PRESS)
      Taste&= ALT_FILTER;
   if( Sondertaste& STRG_PRESS)
      Taste&= STRG_FILTER;
   if(( Sondertaste& SHIFTLEFT_PRESS)|| ( Sondertaste& SHIFTRIGHT_PRESS))
      Taste&= SHIFT_FILTER;
   return( Taste);
}

int GetElementofArt( MAUSStruct *MS, WORD Elementeart, int Teilelement, int *array_index, int *ptr_index)
{
   ElementInfo EInfo;
   int i, l, taste, Sondertaste;

   while( 1)
   {
      do
      {
	 Clock();
      }
      while(( MouseStat()== NOTHING)&& ( !( taste= kbhit())));
      if( !taste)
      {
	 for( i= 0, *array_index= 0, *ptr_index= 0; i< MS->spotanz; i++, *ptr_index+= EInfo.zeiger)
	 {
	    if((( MS->mauspos[ *array_index]& CODE_FILTER)== Elementeart)&& ( Is_Mouse_at_Element( MS, *array_index, *ptr_index)== Teilelement))
	       return( 0);
	    *array_index+= Anzahl_Eintraege_pro_Typ( MS->mauspos[ *array_index], &EInfo);
	 }
      }
      else
      {
	 if(( taste= getch())== 0)                    /* erweiterter Code ? */
	 {
	    Sondertaste= _bios_keybrd( _NKEYBRD_SHIFTSTATUS);
	    switch( taste= getch())             /* erweiterter Tastaturcode */
	    {
	       case SHIFT_TAB& EXTENDED_FILTER:
		  ElementeRahmen( MS, ONLY_FRAME, BACKWARD);
		  break;
	    }
	 }
	 else
	 {
	    switch( taste)
	    {
	       case ESC:
		  return( -1);
	       case TAB:
		  ElementeRahmen( MS, ONLY_FRAME, FORWARD);
		  break;
	       case STRG_RETURN:
		  if(( MS->mauspos[ MS->framesp]& CODE_FILTER)== Elementeart)
		  {
		     *array_index= MS->framesp;
		     *ptr_index=   MS->frame_ptr_sp;
		     return( 0);
		  }
		  break;
	    }
	 }
	 for( i= 0, *array_index= 0, *ptr_index= 0; i< MS->spotanz; i++, *array_index+= EInfo.WORDS_pro_Element, *ptr_index+= EInfo.zeiger)
	 {
	    Anzahl_Eintraege_pro_Typ( MS->mauspos[ *array_index], &EInfo);
	    if(( MS->mauspos[ *array_index]& KEY)&& ( !(( MS->mauspos[ *array_index]& _IF)&& !*( BOOL *)MS->arg_ptr[ *ptr_index]))) /* Tastenkombination vorhanden */
	    {
	       for( l= EInfo.tasten; l> 0; l--)/* wieviel Tasten hat Element ? */
	       {
		  if((( MS->mauspos[ *array_index]& CODE_FILTER)== Elementeart)&& ( taste== Taste_Umformen( MS->mauspos[ *array_index+ EInfo.WORDS_pro_Element- l], Sondertaste)))
		     return( 0);
	       }
	    }
	 }
      }
   }
}

int MakeKlick( MAUSStruct *MS, int index, int ptr_index, int status, char Eingabe)
{
   ElementInfo EInfo;
   int i, ret_val= 0, array_index, arg_ptr_index, Art;
   char tmp_array[ MAXPATH];

   if( !(( MS->mauspos[ index]& _IF)&& !*( BOOL *)MS->arg_ptr[ ptr_index]))
   {
      if( MS->mauspos[ index]& _IF)
	 ptr_index++;
      switch( Art= MS->mauspos[ index]& CODE_FILTER)
      {
	 case TASTE:
	    While_Klick();
	    break;
	 case ROLLBALKEN:
	    KlickRollBalken( MS, MS->arg_ptr[ ptr_index], ( void (*)())MS->arg_ptr[ ptr_index+ 1], status);
	    break;
	 case DOUBLE_KLICKAREA:
	    if( Eingabe== MAUS)
	    {
	       While_Klick();
	       delay( klickwait);                    /* Doppelklickzeit warten */
	       if( !(( MouseStat()!= NOTHING)&& Is_Mouse_at_Element( MS, index, ptr_index))) /* ist Maus nicht mehr auf dem Element ? */
		  ret_val= 1;
	    }
	 case KLICKAREA:
	    While_Klick();
	    break;
	 case RADIOBUTTON:
	    KlickRadioButton( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y);
	    ShowMouse( AUS);
	    RadioButton( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, AN);
	    for( i= 0, array_index= 0, arg_ptr_index= 0; i< MS->spotanz; i++, arg_ptr_index+= EInfo.zeiger)
	    {
	       if((( MS->mauspos[ array_index]& CODE_FILTER)== RADIOBUTTON)&& ( MS->arg_ptr[ ptr_index]== MS->arg_ptr[ arg_ptr_index])&& ( array_index!= index))
		  RadioButton( MS->mauspos[ array_index+ 1]+ *MS->x, MS->mauspos[ array_index+ 2]+ *MS->y, AUS);
	       array_index+= Anzahl_Eintraege_pro_Typ( MS->mauspos[ array_index], &EInfo);
	    }
	    ShowMouse( AN);
	    *( char *)MS->arg_ptr[ ptr_index]= ( char)MS->mauspos[ index+ 3];
	    break;
	 case CHECKBOX:
	    KlickCheckBox( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y);
	    ( *( char *)MS->arg_ptr[ ptr_index]== AN) ? ( *( char *)MS->arg_ptr[ ptr_index]= AUS) : ( *( char *)MS->arg_ptr[ ptr_index]= AN);
	    ShowMouse( AUS);
	    CheckBox( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, *( char *)MS->arg_ptr[ ptr_index]);
	    ShowMouse( AN);
	    break;
	 case BUTTON:
	    if( !KlickButton( MS->mauspos[ index+ 1]+ *MS->x+ 1, MS->mauspos[ index+ 3]+ *MS->y+ 1, MS->mauspos[ index+ 2]+ *MS->x- 1, MS->mauspos[ index+ 4]+ *MS->y- 1))
	       ret_val= 1;
	    break;
	 case BUTTON2:
	    if( !KlickButton( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 3]+ *MS->y, MS->mauspos[ index+ 2]+ *MS->x, MS->mauspos[ index+ 4]+ *MS->y))
	       ret_val= 1;
	    break;
	 case BUTTON3:
	    if( !KlickButton( MS->mauspos[ index+ 1]+ *MS->x- 1, MS->mauspos[ index+ 3]+ *MS->y- 1, MS->mauspos[ index+ 2]+ *MS->x+ 1, MS->mauspos[ index+ 4]+ *MS->y+ 1))
	       ret_val= 1;
	    break;
	 case LAUFLEISTE:
	    if( !KlickLaufLeiste( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, MS->mauspos[ index+ 3], MS->mauspos[ index+ 4], MS->mauspos[ index+ 5], MS->mauspos[ index+ 6], ( int *)MS->arg_ptr[ ptr_index+ 1], ( char *)MS->arg_ptr[ ptr_index], status))
	       ret_val= 1;
	    break;
	 case FILEINPUT:
	    if( status== DATEIAUSWAHLBOX_RET)
	    {
	       if( KlickButton( MS->mauspos[ index+ 5]+ *MS->x+ 1, MS->mauspos[ index+ 6]+ *MS->y+ 1, MS->mauspos[ index+ 5]+ DATEIAUSWAHLBOXBUTTON_X_LAENGE+ *MS->x- 1, MS->mauspos[ index+ 6]+ DATEIAUSWAHLBOXBUTTON_Y_LAENGE+ *MS->y- 1))
	       {
		  if( !LwBox( ( int *)MS->arg_ptr[ ptr_index+ 1], ( int *)MS->arg_ptr[ ptr_index+ 2], ( int)MS->mauspos[ index+ 7], ( char *)MS->arg_ptr[ ptr_index+ 3], tmp_array))
		  {
		     if( MS->duplicate& DUP_FILEINPUT)
		     {
			MouseArt( maus_nach);
			PrintStatus( "Welches Eingabefeld soll den Suchweg erhalten ? (ESC-Abbruch)");
			if( !GetElementofArt( MS, FILEINPUT, INPUTZEILE, &array_index, &arg_ptr_index))
			{
			   strcpy( ( char *)MS->arg_ptr[ arg_ptr_index], tmp_array);
			   ShowMouse( AUS);
			   InitInputLine( MS->mauspos[ array_index+ 1]+ *MS->x, MS->mauspos[ array_index+ 2]+ *MS->y, MS->mauspos[ array_index+ 3], ( char *)MS->arg_ptr[ arg_ptr_index]);
			   ShowMouse( AN);
			}
			MouseArt( maus_pfeil);
			ClearStatus();
		     }
		     else
		     {
			strcpy( ( char *)MS->arg_ptr[ ptr_index], tmp_array);
			ShowMouse( AUS);
			InitInputLine( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, MS->mauspos[ index+ 3], ( char *)MS->arg_ptr[ ptr_index]);
			ShowMouse( AN);
		     }
		  }
		  else
		     ret_val= 1;
	       }
	       else
		  ret_val= 1;
	       break;
	    }
	    goto L_INPUT;
	 case DIRINPUT:
	    if( status== VERZEICHNISBAUM_RET)
	    {
	       if( KlickButton( MS->mauspos[ index+ 5]+ *MS->x+ 1, MS->mauspos[ index+ 6]+ *MS->y+ 1, MS->mauspos[ index+ 5]+ VERZEICHNISBAUMBUTTON_X_LAENGE+ *MS->x- 1, MS->mauspos[ index+ 6]+ VERZEICHNISBAUMBUTTON_Y_LAENGE+ *MS->y- 1))
	       {
		  if( !ShowTree( tmp_array, ( int *)MS->arg_ptr[ ptr_index+ 1], ( int)MS->mauspos[ index+ 7]))
		  {
		     if( MS->duplicate& DUP_DIRINPUT)
		     {
			MouseArt( maus_nach);
			PrintStatus( "Welches Eingabefeld soll das Verzeichnis erhalten ? (ESC-Abbruch)");
			if( !GetElementofArt( MS, DIRINPUT, INPUTZEILE, &array_index, &arg_ptr_index))
			{
			   strcpy( ( char *)MS->arg_ptr[ arg_ptr_index], tmp_array);
			   ShowMouse( AUS);
			   InitInputLine( MS->mauspos[ array_index+ 1]+ *MS->x, MS->mauspos[ array_index+ 2]+ *MS->y, MS->mauspos[ array_index+ 3], ( char *)MS->arg_ptr[ arg_ptr_index]);
			   ShowMouse( AN);
			}
			MouseArt( maus_pfeil);
			ClearStatus();
		     }
		     else
		     {
			strcpy( ( char *)MS->arg_ptr[ ptr_index], tmp_array);
			ShowMouse( AUS);
			InitInputLine( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, MS->mauspos[ index+ 3], ( char *)MS->arg_ptr[ ptr_index]);
			ShowMouse( AN);
		     }
		  }
		  else
		     ret_val= 1;
	       }
	       else
		  ret_val= 1;
	       break;
	    }
	 case INPUT:
	 case FILEINPUTNOBOX:
	 case DIRINPUTNOBOX:
	    L_INPUT:
	    ;
	    if(( ( ( i= _Input( MS->mauspos[ index+ 1]+ *MS->x, MS->mauspos[ index+ 2]+ *MS->y, MS->mauspos[ index+ 3], ( char *)MS->arg_ptr[ ptr_index], MS->mauspos[ index+ 4], Art, ( MS->mauspos[ index]& IGN_CASE)!= 0 ))& FUNC_RETURN)&& ( MS->mauspos[ index]& RETURN_INPUT))|| ( !( MS->mauspos[ index]& RETURN_INPUT)&& ( i& INPUT_VERAENDERT)))
	    {
	    }
	    else
	       ret_val= 1;
	    break;
	 case INPUT_TABLE:
	 case FILE_INPUT_TABLE:
	 case DIR_INPUT_TABLE:
	    ret_val= Klick_Input_Table( MS, index, ptr_index, status);
	    break;
	 case KLICK_TABLE:
	    ret_val= Klick_Table( MS, index, ptr_index);
	    break;
      }
   }
   return( ret_val);
}

void ButtonRahmen( int Xl, int Yo, int Xr, int Yu, char an_aus)
{
   char color;

   color= getcolor();
   if( an_aus== AN)
   {
      setcolor( EGA_BLACK);
      rectangle( Xl, Yo, Xr, Yu);
   }
   else
   {
      setcolor( EGA_WHITE);
      line( Xl, Yu, Xr, Yu);
      line( Xr, Yu, Xr, Yo);
      setcolor( EGA_DARKGRAY);
      line( Xl, Yo, Xl, Yu);
      line( Xl, Yo, Xr, Yo);
   }
   setcolor( color);
}

void CheckBoxRahmen( int Xlo, int Ylo, char an_aus)
{
   char color;

   color= getcolor();
   if( an_aus== AN)
      setcolor( EGA_BLACK);
   else
      setcolor( EGA_LIGHTGRAY);
   rectangle( Xlo- 1, Ylo- 1, Xlo+ 13, Ylo+ 13);
   setcolor( color);
}

void ButtonAreaRahmen( int Xl, int Yo, int Xr, int Yu, char an_aus)
{
   char color;

   color= getcolor();
   setcolor( ( an_aus== AN) ? EGA_BLACK : EGA_LIGHTGRAY);
   rectangle( Xl- 1, Yo- 1, Xr+ 1, Yu+ 1);
   setcolor( color);
}

void RadioButtonRahmen( int Xm, int Ym, char an_aus)
{
   char color;

   color= getcolor();
   if( an_aus== AN)
      setcolor( EGA_BLACK);
   else
      setcolor( EGA_LIGHTGRAY);
   line( Xm+ 1, Ym- 7, Xm+ 8, Ym);
   line( Xm+ 8, Ym, Xm, Ym+ 8);
   line( Xm, Ym- 8, Xm- 8, Ym);
   line( Xm- 8, Ym, Xm- 1, Ym+ 7);
   line( Xm+ 1, Ym- 6, Xm+ 7, Ym);
   line( Xm+ 7, Ym, Xm, Ym+ 7);
   line( Xm, Ym- 7, Xm- 7, Ym);
   line( Xm- 7, Ym, Xm- 1, Ym+ 6);
   setcolor( color);
}

void LaufLeisteRahmen( int X, int Yo, int laenge, int pos, char an_aus)
{
   int Xl, Xr, Yu;
   char color;

   color= getcolor();
   if( pos== LEFT)                                           /* linke Taste */
   {
      Xr= X+ LAUFLEISTENTASTENBREITE;
      Xl= X;
   }
   else                                                     /* rechte Taste */
   {
      Xr= X+ laenge;
      Xl= Xr- LAUFLEISTENTASTENBREITE;
   }
   Yu= Yo+ LAUFLEISTENHOEHE;
   if( an_aus== AN)
   {
      setcolor( EGA_BLACK);
      rectangle( Xl, Yo, Xr, Yu);
   }
   else
   {
      setcolor( EGA_WHITE);
      line( Xl, Yu, Xr, Yu);
      line( Xr, Yu, Xr, Yo);
      setcolor( EGA_DARKGRAY);
      line( Xl, Yo, Xl, Yu);
      line( Xl, Yo, Xr, Yo);
   }
   setcolor( color);
}

void RollbalkenRahmen( int x, int y, int x_ref, int y_ref, int x_y_ref, char lage, int Einzelelement, char an_aus)
{
   int X, Y, X_Y;
   char color;

   color= getcolor();
   if( an_aus== AN)
      setcolor( EGA_BLACK);
   else
      setcolor( EGA_LIGHTGRAY);
   X= x+ x_ref;
   Y= y+ y_ref;
   if( lage== VERT_DIR)
   {
      X_Y= y+ x_y_ref;
      switch( Einzelelement)
      {
	 case 1:                                                   /* - min */
	    line( X-  1, Y+ 17, X-  1, Y-  1);
	    line( X    , Y-  1, X+ 17, Y-  1);
	    line( X+ 18, Y-  1, X+ 18, Y+ 17);
	    break;
	 case 2:                                                   /* + min */
	    line( X-  1, X_Y- 17, X-  1, X_Y+  1);
	    line( X    , X_Y+  1, X+ 17, X_Y+  1);
	    line( X+ 18, X_Y+  1, X+ 18, X_Y- 17);
	    break;
      }
   }
   setcolor( color);
}

int ElementeRahmen( MAUSStruct *MS, char modus, char direction)
{
   ElementInfo EInfo;
   int old_framesp, x_length;
   char *input_ptr, an_aus, ret_val= 1, endlos= 2, tmp_flag= 0;

   (( MS->statsp== INIT)|| ( direction== ANZEIGE)) ? ( an_aus= AN) : ( an_aus= AUS);
   ShowMouse( AUS);
   for( ; an_aus<= AN; an_aus++)
   {
      if( an_aus== AN)
      {
	 if( MS->statzeile== AN)
	 {
	    if( MS->mauspos[ MS->framesp]& MSG)
	       PrintStatus( MS->msg[ MS->frame_msg_sp& AFTER_INIT_FILTER]);
	    else
	       ClearStatus();
	 }
      }
      if( MS->mauspos[ MS->framesp]& _IF)
	 MS->frame_ptr_sp++;
      switch( MS->mauspos[ MS->framesp]& CODE_FILTER)
      {
	 case ROLLBALKEN:
	    RollbalkenRahmen( *MS->x, *MS->y, ( *( RBalken *)MS->arg_ptr[ MS->frame_ptr_sp]).x, ( *( RBalken *)MS->arg_ptr[ MS->frame_ptr_sp]).y, ( *( RBalken *)MS->arg_ptr[ MS->frame_ptr_sp]).x_y, ( *( RBalken *)MS->arg_ptr[ MS->frame_ptr_sp]).lage, MS->frame_pos_at_element, an_aus);
	    break;
	 case DOUBLE_KLICKAREA:
	 case KLICKAREA:
	 case BUTTON2:
	    ButtonAreaRahmen( MS->mauspos[ MS->framesp+ 1]+ *MS->x, MS->mauspos[ MS->framesp+ 3]+ *MS->y, MS->mauspos[ MS->framesp+ 2]+ *MS->x, MS->mauspos[ MS->framesp+ 4]+ *MS->y, an_aus);
	    break;
	 case BUTTON:
	    ButtonRahmen( MS->mauspos[ MS->framesp+ 1]+ *MS->x, MS->mauspos[ MS->framesp+ 3]+ *MS->y, MS->mauspos[ MS->framesp+ 2]+ *MS->x, MS->mauspos[ MS->framesp+ 4]+ *MS->y, an_aus);
	    break;
	 case BUTTON3:
	    ButtonAreaRahmen( MS->mauspos[ MS->framesp+ 1]+ *MS->x+ 2, MS->mauspos[ MS->framesp+ 3]+ *MS->y+ 2, MS->mauspos[ MS->framesp+ 2]+ *MS->x- 2, MS->mauspos[ MS->framesp+ 4]+ *MS->y- 2, an_aus);
	    break;
	 case RADIOBUTTON:
	    RadioButtonRahmen( MS->mauspos[ MS->framesp+ 1]+ *MS->x, MS->mauspos[ MS->framesp+ 2]+ *MS->y, an_aus);
	    break;
	 case CHECKBOX:
	    CheckBoxRahmen( MS->mauspos[ MS->framesp+ 1]+ *MS->x, MS->mauspos[ MS->framesp+ 2]+ *MS->y, an_aus);
	    break;
	 case LAUFLEISTE:
	    LaufLeisteRahmen( MS->mauspos[ MS->framesp+ 1]+ *MS->x, MS->mauspos[ MS->framesp+ 2]+ *MS->y, MS->mauspos[ MS->framesp+ 3], MS->frame_pos_at_element, an_aus);
	    break;
	 case KLICK_TABLE:
	    InputRahmen( MS->mauspos[ MS->framesp+ 1]- INPUTZEILENTASTENBREITE+ *MS->x, MS->mauspos[ MS->framesp+ 2]+ *MS->y, MS->mauspos[ MS->framesp+ 3]+ INPUT_TABLE_PULL_DOWN, *( ( char **)MS->arg_ptr[ MS->frame_ptr_sp]+ *( BYTE *)MS->arg_ptr[ MS->frame_ptr_sp+ 1]), an_aus);
	    break;
	 case INPUT_TABLE:
	 case FILE_INPUT_TABLE:
	 case DIR_INPUT_TABLE:
	    if(( modus== ONLY_FRAME)|| ( an_aus== AUS))
	       InputRahmen( MS->mauspos[ MS->framesp+ 1]+ *MS->x, MS->mauspos[ MS->framesp+ 2]+ *MS->y, MS->mauspos[ MS->framesp+ 3]- INPUT_TABLE_PULL_DOWN, *( char **)MS->arg_ptr[ MS->frame_ptr_sp], an_aus);
	    else
	    {
	       if( an_aus== AN)
	       {
		  ShowMouse( AN);
		  ret_val= Klick_Input_Table( MS, MS->framesp, MS->frame_ptr_sp, INPUTZEILE);
		  ShowMouse( AUS);
	       }
	    }
	    break;
	 case FILEINPUT:
	    if( MS->frame_pos_at_element== DATEIAUSWAHLBOX_RET)
	    {
	       ButtonRahmen( MS->mauspos[ MS->framesp+ 5]+ *MS->x, MS->mauspos[ MS->framesp+ 6]+ *MS->y, MS->mauspos[ MS->framesp+ 5]+ DATEIAUSWAHLBOXBUTTON_X_LAENGE+ *MS->x, MS->mauspos[ MS->framesp+ 6]+ DATEIAUSWAHLBOXBUTTON_Y_LAENGE+ *MS->y, an_aus);
               break;
            }
	    else
	       goto _INPUT;
	 case DIRINPUT:
            if( MS->frame_pos_at_element== VERZEICHNISBAUM_RET)
            {
	       ButtonRahmen( MS->mauspos[ MS->framesp+ 5]+ *MS->x, MS->mauspos[ MS->framesp+ 6]+ *MS->y, MS->mauspos[ MS->framesp+ 5]+ VERZEICHNISBAUMBUTTON_X_LAENGE+ *MS->x, MS->mauspos[ MS->framesp+ 6]+ VERZEICHNISBAUMBUTTON_Y_LAENGE+ *MS->y, an_aus);
	       break;
	    }
	 case INPUT:
	 case FILEINPUTNOBOX:
	 case DIRINPUTNOBOX:
	    _INPUT:
	    ;
	    if(( modus== ONLY_FRAME)|| ( an_aus== AUS))
	       InputRahmen( MS->mauspos[ MS->framesp+ 1]+ *MS->x, MS->mauspos[ MS->framesp+ 2]+ *MS->y, MS->mauspos[ MS->framesp+ 3], ( char *)MS->arg_ptr[ MS->frame_ptr_sp], an_aus);
	    else
	    {
	       if( an_aus== AN)
	       {
		  ShowMouse( AN);
		  if( _Input( MS->mauspos[ MS->framesp+ 1]+ *MS->x, MS->mauspos[ MS->framesp+ 2]+ *MS->y, MS->mauspos[ MS->framesp+ 3], ( char *)MS->arg_ptr[ MS->frame_ptr_sp], MS->mauspos[ MS->framesp+ 4], MS->mauspos[ MS->framesp]& CODE_FILTER, ( MS->mauspos[ MS->framesp]& IGN_CASE)!= 0 )& INPUT_VERAENDERT)
		     ret_val= 0;
		  ShowMouse( AUS);
	       }
	    }
	    break;
      }
      if( MS->mauspos[ MS->framesp]& _IF)
	 MS->frame_ptr_sp--;
      if( an_aus== AUS)
      {
	 if( direction== FORWARD)
	 {
	    Anzahl_Eintraege_pro_Typ( MS->mauspos[ MS->framesp], &EInfo);
	    if( MS->frame_pos_at_element< EInfo.anz_Einzelelemente)
	    {
	       MS->frame_pos_at_element++;
	       tmp_flag= 1;
	    }
	 }
	 else
	 {
	    if( MS->frame_pos_at_element> 1)
	    {
	       MS->frame_pos_at_element--;
	       tmp_flag= 1;
	    }
	 }
	 if( !tmp_flag)
	 {
	    do
	    {
               old_framesp= MS->framesp;
	       if( direction== FORWARD)
	       {
		  MS->framesp+= Anzahl_Eintraege_pro_Typ( MS->mauspos[ MS->framesp], &EInfo);
		  MS->frame_pos_at_element= 1;
		  MS->frame_ret++;
		  if( MS->frame_ret>= MS->spotanz)
		  {
		     MS->frame_ret= 0;
		     MS->frame_ptr_sp= 0;
		     MS->framesp= 0;
		     MS->frame_msg_sp= 0;
		     endlos--;          /* verhindert Endlosschleife bei nichtvorhandensein von FRAME */
		  }
		  else
		  {
		     MS->frame_ptr_sp+= EInfo.zeiger;
		     if(( MS->mauspos[ MS->framesp]& MSG)&& ( MS->mauspos[ old_framesp]& MSG))
		     {
			MS->frame_msg_sp&= AFTER_INIT_FILTER;
			MS->frame_msg_sp++;
		     }
		  }
	       }
	       else
	       {
		  while(( MS->framesp> 0)&& !( MS->mauspos[ --MS->framesp]& ELEMENTTYPBEZEICHNER_FILTER))
		     ;
		  Anzahl_Eintraege_pro_Typ( MS->mauspos[ MS->framesp], &EInfo);
		  MS->frame_pos_at_element= EInfo.anz_Einzelelemente;
                  MS->frame_ret--;
		  if( MS->frame_ret< 0)
		  {
		     MS->frame_ret= MS->spotanz- 1;
		     MS->frame_ptr_sp= MS->Last_arg_ptr;
		     MS->framesp= MS->Last_mauspos;
		     MS->frame_msg_sp= MS->Last_msg;
		     endlos--;          /* verhindert Endlosschleife bei nichtvorhandensein von FRAME */
		  }
		  else
		  {
		     MS->frame_ptr_sp-= EInfo.zeiger;
		     if(( MS->mauspos[ MS->framesp]& MSG)&& (( MS->mauspos[ old_framesp]& MSG)|| ( MS->frame_msg_sp& AFTER_INIT)))
		     {
			MS->frame_msg_sp&= AFTER_INIT_FILTER;
			MS->frame_msg_sp--;
		     }
		  }
	       }
	    }while(( !( MS->mauspos[ MS->framesp]& FRAME)|| (( MS->mauspos[ MS->framesp]& _IF)&& !*( BOOL *)MS->arg_ptr[ MS->frame_ptr_sp]))&& endlos);
	 }
      }
   }
   ShowMouse( AN);
   return( ret_val);        /* 0-> MS->frame_ret von __CheckMousepos zurck */
}

void ReinitWindow( MAUSStruct *MS)
{
   MS->statsp= REINIT;
   __CheckMousepos( MS);
}

/* ------------------ Aufbau der Struktur MAUSStruct ----------------------

typedef struct
	{
	   int *x, *y, xlength, ylength, spotanz, statsp;
	   char **msg, statzeile;
	   WORD *mauspos;
	   void **arg_ptr;
	   int framesp, frame_ptr_sp, frame_ret, frame_pos_at_element,
	       frame_msg_sp, anz_intern_Tasten, Last_mauspos, Last_arg_ptr,
	       Last_msg;
	   WORD intern_Tasten[ MAX_INTERN_TASTEN][ 4], dup_flag, duplicate;
	   char Taste_Maus;
	   saveall sa;
	}MAUSStruct;

  x:                    Adresse der X-Koordinate der linken oberen Ecke des Fensters
  y:                    Adresse der Y-Koordinate der linken oberen Ecke des Fensters
  xlength:              horizontale Lnge des Fensters
  ylength:              vertikale Lnge des Fensters
  statzeile:            Statuszeile wird benutzt            AN/AUS
  msg:                  Zeiger auf ein Array mit Meldungen
  mauspos:              Zeiger auf ein Array mit Positionen etc.
  spotanz:              Anzahl der Eintrge im Array
  arg_ptr:              Zeiger auf ein Array dem zu verndernde Variablen zugewiesen werden
  statsp:               interne Variable                (Statuszeile)
  framesp:              interne Variable                (Rahmen um die Elemente)
  frame_ptr_sp:         interne Variable                (Rahmen um die Elemente)
  frame_ret:            interne Variable                (Rahmen um die Elemente)
  frame_pos_at_element: interne Variable                (Rahmen um die Elemente)
  frame_msg_sp:         interne Variable                (Rahmen um die Elemente)
  anz_intern_Tasten:    interne Variable
  Last_mauspos:         interne Variable
  Last_arg_ptr:         interne Variable
  Last_msg:             interne Variable
  intern_Tasten:        interne Variable
  dup_flag:             interne Variable
  duplicate:            interne Variable
  Taste_Maus:           woher kommt das Ergebnis ? -> TAB_RET, MAUS_RET, TASTE_RET, INIT_RET

  WORD mauspos[]= { Codierung der Art des Elementes,
		    minimale X-Koordinate,
		    maximale X-Koordinate,
		    minimale Y-Koordinate,
		    maximale Y-Koordinate,
		    etc.,
		    quivalente Tastenkombination( en),
		    . . .};

  KLICKAREA,    Xl,  Xr,  Yo,  Yu, Taste;
  PUSHAREA,     Xl,  Xr,  Yo,  Yu;
  RADIOBUTTON,  Xm,  Ym, WERT, Taste;                                     + Zeiger auf ( char)RadiobuttonWahl
  CHECKBOX,    Xlo, Ylo, Taste;                                           + Zeiger auf ( char)CheckboxWahl (AN/AUS)
  MOVEWINDOW;
  BUTTON,       Xl,  Xr,  Yo,  Yu, Taste;
  BUTTON2,      Xl,  Xr,  Yo,  Yu, Taste;
  HOTAREA,      Xl,  Xr,  Yo,  Yu;
  LAUFLEISTE,  Xlo, Ylo,  Xlength, min, max, step, Taste_min, Taste_max;  + Zeiger auf ( char *)LaufleistenAnzeige   + Zeiger auf ( int)Laufleistenwert
  INPUT,       Xlo, Ylo,  Xlength, maxzeichen, Taste;                     + Zeiger auf ( char *)InputArray
  FILEINPUT,   Xlo, Ylo,  Xlength, maxzeichen, Xlo, Ylo, LW, Taste;       + Zeiger auf ( char *)Suchweg[ MAXPATH]    + Zeiger auf ( int)Xlo_Dateiauswahlbox + Zeiger auf ( int)Ylo_Dateiauswahlbox + Zeiger auf ( char *)DateiauswahlboxFilter (*.EXE;*.COM)
  DIRINPUT,    Xlo, Ylo,  Xlength, maxzeichen, Xlo, Ylo, LW, Taste;       + Zeiger auf ( char *)Verzeichnis[ MAXDIR] + Zeiger auf ( int)X_Verzeichnisbaum
  FILEINPUTNOBOX, Xlo, Ylo,  Xlength, maxzeichen, Taste;                  + Zeiger auf ( char *)InputArray
  DIRINPUTNOBOX,  Xlo, Ylo,  Xlength, maxzeichen, Taste;                  + Zeiger auf ( char *)InputArray
  BUTTON3,      Xl,  Xr,  Yo,  Yu, Taste;
  ROLLBALKEN,  Taste_minus_min, Taste_plus_min, Taste_minus_max, Taste_plus_max, Taste_pos1, Taste_ende, Taste_return;  + Zeiger auf struct 'RBalken' + Zeiger auf void ZeigerFunktion()
  TASTE,       Taste;
  INPUT_TABLE, Xlo, Ylo,  Xlength, maxzeichen, anzeintrge, Taste;
  FILE_INPUT_TABLE, Xlo, Ylo,  Xlength, maxzeichen, anzeintrge, Taste;
  DIR_INPUT_TABLE, Xlo, Ylo,  Xlength, maxzeichen, anzeintrge, Taste;
  DOUBLE_KLICKAREA, Xl,  Xr,  Yo,  Yu, Taste;
  KLICK_TABLE, Xlo, Ylo,  Xlength, anzeintrge, mode, Taste;

  - |KEY - Element hat Tastenkombination
  - |FRAME - Element darf mit der TAB-Taste eingerahmt werden
  - |MSG - Element hat eine Meldung im Array 'MAUSStruct.msg'
  - |DEFBUTTON - Element wird zuerst Eingerahmt
  - |_IF - wird nur ausgewertet wenn die Bedingung erfllt ist
  - |IGN_CASE - Input ignoriert Gro/Kleinschreibung
  - das MOVEWINDOW-Flag mu immer als letzte Konstante im Array stehen
  - wenn LW == DEFAULT ist, wird getdisk() benutzt ( 'A', 'B' ... )
  - wenn LW == LWAUSWAHL ist, wird eine Dialogbox zur Auswahl benutzt

  -----------------------------------ENDE--------------------------------  */

BOOL is_Shift( BOOL _extended, WORD Sondertaste, WORD Code)
{
   if( _extended!= (( Code& EXTENDED)!= 0))
      return( 0);
   if((( Code& ALT)!= 0)!= (( Sondertaste& ALT_PRESS)!= 0))
      return( 0);
   if((( Code& STRG)!= 0)!= (( Sondertaste& STRG_PRESS)!= 0))
      return( 0);
   if(((( Code& SHIFT)!= 0)!= (( Sondertaste& SHIFT_PRESS)!= 0))&& ((( Code& SHIFT_FILTER)< 0x20)|| (( Code& SHIFT_FILTER)> 0x7E)))
      return( 0);
   return( 1);
}

BOOL GetArrayIndexofElement( MAUSStruct *MS, int Nr, int *array_index, int *ptr_index)
{
   ElementInfo EInfo;
   int i;

   for( i= 0, *array_index= 0, *ptr_index= 0; ( i< Nr)&& ( i< MS->spotanz); i++, *array_index+= Anzahl_Eintraege_pro_Typ( MS->mauspos[ *array_index], &EInfo), *ptr_index+= EInfo.zeiger)
      ;
   return( i< MS->spotanz);
}

int __CheckMousepos( MAUSStruct *MS)
{
   ElementInfo EInfo;
   saveall screen_move;
   unsigned taste, Sondertaste= NOTHING;
   int i, l, array_index, tastvergl,
       xabst, yabst, x, y, mx, my, status= -1, ptr_index, klickstatus;
   static int oldstatus;
   BOOL clr= 1, have_HOTAREA= 0, _extended;
   char color;

   Clock();                                            /* Uhr aktualisieren */
   if(( MS->statsp== INIT)|| ( MS->statsp== REINIT))   /* Elemente initialisieren */
   {
      if( MS->statsp== INIT)
      {
	 oldstatus= -1;
	 MS->framesp= 0;
	 MS->frame_ptr_sp= 0;
	 MS->frame_ret= 0;
	 MS->frame_pos_at_element= 1;
	 MS->frame_msg_sp= 0;
	 MS->anz_intern_Tasten= 0;
	 MS->dup_flag= 0x0000;
	 MS->duplicate= 0x0000;
	 ClearStatus();
      }
      for( i= 0, l= 0, array_index= 0, ptr_index= 0; i< MS->spotanz; i++, ptr_index+= EInfo.zeiger)
      {
	 InitElemente( MS, array_index, ptr_index);
	 if(( MS->mauspos[ array_index]& DEFBUTTON)&& ( MS->statsp== INIT))
	 {
	    MS->framesp= array_index;
	    MS->frame_ptr_sp= ptr_index;
	    MS->frame_ret= i;
	    MS->frame_msg_sp= l| AFTER_INIT;
	 }
	 if( MS->mauspos[ array_index]& MSG)
	    l++;
	 array_index+= Anzahl_Eintraege_pro_Typ( MS->mauspos[ array_index], &EInfo);
      }
      if( MS->statsp== INIT)
      {
	 MS->Last_mauspos= array_index- EInfo.WORDS_pro_Element;
	 MS->Last_arg_ptr= ptr_index- EInfo.zeiger;
	 MS->Last_msg= l- 1;
	 if( !ElementeRahmen( MS, WORK, FORWARD))
	    status= MS->frame_ret;
      }
      else
	 if( MS->statsp== REINIT)
	    ElementeRahmen( MS, ONLY_FRAME, ANZEIGE);
      MS->statsp= -1;
      MS->Taste_Maus= INIT_RET;
      return( status);
   }
   MouseStat();                                      /* MausStatus erfragen */
   if( MS->statzeile== AN)                       /* Statuszeile erwnscht ? */
   {
      for( i= 0, l= 0, array_index= 0, ptr_index= 0; i< MS->spotanz; i++, ptr_index+= EInfo.zeiger)
      {
	 if( MS->mauspos[ array_index]& MSG)
	 {
	    if( Is_Mouse_at_Element( MS, array_index, ptr_index))
	    {
	       if( MS->statsp!= l)  /* steht Meldung nicht in Statuszeile ? */
		  PrintStatus( MS->msg[ MS->statsp= l]);
	       l= -1;
	       break;
	    }
	    l++;
	 }
	 array_index+= Anzahl_Eintraege_pro_Typ( MS->mauspos[ array_index], &EInfo);
      }
      if(( l!= -1)&& ( MS->statsp!= -1))
      {
	 ClearStatus();
	 MS->statsp= -1;
      }
   }
   if( _bios_keybrd( _NKEYBRD_READY))          /* Taste im Tastaturpuffer ? */
   {
      taste= _bios_keybrd( _NKEYBRD_READ);
      Sondertaste= _bios_keybrd( _NKEYBRD_SHIFTSTATUS);
      _extended= (( taste& 0xFF)== 0x00)| (( taste& 0xFF)== 0xE0);
      if( _extended)
      {
	 switch( taste>>= 8)
	 {
	    case SHIFT_TAB& EXTENDED_FILTER:
	       screensp= 0;
	       msg_to_Klick= AUS;
	       if( !ElementeRahmen( MS, WORK, BACKWARD))
		  status= MS->frame_ret;
	       MS->Taste_Maus= TAB_RET;
	       return( status);
	 }
      }
      else
      {
	 switch( taste&= 0xFF)
	 {
	    case TAB:
	       screensp= 0;
	       msg_to_Klick= AUS;
	       if( !ElementeRahmen( MS, WORK, FORWARD))
		  status= MS->frame_ret;
	       MS->Taste_Maus= TAB_RET;
	       return( status);
	    case STRG_RETURN:
	       screensp= 0;
	       msg_to_Klick= AUS;
	       MS->Taste_Maus= TAB_RET;
	       if( !MakeKlick( MS, MS->framesp, MS->frame_ptr_sp, MS->frame_pos_at_element, TASTATUR))
		  return( MS->frame_ret);
	       return( -1);
	 }
      }
      for( i= 0; i< MS->anz_intern_Tasten; i++)
      {
	 if(( taste== Taste_Umformen( MS->intern_Tasten[ i][ TASTENKOMBINATION], Sondertaste))&& ( !(( MS->mauspos[ MS->intern_Tasten[ i][ MAUSPOSINDEX]]& _IF)&& !*( BOOL *)MS->arg_ptr[ MS->intern_Tasten[ i][ ARGPOINTERINDEX]])))
	 {
	    MakeKlick( MS, MS->intern_Tasten[ i][ MAUSPOSINDEX], MS->intern_Tasten[ i][ ARGPOINTERINDEX], MS->intern_Tasten[ i][ POS_AT_ELEMENT], TASTATUR);
	    screensp= 0;
	    msg_to_Klick= AUS;
	    return( -1);
	 }
      }
      for( i= 0, array_index= 0, ptr_index= 0; ( i< MS->spotanz)&& ( status== -1); i++, array_index+= EInfo.WORDS_pro_Element, ptr_index+= EInfo.zeiger)
      {
	 Anzahl_Eintraege_pro_Typ( MS->mauspos[ array_index], &EInfo);
	 if(( MS->mauspos[ array_index]& KEY)&& ( !(( MS->mauspos[ array_index]& _IF)&& !*( BOOL *)MS->arg_ptr[ ptr_index])))  /* Tastenkombination vorhanden */
	 {
	    if(( MS->mauspos[ array_index]& ( CODE_FILTER| KEY))== NOT_USE_KEY)
	    {
	       ( *( not_use_key_struct *)MS->arg_ptr[ ptr_index]).Taste= taste;
	       ( *( not_use_key_struct *)MS->arg_ptr[ ptr_index]).Sondertaste= Sondertaste;
	       MS->Taste_Maus= TASTE_RET;
	       status= i;
	       break;
	    }
	    for( l= EInfo.tasten; l> 0; l--)  /* wieviel Tasten hat Element ? */
	    {
	       if( taste== Taste_Umformen( MS->mauspos[ array_index+ EInfo.WORDS_pro_Element- l], Sondertaste))
	       {
		  if( is_Shift( _extended, Sondertaste, MS->mauspos[ array_index+ EInfo.WORDS_pro_Element- l]))
		  {
		     MS->Taste_Maus= TASTE_RET;
		     if( !MakeKlick( MS, array_index, ptr_index, EInfo.tasten- l+ 1, TASTATUR))
			status= i;
		     break;
		  }
	       }
	    }
	 }
      }
   }
   else
   {
      if( MStat.buttons!= NOTHING)
      {
	 if( MStat.buttons== TWO)
	    ScreenSaver();
	 else
	 {
	    for( i= 0, array_index= 0, ptr_index= 0; i< MS->spotanz; i++, ptr_index+= EInfo.zeiger)
	    {
	       if(( klickstatus= Is_Mouse_at_Element( MS, array_index, ptr_index))!= 0)
	       {
		  if(( MS->mauspos[ array_index]& CODE_FILTER)== MOVEWINDOW)
		  {
		     color= getcolor();
		     setcolor( 0x08);
		     setlinestyle( USERBIT_LINE, 0xAAAA, NORM_WIDTH);
		     setwritemode( XOR_PUT);
		     xabst= MStat.x- *MS->x;
		     yabst= MStat.y- *MS->y;
		     x= MS->xlength- xabst;
		     y= MS->ylength- yabst;
		     SetXRange( MIN_X_TO_MOVE+ xabst, MAX_X_TO_MOVE- x);
		     SetYRange( MIN_Y_TO_MOVE+ yabst, MAX_Y_TO_MOVE- y);
		     do
		     {
			if( clr)
			{
			   ShowMouse( AUS);
			   rectangle( MStat.x- xabst, MStat.y- yabst, MStat.x+ x, MStat.y+ y);
			   ShowMouse( AN);
			   mx= MStat.x;
			   my= MStat.y;
			   clr= 0;
			}
			else
			{
			   if(( mx!= MStat.x)|| ( my!= MStat.y))
			   {
			      ShowMouse( AUS);
			      rectangle( mx- xabst, my- yabst, mx+ x, my+ y);
			      ShowMouse( AN);
			      clr= 1;
			   }
			}
		     }while( MouseStat()== LEFT);
		     if( !clr)
		     {
			ShowMouse( AUS);
			rectangle( mx- xabst, my- yabst, mx+ x, my+ y);
			ShowMouse( AN);
		     }
		     setwritemode( COPY_PUT);
		     setlinestyle( SOLID_LINE, 0, NORM_WIDTH);
		     SetXRange( 0, 639);
		     SetYRange( 0, 479);
		     setcolor( color);
		     screensp= 0;
		     if((( MStat.x- xabst)!= *MS->x)|| (( MStat.y- yabst)!= *MS->y))
		     {
			ShowMouse( AUS);
			BigScreenSave( &screen_move, *MS->x, *MS->y, *MS->x+ MS->xlength- 1, *MS->y+ MS->ylength- 1);
			BigScreenRestore( &MS->sa, *MS->x, *MS->y);
			*MS->x= MStat.x- xabst;
			*MS->y= MStat.y- yabst;
			BigScreenSave( &MS->sa, *MS->x, *MS->y, *MS->x+ MS->xlength+ 2, *MS->y+ MS->ylength+ 2);
			BigScreenRestore( &screen_move, *MS->x, *MS->y);
			Fensterschatten( *MS->x, *MS->y, *MS->x+ MS->xlength- 1, *MS->y+ MS->ylength- 1);
			ShowMouse( AN);
			veraendert= AN;
		     }
		  }
		  else
		  {
		     MS->Taste_Maus= MAUS_RET;
		     if( !MakeKlick( MS, array_index, ptr_index, klickstatus, MAUS))
			status= i;
		     break;
		  }
	       }
	       array_index+= Anzahl_Eintraege_pro_Typ( MS->mauspos[ array_index], &EInfo);
	    }
	 }
      }
      else
      {
	 for( i= 0, ptr_index= 0, array_index= 0; i< MS->spotanz; i++, ptr_index+= EInfo.zeiger)
	 {
	    if( !(( MS->mauspos[ array_index]& _IF)&& !*( BOOL *)MS->arg_ptr[ ptr_index]))
	    {
	       switch( MS->mauspos[ array_index]& CODE_FILTER)
	       {
		  case HOTAREA:
		     if( !have_HOTAREA&& Is_Mouse_at_Element( MS, array_index, ptr_index))
		     {
			have_HOTAREA= 1;
			if( i!= oldstatus)
			{
			   MS->Taste_Maus= MAUS_RET;
			   status= i;
			}
		     }
		     break;
		  case ROLLBALKEN:
		     switch( ( *( RBalken *)MS->arg_ptr[ ptr_index]).button_flag)
		     {
			case ZEIGERPOS_AUS:
			case RBALKEN_RANDOM:
			   ( ( void (*)())MS->arg_ptr[ ptr_index+ 1])( *MS->x, *MS->y, ( *( RBalken *)MS->arg_ptr[ ptr_index]).Zeiger_pos, AN);
			   break;
			case RBALKEN_MINUS_MIN_MAUS:
			   ShowMouse( AUS);
			   ButtonUp( ( *( RBalken *)MS->arg_ptr[ ptr_index]).button, ( *( RBalken *)MS->arg_ptr[ ptr_index]).x+ *MS->x, ( *( RBalken *)MS->arg_ptr[ ptr_index]).y+ *MS->y, ( *( RBalken *)MS->arg_ptr[ ptr_index]).x+ *MS->x+ 17, ( *( RBalken *)MS->arg_ptr[ ptr_index]).y+ *MS->y+ 17);
			   ( ( void (*)())MS->arg_ptr[ ptr_index+ 1])( *MS->x, *MS->y, ( *( RBalken *)MS->arg_ptr[ ptr_index]).Zeiger_pos, AN);
			   ShowMouse( AN);
			   break;
			case RBALKEN_PLUS_MIN_MAUS:
			   ShowMouse( AUS);
			   if( ( *( RBalken *)MS->arg_ptr[ ptr_index]).lage== VERT_DIR)
			      ButtonUp( ( *( RBalken *)MS->arg_ptr[ ptr_index]).button, ( *( RBalken *)MS->arg_ptr[ ptr_index]).x+ *MS->x, ( *( RBalken *)MS->arg_ptr[ ptr_index]).x_y+ *MS->y- 17, ( *( RBalken *)MS->arg_ptr[ ptr_index]).x+ *MS->x+ 17, ( *( RBalken *)MS->arg_ptr[ ptr_index]).x_y+ *MS->y);
			   else
			      ButtonUp( ( *( RBalken *)MS->arg_ptr[ ptr_index]).button, ( *( RBalken *)MS->arg_ptr[ ptr_index]).x_y- 17+ *MS->x, ( *( RBalken *)MS->arg_ptr[ ptr_index]).y+ *MS->y, ( *( RBalken *)MS->arg_ptr[ ptr_index]).x_y+ *MS->x, ( *( RBalken *)MS->arg_ptr[ ptr_index]).y+ 17+ *MS->y);
			   ( ( void (*)())MS->arg_ptr[ ptr_index+ 1])( *MS->x, *MS->y, ( *( RBalken *)MS->arg_ptr[ ptr_index]).Zeiger_pos, AN);
			   ShowMouse( AN);
			   break;
			case RBALKEN_MINUS_MAX:
			   ViewPG( ( *( RBalken *)MS->arg_ptr[ ptr_index]).x+ *MS->x, ( *( RBalken *)MS->arg_ptr[ ptr_index]).y+ *MS->y, ( *( RBalken *)MS->arg_ptr[ ptr_index]).x_y+ *MS->y, ( *( RBalken *)MS->arg_ptr[ ptr_index]).greifx_y+ ( ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).lage== VERT_DIR) ? ( *MS->y) : ( *MS->x)), UP, ( *( RBalken *)MS->arg_ptr[ ptr_index]).lage, AUS);
			   ( ( void (*)())MS->arg_ptr[ ptr_index+ 1])( *MS->x, *MS->y, ( *( RBalken *)MS->arg_ptr[ ptr_index]).Zeiger_pos, AN);
			   break;
			case RBALKEN_PLUS_MAX:
			   ViewPG( ( *( RBalken *)MS->arg_ptr[ ptr_index]).x+ *MS->x, ( *( RBalken *)MS->arg_ptr[ ptr_index]).y+ *MS->y, ( *( RBalken *)MS->arg_ptr[ ptr_index]).x_y+ *MS->y, ( *( RBalken *)MS->arg_ptr[ ptr_index]).greifx_y+ ( ( ( *( RBalken *)MS->arg_ptr[ ptr_index]).lage== VERT_DIR) ? ( *MS->y) : ( *MS->x)), DOWN, ( *( RBalken *)MS->arg_ptr[ ptr_index]).lage, AUS);
			   ( ( void (*)())MS->arg_ptr[ ptr_index+ 1])( *MS->x, *MS->y, ( *( RBalken *)MS->arg_ptr[ ptr_index]).Zeiger_pos, AN);
			   break;
		     }
		     ( *( RBalken *)MS->arg_ptr[ ptr_index]).button_flag= 0;
		     break;
	       }
	    }
	    array_index+= Anzahl_Eintraege_pro_Typ( MS->mauspos[ array_index], &EInfo);
	 }
      }
   }
   if( status!= oldstatus)
   {
      oldstatus= status;
      screensp= 0;
      if( status!= -1)
	 msg_to_Klick= FALSE;
   }
   return( status);
}

int DragDrop_Element( MAUSStruct *MS, BYTE *Zielelemente_Index, BYTE Anz_Zielelemente)
{
   ElementInfo EInfo;
   int i, l, array_index, ptr_index;

   for( i= 0, array_index= 0, ptr_index= 0; i< MS->spotanz; i++, ptr_index+= EInfo.zeiger)
   {
      if( Is_Mouse_at_Element( MS, array_index, ptr_index))
      {
	 if( Zielelemente_Index!= NULL)
	 {
	    for( l= 0; l< Anz_Zielelemente; l++)
	    {
	       if( *( Zielelemente_Index+ l)== i)
		  return( i);
	    }
	 }
	 else
	    break;
      }
      array_index+= Anzahl_Eintraege_pro_Typ( MS->mauspos[ array_index], &EInfo);
   }
   if( i>= MS->spotanz)
      i= -1;
   return( i);
}