#ifndef _CD_OP_H
#define _CD_OP_H

#include "typedef.h"

/*
 * Zuerst mssen einige Strukturen vereinbart werden, da der Zugriff auf das
 * Laufwerk ber sog. IOCTL Anfragen luft. Die IOCTL Anfragen werden dem
 * Gertesteuerprogramm ber die Funktion "SEND DEVICE REQUEST (0x10)" der
 * MSCDEX Erweiterung mitgeteilt.
 */

/*
 * Zuerst ganz allgemein einen Anfragekopf fr die Nachricht an das Gerte-
 * steuerprogramm (device driver request header).
 */

typedef struct {
    BYTE            rq_len;     /* Lnge der Nachricht  */
    BYTE            rq_unit;    /* Empfnger der Nachricht */
    BYTE            rq_cmd;     /* Art der Nachricht    */
    WORD            rq_status;  /* Ergebniss der Anfrage (wird vom
				 * Gertetreiber ausgefllt) */
    BYTE            reserved[8];/* Fr Erweiterungen reserviert */
}               Request_Hdr;
/*-----------------------*/

/* Die IOCTL Nachrichten bauen auf die allgemeine Anfrage auf: */

typedef struct {
    Request_Hdr     ioctl_rqh;  /* s.o. */
    BYTE            ioctl_media;/* Media Descriptor Byte des BIOS PARAMETER
				 * BLOCKS (BPB)  (0)       */
    void far       *ioctl_xfer; /* Adresse des speziellen IOCTL Blocks */
    WORD            ioctl_nbytes;       /* Lnge des Blocks in Bytes */
    WORD            ioctl_sector;       /* Startsektor  (0)                  */
    void far       *ioctl_volid;/* (0) */
}               IOCTL_Inp_Request;

typedef struct {
    Request_Hdr     ioctl_rqh;  /* s.o. */
    BYTE            ioctl_media;/* Media Descriptor Byte des BIOS PARAMETER
				 * BLOCKS (BPB)  (0)       */
    void far       *ioctl_xfer; /* Adresse des speziellen IOCTL Blocks */
    WORD            ioctl_nbytes;       /* Lnge des Blocks in Bytes */
    WORD            ioctl_sector;       /* Startsektor  (0)                  */
    void far       *ioctl_volid;/* (0) */
}               IOCTL_Outp_Request;

/*-----------------------*/

/* Die Union CD_Addr enthlt die beiden Formate, in denen MSCDEX die Sektoren
   einer CD adressiert.
   Die Diskriminante HSG_sector enthlt eine Sektornummer (0L-0xFFFFFFFFL)

   In der Diskriminate TIME wird ein Sektor ber die Zeit definiert, die vom 
   Anfang der Audio CD bis zum Erreichen des Sektors verstrichen ist. Dieses
   Format wurde im RED Book definiert. Die kleinste Zeiteinheit ist ein Frame,
   dieser entspricht 1/75tel Sekunde.
*/   
typedef union {
    DWORD           HSG_sector;
    struct {
	BYTE            frame;  /* 0-74 */
	BYTE            second; /* 0-59 */
	BYTE            minute; /* 0- Lnge der CD */
	BYTE            unused;
    }               TIME;
}               CD_Addr;

/*
 * Im Folgenden stehen die mglichen IOCTL Kommandos, die ein CD-ROM Player
 * untersttzt. Am Anfang die Befehle, die Informationen ber den
 * Zustand des Laufwerk anfordern (Input). 
 * Zu Ende die Befehle, die Zusatndsnderungen bewirken (Output).
 * 
 * Jedes Kommando hat eine Nummer und einen zugehrigen IOCTL-Kommando Block.
 */

/*
 * Es werden zwei Adressierungsmodi unterschieden: 
 *	0 - High Siera Group (HSG)        ; CD-ROM Sektoren 
 *	1 - Red Book                      ; CD-Audio Frames
 */

#define HSG     0
#define RED 1

#define IOI_DRV_HEAD    0       /* Ermitteln der Adresse des Gertesteuer-
				 * programmes */
typedef struct {
    BYTE            ioctl_cmd;  /* Mu 0 sein */
    void far       *device_hdr; /* Adresse wird von MSCDEX eingetragen. */
}               IO_Inp_Device_Hdr;


#define IOI_LOC_HEAD    1       /* Lesen der Kopfposition                               */
typedef struct {
    BYTE            ioctl_cmd;  /* Mu 1 sein */
    BYTE            addr_mode;  /* Entweder HSG oder RED */
    DWORD           location;   /* Position des Lesekopfes */
}               IO_Inp_Head_Loc;

#define IOI_AUDIOCHAN_INFO      4       /* Informationen ber die Audio
					 * Mglichkeiten des angeschlossenen
					 * Laufwerkes */
typedef struct {
    BYTE            ioctl_cmd;  /* Mu 4 sein */
    BYTE            inp_chan0;  /* Eingangskanal (0-3) fr Ausgang 0 */
    BYTE            vol_chan0;  /* Lautstrke von Ausgang 0 (0-255)  */
    BYTE            inp_chan1;  /* dto. fr 1-3 (Quadrophonie!*)     */
    BYTE            vol_chan1;
    BYTE            inp_chan2;
    BYTE            vol_chan2;
    BYTE            inp_chan3;
    BYTE            vol_chan3;
}               IO_Inp_Audiochan_Info;

#define IOI_DRIVE_BYTES 5       /* Informationen ber herstellerspezfische
				 * Angaben */
typedef struct {
    BYTE            ioctl_cmd;  /* Mu 5 sein */
    BYTE            bytes2read; /* Wieviel Bytes sollen gelesen werden ? */
    BYTE            read_buff[128];     /* Lesepuffer */
}               IO_Inp_Drive_Bytes;

#define IOI_DEV_STAT    6       /* Gertestatus Informationen   */
typedef struct {
    BYTE            ioctl_cmd;  /* Mu 6 sein */
    DWORD           status;     /* Statusinformationen s.u. */
}               IO_Inp_Device_Status;

/* Die Bits im Statuswort der Struktur IO_Inp_Device_status 
   haben folgende Bedeutung: */

#define DOOR_OPEN                     0x001L
#define DOOR_UNLOCKED 		      0x002L
#define COOCKED_AND_RAW		      0x004L
#define READ_WRITE                    0x008L
#define DATA_AND_AUDIO         	      0x010L
#define INTERLEAVING                  0x020L
#define PREFETCHING                   0x080L
#define AUDIO_MANIPULATION            0x100L
#define HSG_AND_RED                   0x200L
#define NO_CD_INSERT                  0x800L

#define IOI_SECT_SIZE   7       /* Gre der logischen Sektoren in Byte */
typedef struct {
    BYTE            ioctl_cmd;  /* Mu 7 sein */
    BYTE            addr_mode;  /* HSG oder RED */
    WORD            sect_size;  /* Gre der Sektoren */
}               IO_Inp_Sector_Size;

#define IOI_VOL_SIZE    8       /* gre des Volumes als HSG Information */
typedef struct {
    BYTE            ioctl_cmd;  /* Mu 8 sein */
    DWORD           hsg_sect;   /* Anzahl der HSG Sektoren */
}               IO_Inp_Volume_Size;

#define IOI_MEDIA_CHANG 9       /* wurde die CD seit dem letzten Zugriff
				 * gewechselt ? */
typedef struct {
    BYTE            ioctl_cmd;  /* Mu 9 sein */
    BYTE            media_byte; /* s.u. */
}               IO_Inp_Media_Changed;

/* Mgliche Zustnde des Media Bytes: */
#define NOT_CHANGED     0x01
#define DONT_KNOW       0x00
#define HAS_CHANGED     0xFF

#define IOI_AUDIO_INFO  10      /* Informationen, die aus dem TOC einer Audio
				 * CD gelesen werden. */
typedef struct {
    BYTE            ioctl_cmd;  /* Mu 10 sein */
    BYTE            track_lo;   /* Kleinste Stcknummer */
    BYTE            track_hi;   /* Grte Stcknummer */
    CD_Addr         track_lead_out; /* Adresse des Lead Out Tracks (RED) */
}               IO_Inp_Audio_Info;

#define IOI_TRACK_INFO  11      /* Lesen der Track Informationen */
typedef struct {
    BYTE            ioctl_cmd;  /* mu 11 sein ! */
    BYTE            tno;        /* Track Nummer */
    CD_Addr         start;      /* Anfangszeitpunkt in RED Notation */
    BYTE            control;    /* diverse Informationen zum Track */
}               IO_Inp_Track_Info;
/* Mgliche Werte von control: */
#define	TWOTRACK	0x0
#define FOURTRACK	0x80
#define EMPHASIS	0x10
#define DATA		0x40
#define DIGITALCOPY	0x20

#define IOI_QCHAN_INFO  12      /* Lesen des Q Channels */
/* Hilfsstruktur fr den leichteren Umgang im Programm */
typedef struct {
    BYTE            tno;        /* Tracknummer */
    BYTE            x;
    BYTE            tmin;       /* Zeit innerhalb des aktuellen Tracks */
    BYTE            tsec;
    BYTE            tframe;
    BYTE            zero;
    BYTE            dmin;       /* Zeit auf der CD */
    BYTE            dsec;
    BYTE            dframe;
}               QChannel_Info;

typedef struct {
    BYTE            ioctl_cmd;  /* Mu 12 sein */
    BYTE            addr_mode;  /* HSG oder RED */
    QChannel_Info   qinfo;
}               IO_Inp_QChannel;

#define IOI_UPC                 14      /* Lesen des Universal Product Codes */
typedef char	upcstr[14];
typedef struct {
    BYTE            ioctl_cmd;  /* Mu 14 sein  */
    BYTE            addr_mode;
    upcstr          signature;
    BYTE            aframe;     /* ????? */
}               IO_Inp_UPC;

#define IOI_AUDIO_STATUS        15
typedef struct {
    WORD            status;     /* s.u. */
    CD_Addr         start;      /* Startposition fr PLAY oder RESUME */
    CD_Addr         end;        /* Endpostion      - " -              */
}               Audio_Status;

typedef struct {
    BYTE            ioctl_cmd;  /* Mu 15 sein */
    Audio_Status    report;
}               IO_Inp_Audio_Status;

/* Mgliche Statuswerte: */
#define PAUSE   0x01;

/* IOCTL Output Funktionen */

#define IOO_EJECT              0       /* Auswurf der aktuellen CD */
typedef struct {
    BYTE            ioctl_cmd;  /* Mu 0 sein */
}               IO_Outp_Eject;

#define IOO_LOCK               1       /* Sperren des manuellen
						 * Auswurfes */
typedef struct {
    BYTE            ioctl_cmd;  /* Mu 1 sein */
    BYTE            function;   /* s.u. */
}               IO_Outp_Lock_Door;
/* Werte fr function: */
#define UNLOCK  0x00
#define LOCK    0x01

#define IOO_RESET                2       /* Rcksetzten des Laufwerkes */
typedef struct {
    BYTE            ioctl_cmd;  /* Mu 2 sein   */
}               IO_Outp_Reset;

#define IOO_AUDIOCHAN_CTRL      3       /* Setzten der Audiokanle des
					 * Laufwerkes */
typedef struct {
    BYTE            ioctl_cmd;  /* Mu 3 sein */
    BYTE            inp_chan0;  /* Eingangskanal (0-3) fr Ausgang 0 */
    BYTE            vol_chan0;  /* Lautstrke von Ausgang 0 (0-255)  */
    BYTE            inp_chan1;  /* dto. fr Kanal 1-3		     */
    BYTE            vol_chan1;
    BYTE            inp_chan2;
    BYTE            vol_chan2;
    BYTE            inp_chan3;
    BYTE            vol_chan3;
}               IO_Outp_Audiochan_Ctrl;

#define IOO_CLOSE_TRAY          5       /* Einziehen einer CD  */
typedef struct {
    BYTE            ioctl_cmd;  /* Mu 5 sein   */
}               IO_Outp_Close_Tray;

/* Der MSCDEX Treiber untersttzt die folgenden Anfragen: */
#define CD_INIT    0        /* wird von MS-DOS whrend des Bootens erzeugt */
#define IOCTL_INP                       3
#define IOCTL_OUTP                      12
#define READ_LONG                       128
#define READ_LONG_PREFETCH      	130
#define SEEK                            131
#define PLAY_AUDIO                      132
#define STOP_AUDIO                      133
#define RESUME_AUDIO            	136
#define WRITE_LONG                      134
#define WRITE_LONG_VERIFY       	135
#define INPUT_FLUSH                     7
#define OUTPUT_FLUSH            	8
#define DEV_OPEN                        13
#define DEV_CLOSE                       14

/* Aufbau des Anfrageblocks, um eine Sequenz von Audioframes abzuspielen */
typedef struct {
    Request_Hdr     play_rqh;	
    BYTE            addr_mode;	/* RED oder HSG */
    CD_Addr         start;	/* Startframe */
    DWORD           nframes;    /* 1 Frame entspricht 1/75tel Sekunde ! */
}               Audio_Play_Request;

/* Fehler der Funktion init_CDAudio() */
#define NODRIVE	-1
#define NOAUDIO -2
#define NOMEMORY -3
#define NOTREADY -4

/* Prototypen der Zugriffsfunktionen auf das CD-ROM */

int             init_CDAudio(void);	/* mu vor allen anderen Funktionen
					   aufgerufen werden */

/* gibt den mit init_CDAudio() belegten Speicher wieder frei */

void            Free_CD_Res( void);

/* Umwandlung von RED <-> HSG */
DWORD           RED2HSG(CD_Addr time);
CD_Addr         HSG2RED(DWORD nsect);

/* Lesen des UPC Strings - wird leider von den wenigsten CDs gesetzt */
void            get_UPC(BYTE upc[]);

/* Lesen des Laufwerk Status */
DWORD           get_Status(BYTE drive);

/* Lesen des Audi Status (PAUSE, Anfang und Ende des aktuellen Play Requests */
Audio_Status    Read_Audio_Status(void);

/* CD seit dem letzten Zugriff gewechselt ? */
BYTE            get_Media_Changed(void);

/* Lesen des Inhaltsverzeichnis in eine interne Struktur */
BYTE            get_TOC(void);

/* Information, ob sich das CD Laufwerk im Pause Zustand befindet:
	0 - Nein
 	1 - Ja
*/
WORD            audio_pause(void);

/* Lesen der Statistik eines Stckes */
BYTE	get_track_info(BYTE);

/* Lesen der Q-Kanal Informationen */
QChannel_Info   read_QChannel(void);

/* Zurcksetzten des Laufwerkes */
WORD            CD_Reset(void);

/* Abspielen einer CD von Startadresse an nsectors weit */
WORD            Play_Audio(CD_Addr start, DWORD nsectors);

/* Abspielen beenden (PAUSE) */ 
WORD            Stop_Audio(void);

/* Abspielen an aktueller Position wieder aufnehmen */
WORD            Resume_Audio(void);

/* CD auswerfen */
WORD		eject_CD(void);

/* CD einziehen */
WORD		insert_CD(void);

/* Lautstrke der Kanle 0-3 setzten */
void 		setvolume(BYTE, BYTE, BYTE, BYTE);

/* Eingangskanle von Ausgngen 0-3 setzten */
void 		setinput(BYTE, BYTE, BYTE, BYTE);

/* Abspielen eines ganzen Stckes */
BYTE            Play_Track(BYTE tno);

/* Abspielen mehrer Stcke */
BYTE		Play_Tracks(BYTE from, BYTE to);

/* Anspielen der ersten 10 Sekunden eines Stckes */
BYTE		Play_Track_Intro(int tno);

/* berspringen der nchsten Frames (1/75tel Sekunden) */
WORD            Skip_Audio(long frames);

/* Anzahl der Titel ermitteln */
BYTE            get_Titles(void);

/* Lnge eines Titels in RED Notation */
CD_Addr         get_len(BYTE tno);

/* ber welchem Stck befindet sich der Kopf ? */
BYTE            get_actual_track(void);

/* Q-Kanal Informationen */
QChannel_Info   get_time_in_track(void);

/* Ermitteln der Laufwerkskennung des aktuellen Audio Laufwerkes */
/* (0=A:, 1=B: etc.)						 */
BYTE 		get_audio_drive(void);

/* wieviel Sekunden/Frames ist die CD lang */
WORD            CD_length_in_Sec( void);
WORD            CD_length_in_Frames( void);

/* nach wieviel Sekunden ab Start beginnt das Stck */
WORD            Song_Begin_in_Sec( int Song);

#endif  /* _CD_OP_H */
