/* keydefRU.H */
/* country=7, code page=866, language=441, keyboard=ru */

/*
 * history
 * 24 apr 02: tom ehlert - creation
 * 2002.04.28: fixed by Arkady Belousov <ark@mos.ru>
 *
 */

#define LANGUAGE "russia"
#define STATUS   "first try"

#define EURO 0x00	/* unknown so far */

/********************************************************
 * RUSSIAN keyboard mappings				*
 ********************************************************/

/* keyboard contributed by Arkady Belousov <ark@mos.ru>

US characters+Scancodes:
ͻ
~29 02 03 04 05 06 07 08 09 0a 0b 0c 0d 2b  BS 
Ķ
Tab 0fq10w11e12r13t14y15u16i17o18p19[1a]1b      
 < 
 Caps 1da1es1fd20f21g22h23j24k25l26;27'28Enter 1c
Ķ
  Shift 2az2cx2dc2ev2fb30n31m32,33.34/35 Shift  36
ͼ

normal:
ͻ
   1  2  3  4  5  6  7  8  9  0  -  =  \   BS 
Ķ
 Tab                                
 < 
  Caps                          Enter 
Ķ
  Shift                      /    Shift  
ͼ

Caps Lock:
ͻ
   1  2  3  4  5  6  7  8  9  0  -  =  %   BS 
Ķ
 Tab                                
 < 
  Caps                          Enter 
Ķ
  Shift                      ?    Shift  
ͼ

Shift:
ͻ
   !  "    ;  :  ,  .  *  (  )  _  +  %   BS 
Ķ
 Tab                                
 < 
  Caps                          Enter 
Ķ
  Shift                      ?    Shift  
ͼ

Caps Lock+Shift:
ͻ
   !  "    ;  :  ,  .  *  (  )  _  +  %   BS 
Ķ
 Tab                                
 < 
  Caps                          Enter 
Ķ
  Shift                      ?    Shift  
ͼ
*/

uchar scancodetable[] = {

//* 1 */ 0x02, NORMAL,		'1', '!', 0xff,
 /* 2 */ 0x03, NORMAL,		'2', '"', 0xff,
 /* 3 */ 0x04, NORMAL,		'3',0xfc, 0xff,
 /* 4 */ 0x05, NORMAL,		'4', ';', 0xff,
 /* 5 */ 0x06, NORMAL,		'5', ':', 0xff,
 /* 6 */ 0x07, NORMAL,		'6', ',', '^'-'@',
 /* 7 */ 0x08, NORMAL,		'7', '.', 0xff,
//* 8 */ 0x09, NORMAL,		'8', '*', 0xff,
//* 9 */ 0x0a, NORMAL,		'9', '(', 0xff,
//* 0 */ 0x0b, NORMAL,		'0', ')', 0xff,
//* - */ 0x0c, NORMAL,		'-', '_', '_'-'@',
//* = */ 0x0d, NORMAL,		'=', '+', 0,

 /* q */ 0x10, NORMAL+CAPS,	'', '', 'Q'-'@',
 /* w */ 0x11, NORMAL+CAPS,	'', '', 'W'-'@',
 /* e */ 0x12, NORMAL+CAPS,	'', '', 'E'-'@',
 /* r */ 0x13, NORMAL+CAPS,	'', '', 'R'-'@',
 /* t */ 0x14, NORMAL+CAPS,	'', '', 'T'-'@',
 /* y */ 0x15, NORMAL+CAPS,	'', '', 'Y'-'@',
 /* u */ 0x16, NORMAL+CAPS,	'', '', 'U'-'@',
 /* i */ 0x17, NORMAL+CAPS,	'', '', 'I'-'@',
 /* o */ 0x18, NORMAL+CAPS,	'', '', 'O'-'@',
 /* p */ 0x19, NORMAL+CAPS,	'', '', 'P'-'@',
 /* [ */ 0x1a, NORMAL+CAPS,	'', '', '['-'@',
 /* ] */ 0x1b, NORMAL+CAPS,	'', '', ']'-'@',

 /* a */ 0x1e, NORMAL+CAPS,	'', '', 'A'-'@',
 /* s */ 0x1f, NORMAL+CAPS,	'', '', 'S'-'@',
 /* d */ 0x20, NORMAL+CAPS,	'', '', 'D'-'@',
 /* f */ 0x21, NORMAL+CAPS,	'', '', 'F'-'@',
 /* g */ 0x22, NORMAL+CAPS,	'', '', 'G'-'@',
 /* h */ 0x23, NORMAL+CAPS,	'', '', 'H'-'@',
 /* j */ 0x24, NORMAL+CAPS,	'', '', 'J'-'@',
 /* k */ 0x25, NORMAL+CAPS,	'', '', 'K'-'@',
 /* l */ 0x26, NORMAL+CAPS,	'', '', 'L'-'@',
 /* ; */ 0x27, NORMAL+CAPS,	'', '', 0,
 /* ' */ 0x28, NORMAL+CAPS,	'', '', 0,

 /* ~ */ 0x29, NORMAL+CAPS,	'', '', 0,
 /* \ */ 0x2b, NORMAL,		'\\','%', 0,

 /* z */ 0x2c, NORMAL+CAPS,	'', '', 'Z'-'@',
 /* x */ 0x2d, NORMAL+CAPS,	'', '', 'X'-'@',
 /* c */ 0x2e, NORMAL+CAPS,	'', '', 'C'-'@',
 /* v */ 0x2f, NORMAL+CAPS,	'', '', 'V'-'@',
 /* b */ 0x30, NORMAL+CAPS,	'', '', 'B'-'@',
 /* n */ 0x31, NORMAL+CAPS,	'', '', 'N'-'@',
 /* m */ 0x32, NORMAL+CAPS,	'', '', 'M'-'@',
 /* , */ 0x33, NORMAL,		'', '', 0,
 /* . */ 0x34, NORMAL,		'', '', 0,
//* / */ 0x35, NORMAL,		'/', '?', 0,
	 0
};

// character to be send, if NUMLOCK+'.' on numeric keypad
// #define DECIMALDINGSBUMS '.'
                              
// define this, if after starting the default layout is still international                              
#define DEFAULT_LAYOUT_ENGLISH




