.include "crc48.tab"

insert_long_filename:
		push	si
		push	di
		mov		si,di
		call	find_file_directory_entry
		jc		?exit					; shouldn't happen
		; nab the sfn checksum
		push	ax
		mov		di,ax
		call	calc_sfn_checksum
		mov		[?sfn_checksum],al
		pop		ax
		; copy the sfn dirent to temporary storage
		mov		si,ax
		mov		di,?dirent_buffer
		mov		cx,dirent/4
		rep
		movsd
		; delete the sfn dirent
		movb	[eax+dirent.name+0],0xe5; deleted file entry
		movb	[bx+search_handle.current.dirty],1
		; find out how many directory entries are needed to store the lfn and
		; sfn together
		mov		di,[esp+2]
		call	strlen
		mov		cx,13					; 13 lfn chars per directory entry
		xor		dx,dx
		div		cx
		test	dx,dx					; dx holds remainder, if it's not
		setnz	cl						; zero, need one more dirent
		add		cx,ax					; cx=# direntries needed for lfn
		inc		cx						; one more for sfn
		call	goto_directory_start	; preserves cx
		jc		?error
		call	find_space				; bx from find_file_directory_entry above
		jc		?error
		mov		si,[esp+2]
		mov		cl,[?sfn_checksum]
		mov		dx,?dirent_buffer
		call	write_lfn
	?error:
	?exit:
		pop		di
		pop		si
		ret
	?dirent_buffer	.struct dirent
	?sfn_checksum:
		.db		0
; end of insert_long_filename

generate_short_filename:
		push	ecx
		push	edx
		push	ebx
		push	si
		push	di
		; if there are leading spaces or periods, the name cannot be used by
		; dos
		xor		eax,eax
		cmpb	[si],' '
		je		?not_valid_sfn
		cmpb	[si],'.'
		je		?not_valid_sfn
		; make sure the name part is <= 8 chars with no invalid chars (lower
		; case chars are invalid).
		mov		cx,8
	?name_loop:
		lodsb
		test	al,al
		jzl		?valid_sfn
		cmp		al,'.'
		je		?check_ext
		bt		[?valid_chars],ax
		jnc		?not_valid_sfn
		loop	?name_loop
		; no dots before here. if there's no dot and the string doesn't end
		; here, the name is invalid for dos.
		cmpb	[si],0
		jel		?valid_sfn
		cmpb	[si],'.'
		jne		?not_valid_sfn
		inc		si
		; if there's a trailing dot, the file name is invalid (allows trailing
		; dots in the file name)
		cmpb	[si],0
		je		?not_valid_sfn
	?check_ext:
		; make sure the extension is <= 3 chars with no invalid chars (lower
		; case chars and periods are invalid).
		mov		cx,3
	?ext_loop:
		lodsb
		test	al,al
		jz		?valid_sfn
		cmp		al,'.'
		je		?not_valid_sfn
		bt		[?valid_chars],ax
		jnc		?not_valid_sfn
		loop	?ext_loop
		; if the name end's here, its valid.
		cmpb	[si],0
		je		?valid_sfn
	?not_valid_sfn:
		; Calculate the 48 bit crc checksum of the long filename. Uses the
		; reflected form as it makes for slightly simpler coding. Actually
		; uses an algorithm suitable for 64 bit crc's, except the table has
		; has been setup with 48 bit numbers.
		mov		si,[esp+2]
		xor		ebx,ebx
		xor		edx,edx
	?crc_loop:
		lodsb
		test	al,al
		jz		?crc_done
		xor		al,bl
		movzx	eax,al
		shrd	ebx,edx,8
		shr		edx,8
		xor		ebx,[8*eax+crc48_table]
		xor		edx,[8*eax+crc48_table+4]
		jmp		?crc_loop
	?crc_done:
		; Now encode the 48 bit crc checksum as 8 6 bit values using a custom
		; base 64 encoding (just the 64 bit value added to 0xb0). Unfortuanly,
		; dos just might change the characters under other codepages. Hmm, I
		; wonder if dynamic codepage swapping will be feasable?? Or maybe
		; hooking int -D-2F1213 (upcase char) and not modifying chars in the
		; range 0xb0-0xef will do the trick.
		mov		cx,8
	?encode_loop:
		mov		al,bl
		and		al,0x3f
		add		al,0xb0
		cmp		al,0xe5					; dos file deleted flag :(
		jne		@f1
		mov		al,0xf0
	@f1:
		stosb
		shrd	ebx,edx,6
		shr		edx,6
		loop	?encode_loop
		movb	[di],0
	?find_dot:
		; find the extension (if it exists) and append it to the generated
		; short name. This way, the type of the file can still be identified.
		dec		si
		cmp		si,[esp+2]
		je		?exit
		cmpb	[si],'.'
		jne		?find_dot
		call	strucpy					; upcase as copying
		movb	[di+4],0				; truncate extension
		jmp		?exit
	?valid_sfn:
		; just copy the filename as its a perfectly valid dos filename and
		; doesn't have any lowercase characters
		mov		si,[esp+2]
		call	strcpy
		movb	[si],0
	?exit:
		pop		di
		pop		si
		pop		ebx
		pop		edx
		pop		ecx
		ret
	?valid_chars:
		; This is a bit table of the valid chars in a dos sfn.
		.dd		0x00000001	; control chars except nul invalid
		.dd		0x03ff63fb	; "*+,/:;<=>? invalid
		.dd		0xc7ffffff	; [\] invalid
		.dd		0xe8000001	; lower case chars and | invalid
		; the correctness of extended characters depends greatly on the
		; current codepage. It seems dos converts the lowercase accented chars
		; to uppercase, often unaccented (depends on the character),
		; characters. This can be a royal pain in the but, as it all depends
		; on the codepage.
		.dd		0xffffffff	; all extended chars valid (??)
		.dd		0xffffffff	; all extended chars valid (??)
		.dd		0xffffffff	; all extended chars valid (??)
		.dd		0xffffffff	; all extended chars valid (??)
; end of generate_short_filename

lfn_open_file:
		call	get_short_name
		jc		?file_does_not_exist
		; ok, the file exists. let dos do the dirty work (version permitting)
		cmpw	[dos_version],0x0400
		jb		?extended_open
		mov		ax,0x6c00
		mov		bx,[bp+sf.BX]
		mov		dh,0
		mov		si,di
		int		0x21
		jcl		?error
		mov		[bp+sf.AX],ax
		jmpl	?file_opened
	?extended_open:
		; for dos versions < 4.00, extended open needs to be emulated
		test	dl,2					; truncate?
		jz		?open_file
		; truncate the file
		mov		ah,0x3c
		mov		dx,di
		int		0x21
		jcl		?error
		mov		cx,3					; file truncated/replaced
		mov		[bp+sf.AX],ax
		jmp		?file_opened
	?open_file:
		test	dl,1
		jz		?not_open_file
		; open the file
		mov		ah,0x3d
		mov		al,[bp+sf.BL]
		mov		dx,di
		int		0x21
		jc		?error
		mov		cx,1					; file opened
		mov		[bp+sf.AX],ax
		jmp		?file_opened
	?not_open_file:
		mov		ax,DE_file_exists
		jmp		?error

		; If the call to get_short_name failed because it couldn't find the
		; file, create it.  Otherwise fail the call (eg path not found or some
		; other error.
	?file_does_not_exist:
		cmp		ax,DE_file_not_found	; fail on any other reason
		jne		?error
		test	dl,0x10					; create flag
		jz		?error
		; generate an sfn for the file
		call	generate_short_filename
		; first, get dos to try to create the file.
		cmpw	[dos_version],0x0400
		jb		?extended_create
		mov		ax,0x6c00
		push	bx						; preserve search handle
		push	si
		mov		bx,[bp+sf.BX]
		mov		dh,0
		mov		si,filename_buffer		; get_short_name puts sfn here
		int		0x21
		pop		si
		pop		bx
		jc		?error
		jmp		?do_lfn
	?extended_create:
		mov		ah,0x3c
		mov		dx,filename_buffer		; get_short_name puts sfn here
		int		0x21
		jc		?error
		; XXX need to insert lfn directory entries
	?do_lfn:
		mov		[bp+sf.AX],ax			; save the file handle
		cmpb	[si],0
		je		?file_created			; lfn was valid sfn, don't bother
		; insert lfn directory entries
		mov		di,filename_buffer
		call	insert_long_filename
		jnc		?file_created
		; blargh, couldn't insert the lfn. close and delete the created file
		push	ax
		; close the file
		mov		bx,[bp+sf.AX]			; retrieve the file handle
		mov		ah,0x3e
		int		0x21
		; make sure read only is not set
		mov		ax,0x4301
		xor		cx,cx
		mov		dx,filename_buffer
		int		0x21
		; delete the file
		mov		ah,0x41
		int		0x21
		pop		ax
		jmp		?error
	?file_created:
		mov		cx,2					; file created
	?file_opened:
		mov		[bp+sf.CX],cx
		jmp		?exit
	?error:
		orb		[bp+sf.FLAGS],1
		mov		[bp+sf.AX],ax
	?exit:
		ret
; end of lfn_open_file

lfn_delete_file:
		;       AX = 7141h
		;       DS:DX -> ASCIZ long name of file to delete
		;       SI = wildcard and attributes flag
		;               0000h wildcards are not allowed, and search attributes are
		;                       ignored
		;               0001h wildcards are allowed, and only files with matching
		;                       names and attributes are deleted
		;       CL = search attributes
		;       CH = must-match attributes
		;Return: CF clear if successful
		;       CF set on error
		;           AX = error code (see #1332)
		;               7100h if function not supported
		;Note:  for compatibility with DOS versions prior to v7.00, the carry flag
		;         should be set on call to ensure that it is set on exit
		cmp		si,0
		jne		?scan_delete
		mov		si,dx
		call	get_short_name
		jc		?error
		mov		ah,0x41
		mov		dx,di
		int		0x21
		jc		?error
		call	delete_lfn
		jmp		?exit
	?scan_delete:
		mov		ax,DE_invalid_function
	?error:
		mov		[bp+sf.AX],ax			; return error code
		orb		[bp+sf.FLAGS],1			; set carry
	?exit:
		ret
; end of lfn_delete_file

lfn_rename_file:
		;       AX = 7156h
		;       DS:DX -> ASCIZ old file or directory name (long names allowed)
		;       ES:DI -> ASCIZ new name (long names allowed)
		;Return: CF clear if successful
		;       CF set on error
		;           AX = error code
		;               7100h if function not supported
		;Note:  the file may be renamed into a different directory, but not across
		;         disks
		ret
; end of lfn_rename_file

lfn_extended_attrs:
		cmp		bl,8
		jal		?invalid_function

		mov		si,dx
		push	bx						; save function index
		call	get_short_name
		mov		dx,di					; save sfn
		pop		di						; retrieve function index
		jcl		?error
		; Now that we have the file's short name, we can call the appropriate
		; dos function.
		and		di,0xff
		shl		di,1
		jmp		[di+?jump_table]
	?jump_table:
		.dw		?get_attributes
		.dw		?set_attributes
		.dw		?get_physical_size
		.dw		?set_write_datetime
		.dw		?get_write_datetime
		.dw		?set_access_date
		.dw		?get_access_date
		.dw		?set_create_datetime
		.dw		?get_create_datetime
	?get_attributes:
	?set_attributes:
		mov		ax,di
		shr		ax,1
		mov		ah,0x43
		int		0x21
		jc		?error
		mov		[bp+sf.CX],cx			; should be ok for set attributes
		ret
	?get_physical_size:
		cmpw	[dos_version],0x700
		jb		?gps_not_dos7
		mov		ax,di
		shr		ax,1
		mov		ah,0x43
		int		0x21
		jc		?error
		jmp		?gps_done
	?gps_not_dos7:
	?gps_done:
		mov		[bp+sf.DX],dx
		mov		[bp+sf.AX],ax
		ret
	?set_access_date:
	?get_access_date:
	?set_create_datetime:
	?get_create_datetime:
		add		bl,2
	?set_write_datetime:
	?get_write_datetime:
		sub		bl,3
		mov		ah,0x57
		mov		al,bl
		mov		si,ax
		mov		ax,0x3dc0				; no-inherit,denynone,read only
		int		0x21
		jc		?error
		mov		bx,ax
		mov		ax,si
		xor		cx,cx
		cmp		di,5*2					; set access time
		je		@f1
		mov		cx,[bp+sf.CX]
	@f1:
		mov		dx,[bp+sf.DI]
		mov		si,[bp+sf.SI]
		int		0x21
		pushf
		push	ax
		mov		ah,0x3e
		int		0x21
		pop		ax
		popf
		jc		?error
		cmp		di,6*2					; get access time
		je		@f2
		mov		[bp+sf.CX],cx
	@f2:
		mov		[bp+sf.DI],dx
		mov		[bp+sf.SI],si
		ret
	?invalid_function:
		mov		ax,1
	?error:
		mov		[bp+sf.AX],ax
		orb		[bp+sf.FLAGS],1
		ret
; end of lfn_extended_attrs
