; read_sectors
; write_sectors
; select_drive
; read_fat_entry
; write_fat_entry

; FARPTR

.include "bpb.inc"

		.struct	DT_PACKET
sector	.dd
count	.dw
buffer	.struct	FARPTR
		.ends

dt_packet .struct	DT_PACKET

use_217305:			; int 25/26 doesn't work under fat32. int 21, ax=7305, 
		.db		1	; cx=ffff must be used instead. Under windows 95, non
					; fat32 drives seem to be accessable using int 25/26,
					; but in dos mode int 25/26 never work. By default
					; 217503 will be used, and if this returns invalid
					; function, then int 25/26 will be used instead

read_sectors:
		; Read sectors from drive
		;	al -> drive (0=A:, 1=B: 2=C:...)
		;	ds:bx -> transfer buffer
		;	edx -> starting sector (0 based)
		;	cx -> number of sectors to read
		push	esi
		mov		si,0					; read
		call	read_write_sectors
		pop		esi
		ret

write_sectors:
		; Write sectors from drive
		;	al -> drive (0=A:, 1=B: 2=C:...)
		;	ds:bx -> transfer buffer
		;	edx -> starting sector (0 based)
		;	cx -> number of sectors to read
		push	esi
		mov		si,1					; write, unknow type
		call	read_write_sectors
		pop		esi
		ret

extended_dpb:
		.db 72 .dup 0
get_extended_dpb:
		push	ax
		push	dx
		push	es
		push	di
		push	cx
		mov		dl,al
		inc		dl
		mov		cx,72
		mov		ax,0x7302
		push	cs
		pop		es
		mov		di,extended_dpb
		int		0x21
		pop		cx
		pop		di
		pop		es
		pop		dx
		pop		ax
		ret

unlock_disk:
		ret

lock_disk:
		push	ax
		push	cx
		push	dx
		push	bx
		mov		bl,al
		inc		bl
		mov		bh,0					; is this the right lock level?
		mov		ax,0x440d
		mov		cx,0x086a
		mov		dx,0
		int		0x21
		pop		bx
		pop		dx
		pop		cx
		pop		ax
		ret

read_write_sectors:
		; save all registers (int 25/26 scrags some)
		pushad
		push	ds
		; flush all disk buffers. This seems to be required under MS-DOS 7.1
;		push	edx
;		push	eax
;		mov		dl,al
;		mov		ah,0x0d
;		int		0x21
;		pop		eax
;		pop		edx
		; setup the disk transfer packet. There's a very good chance it will
		; be used and the writes cost very little compered to an actual disk
		; access, even for hard drives.
		mov		[cs:dt_packet.sector],edx
		mov		[cs:dt_packet.count],cx
		mov		[cs:dt_packet.buffer.offs],bx
		mov		[cs:dt_packet.buffer.seg],ds
		push	ax						; fake out an int 25/26 stack frame
										; also has the benefit of saving ax for later
		; determine which set of functions should be used. int 21/ax=7305 must
		; be used if the drive is fat32, but is an invalid function under
		; older dos's.
		cmpb	[cs:use_217305],0
		je		?not_fat32
		push	ds
		push	cx
		push	dx
		push	ax

		push	cs
		pop		ds
		mov		bx,dt_packet
		mov		cx,0xffff
		mov		dl,al
		inc		dl						; 0=default drive rather than a:
		mov		ax,0x7305
		int		0x21
		jc		?not_ok
		cmp		ax,0x7305				; Win95 preserves ax, open-dos clears al
		je		?ok
		cmp		ax,0x0207				; Seems MS-DOS 7.1 sets ax to 0x0207
		je		?ok						;  red herring?
		mov		ax,DE_invalid_function
		stc								; cmp above clears carry
?not_ok:
		mov		[esp],ax				; save error code
?ok:
		pop		ax
		pop		dx
		pop		cx
		pop		ds
		jnc		?exit
		cmp		ax,DE_invalid_function
		stc
		je		?not_fat32
		jmp		?exit
?not_fat32:
		pop		ax						; unfake the int 25/26 stack frame and restor ax
		movb	[cs:use_217305],0
		cmpw	[cs:dos_version],0x0331
		jae		?big_partition
		cmp		edx,0xffff
		jbe		?read_write_sectors
		sub		sp,2
		stc
		mov		ax,0x0408
		jmp		?exit
?big_partition:
		push	cs
		pop		ds
		mov		bx,dt_packet
		mov		cx,0xffff
?read_write_sectors:
		test	si,1
		jz		?read_sectors
		int		0x26
		jmp		?exit
?read_sectors:
		int		0x25
		jmp		?exit
?exit:
		push	ax
		pushf
		pop		ax
		and		esp,0xffff
		mov		[esp+2],ax
		pop		ax
		popf
		pop		ds
		mov		[esp+0x1c],ax			; allow ax to be returned
		popad
		nop		; avoid bug on old 386's (like mine)
		ret

boot_block	.struct Boot_Sector
fat_buffer:
		.db 512*4 .dup 0
fat_sector:			; currently cached (relative) fat sector(s)
		.dd		0
current_drive:
		.dw		0xffff
cluster_size:		; sectors per cluster
		.dd		0
first_fat:			; start sector of first fat
		.dd		0
active_fat:			; start sector of active fat
		.dd		0
fat_size:			; sectors per fat
		.dd		0
cluster_0:			; beginning of root directory (unless fat32)
		.dd		0
cluster_0_size:
		.db		0
cluster_2:			; beginning of data area
		.dd		0
root_cluster:		; cluster number of root directory (non 0 for fat32)
		.dd		0
fat_type:			; type of fat
		.db		0	;  valid vales: 1(fat12), 2(fat16) or 3(fat32)
num_fats:			; number of fats
		.db		0
mirror_fat:			; fat mirroring control (1=enabled, 0=disabled
		.db		0

select_drive:
		cmp		[current_drive],ax
		jne		?load_parms
		clc
		ret
	?load_parms:
		push	eax
		push	ecx
		push	edx
		push	ebx
		movw	[current_drive],0xffff		; reset current drive
		xor		edx,edx						; read sector 0
		mov		cx,1
		mov		bx,boot_block
		push	ax
		call	read_sectors
		pop		ax
		jcl		?exit
		mov		[current_drive],ax
		; mark the fat type as unknown
		movb	[fat_type],0
		; copy the sectors per cluster field
		movzxb	eax,[boot_block.bpb.spc]
		mov		[cluster_size],eax
		; copy the number of fat copies
		movzxb	ecx,[boot_block.bpb.nfat]
		mov		[num_fats],cl
		; copy the sectors per fat field (coping with fat32)
		movzxw	eax,[boot_block.bpb.sspf]
		or		eax,eax
		jnz		?not_fat32
		mov		eax,[boot_block.bpb.spf]
		movb	[fat_type],3
	?not_fat32:
		mov		[fat_size],eax
		; total number of sectors dedicated to the fat(s)
		mul		ecx
		; add in the number of reserved sectors
		movzxw	ecx,[boot_block.bpb.nrsec]
		mov		[first_fat],ecx
		mov		[active_fat],ecx
		add		eax,ecx
		; save the calculated cluster 0 and default the root dir cluster to 0
		mov		[cluster_0],eax
		movd	[root_cluster],0
		; get the size of cluster 0 (the root directory on fat12/16) to find
		; cluster 2
		movzxw	ecx,[boot_block.bpb.nrde]
		add		ecx,16-1
		shr		ecx,4
		add		eax,ecx
		mov		[cluster_0_size],cl
		mov		[cluster_2],eax
		or		ecx,ecx
		jnz		?cluster_0_exists
		; no root dir entries, so root directory is actually a `file' in the
		; data space
		mov		eax,[boot_block.bpb.rdclust]
		mov		[root_cluster],eax
	?cluster_0_exists:
		cmpb	[fat_type],0
		jne		?fat_type_set
		incb	[fat_type]				; assume fat12
		; determine the fat type
		movzxw	eax,[boot_block.bpb.stsec]; 16 bit sector count
		or		eax,eax
		jnz		?small_volume
		mov		eax,[boot_block.bpb.tsec]; 32 bit sector count
	?small_volume:
		sub		eax,[cluster_2]
		xor		edx,edx
		divd	[cluster_size]
		cmp		eax,0xff6
		jbe		?fat12
		incb	[fat_type]				; set to fat16
	?fat12:
	?fat_type_set:
		movd	[fat_sector],-1
		movb	[mirror_fat],2
		cmpb	[fat_type],3
		jne		?fat_type_determined
		movzxw	eax,[boot_block.bpb.xflags]
		; set the mirroring control
		or		al,al
		setns	[mirror_fat]			; bit 7==1->no mirroring
		; determine the active fat
		and		eax,0x0f
		muld	[fat_size]
		add		eax,[first_fat]
		mov		[active_fat],eax
	?fat_type_determined:
		; done
		clc
	?exit:
		pop		ebx
		pop		edx
		pop		ecx
		pop		eax
		ret
; end of select_drive

read_fat_entry:
		push	cx
		push	edx
		cmp		eax,2
		jb		?error
		cmpb	[fat_type],1
		je		?fat12
		cmpb	[fat_type],2
		je		?fat16
		cmpb	[fat_type],3
		jel		?fat32
	?error:
		pop		edx
		pop		cx
		stc
		ret
	?fat12:
		cmp		eax,0x0ff8
		jae		?error
		lea		eax,[eax+eax*2]		; eax*=3
		push	eax
		shr		ax,10				; get sector triple
		aam		3
		mov		al,0
		aad		3
		cmp		eax,[fat_sector]
		je		?f12_fat_cached
		mov		[fat_sector],eax
		add		ax,[active_fat]
		mov		edx,eax
		mov		ax,[current_drive]
		push	bx
		mov		bx,fat_buffer
		mov		cx,3
		call	read_sectors
		pop		bx
		jnc		?f12_fat_cached
		pop		eax
		jmp		?error
	?f12_fat_cached:
		pop		eax
		xor		edx,edx
		mov		cx,512*2*3
		div		cx
		shr		dx,1
		setc	cl
		shl		cl,2
		movzxw	eax,[edx+fat_buffer]
		shr		ax,cl
		; convert FAT12 eof markers to FAT32 EOF markers
		cmp		ax,0x0ff8
		jb		?not_eof_12
		or		eax,0x0ffff000
	?not_eof_12:
		pop		edx
		pop		cx
		clc
		ret
	?fat16:
		cmp		eax,0xfff8
		jae		?error
		push	eax
		shr		ax,8				; get sector number
		and		al,~(4-1)
		cmp		eax,[fat_sector]
		je		?f16_fat_cached
		mov		[fat_sector],eax
		add		ax,[active_fat]
		mov		edx,eax
		mov		ax,[current_drive]
		push	bx
		mov		bx,fat_buffer
		mov		cx,4
		call	read_sectors
		pop		bx
		jnc		?f16_fat_cached
		pop		eax
		jmpl	?error
	?f16_fat_cached:
		pop		eax
		and		eax,256*4-1
		movzxw	eax,[eax*2+fat_buffer]
		; convert FAT16 eof markers to FAT32 EOF markers
		cmp		ax,0xfff8
		jb		?not_eof_16
		or		eax,0x0fff0000
	?not_eof_16:
		pop		edx
		pop		cx
		clc
		ret
	?fat32:
		cmp		eax,0x0ffffff8
		jael	?error
		push	eax
		shr		eax,7				; get sector number
		and		al,~(4-1)
		cmp		eax,[fat_sector]
		je		?f32_fat_cached
		mov		[fat_sector],eax
		add		ax,[active_fat]
		mov		edx,eax
		mov		ax,[current_drive]
		push	bx
		mov		bx,fat_buffer
		mov		cx,4
		call	read_sectors
		pop		bx
		jnc		?f32_fat_cached
		pop		eax
		jmpl	?error
	?f32_fat_cached:
		pop		eax
		and		eax,128*4-1
		mov		eax,[eax*4+fat_buffer]
		pop		edx
		pop		cx
		clc
		ret
; end of read_fat_entry

write_fat_entry:
		; in
		;	eax=cluster entry
		;	edx=value to write
		push	eax
		push	edx
		call	read_fat_entry
		pop		edx
		pop		eax
		jc		?error
		cmpb	[fat_type],1
		je		?fat12
		cmpb	[fat_type],2
		je		?fat16
		cmpb	[fat_type],3
		je		?fat32
	?error:
		pop		edx
		pop		cx
		stc
		ret
	?fat12:
		cmp		eax,0x0ff8
		jae		?error
		push	bx
		lea		eax,[eax+eax*2]		; eax*=3
		shr		eax,1
		setc	cl
		shl		cl,2
		mov		bx,0x0fff
		and		dx,bx
		shl		bx,cl
		and		[eax+fat_buffer],bx
		pop		bx
		shl		dx,cl
		or		[eax+fat_buffer],dx
		mov		cx,1
		jmp		?common
	?fat16:
		cmp		eax,0xfff8
		jae		?error
		mov		[eax*2+fat_buffer],dx
		mov		cx,4
		jmp		?common
	?fat32:
		cmp		eax,0x0ffffff8
		jae		?error
		mov		[eax*4+fat_buffer],edx
		mov		cx,4
		;jmp		?common
	?common:
		push	bx
		mov		bx,fat_buffer
		mov		edx,[active_fat]
		cmpb	[mirror_fat],0
		jne		?mirror_fat
		mov		ax,[current_drive]
		call	write_sectors
		jmp		?exit
	?mirror_fat:
		push	bp
		mov		edx,[first_fat]
		movzxb	bp,[num_fats]
	?mirror_fat_loop:
		mov		ax,[current_drive]
		call	write_sectors
		jc		?mirror_fat_done
		add		edx,[fat_size]
		dec		bp
		jnz		?mirror_fat_loop
	?mirror_fat_done:
		pop		bp
	?exit:
		pop		bx
		pop		edx
		pop		cx
		ret
; end of write_fat_entry

cluster_to_sector:
		cmp		eax,0x0ffffff7
		cmc
		jb		?exit
		sub		eax,2
		push	edx
		muld	[cluster_size]
		pop		edx
		add		eax,[cluster_2]
	?exit:
		ret
; end of cluster_to_sector

allocate_cluster:
		; NOTE: will not work for fat32!! Need more info on how to get (and
		; set) the search cluster from the os. There is the entry in the
		; fsinfo sector, but I suspect there will be something in memory too.
		push	es
		push	ecx
		push	edx
		push	bx
		; first, find out where we should start searching for a free cluster.
		mov		ah,0x32
		mov		dl,[current_drive]
		inc		dl
		push	ds
		int		0x21
		push	ds
		pop		es
		pop		ds
		movzxw	ecx,[es:bx+0x0d]	; highest cluster number
		inc		ecx
		; calculate offset of search cluster based on dos version (<4.0=0x1c,
		; >=4.0=0x1d)
		add		bx,0x1d
		cmpw	[dos_version],0x400
		sbb		bx,0
		movzxw	edx,[es:bx]			; search cluster
	?next_cluster:
		mov		eax,edx
		call	read_fat_entry
		or		eax,eax
		je		?found_cluster
		inc		edx
		cmp		edx,ecx
		jb		?next_cluster
		stc
		jmp		?exit
	?found_cluster:
		mov		eax,edx
		mov		[es:bx],dx			; search cluster
		push	eax
		mov		edx,0x0ffffff8
		call	write_fat_entry
		push	cs
		pop		es
		mov		eax,[esp]
		call	cluster_to_sector
		mov		edx,eax
		mov		bx,?zero_buffer
		mov		cx,[cluster_size]
	?write_loop:
		push	cx
		mov		cx,1
		mov		ax,[current_drive]
		call	write_sectors
		pop		cx
		inc		edx
		loop	?write_loop
		pop		eax
	?exit:
		pop		bx
		pop		edx
		pop		ecx
		pop		es
		ret
	?zero_buffer:
		.db 512 .dup 0
; end of allocate_cluster
