		.struct	dirent
name	.db 8 .dup				; blank padded
ext		.db 3 .dup				; blank padded
attr	.db						; file attribute bits
								; Bit(s)	Description	(Table 1089)
								;  0		read-only
								;  1		hidden
								;  2		system
								;  3		volume label
								;  4		directory
								;  5		archive bit
								;  6		reserved
								;  7		if set, file is shareable under Novell
								;			NetWare
								; if 0x0f, is a lfndirent
		; W95 only(?) (OpenDos password)
		.db						; reserved
crt_cs	.db						; creation time 10ms units (centi-seconds)
cr_time	.dw						; file creation time
cr_date	.dw						; file creation date
la_date	.dw						; last access date
clustHi	.dw						; fat32 high word of starting cluster number
		; Back to normal fields
time	.dw						; last modified time
date	.dw						; last modified date
clust	.dw						; starting cluster number
size	.dd						; file size in bytes
		.ends

		.struct lfndirent
index	.db						; bit 6=first entry flag, bits 0-5=entry index
name1	.dw 5 .dup				; names are unicode
sig		.db						; 0x0f (an otherwise impossible file attribute)
		.db						; unknown
chksum	.db						; checksum of the sfn directory entry name+ext
name2	.dw 6 .dup
zero	.dw						; starting cluster always 0
name3	.dw 2 .dup
		.ends

		.struct dirent_record
cluster	.dd						; current cluster number;
sector	.dd						; current absolute sector number
rel_sec	.db						; relative sector number within this cluster
num_sec	.db						; number of sectors in this cluster
index	.db						; directory entry within sector
dirty	.db						; sector needs to be written
		.ends

		.struct search_handle
spec	.db 256 .dup			; search spec
app_psp	.dw						; applications psp. used for handle cleanup
drive	.dw						; drive number
sattr:							; search attribute mask
Aattr	.db						; can be set attr bits
Mattr	.db						; must be set attr bits
start	.dd						; start cluster of directory
current	.struct dirent_record	; current directory entry
lfnstart .struct dirent_record	; firsrt directory entry of lfn
		.ends

mde_long_name:
		.db 261 .dup 0
mde_short_name:
		.db 16 .dup 0
mde_sfn_checksum:
		.db 0

extract_lfn_name:
		; copies the contents of an lfn directory entry into the correct slot
		; of the long name buffer (mde_long_name). does not support unicode
		; characters, the high byte is lost.
		; in
		;	di=directory entry
		push	esi
		push	eax
		; stash away the sfn checksum
		mov		al,[di+lfndirent.chksum]
		testb	[di+lfndirent.index],0x40; is it the first entry?
		jnz		?first_entry
		cmp		[mde_sfn_checksum],al
		jne		?exit					; opps, the lfn entries must have been scrambled
	?first_entry:
		mov		[mde_sfn_checksum],al
		; right, where do we put this thing? lfn directory entries store 13
		; characters. the index byte of the lfn dirent stores both the flag
		; indicating that this is the first dirent for this lfn and the dirent
		; number (1 based!!!).
		movzxb	eax,[di+lfndirent.index]
		and		al,0x3f					; extract the index
		dec		al						; indexes are 1 based!!!
		; fast (4 cylces on 386, 2 on 486 (not counting pipeline stalls)
		; multiply by 13! lea doesnt affect the flags, so the test is stuck
		; between the lea instructions to reduce pipeline stalls
		lea		esi,[eax+eax*2]			; esi=eax*3=ind*3
		testb	[di+lfndirent.index],0x40; is it last chunk (first entry)?
		lea		esi,mde_long_name[eax+esi*4]; esi=eax+esi*4=ind+ind*4*3=ind*13+mde_long_name
		jz		?not_end
		movb	[si+13],0				; null terminate the string
	?not_end:
		; now copy the name (it will be 0 terminated if it's less that 13
		; chars, and the rest will be 0xFF). Unfortuanly, the name segments
		; are not contiguous, so a simple loop cannot be used.
		mov		ax,[di+lfndirent.name1+0*2]
		mov		[si+0],al
		mov		ax,[di+lfndirent.name1+1*2]
		mov		[si+1],al
		mov		ax,[di+lfndirent.name1+2*2]
		mov		[si+2],al
		mov		ax,[di+lfndirent.name1+3*2]
		mov		[si+3],al
		mov		ax,[di+lfndirent.name1+4*2]
		mov		[si+4],al
		mov		ax,[di+lfndirent.name2+0*2]
		mov		[si+5],al
		mov		ax,[di+lfndirent.name2+1*2]
		mov		[si+6],al
		mov		ax,[di+lfndirent.name2+2*2]
		mov		[si+7],al
		mov		ax,[di+lfndirent.name2+3*2]
		mov		[si+8],al
		mov		ax,[di+lfndirent.name2+4*2]
		mov		[si+9],al
		mov		ax,[di+lfndirent.name2+5*2]
		mov		[si+10],al
		mov		ax,[di+lfndirent.name3+0*2]
		mov		[si+11],al
		mov		ax,[di+lfndirent.name3+1*2]
		mov		[si+12],al
	?exit:
		pop		eax
		pop		esi
		ret
; end of extract_lfn_name

extract_short_name:
		; copies the contents of an sfn directory entry to the short name
		; buffer (mde_short_name).  Trims trailing (but not internal) spaces
		; from the name and extenstion and also places a '.' between the name
		; and extenstion and 0 terminates the short name buffer.  However, if
		; the extenstion is all spaces, the '.' is removed from the name
		; buffer
		; in
		;	di=directory entry
		push	si
		push	di
		push	cx
		push	ax
		push	es
		; set up the registers
		push	cs
		pop		es
		mov		al,' '
		mov		si,di
		mov		di,mde_short_name
		; copy the filename part
		mov		cx,8
		cld
		rep
		movsb
		; backup over any trailing spaces
		dec		di
		std
		mov		cx,8
		repe
		scasb
		add		di,3
		; insert a '.'
		movb	[di-1],'.'
		; copy the extension
		cld
		mov		cx,3
		rep
		movsb
		; backup over any traling spaces in the extension
		dec		di
		std
		mov		cx,3
		repe
		scasb
		cmpb	[di],'.'
		jne		?not_dot
		cmpb	[di+1],' '				; is char after the '.' a space
		je		?term_string			; yes, remove the extension
	?not_dot:
		add		di,2
	?term_string:
		; terminate the string
		movb	[di],0

		cld
		pop		es
		pop		ax
		pop		cx
		pop		di
		pop		si
		ret
; end of extract_short_name

calc_sfn_checksum:
		; Calculates the checksum of the sfn directory entry name+extension.
		; The previous sum is rotate 1 bit to the right before adding the next
		; character.
		; in
		;	di=directory entry
		; out
		;	al=checksum
		push	cx
		push	di
		mov		al,0
		mov		cx,11
	?loop:
		ror		al,1
		add		al,[di]
		inc		di
		loop	?loop

		pop		di
		pop		cx
		ret
; end of calc_sfn_checksum

fn_match:
		; Match a filename with a file spec. I beleive this uses the overall
		; algorithm as windows 95 for wildcard matching.  The implementation
		; is taken from src/libc/posix/fnmatch/fnmatct.c of djgpp with the
		; following modifications: character sets ([...]) are not supported
		; and "*.*" will match any file, including files with no dots.  The
		; one known variation from windows 95 is the optional case
		; sensitivity.
		; in
		;	ax=case flag (1=sensitive)
		;	si=file name (test characters)
		;	di=search spec (match characters)
		; out
		;	cf set no match, cf clear match
		push	di
		push	si
		push	ax
	?match_loop:
		; optimize for "*" or "*.*" and the end of the spec (this allows *.*
		; to match `foo')
		cmpw	[di],0x002a				; "*" (with terminating 0)
		je		?match
		cmpd	[di],0x002a2e2a			; "*.*" (with terminating 0)
		je		?match
		; get the match character
		mov		ah,[di]
		inc		di
		; special case '\0', '?' and '*'
		cmp		ah,0
		je		?case_0
		cmp		ah,'?'
		je		?case_Q
		cmp		ah,'*'
		je		?case_S
		; any other character must match either exactly (ax on entry!=0) or
		; with case conversion. Does not take locale into consideration, so
		; funny things may happen with extended characters.
	?default:
		; get the test character
		lodsb
		; is case sensitivity wanted
		testw	[esp],-1				; pushed ax (sensitivity flag)
		jnz		?insensitive
		; convert the test character to uppercase
		call	toupper
		; swap the test and match characters. The order of comparison doesn;t
		; matter as all we're interested in is equality
		xchg	al,ah
		; convert the match character to uppercase
		call	toupper
	?insensitive:
		cmp		ah,al
		jne		?no_match
		jmp		?match_loop
		; The end of the match string. The test string must end here as well.
	?case_0:							; c==0
		; the test string must also stop here
		cmpb	[si],0
		je		?match
		jmp		?no_match
		; match with any character except '\0'
	?case_Q:							; c=='?'
		; the test string must not stop here
		cmpb	[si],0
		je		?no_match
		inc		si
		jmp		?match_loop
		; match with 0 or more characters of any description.
	?case_S:							; c=='*'
		mov		ah,[di]
		; gobble up successive '*'s as they're redundant
	?gobble_S:
		cmp		ah,'*'
		jne		?g_not_star
		inc		di
		mov		ah,[di]
		jmp		?gobble_S
	?g_not_star:
		; if there's no more match characters, then the match automatically
		; succeeds as '*' matches anything
		cmp		ah,0
		je		?match
		mov		bx,di
	?star_loop:
		cmpb	[si],0
		je		?no_match
		mov		ax,[esp+2]
		call	fn_match
		jnc		?match
		inc		si
		jmp		?star_loop

	?no_match:
		stc
		jmp		?exit
	?match:
		clc
	?exit:
		pop		ax
		pop		si
		pop		di
		ret
; end of fnmatch

save_lfn_start:
		; Save the details of the first entry of the long file name for later
		; use (eg file deletion/renaming).
		; Trashes eax.
		; in
		;	bx=search handle
		; out
		;	eax=rubbish (last 4 bytes of the dirent_record structure)
		mov		eax,[bx+search_handle.current+0]
		mov		[bx+search_handle.lfnstart+0],eax
		mov		eax,[bx+search_handle.current+4]
		mov		[bx+search_handle.lfnstart+4],eax
		mov		eax,[bx+search_handle.current+8]
		mov		[bx+search_handle.lfnstart+8],eax
		ret
; end of save_lfn_start

goto_lfn_start:
		; in
		;	bx=search handle
		; out
		;	di=dirent address
		push	eax
		mov		eax,[bx+search_handle.lfnstart.cluster]
		mov		[bx+search_handle.current.cluster],eax
		mov		eax,[bx+search_handle.lfnstart.sector]
;		cmp		eax,[bx+search_handle.current.sector]
		mov		[bx+search_handle.current.sector],eax
;		je		?same_sector
		cmpb	[bx+search_handle.current.dirty],0
		movb	[bx+search_handle.current.dirty],0
		je		?read_sector
		call	write_dir_sector
		jc		?exit
	?read_sector:
		call	read_dir_sector
		jc		?exit
	?same_sector:
		mov		eax,[bx+search_handle.lfnstart.rel_sec]
		mov		[bx+search_handle.current.rel_sec],eax

		xor		eax,eax					; zero eax for lea below
		; get the address of the current directory entry of interest
		mov		al,[bx+search_handle.current.index]
		mov		ah,dirent				; size of directory entry
		mul		ah						; ax=ah*al
		lea		di,[eax+dir_sector]
		clc
	?exit:
		pop		eax
		ret
; end of goto_lfn_start

match_dir_entry:
		; in
		;	bx=search handle
		;	di=directory entry
		;	cx=attribute masks
		;	dl=lfn only flag (0=check sfn if doesn't match lfn)
		; out
		;	cf set failed, cf clear found
		;	ax 0 no long name, 1 long name
		cmpb	[di+dirent.name+0],0xe5	; deleted entry
		jne		?not_deleted
	?not_found:
		stc
		ret
	?not_deleted:
		mov		al,[di+dirent.attr]
		cmp		al,0x0f					; lfn signature
		jne		?not_lfn_entry
		call	save_lfn_start
		call	extract_lfn_name
		stc
		ret
	?not_lfn_entry:
		push	cx
		push	si
		push	di
		push	bp
		xor		bp,bp					; assume no long name exists
		not		cl
		mov		ah,al
		and		al,~0x21				; not interrested in archive or readonly
		and		al,cl
		jnz		?no_match
		and		ah,ch
		cmp		ah,ch
		jne		?no_match
		call	extract_short_name
		cmpb	[mde_long_name],0
		je		?no_long_name
		call	calc_sfn_checksum
		cmp		al,[mde_sfn_checksum]
		jne		?bad_sfn_checksum
		lea		di,[bx+search_handle.spec]
		mov		si,mde_long_name
		mov		bp,1					; indicate long name present/search
		movzxb	ax,[lfn_case_flag]
		call	fn_match
		jnc		?exit
		cmp		dl,0
		jne		?no_match
		jmp		?no_long_name
	?bad_sfn_checksum:
		movb	[mde_long_name],0		; make sure long name is invalid (for bad csum)
	?no_long_name:
		lea		di,[bx+search_handle.spec]
		mov		si,mde_short_name
;		xor		ax,ax
		movzxb	ax,[lfn_case_flag]
		call	fn_match
		jc		?no_match
		cmpb	[mde_long_name],0
		clc
		jne		?exit
		call	save_lfn_start
		jmp		?exit
	?no_match:
		movb	[mde_long_name],0
		stc
	?exit:
		mov		ax,bp
		pop		bp
		pop		di
		pop		si
		pop		cx
		ret
; end of match_dir_entry

dir_sector:								; directory sector buffer
		.db 512 .dup 0
dir_sector_dirty:
		.db		0

write_dir_sector:
		; in
		;	bx=search handle
		push	bx
		push	edx
		push	cx
		mov		ax,[bx+search_handle.drive]
		mov		cx,1
		mov		edx,[bx+search_handle.current.sector]
		mov		bx,dir_sector
		call	write_sectors
		pop		cx
		pop		edx
		pop		bx
		ret
; end of write_dir_sector

read_dir_sector:
		; in
		;	bx=search handle
		push	bx
		push	edx
		push	cx
		mov		ax,[bx+search_handle.drive]
		mov		cx,1
		mov		edx,[bx+search_handle.current.sector]
		mov		bx,dir_sector
		call	read_sectors
		pop		cx
		pop		edx
		pop		bx
		ret
; end of read_dir_sector

goto_next_cluster:
		; Advances the search_handle's current cluster to the next cluster in
		; the cluster chain.
		; in
		;	bx=search handle
		; out
		;	eax=next cluster number
		;	cf=0 ok
		;	cf=1 no more clusters
		push	ecx
		push	edx
		mov		eax,[bx+search_handle.current.cluster]
		cmp		eax,2					; eax will be 0 for fat12/16 root direcotry
		jb		?exit					; why bother?
		call	read_fat_entry
		jc		?exit					; eep, some other error!
		cmp		eax,0x0ffffff7			; highest possible cluster number
		cmc
		jb		?exit					; no more clusters in this directory/file
		mov		[bx+search_handle.current.cluster],eax
	?exit:
		pop		edx
		pop		ecx
		ret
; end of goto_next_cluster

goto_next_sector:
		; Advances the current sector. If the relative sector within a cluster
		; is -1 (first call for this directory), then only the relative sector
		; and the directory entry index are affected (zeroed), otherwise the
		; absolute sector is updated and if the end of the cluster is reached,
		; the next cluster is found and the relative and absolute sectors are
		; updated approriately
		; in
		;	bx=search handle
		; junks eax (will hold the new sector)
		clc								; inc doesn't affect the carry flag
		movb	[bx+search_handle.current.index],0
		incb	[bx+search_handle.current.rel_sec]
		jnz		?next_sector
		ret
	?next_sector:
		incd	[bx+search_handle.current.sector]
		mov		al,[bx+search_handle.current.rel_sec]
		cmp		al,[bx+search_handle.current.num_sec]
		cmc
		jnc		?exit
		call	goto_next_cluster
		jc		?exit
		call	cluster_to_sector
		jc		?exit
		mov		[bx+search_handle.current.sector],eax
		movb	[bx+search_handle.current.rel_sec],0
	?exit:
		ret
; end of goto_next_sector

goto_next_dir_entry:
		; Advance the current directory entry index. If the index is -1 (first
		; call), then there's no need to check whether to go to the next
		; sector, it must be done anyway.  After advancing the sector (if
		; needed), reads in the new directory sector.
		; in
		;	bx=search handle
		; out
		;	ax=dirent offset within sector
		;	di=address of dirent
		clc								; inc doesn't affect the carry flag
		incb	[bx+search_handle.current.index]
		jz		?advance_sector			; first call for this dir, skip test
		cmpb	[bx+search_handle.current.index],512/dirent
		cmc								; reverse the comparison
		jnb		?get_dirent_addr		; not at end of sector yet
	?advance_sector:
		; does the current sector need to be written
		cmpb	[bx+search_handle.current.dirty],0
		movb	[bx+search_handle.current.dirty],0
		je		?next_sector
		call	write_dir_sector
		jc		?exit
	?next_sector:
		; move to to next (or first) sector
		call	goto_next_sector
		jc		?exit					; no more sectors or error
		; read in the current directory sector
		call	read_dir_sector			; will set carry flag on error
		jc		?exit
	?get_dirent_addr:
		xor		eax,eax					; zero eax for lea below
		; get the address of the current directory entry of interest
		mov		al,[bx+search_handle.current.index]
		mov		ah,dirent				; size of directory entry
		mul		ah						; ax=ah*al
		lea		di,[eax+dir_sector]
		clc
	?exit:
		ret
; end of goto_next_dir_entry

scan_directory:
		; Find the directory entry in the directory pointed to by the search
		; handle. The handle will either have been initialized to point to the
		; beginning of the directory, or points to the last directory entry
		; found matching the search spec
		; in
		;	bx=search handle
		;	dl=lfn only flag (0=check sfn if doesn't match lfn)
		; out
		;	cf set fail, cf clear found
		;	eax=directory entry if found
		push	di
		; make sure the long name is invalid
		movb	[mde_long_name],0
		; must call this to advace the directory entry index, otherwise we'll
		; keep returning the same directory entry on multiple calls. Also
		; reads in the directory sector.
		call	goto_next_dir_entry
		jc		?no_match
		; load the seach attribute mask into cx for the call(s) to
		; match_dir_entry
		mov		cx,[bx+search_handle.sattr]
	?scan_dir:
		; Check to see if we're at the end of the directory. If the first byte
		; of the directory entry name is 0, then this is the end of the
		; directory and the search can stop and has failed to find a match
		; with the search spec.
		cmpb	[di+dirent.name+0],0	; no more entries in this directory
		je		?no_match
		; is it the directory entry we want?
		call	match_dir_entry
		jnc		?match_found
		; nope, try the next one
		call	goto_next_dir_entry
		jnc		?scan_dir				; no more sectors in this directory
	?no_match:
		stc
		mov		ax,DE_file_not_found
		jmp		?exit
	?match_found:
		movzx	eax,di
	?exit:
		pop		di
		ret
; end of scan_directory

setup_search_handle:
		; Initalizes a search handle to search the directory starting at the
		; cluster in eax. Does not touch the `first' fields.
		; in
		;	bx=search handle
		;	eax=cluster
		;	cx=search attribute mask
		; out
		;	cf set if error, clear if ok
		; modifies eax
		; Assumes the drive has already been selected and hence the drive
		; parameters (fat type, cluster sizes etc) are known.
		; Also assumes the contents of the dir_sector buffer are no longer
		; needed (clears the dirty flag), meaning that if the buffer has been
		; modified, make sure it is written BEFORE calling this function,
		; otherwise the modifications will be lost forever.
		push	cx
		mov		[bx+search_handle.sattr],cx

		mov		[bx+search_handle.start],eax
		mov		[bx+search_handle.current.cluster],eax
		; convert the cluster number to a sector number. Interprets cluster 0
		; as the root directory (for non fat32 drives)
		or		eax,eax
		jz		?root_is_cluster_0
		; fat32 root directory is actually a `subdirectory'. ie it is stored
		; in the data area of a drive and has the same properties as other
		; subdirectories and files (except of course, it's the root directory
		; (no '.' or '..' and it can't be read as a file).
		;
		; convert the root directory cluster to a sector number
		call	cluster_to_sector
		jc		?error
		mov		cl,[cluster_size]
		jmp		?got_root_sector
	?root_is_cluster_0:
		; standard fat12/16 root directory
		mov		eax,[cluster_0]			; root directory sector number
		; the root directory `cluster' is not a standard cluster, and so it
		; has it's own cluster size which is the number of sectors required to
		; hold the number of directory entries specified in the boot sector.
		mov		cl,[cluster_0_size]
	?got_root_sector:
		mov		[bx+search_handle.current.sector],eax	; starting sector
		movb	[bx+search_handle.current.rel_sec],-1	; indicate first sector
		mov		[bx+search_handle.current.num_sec],cl	; # of sectors in this `cluster'
		movb	[bx+search_handle.current.index],-1		; indicate first dir entry
		movb	[bx+search_handle.current.dirty],0
		; copy the selected drive into the search handle's drive field.
		mov		ax,[current_drive]
		mov		[bx+search_handle.drive],ax
	?error:
		pop		cx
		ret
; end of setup_search_handle

goto_directory_start:
		; Reset the current directory entry index (and other associated 
		; variables) to the beginning of the current search directory
		; in
		;	bx=search handle
		push	cx
		; does the current sector need to be written?
		cmpb	[bx+search_handle.current.dirty],0
		movb	[bx+search_handle.current.dirty],0
		je		?reset_sector
		call	write_dir_sector
		jc		?exit
	?reset_sector:
		mov		eax,[bx+search_handle.start]
		mov		cx,[bx+search_handle.sattr]
		call	setup_search_handle
	?exit:
		pop		cx
		ret
; end of goto_directory_start

get_file_start_cluster:
		; extract the cluster number of the file/subdir start
		; in
		;	eax=address of directory entry
		; out
		;	eax=cluster number
		pushw	0						; assume fat12/16, push 0 for bits 16-31
		cmpb	[fat_type],3			; is it fat32?
		jne		?not_fat32
		add		sp,2					; yes, remove bits 16-31 for fat12/16
		pushw	[eax+dirent.clustHi]	; push the high 16 bits of the cluster number
	?not_fat32:
		pushw	[eax+dirent.clust]		; push the low 16 bits of the cluster number
		pop		eax						; retrieve the reconstructed cluster number
		ret
; end of get_file_start_cluster

copy_path_element:
		; Copy one path element to the spec field of the search handle.
		; find the extents of the current path element
		; in
		;	ds:si=beginning of current path element
		;	bx=search handle
		; out
 		;	bx.spec updated
		;	ds:si=next path separator or end of string
		;	zf set if nothing copied
		push	si						; save start pointer
	@b1:
		cmpb	[si],'\\'
		je		@f1
		cmpb	[si],'/'
		je		@f1
		cmpb	[si],'|'				; sfn/lfn directory separator
		je		@f1
		cmpb	[si],0
		je		@f1
		inc		si
		jmp		@b1
	@f1:
		mov		cx,si					; save end pointer
		pop		si						; retrieve start pointer
		sub		cx,si					; cx now holds length of the path segment
		jz		?exit					; no element, done and must have found the path
		; copy the path into the search spec
		push	es
		push	di
		push	cs
		pop		es
		lea		di,[bx+search_handle.spec]
		rep
		movsb
		movb	[di],0					; terminate the string
		pop		di
		pop		es
		or		sp,sp					; clear zf
	?exit:
		ret
; end of copy_path_element

setup_next_level:
		; advance over the directory separator, updating the lfn only flag if
		; it's the special sfn/lfn separator character
		cmpb	[si],'|'
		jne		?not_separator
		mov		dl,[lfn_only_flag]
	?not_separator:
		inc		si
		; make certain the directory entry is a directory
		testb	[eax+dirent.attr],0x10	; directory attribute
		jz		?error
		; extract the cluster number of the next path element
		call	get_file_start_cluster
		; setup to search the next level down the directory tree
		mov		cx,0x003f				; any file, no required bits
		call	setup_search_handle
		ret
	?error:
		mov		ax,0x03					; path not found
		stc
		ret
; end of setup_next_level

copy_directory_name:
		; copy the appropriate name (short or long) to the destination buffer
		; in
		;	ax=sfn/lfn desired flag (1=lfn, 0=sfn)
		;	mde_long_name=long file name
		;	mde_short_name=short file name
		;	di=destination buffer
		push	si						; save the path pointer
		cmp		ax,0					; is the short name wanted?
		setne	al						; al=1 if long name wanted
		cmpb	[mde_long_name],0		; is there a long name entry?
		setne	ah						; ah=1 if there is a lfn entry
		and		al,ah
		movzx	si,al					; si=1 if there is a lfn entry and it's wanted
		; Uses the Intel recomended method of choosing two values without a
		; jump (the sets have been done above).
		dec		si								; 0 or -1 (0xffff)
		and		si,mde_short_name-mde_long_name ; 0 or `short'-`long'
		add		si,mde_long_name				; `long' or `short'
		; now copy the file/directory name as selected above. automatically
		; terminates the destination string.
		call	strcpy
		pop		si						; restore the path pointer
		ret
; end of copy_directory_name
		
get_true_file_path:
		; in
		;	ax=name flag (1=long, 0=short)
		;	ds:si=path
		;	es:di=destination buffer
		; out
		;	cf set failure, cf clear found
		;	bx=search handle
		push	ax						; ax=get short(0)/long name flag
		push	cx
		push	dx
		push	si
		push	di
		; If we're after the short name (ax=0), then the path must match the
		; long name entries. however, if the long name is wanted, matching
		; against the short name must be allowed
		or		ax,ax
		setnz	dh
		dec		dh
		; initially allow matches with the sfn so we can find the directory
		; dos gave us.
		mov		dl,0					; allow match with sfn
		; select the search drive
		movzxb	ax,[si]					; get the drive letter
		call	toupper
		sub		al,'A'
		call	select_drive
		jcl		?error
		; copy the drive specifier ("d:\")
		mov		cx,3
		cld
		rep
		movsb
		; if we copied the sfn/lfn separator, fix the output path and set the
		; lfn only flag
		cmpb	[es:di-1],'|'
		jne		?not_separator
		mov		dl,[lfn_only_flag]
	?not_separator:
		movw	[es:di-1],0x005c		; fix separator and truncate
		; check whether any path elements are present
		mov		eax,?root_directory_dirent
		cmpb	[si-1],0				; "d:" only?
		jel		?found
		cmpb	[si],0					; "d:\" only?
		jel		?found
		; set up to search the directory tree, starting at the root
		mov		bx,?search_handle
		mov		cx,0x003f				; any file, no required bits
		mov		eax,[root_cluster]		; start at the root directory
		call	setup_search_handle
	?next_level:
		call	copy_path_element
		jz		?found
		; make sure the lfn only flag is set appropriatly
		and		dl,dh
		; si now points to the beginning of the next path segment
		; try to find the directory/file
		call	scan_directory
		jc		?error
		push	eax						; save the returned directory entry address
		mov		ax,[esp+12]				; get the sfn/lfn desired flag
		call	copy_directory_name
		pop		eax						; restore the returned directory entry address
		; are there any more path elements?
		cmpb	[si],0
		je		?found
		; yes, place a terminated path separator at the end of the string. di
		; will be pointing to the right place for the next time around the
		; loop
		call	end_of_string
		inc		di
		movw	[es:di-1],0x005c
		call	setup_next_level
		jnc		?next_level
	?error:
		stc
		jmp		?exit
	?found:
		clc
	?exit:
		pop		di
		pop		si
		pop		dx
		pop		cx
		mov		[esp],ax
		pop		ax
		ret
	?search_handle:
		.db search_handle .dup 0
	?root_directory_dirent .struct dirent (.)	; does not emit any bytes!
		; Ugh, this is prone to error! (but it's right, now)
		.db	"*root dir*!"	; 11 chars - name + ext
		.db 0x10			; attributes - directory entry
		.dw 4 .dup 0		; extra time fields for W95
		.dw 0				; cluster hi
		.dd 0				; date/time
		.dw 0				; cluster lo
		.dd	0				; file size
; end of get_true_file_path

find_file_directory_entry:
		; in
		;	ax=sfn/lfn control
		;	ds:si=path
		;	es:di=destination buffer
		; out
		;	cf set failure, cf clear found
		;	bx=search handle
		push	cx
		push	dx
		push	si
		push	di
		; If we're after the short name (ax=0), then the path must match the
		; long name entries. however, if the long name is wanted, matching
		; against the short name must be allowed
		or		ax,ax
		
		setnz	dh
		dec		dh
		; initially allow matches with the sfn so we can find the directory
		; dos gave us.
		mov		dl,0					; allow match with sfn
		; select the search drive
		movzxb	ax,[si]					; get the drive letter
		call	toupper
		sub		al,'A'
		call	select_drive
		jcl		?error
		add		si,3
		; if we have the sfn/lfn separator, set the lfn only flag
		cmpb	[es:si-1],'|'
		jne		?not_separator
		mov		dl,[lfn_only_flag]
	?not_separator:
		; check whether any path elements are present
		mov		eax,?root_directory_dirent
		cmpb	[si-1],0				; "d:" only?
		jel		?found
		cmpb	[si],0					; "d:\" only?
		jel		?found
		; set up to search the directory tree, starting at the root
		mov		bx,?search_handle
		mov		cx,0x003f				; any file, no required bits
		mov		eax,[root_cluster]		; start at the root directory
		call	setup_search_handle
	?next_level:
		call	copy_path_element
		jz		?found
		; make sure the lfn only flag is set appropriatly
		and		dl,dh
		; si now points to the beginning of the next path segment
		; try to find the directory/file
		call	scan_directory
		jc		?error
		; are there any more path elements?
		cmpb	[si],0
		je		?found
		call	setup_next_level
		jnc		?next_level
	?error:
		stc
		jmp		?exit
	?found:
		clc
	?exit:
		pop		di
		pop		si
		pop		dx
		pop		cx
		ret
	?search_handle:
		.db search_handle .dup 0
	?root_directory_dirent .struct dirent (.)	; does not emit any bytes!
		; Ugh, this is prone to error! (but it's right, now)
		.db	"*root dir*!"	; 11 chars - name + ext
		.db 0x10			; attributes - directory entry
		.dw 4 .dup 0		; extra time fields for W95
		.dw 0				; cluster hi
		.dd 0				; date/time
		.dw 0				; cluster lo
		.dd	0				; file size
; end of find_file_directory_entry

resolve_path:
		; Sets up a search handle to start searching at the beginning of the
		; PATH part of the supplied filename (will use the current directory
		; if there is no path part).
		; in
		;	bx=search handle to setup
		;	di=path/filename
		; out
		;	bx=setup search handle
		;	si=beginning of actual filename
		;	di=full path name
		push	dx
		push	cx

		mov		si,di
		call	end_of_string
		mov		cx,di
		sub		cx,si
	?find_last_slash_loop:
		cmpb	[di-1],'/'
		je		?found_last_slash
		cmpb	[di-1],'\\'
		je		?found_last_slash
		dec		di
		loop	?find_last_slash_loop
		mov		si,?current_dir
		jmp		?expand_path
	?found_last_slash:
		movb	[di-1],0
	?expand_path:
		mov		dx,di
		mov		di,path_buffer
		pushw	[si+2]
		sub		dx,si
		cmp		dx,3
		jne		?not_root
		movw	[si+2],0x005c			; "\\\0"
	?not_root:
		add		dx,si
		call	expand_path
		popw	[si+2]
		jc		?exit
		; mark the separation between the sfn and lfn portions of the path
		call	mark_path
		mov		si,dx
		push	di
		call	end_of_string
		inc		di
		call	strcpy
		mov		dx,di
		pop		di
		mov		si,di
		
		mov		di,filename_buffer
		xor		ax,ax					; get short name
		push	bx
		call	get_true_file_path
		pop		bx
		jc		?invalid_path
		testb	[eax+dirent.attr],0x10	; is it a directory?
		jz		?invalid_path			; nope, IT'S TIME TO DIE!!! snick
		call	get_file_start_cluster	; convert eax from direntry to cluster
		mov		cx,[esp]
		call	setup_search_handle
		jb		?invalid_path			; shouldn't happen
		mov		si,dx
		jmp		?exit
	?invalid_path:
		mov		ax,DE_path_not_found
		stc
	?exit:
		pop		cx
		pop		dx
		ret
	?current_dir:
		.db		".\0"
; end of resolve_path

get_short_name:
		; Gets the file's short name into filename_buffer.
		; in
		;	ds:si=long file name
		; out
		;	es,ds=cs
		;	bx=search handle used to find file
		;	cf clear
		;		di=full short name path
		;		si=short file name within path
		;		ax=sfn directory entry of file
		;	cf set
		;		ax=error code
		;		  2 (file not found)
		;			di=end of sfn path ie ^ in c:\SNAFU\^ for c:\snafu\foo.bar
		;			si=long name of file (no path) ie foo.bar of c:\snafu\foo.bar
		;		  3 (invalid path)
		;			si,di=??
		push	dx
		push	cx
		push	cs
		pop		es
		mov		di,filename_buffer
		mov		cx,260
		call	strncpy
		push	cs
		pop		ds
		movb	[di+260],0

		mov		bx,?search_handle
		mov		cx,0x3f
		call	resolve_path
		jc		?exit
		push	di
		lea		di,[bx+search_handle.spec]
		call	strcpy
		pop		di
		call	scan_directory
		jc		?not_found
		push	di
		call	end_of_string
		cmpb	[di-1],'\\'
		je		@f1
		movb	[di],'\\'
		inc		di
	@f1:
		mov		si,mde_short_name
		call	strcpy
		mov		si,di
		pop		di
		jmp		?exit
	?not_found:
		call	end_of_string
		movw	[di],0x005c
		inc		di
		mov		ax,DE_file_not_found
		stc
	?exit:
		pop		cx
		pop		dx
		ret
	?search_handle:
		.db search_handle .dup 0
; end of get_short_name

delete_lfn:
		; Marks all the lfn entries associated with this file as deleted. Used
		; for renaming or deleting the file.
		; in
		;	bx=search handle
		push	di
		call	goto_lfn_start
	?next_entry:
		jc		?exit
		cmpb	[di+lfndirent.sig],0x0f
		jne		?done
		mov		al,[di+lfndirent.chksum]
		cmp		[mde_sfn_checksum],al
		jne		?done
		movb	[di+dirent.name+0],0xe5	; delete entry
		movb	[bx+search_handle.current.dirty],1
		call	goto_next_dir_entry
		jc		?exit
		jmp		?next_entry
	?done:
		cmpb	[bx+search_handle.current.dirty],0
		movb	[bx+search_handle.current.dirty],0
		je		?exit
		call	write_dir_sector
	?exit:
		pop		di
		ret
; end of delete_lfn

write_lfn:
		; Writes the lfn entries and the sfn entry to the directory starting
		; at the current directory entry.
		; in
		;	bx=search handle
		;	cl=sfn checksum
		;	si=lfn
		;	dx=sfn directory entry
		push	ax
		push	si
		push	di
		push	dx
		mov		di,si
		call	strlen
		dec		ax
		mov		di,ax
		mov		dl,13
		div		dl
		mov		dl,al
		add		dl,0x41
		movzx	ax,ah
		sub		di,ax
		add		si,di
		call	save_lfn_start
		call	goto_lfn_start
		xor		ax,ax
	?next_entry:
		mov		[di+lfndirent.index],dl
		and		dl,0x3f
		mov		al,[si+0]
		mov		[di+lfndirent.name1+0*2],ax
		mov		al,[si+1]
		mov		[di+lfndirent.name1+1*2],ax
		mov		al,[si+2]
		mov		[di+lfndirent.name1+2*2],ax
		mov		al,[si+3]
		mov		[di+lfndirent.name1+3*2],ax
		mov		al,[si+4]
		mov		[di+lfndirent.name1+4*2],ax
		mov		al,[si+5]
		mov		[di+lfndirent.name2+0*2],ax
		mov		al,[si+6]
		mov		[di+lfndirent.name2+1*2],ax
		mov		al,[si+7]
		mov		[di+lfndirent.name2+2*2],ax
		mov		al,[si+8]
		mov		[di+lfndirent.name2+3*2],ax
		mov		al,[si+9]
		mov		[di+lfndirent.name2+4*2],ax
		mov		al,[si+10]
		mov		[di+lfndirent.name2+5*2],ax
		mov		al,[si+11]
		mov		[di+lfndirent.name3+0*2],ax
		mov		al,[si+12]
		mov		[di+lfndirent.name3+1*2],ax
		mov		[di+lfndirent.chksum],cl
		movb	[di+lfndirent.sig],0x0f
		movb	[bx+search_handle.current.dirty],1
		call	goto_next_dir_entry
		jb		?exit
		sub		si,13
		dec		dl
		jnz		?next_entry
		mov		si,[esp]
		mov		cx,dirent/4
		rep
		movsd
		call	write_dir_sector
	?exit:
		pop		dx
		pop		di
		pop		si
		pop		ax
		ret
; end of write_lfn

extend_directory:
		; Adds another cluster to the directory.  Fails if the directory is
		; root unless FAT32 is used (ie fails if current cluster is 0).
		; in
		;	bx=search handle
		mov		ax,DE_out_of_disk_space
		cmpd	[bx+search_handle.current.cluster],1
		jb		?exit
		call	allocate_cluster
		jb		?exit
		mov		edx,eax
		mov		eax,[bx+search_handle.current.cluster]
		call	write_fat_entry
	?exit:
		ret
; end of extend_directory

find_space:
		; Finds a space in the directory with enough unused (deleted or never
		; used) entries to hold the lfn+sfn.  Search handle should be reset to
		; the beginning of the directory.
		; in
		;	bx=search handle
		;	cl=number of entries needed.
		push	si
		push	di
	?find_unused_entry:
		mov		si,?find_unused_entry
		call	save_lfn_start
		call	goto_next_dir_entry
		jc		?reached_end_of_directory
		cmpb	[di+dirent.name+0],0xe5
		je		?found_unused_entry
		cmpb	[di+dirent.name+0],0x00
		jne		?find_unused_entry
	?found_unused_entry:
		mov		si,?found_unused_entry
		call	save_lfn_start
		mov		ch,cl
	?check_next_entry:
		dec		ch
		jz		?found_space
		call	goto_next_dir_entry
		jc		?reached_end_of_directory
		cmpb	[di+dirent.name+0],0xe5
		je		?check_next_entry
		cmpb	[di+dirent.name+0],0x00
		jne		?find_unused_entry
		jmp		?check_next_entry
	?reached_end_of_directory:
		call	extend_directory
		jc		?exit
		call	goto_lfn_start
		jmp		si
	?found_space:
		call	goto_lfn_start
	?exit:
		pop		di
		pop		si
		ret
; end of find_space
