#
# Makefile for Borland C++ 3.1 for kernel.sys
#
# $Id: KERNEL.MAK,v 1.6 1999/08/10 17:57:13 jprice Exp $
#

# $Log: KERNEL.MAK,v $
# Revision 1.6  1999/08/10 17:57:13  jprice
# ror4 2011-02 patch
#
# Revision 1.5  1999/04/23 04:25:15  jprice
# no message
#
# Revision 1.4  1999/04/23 03:45:11  jprice
# Improved by jprice
#
# Revision 1.3  1999/04/16 12:21:22  jprice
# Steffen c-break handler changes
#
# Revision 1.2  1999/04/13 15:48:21  jprice
# no message
#
# Revision 1.1.1.1  1999/03/29 15:41:15  jprice
# New version without IPL.SYS
#
# Revision 1.7  1999/03/01 06:04:37  jprice
# Fixed so it'll work with config.mak
#
# Revision 1.6  1999/03/01 05:46:43  jprice
# Turned off DEBUG define.
#
# Revision 1.5  1999/02/09 04:49:43  jprice
# Make makefile use common config.mak file
#
# Revision 1.4  1999/02/08 05:55:57  jprice
# Added Pat's 1937 kernel patches
#
# Revision 1.3  1999/02/04 03:09:59  jprice
# Added option to share constants (-d).
#
# Revision 1.2  1999/01/22 04:13:26  jprice
# Formating
#
# Revision 1.1.1.1  1999/01/20 05:51:01  jprice
# Imported sources
#
#
#   Rev 1.8.1 10 Jan 1999            SRM
#Took out "/P-" from TLINK
#Changed "bcc" to "tcc"
#
#   Rev 1.9   06 Dec 1998  8:45:40   patv
#Added new files for I/O subsystem.
#
#   Rev 1.8   22 Jan 1998 14:50:06   patv
#Outdated stacks.asm.
#
#   Rev 1.6   03 Jan 1998  8:36:50   patv
#Converted data area to SDA format
#
#   Rev 1.5   30 Jan 1997  7:55:54   patv
#Added TSC flag for trace support.
#
#   Rev 1.4   16 Jan 1997 12:46:42   patv
#pre-Release 0.92 feature additions
#
#   Rev 1.3   29 Aug 1996 13:07:34   patv
#Bug fixes for v0.91b
#
#   Rev 1.2   29 May 1996 21:03:32   patv
#bug fixes for v0.91a
#
#   Rev 1.1   19 Feb 1996  3:35:38   patv
#Added NLS, int2f and config.sys processing
#
#   Rev 1.0   02 Jul 1995  8:30:22   patv
#Initial revision.
#
# $EndLog$
#

!include "..\config.mak"

RELEASE = 1.00

.AUTODEPEND

#
# Compiler and Options for Borland C++
# ------------------------------------
LIBPATH = .
INCLUDEPATH = ..\HDR
#AFLAGS      = /Mx /DSTANDALONE=1 /I..\HDR
NASMFLAGS   = -i../hdr/
LIBS        =..\LIB\DEVICE.LIB ..\LIB\LIBM.LIB

#               *Implicit Rules*
.c.obj:
  $(CC) +kernel.cfg -c {$< }

.cpp.obj:
  $(CC) +kernel.cfg -c {$< }

.asm.obj:
	$(NASM) $(NASMFLAGS) -f obj $<

#               *List Macros*


EXE_dependencies =  \
 kernel.obj \
 entry.obj \
 io.obj \
 blockio.obj \
 chario.obj \
 dosfns.obj \
 console.obj \
 printer.obj \
 serial.obj \
 dsk.obj \
 error.obj \
 fatdir.obj \
 fatfs.obj \
 fattab.obj \
 fcbfns.obj \
 initoem.obj \
 inthndlr.obj \
 irqstack.obj \
 ioctl.obj \
 main.obj \
 config.obj \
 memmgr.obj \
 misc.obj \
 newstuff.obj \
 nls.obj \
 dosnames.obj \
 prf.obj \
 strings.obj \
 sysclk.obj \
 syspack.obj \
 systime.obj \
 task.obj \
 int2f.obj \
 apisupt.obj \
 asmsupt.obj \
 execrh.obj \
 nlssupt.obj \
 procsupt.obj \
 break.obj

#               *Explicit Rules*

production:     ..\bin\kernel.sys

..\bin\kernel.sys: kernel.sys
                copy kernel.sys ..\bin

kernel.sys:	kernel.exe
                ..\utils\exeflat kernel.exe kernel.sys 0x60 > nul

clobber:        clean
                $(RM) kernel.exe kernel.sys status.me

clean:
                $(RM) *.obj *.bak *.crf *.xrf *.map *.lst

kernel.exe: $(EXE_dependencies) $(LIBS) kernel.cfg
  $(LINK) /m/c/L$(LIBPATH) @&&|
kernel.obj+
entry.obj+
io.obj+
blockio.obj+
chario.obj+
dosfns.obj+
console.obj+
printer.obj+
serial.obj+
dsk.obj+
error.obj+
fatdir.obj+
fatfs.obj+
fattab.obj+
fcbfns.obj+
initoem.obj+
inthndlr.obj+
ioctl.obj+
main.obj+
config.obj+
memmgr.obj+
misc.obj+
newstuff.obj+
nls.obj+
dosnames.obj+
prf.obj+
strings.obj+
sysclk.obj+
syspack.obj+
systime.obj+
task.obj+
int2f.obj+
irqstack.obj+
apisupt.obj+
asmsupt.obj+
execrh.obj+
nlssupt.obj+
procsupt.obj+
break.obj
kernel          # exe file
kernel          # map file
$(LIBS)
|
	tdstrip kernel.exe


#               *Individual File Dependencies*
kernel.obj: kernel.asm segs.inc

console.obj: console.asm io.inc

printer.obj: printer.asm io.inc

serial.obj: serial.asm io.inc

entry.obj: entry.asm segs.inc ../hdr/stacks.inc

blockio.obj: blockio.c globals.h kernel.cfg

chario.obj: chario.c globals.h kernel.cfg

dosfns.obj: dosfns.c globals.h kernel.cfg

dsk.obj: dsk.c globals.h kernel.cfg

error.obj: error.c globals.h kernel.cfg

fatdir.obj: fatdir.c globals.h fatdir.c kernel.cfg

fatfs.obj: fatfs.c globals.h fatfs.c kernel.cfg

fattab.obj: fattab.c globals.h kernel.cfg

fcbfns.obj: fcbfns.c globals.h kernel.cfg

initoem.obj: initoem.c globals.h kernel.cfg

inthndlr.obj: inthndlr.c globals.h kernel.cfg

ioctl.obj: ioctl.c globals.h kernel.cfg

main.obj: main.c globals.h kernel.cfg

config.obj: config.c globals.h kernel.cfg

memmgr.obj: memmgr.c globals.h kernel.cfg

misc.obj: misc.c globals.h kernel.cfg

nls.obj: nls.c globals.h kernel.cfg

newstuff.obj: newstuff.c globals.h kernel.cfg

dosnames.obj: dosnames.c globals.h dosnames.c kernel.cfg

prf.obj: prf.c globals.h kernel.cfg

strings.obj: strings.c globals.h kernel.cfg

sysclk.obj: sysclk.c globals.h kernel.cfg

syspack.obj: syspack.c globals.h kernel.cfg

systime.obj: systime.c globals.h kernel.cfg

break.obj: break.c globals.h kernel.cfg

task.obj: task.c globals.h kernel.cfg

apisupt.obj: apisupt.asm segs.inc

asmsupt.obj: asmsupt.asm segs.inc

execrh.obj: execrh.asm segs.inc

int2f.obj: int2f.asm segs.inc

io.obj: io.asm segs.inc

irqstack.obj: irqstack.asm

nlssupt.obj: nlssupt.asm segs.inc

procsupt.obj: procsupt.asm segs.inc ../hdr/stacks.inc

proto.h:        $(CSRC) $(LIBCSRC1) $(LIBCSRC2) $(LIBCSRC3) $(LIBCSRC4)
                echo /* proto.h generated by make */ > proto.h
                echo #undef _P >> proto.h
                ..\utils\proto $(CSRC)
                ..\utils\proto $(LIBCSRC1)
                ..\utils\proto $(LIBCSRC2)
                ..\utils\proto $(LIBCSRC3)
                ..\utils\proto $(LIBCSRC4)
                echo Don't forget to edit proto.h for version control
