#
# To build Jemm386, you will need:
#
# Assembler:  Masm 6.14/6.15/7.00
#        or   Tasm/Tasm32 5.0
# C Compiler: Open Watcom WCC 1.5/1.6
#        or   Borland Turbo C 2.01/4.0 
#        or   MS VC++ 1.5 
#        or   Digital Mars C++
# OMF Linker: Digital Mars OptLink
#        or   Open Watcom WLINK
#        or   Borland TLink 7.1.30 (older versions might work) 
#        or   MS Link (OMF version!)
#        or   LADSoft VALX (currently NOT!)
# COFF Linker: MS Link
#        or   Open Watcom WLINK
#        or   PoLink
# MAKE tool:  Open Watcom WMAKE
#        or   Borland MAKE (v3.6+)
#        or   MS NMAKE
#
# not all combination work, however, i.e. OW WLINK won't link modules
# compiled with MS VC.
#
# Since Jemm386 v5.4, the 32bit code uses the FLAT memory model and
# is linked separately. This complicates the build process slightly:
#
#  1. assemble + link Jemm32 to Jemm32.bin. This is a Win32 PE binary.
#  2. use EXTRSECT to extract the section contents of this binary to file
#     Jemm32.inc.
#  3. assemble Jemm16.asm (which includes Jemm32.inc).
#  4. compile the C modules with 16-bit compiler.
#  5. link Jemm16.obj and C modules to Jemm386.exe.

!ifndef DEBUG
DEBUG=0
!endif

# select assembler, default MASM

!ifndef MASM
MASM=1
!endif

# select 16-bit C compiler, default MS C

!ifndef WCC
WCC=0
!endif
!ifndef DMC
DMC=0
!endif
!ifndef TCC
TCC=0
!endif
!ifndef MSC
!if $(WCC)+$(DMC)+$(TCC)==0
MSC=1
!else
MSC=0
!endif
!endif

# select Win32 COFF linker
# default is MS LINK
# PoLink works similiar well
# wlink works not so good (generates empty .idata and .reloc sections)

LINKCOFF=c:\div\link.exe /filealign:0x200 /fixed /driver /subsystem:native /entry:start /base:0x100000 /align:0x10000 jemm32.obj /MAP /OUT:jemm32.bin
#LINKCOFF=polink.exe /subsystem:native /entry:start /base:0x100000 /align:0x10000 jemm32.obj /MAP /OUT:jemm32.bin
#LINKCOFF=\watcom\binnt\wlink system nt file jemm32.obj name jemm32.bin option offs=0x100000, objalign=0x10000, start=_start

# select OMF linker, default OPTLINK

!ifndef TLINK
TLINK=0
!endif
!ifndef WLINK
WLINK=0
!endif
!ifndef VALX
VALX=0
!endif
!ifndef MSLINK
MSLINK=0
!endif

!ifndef OPTLINK
!if $(TLINK)+$(WLINK)+$(VALX)+$(MSLINK)==0
OPTLINK=1
!else
OPTLINK=0
!endif
!endif

NAME=JEMM386

!if $(DEBUG)
!if $(MASM)
AOPTD=-D_DEBUG
!else
AOPTD=/d_DEBUG
!endif
OUTDIR=DEB386
!else
AOPTD=
OUTDIR=REL386
!endif

!if $(MASM)
ML=ml.exe -c -nologo -Cp
AS1=$(ML) -coff $(AOPTD) -Fl$(OUTDIR)\jemm32.LST -Fo$(OUTDIR)\jemm32.OBJ jemm32.asm
AS2=$(ML) $(AOPTD) -D?WCC=$(WCC) -D?MSC=$(MSC) -D?DMC=$(DMC) -Fl$(OUTDIR)\jemm16.LST -Fo$(OUTDIR)\jemm16.OBJ jemm16.asm
!else
TASM=tasm.exe /la /m3 /ml /z /n /d?MASM=0 /d?WCC=$(WCC) /d?MSC=$(MSC)
AS1=$(TASM) $(AOPTD) jemm32.asm, $(OUTDIR)\jemm32.OBJ, $(OUTDIR)\jemm32.LST;
AS2=$(TASM) $(AOPTD) jemm16.asm, $(OUTDIR)\jemm16.OBJ, $(OUTDIR)\jemm16.LST;
!endif

!if $(WCC)
CC=wcc.exe -3 -bt=dos -ecc -ms -os -q -s -fp3 -w=3
# the OW C++ compiler produces slightly better code
#CC=wpp.exe -3 -bt=dos -ecc -ms -os -q -s -fp3 -w=3
OUTO=-fo
!endif
!if $(DMC)
CC=\dm\bin\sc.exe -msd -c -3 -J -o
OUTO=-o
!endif
!if $(TCC)
CC=tcc.exe -c -G- -w -r -N- -O -Z -k-
#CC=bcc.exe -c -3 -N- -O -w -Z
OUTO=-o
!endif
!if $(MSC)
CC=cl.exe -c -nologo -O1 -G3 -Gs -Gx -J -Zl -Fl$*.lst
OUTO=-Fo
!endif

!if $(TLINK)
LINK=tlink.exe /3 /m /s /n jemm16.obj jemm16c.obj,$(NAME).EXE,$(NAME).MAP;
!endif
!if $(WLINK)
LINK=wlink.exe system dos file jemm16.obj,jemm16c.obj name $(NAME).EXE option map=$(NAME).MAP
!endif
!if $(MSLINK)
LINK=link16.exe /MAP:FULL/NOD /NOI jemm16.obj jemm16c.obj,$(NAME).EXE,$(NAME).MAP;
!endif  
!if $(VALX)
LINK=valx.exe /MAP jemm16.obj jemm16c.obj,$(NAME).EXE,$(NAME).MAP;
!endif
!if $(OPTLINK)
LINK=\dm\bin\link.exe /MAP:FULL /NOD /NOI /ONE:NOE jemm16.obj jemm16c.obj,$(NAME).EXE,$(NAME).MAP;
!endif  

$(OUTDIR)\$(NAME).EXE: $(OUTDIR)\jemm16.obj $(OUTDIR)\jemm16c.obj 
    @cd $(OUTDIR)
	@$(LINK)
    @cd ..

$(OUTDIR)\jemm16.obj: jemm16.asm jemm.inc debug.inc $(OUTDIR)\jemm32.inc $(NAME).MAK
	@$(AS2)

$(OUTDIR)\jemm32.inc: $(OUTDIR)\jemm32.obj
	@cd $(OUTDIR)
	@$(LINKCOFF) 
	@..\extrsect -i -q jemm32.bin jemm32.inc
    @cd ..

$(OUTDIR)\jemm32.obj: jemm32.asm jemm32.inc jemm.inc debug.inc $(NAME).MAK
	@$(AS1)

$(OUTDIR)\jemm16c.obj: jemm16c.c jemm16c.h $(NAME).MAK
	@$(CC) $(OUTO)$(OUTDIR)\jemm16c.obj jemm16c.c

