
;--- common definitions for both Jemm32 and Jemm16

ifndef ?MASM
?MASM equ 1
endif

LF				EQU 0AH
CR				EQU 0DH

?VERSIONHIGH	equ 5
?VERSIONLOW		equ 45

?DMA			EQU 1		; 1=enable DMA support
?VDS			EQU 1		; 1=enable VDS support
?VCPI			EQU 1		; 1=enable VCPI support
?EMX			EQU 1		; 1=EMX compat switch supported
?SB 			EQU 1		; 1=SB compat switch supported
?EMMXXXX0		EQU 1		; 1=implement EMMXXXX0 IOCTL
?A20XMS 		EQU 1		; 1=emu A20 by trapping XMS functions
?A20PORTS		EQU 1		; 1=emu A20 by trapping ports (92, 64, 60)
?VME			EQU 1		; 1=support P1+ VME extension
?LOAD			EQU 1		; 1=support LOAD command line option
?PGE			EQU 1		; 1=support PGE on P3+ (requires ?INVLPG!) 
?MOVEHIGH		EQU 1		; 1=support moving in first UMB
?UNLOAD			EQU 1		; 1=support unloading

V86_TOS 		EQU 200H			; Size of monitor stack

?BPOPC			equ 0F4h			; opcode used for breakpoints (HLT)
;?BPOPC			equ 063h			; this should also work (ARPL)

if ?EMMXXXX0

;--- structure returned by Jemm386 if an "INFO" request was made
;--- for device "EMMXXXX0"

EMX06 struc
e06_NoEMS	 	db ? ;+0
e06_Frame		dw ? ;+1 segment
e06_NoVCPI		db ? ;+3
e06_DMABuff		dd ? ;+4 physical address DMA buffer
e06_NoPGE 		db ? ;+8
				db ?
				db ?
				db ?
e06_DMASize		dw ? ;+12 in KB
e06_NoVME 		db ? ;+14
e06_NoA20 		db ? ;+15
e06_VCPITotal	dd ? ;+16 VCPI pages total (def 120 MB)
e06_VCPIUsed	dd ? ;+20 VCPI pages allocated
EMX06 ends

;--- this is the structure for an "UPDATE" request with IoctlWrite

EMX15W struc
e15_bVME	db ?
e15_bA20	db ?
e15_bVCPI	db ?
e15_bPGE	db ?
EMX15W ends

endif

;--- data for monitor initialization
;--- this structure is also defined in C (jemm386.c)!!!

JEMMINIT struc
jiMonitorStart		dd ?	;XMS memory block start address
jiMonitorEnd		dd ?	;XMS memory block end address
jiTotalMemory 		dd ?	;XMS highest physical memory address
jiMaxMem16k			dd ?	;MAX VCPI mem in 16 kB units (default 7680)
jiXMSHandleTable	dd ?	;XMS handle table (FAR16)
jiMaxEMSPages		dw ?	;EMS max 16 kB pages (default 2048)
jiXMSControlHandle	dw ?	;XMS memory block handle
jiDMABufferSize		dw ?	;DMA buffer size in kB
jiFrame				dw ?	;EMS page frame (default E000)
jiNoEMS				db ?
jiNoFrame			db ?
jiNoPool			db ?
jiAltBoot 			db ?
jiNoVME				db ?
jiNoVDS				db ?
jiNoPGE				db ?
jiNoA20				db ?
jiNoVCPI			db ?
jiNoInvlPg			db ?
jiV86Flags			db ?
JEMMINIT ends

;--- this is the table of RSEG offsets 
;--- the values are byte-offsets into the RSEG segment
;--- there is just one instance defined in jemm16.asm.

RSOFS struc
wBpTab		dw ?	;offset of BP table
if ?DMA
wRFlags		dw ?	;offset of DMA flags
endif
RSOFS ends

;--- max number of UMB blocks
;--- this constant is also defined in Jemm386c.c

UMB_MAX_BLOCKS	equ 8

UMBBLK struc
wSegm	dw ?	;segment address
wSize	dw ?	;size in paras, high bit used as flag free/allocated
UMBBLK ends

;--- macros

@BPOPC macro
	db ?BPOPC
	endm

