/* xmalloc.h -- memory allocator

  AUTHOR: Gregory Pietsch <GKP1@flash.net>

  DESCRIPTION:

  This file contains prototypes for xmalloc.c.

  COPYRIGHT NOTICE AND DISCLAIMER:

  Copyright (C) 2003 Gregory Pietsch

  This program is free software; you can redistribute it and/or
  modify it under the terms of the GNU General Public License
  as published by the Free Software Foundation; either version 2
  of the License, or (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License along
  with this program; if not, write to the Free Software Foundation, Inc.,
  59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.

*/

#ifndef XMALLOC_H
#define XMALLOC_H

/* includes */
#include <stddef.h>

/* macros */

 /* comp.lang.c will never forgive me for these ... GKP */
#define XMALLOC(T, n)   ((T*)xmalloc((n)*sizeof(T)))
#define XREALLOC(T,p,n) ((T*)xrealloc((p),(n)*sizeof(T)))
#define XFREE(p)                do{if(p){free(p);p=0;}}while(0)

/* functions */
void *xmalloc(size_t n);
void *xrealloc(void *s, size_t n);

#endif

/* END OF FILE */
