/*    
   Lolstbx.c - base for list box implementations.
   Copyright (C) 2000 Imre Leber

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

   If you have any questions, comments, suggestions, or fixes please
   email me at:  imre.leber@worldonline.be
*/
#include "control.h"
#include "controls.h"
#include "vscrctrl.h"
#include "lolstbx.h"

#include "..\event\event.h"
#include "..\mouse\mouse.h"
#include "..\..\misc\bool.h"

static void FillListBox(struct Control* control)
{
   int    i;
   struct VerticalScrollControl* VBox = 
                         (struct VerticalScrollControl*)control->ControlData;
   
   struct LowListBox* box = (struct LowListBox*) VBox->ControlData;

   int AmofEntries = box->AmOfEntries(control);
   
   for (i = 0; (i < VBox->ylen-2) && (i + box->top < AmofEntries); i++)
       box->PrintEntry(control, box->top, i+box->top);
   
   if (AmofEntries) box->SelectEntry(control, box->top, 
                                     box->CursorPos+box->top);
}

static void ScrollOneDown(struct Control* control)
{
   struct VerticalScrollControl* VBox = 
                         (struct VerticalScrollControl*)control->ControlData;
   
   struct LowListBox* box = (struct LowListBox*) VBox->ControlData;

   if (VBox->ylen + box->top -2 < box->AmOfEntries(control))
   {
      box->top++;
      FillListBox(control);
   }
}

static void ScrollOneUp(struct Control* control)
{
   struct VerticalScrollControl* VBox = 
                         (struct VerticalScrollControl*)control->ControlData;
   
   struct LowListBox* box = (struct LowListBox*) VBox->ControlData;

   if (box->top > 0)
   {
      box->top--;
      FillListBox(control);
   }
}

static void OneUp(struct Control* control)
{
   struct VerticalScrollControl* VBox = 
                         (struct VerticalScrollControl*)control->ControlData;
   
   struct LowListBox* box = (struct LowListBox*) VBox->ControlData;

   if (box->CursorPos > 0)
   {
      box->PrintEntry(control, box->top, box->top+box->CursorPos);
      box->CursorPos--;
      box->SelectEntry(control, box->top, box->CursorPos+box->top);
   }
   else
      ScrollOneUp(control);
}

static void OneDown(struct Control* control)
{
   struct VerticalScrollControl* VBox = 
                         (struct VerticalScrollControl*)control->ControlData;
   
   struct LowListBox* box = (struct LowListBox*) VBox->ControlData;
   
   if ((box->CursorPos < VBox->ylen-3) && 
       (box->AmOfEntries(control) > box->top+box->CursorPos+1))
   {
      box->PrintEntry(control, box->top, box->top+box->CursorPos);
      box->CursorPos++;
      box->SelectEntry(control, box->top, box->CursorPos+box->top);
   }
   else
      ScrollOneDown(control);
}

static int OnClick(struct Control* control)
{
   int pos;
   
   struct VerticalScrollControl* VBox = 
                         (struct VerticalScrollControl*)control->ControlData;
   
   struct LowListBox* box = (struct LowListBox*) VBox->ControlData;
   
   box->PrintEntry(control, box->top, box->top+box->CursorPos);

   pos = GetPressedY() - control->posy-1;
   
   if (pos < box->AmOfEntries(control)) box->CursorPos = pos;

   box->SelectEntry(control, box->top, box->CursorPos+box->top);

   return EVENT_ANSWERED;
}

static void EntryChosen(struct Control* control, int index)
{
   struct VerticalScrollControl* VBox = 
                         (struct VerticalScrollControl*)control->ControlData;
   
   struct LowListBox* box = (struct LowListBox*) VBox->ControlData;



}

static void OnEntering(struct Control* control)
{
   struct VerticalScrollControl* VBox = 
                         (struct VerticalScrollControl*)control->ControlData;
   
   struct LowListBox* box = (struct LowListBox*) VBox->ControlData;

   box->EnterEntry(control, box->top, box->top+box->CursorPos);
}

static void OnLeaving(struct Control* control)
{
   struct VerticalScrollControl* VBox = 
                         (struct VerticalScrollControl*)control->ControlData;
   
   struct LowListBox* box = (struct LowListBox*) VBox->ControlData;

   box->LeaveEntry(control, box->top, box->top+box->CursorPos);
}

struct Control CreateLowListBox(struct LowListBox* box,
                                struct VerticalScrollControl* VBox,
                                int posx, int posy,
                                int forcolor, int backcolor)
{
   struct Control result;

   result = CreateVScrollBox(VBox, posx, posy, forcolor, backcolor);

   VBox->ControlData = (void*) box;
   
   VBox->AnswersEvents = FALSE;

   VBox->OneUp       = OneUp;
   VBox->OneDown     = OneDown;
   VBox->OnClick     = OnClick;
   VBox->EntryChosen = EntryChosen;
   VBox->DrawControl = FillListBox;
   VBox->OnEntering  = OnEntering;
   VBox->OnLeaving   = OnLeaving;

   return result;
}
