/*
 *  dos\free.c      get disk free space
 *
 *  This file is part of the D_DISK library.
 *  Copyright (C) 1998, Gregg Jennings.
 *
 *  See D_DISK.HTM for the library specifications.
 *  See D_DISK.TXT for overview the implementation.
 *  See NOTES.TXT for particulars about the source files.
 *
 */

#include <dos.h>

#include "dosio.h"
#include "debug.h"

/*
 * disk_free_space      get disk free space, unit and sector sizes
 *
 */

extern int disk_free_space(int disk, struct FREESPACE *fs)
{
union REGS regs DBG_0;

    regs.x.ax = DOS_GET_FREE_SPACE;
    regs.x.dx = disk;

    intdos(&regs,&regs);

    if (regs.x.ax >= 0xff) {
        DBG_err_dump("free");
        return 0;
    }

    fs->secs_cluster = (unsigned short)regs.x.ax;
    fs->avail_clusters = (unsigned short)regs.x.bx;
    fs->sec_size = (unsigned short)regs.x.cx;
    fs->num_clusters = (unsigned short)regs.x.dx;

    return -1;
}
