/***
*general.h - definitions/declarations for general C programs
*
*this file is part of DISKED
*Copyright (c) 1991-1998, Gregg Jennings.  All rights reserved.
*   P O Box 200, Falmouth, MA 02541-0200
*
*Purpose:
*   Compiler specifics.
*
*Notice:
*   This program can be distributed only in accordance with, and
*   accompanied by, the DPU Software License. See COPYING.TXT or,
*   <http://www.diskwarez.com/dpu.htm>.
*******************************************************************************/

/*
   Versions

   1.3   21-Jun-1998    __GNUC__
   1.2   29-Nov-1997    int3()
   1.1   12-Nov-1997    removed #define ESC (see KEYS.H)
   1.0   21-Feb-1997    added _ultoa reference

   Notes:   I like the use of leading underscores for all
            non-ANSI library functions and typedefs.  Only
            CL 7.00+ adheres to this "standard".

            Watcom 10.5+ also uses leading underscores but
            not quite as extensive as does Microsoft.

            I no longer will code to support Borland C although
            there are some older references which I will leave in.
*/

#ifndef GENERAL_H
#define GENERAL_H

#define swapHILO(w)  (((unsigned short)w >> 8) | ((unsigned short)w<<8))

#ifdef __WATCOMC__                  /* debugger breakpoint */
#pragma aux int3 = \
   "int 3";
void int3(void);
#else
#define int3() __asm int 3
#endif

#define OK    1
#define ERROR (-1)
#define ABORT (-2)

typedef enum { FALSE, TRUE } boolean;

typedef unsigned char BYTE;
typedef unsigned int UINT;
typedef short INT16;
typedef long INT32;
typedef unsigned char UINT8;
typedef unsigned short UINT16;
typedef unsigned long UINT32;


#ifndef _MAX_PATH
#define _MAX_PATH 67
#endif
#ifndef _MAX_DIR
#define _MAX_DIR  67
#endif

/* compiler dependencies -- see ALLOC.H for more */

/* first consolodate some defines */

#if defined(__GNUC__)
 #include <unistd.h>
 #define __far
 #define __huge
 #define __near
 #define _getcwd     getcwd
 #define _harderr	 harderr
#endif

#if defined(_MSC_VER)

 #pragma warning(disable:4746)                  /* should work, but doesn't */

 #if defined(_M_I86LM) || defined(_M_I86CM)     /* determine memory model */
  #define __LARGE__                             /* (easier to remember) */
 #endif
 #if defined(M_I86LM) || defined(M_I86CM)
  #define __LARGE__
 #endif

 #if _MSC_VER >= 700 && defined _QC             /* "quick compile" */
  #undef _QC                                    /*  not QuickC */
 #endif

 #if defined __STDC__                           /* I use ANSI_C because */
  #define ANSI_C                                /*  Watcom ALWAYS defines */
 #endif                                         /*  __STDC__ */

 #if (_MSC_VER >= 600 && !defined __STDC__)
  #define _ASM_DEFINED                          /* can use inline assemebler */
 #endif

#elif defined(__BORLANDC__) || defined(__TURBOC__)

 #if !defined(__BORLANDC__)
  #define __BORLANDC__  __TURBOC__              /* stupid Turbo C! */
 #endif

#elif defined(__WATCOMC__)

  #if defined(NO_EXT_KEYS)
   #define ANSI_C
  #endif

  #if _M_IX86 == 500                            /* make theirs like CL */
    #define M_I586
  #elif _M_IX86 == 400
    #define M_I486
  #elif _M_IX86 == 300
    #define M_I386
  #elif _M_IX86 == 200
    #define M_I286
  #elif _M_IX86 <= 100
    #define M_I186
  #endif

#endif

/* if CL less than version 7.0 or not CL do the leading underscore thing */

#if (defined(_MSC_VER) && (_MSC_VER < 700)) || !defined(_MSC_VER)

 #if (defined(_MSC_VER) && (_MSC_VER < 700))
 #define __far    _far
 #define __huge   _huge
 #endif
 #define __inline
 #define _chdir      chdir
 #define _getcwd     getcwd
 #define _intdos     intdos
 #define _intdosx    intdosx
 #define _int86      int86
 #define _int86x     int86x
 #define _segread    segread
 #define _REGS       REGS
 #define _SREGS      SREGS
 #define _access     access
 #define _file_t     file_t
 #define _find_t     find_t
 #define _diskfree_t diskfree_t
 #define _open       open
 #define _write      write
 #define _read       read
 #define _close      close
 #define _unlink     unlink
 #define _kbhit      kbhit
 #define _spawnl     spawnl
 #define _bdos       bdos
 #define _putenv     putenv
 #define _stricmp    stricmp
 #define _itoa       itoa
 #define _ltoa       ltoa
 #define _ultoa      ultoa
 #define _stackavail stackavail
 #define _filelength filelength
 #ifndef __GNUC__
  #define _dosexterr  dosexterr
 #else
  #undef _ultoa
  #undef _ltoa
  #define _ltoa       itoa
  #define _ultoa      itoa
 #endif
 #ifndef _O_RDONLY
  #define _O_RDONLY   O_RDONLY
  #define _O_BINARY   O_BINARY
  #define _O_CREAT    O_CREAT
  #define _O_TRUNC    O_TRUNC
  #define _O_RDWR     O_RDWR
 #endif
 #define _S_IWRITE   S_IWRITE
 #define _S_IREAD    S_IREAD
 #define _P_WAIT     P_WAIT

 #ifndef _FP_OFF
   #define _FP_OFF     FP_OFF
   #define _FP_SEG     FP_SEG
 #endif
 #ifndef _MK_FP
   #define _MK_FP(seg, offset) (void __far *)(((unsigned long)seg << 16) \
    + (unsigned long)(unsigned)offset)
 #endif

#endif

/* finally, extensions turned off, but we want to use some non-ANSI stuff */

#ifdef ANSI_C  /* defined if  CL /Za  or  WCL /za */

extern unsigned char __near _osmajor;  /*  O/S version #        */
extern unsigned char __near _osminor;  /*  O/S version #        */
extern unsigned char __near _osmode;   /* DOS_MODE or OS2_MODE  */

#ifdef __WATCOMC__

extern char *sys_errlist[];
#define _sys_errlist    sys_errlist
extern int putenv(const char *);
extern int stricmp(char *, char *);
extern char *itoa(int, char *, int);
extern char *ltoa(long int, char *, int);
extern char *ultoa(unsigned long int, char *, int);

#endif /* __WATCOMC__ */

#ifdef _MSC_VER
extern char * __near __cdecl _sys_errlist[];    /* perror error message table */
#endif

#endif /* ANSI_C */

#endif
